/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package nak.core;

/**
 * Interface for models that construct a linear separator.
 **/
public interface LinearModel {

  /**
   * Evaluates a context.
   *
   * @param context A list of String names of the contextual predicates
   *                which are to be evaluated together.
   * @return an array of the probabilities for each of the different
   *         outcomes, all of which sum to 1.
   *
   **/
  public double[] eval(String[] context);
  
  /**
   * Evaluates a contexts with the specified context values.
   * @param context A list of String names of the contextual predicates
     *                which are to be evaluated together.
   * @param values The values associated with each context.
   * @return an array of the probabilities for each of the different outcomes, all of which sum to 1.
   */
  public double[] eval(String[] context, float[] values);

  /**
   * Gets the String name of the outcome associated with the index
   * i.
   *
   * @param i the index for which the name of the associated outcome is
   *          desired.
   * @return the String name of the outcome
   **/
  public String getOutcome(int i);

  /**
   * Gets the index associated with the String name of the given
   * outcome.
   *
   * @param outcome the String name of the outcome for which the
   *          index is desired
   * @return the index if the given outcome label exists for this
   * model, -1 if it does not.
   **/
  public int getIndex(String outcome);

  /** Returns the number of outcomes for this model.
   *  @return The number of outcomes.
   **/
  public int getNumOutcomes();


  public nak.core.AbstractModel.ModelType getModelType();


}
