/*
 * Decompiled with CFR 0.152.
 */
package nak.app;

import java.io.File;
import java.io.FileReader;
import java.text.DecimalFormat;
import java.util.Arrays;
import nak.core.BasicContextGenerator;
import nak.core.ContextGenerator;
import nak.core.Event;
import nak.core.LinearModel;
import nak.data.BasicEventStream;
import nak.data.PlainTextByLineDataStream;
import nak.data.RealValueFileEventStream;
import nak.io.GenericModelReader;
import nak.util.DoubleStringPair;

public class ModelApplier {
    LinearModel _model;
    ContextGenerator _cg = new BasicContextGenerator(",");
    int counter = 1;
    public static final DecimalFormat ROUNDED_FORMAT = new DecimalFormat("0.000");

    public ModelApplier(LinearModel linearModel) {
        this._model = linearModel;
    }

    private void eval(Event event) {
        this.eval(event, false);
    }

    private void eval(Event event, boolean bl) {
        int n;
        double[] dArray;
        String string = event.getOutcome();
        String[] stringArray = event.getContext();
        if (!bl) {
            dArray = this._model.eval(stringArray);
        } else {
            float[] fArray = RealValueFileEventStream.parseContexts(stringArray);
            dArray = this._model.eval(stringArray, fArray);
        }
        int n2 = dArray.length;
        Object[] objectArray = new DoubleStringPair[n2];
        for (n = 0; n < n2; ++n) {
            objectArray[n] = new DoubleStringPair(dArray[n], this._model.getOutcome(n));
        }
        Arrays.sort(objectArray);
        for (n = n2 - 1; n >= 0; --n) {
            System.out.print(((DoubleStringPair)objectArray[n]).stringValue + " " + ((DoubleStringPair)objectArray[n]).doubleValue + " ");
        }
        System.out.println();
    }

    private static void usage() {
        System.err.println("java ModelApplier [-real] modelFile dataFile");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        String string = "maxent";
        int n = 0;
        if (stringArray.length == 0) {
            ModelApplier.usage();
        }
        if (stringArray.length > 0) {
            Object object;
            while (stringArray[n].startsWith("-")) {
                if (stringArray[n].equals("-real")) {
                    bl = true;
                } else if (stringArray[n].equals("-perceptron")) {
                    string = "perceptron";
                } else {
                    ModelApplier.usage();
                }
                ++n;
            }
            String string2 = stringArray[n++];
            String string3 = stringArray[n++];
            ModelApplier modelApplier = null;
            try {
                object = new GenericModelReader(new File(string2)).getModel();
                modelApplier = new ModelApplier((LinearModel)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(0);
            }
            try {
                object = new BasicEventStream(new PlainTextByLineDataStream(new FileReader(new File(string3))), ",");
                while (object.hasNext()) {
                    modelApplier.eval(object.next(), bl);
                }
                return;
            }
            catch (Exception exception) {
                System.out.println("Unable to read from specified file: " + string2);
                System.out.println();
                exception.printStackTrace();
            }
        }
    }
}

