/*
 * Decompiled with CFR 0.152.
 */
package nak.app;

import java.io.File;
import java.io.FileReader;
import nak.core.AbstractModel;
import nak.data.AbstractEventStream;
import nak.data.BasicEventStream;
import nak.data.OnePassDataIndexer;
import nak.data.OnePassRealValueDataIndexer;
import nak.data.PlainTextByLineDataStream;
import nak.data.RealBasicEventStream;
import nak.io.AbstractModelWriter;
import nak.io.SuffixSensitiveGISModelWriter;
import nak.io.SuffixSensitivePerceptronModelWriter;
import nak.maxent.GIS;
import nak.maxent.GISModel;
import nak.perceptron.PerceptronTrainer;

public class ModelTrainer {
    public static boolean USE_SMOOTHING = false;
    public static double SMOOTHING_OBSERVATION = 0.1;

    private static void usage() {
        System.err.println("java ModelTrainer [-real] dataFile modelFile");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        boolean bl = false;
        String string = "maxent";
        int n2 = 100;
        int n3 = 1;
        double d = 1.0;
        if (stringArray.length == 0) {
            ModelTrainer.usage();
        }
        while (stringArray[n].startsWith("-")) {
            if (stringArray[n].equals("-real")) {
                bl = true;
            } else if (stringArray[n].equals("-perceptron")) {
                string = "perceptron";
            } else if (stringArray[n].equals("-maxit")) {
                n2 = Integer.parseInt(stringArray[++n]);
            } else if (stringArray[n].equals("-cutoff")) {
                n3 = Integer.parseInt(stringArray[++n]);
            } else if (stringArray[n].equals("-sigma")) {
                d = Double.parseDouble(stringArray[++n]);
            } else {
                System.err.println("Unknown option: " + stringArray[n]);
                ModelTrainer.usage();
            }
            ++n;
        }
        String string2 = stringArray[n++];
        String string3 = stringArray[n];
        try {
            AbstractModelWriter abstractModelWriter;
            FileReader fileReader = new FileReader(new File(string2));
            AbstractEventStream abstractEventStream = !bl ? new BasicEventStream(new PlainTextByLineDataStream(fileReader), ",") : new RealBasicEventStream(new PlainTextByLineDataStream(fileReader));
            File file = new File(string3);
            if (string.equals("maxent")) {
                GIS.SMOOTHING_OBSERVATION = SMOOTHING_OBSERVATION;
                GISModel gISModel = !bl ? GIS.trainModel(abstractEventStream, n2, n3, d) : GIS.trainModel(n2, new OnePassRealValueDataIndexer(abstractEventStream, n3), USE_SMOOTHING);
                abstractModelWriter = new SuffixSensitiveGISModelWriter(gISModel, file);
            } else if (string.equals("perceptron")) {
                AbstractModel abstractModel = new PerceptronTrainer().trainModel(n2, new OnePassDataIndexer(abstractEventStream, n3), n3);
                abstractModelWriter = new SuffixSensitivePerceptronModelWriter(abstractModel, file);
            } else {
                throw new RuntimeException("Unknown model type: " + string);
            }
            ((AbstractModelWriter)abstractModelWriter).persist();
        }
        catch (Exception exception) {
            System.out.print("Unable to create model due to exception: ");
            System.out.println(exception);
            exception.printStackTrace();
        }
    }
}

