/*
 * Decompiled with CFR 0.152.
 */
package nak.core;

import java.util.Arrays;

public class ComparableEvent
implements Comparable<ComparableEvent> {
    public int outcome;
    public int[] predIndexes;
    public int seen = 1;
    public float[] values;

    public ComparableEvent(int n, int[] nArray, float[] fArray) {
        this.outcome = n;
        if (fArray == null) {
            Arrays.sort(nArray);
        } else {
            this.sort(nArray, fArray);
        }
        this.values = fArray;
        this.predIndexes = nArray;
    }

    public ComparableEvent(int n, int[] nArray) {
        this(n, nArray, null);
    }

    @Override
    public int compareTo(ComparableEvent comparableEvent) {
        if (this.outcome < comparableEvent.outcome) {
            return -1;
        }
        if (this.outcome > comparableEvent.outcome) {
            return 1;
        }
        int n = this.predIndexes.length > comparableEvent.predIndexes.length ? comparableEvent.predIndexes.length : this.predIndexes.length;
        for (int i = 0; i < n; ++i) {
            if (this.predIndexes[i] < comparableEvent.predIndexes[i]) {
                return -1;
            }
            if (this.predIndexes[i] > comparableEvent.predIndexes[i]) {
                return 1;
            }
            if (this.values != null && comparableEvent.values != null) {
                if (this.values[i] < comparableEvent.values[i]) {
                    return -1;
                }
                if (!(this.values[i] > comparableEvent.values[i])) continue;
                return 1;
            }
            if (this.values != null) {
                if (this.values[i] < 1.0f) {
                    return -1;
                }
                if (!(this.values[i] > 1.0f)) continue;
                return 1;
            }
            if (comparableEvent.values == null) continue;
            if (1.0f < comparableEvent.values[i]) {
                return -1;
            }
            if (!(1.0f > comparableEvent.values[i])) continue;
            return 1;
        }
        if (this.predIndexes.length < comparableEvent.predIndexes.length) {
            return -1;
        }
        if (this.predIndexes.length > comparableEvent.predIndexes.length) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.outcome).append(":");
        for (int i = 0; i < this.predIndexes.length; ++i) {
            stringBuilder.append(" ").append(this.predIndexes[i]);
            if (this.values == null) continue;
            stringBuilder.append("=").append(this.values[i]);
        }
        return stringBuilder.toString();
    }

    private void sort(int[] nArray, float[] fArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            int n2 = i;
            for (n = i + 1; n < nArray.length; ++n) {
                if (nArray[n2] <= nArray[n]) continue;
                n2 = n;
            }
            n = nArray[i];
            nArray[i] = nArray[n2];
            nArray[n2] = n;
            float f = fArray[i];
            fArray[i] = fArray[n2];
            fArray[n2] = f;
        }
    }
}

