/*
 * Decompiled with CFR 0.152.
 */
package nak.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nak.core.ComparableEvent;
import nak.core.Event;
import nak.data.AbstractDataIndexer;
import nak.data.EventStream;

public class OnePassDataIndexer
extends AbstractDataIndexer {
    public OnePassDataIndexer(EventStream eventStream) throws IOException {
        this(eventStream, 0);
    }

    public OnePassDataIndexer(EventStream eventStream, int n) throws IOException {
        this(eventStream, n, true);
    }

    public OnePassDataIndexer(EventStream eventStream, int n, boolean bl) throws IOException {
        this(eventStream, n, bl, false);
    }

    public OnePassDataIndexer(EventStream eventStream, int n, boolean bl, boolean bl2) throws IOException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (bl2) {
            System.out.println("Indexing events using cutoff of " + n + "\n");
        }
        if (bl2) {
            System.out.print("\tComputing event counts...  ");
        }
        LinkedList<Event> linkedList = this.computeEventCounts(eventStream, hashMap, n);
        if (bl2) {
            System.out.println("done. " + linkedList.size() + " events");
        }
        if (bl2) {
            System.out.print("\tIndexing...  ");
        }
        List<ComparableEvent> list = this.index(linkedList, hashMap);
        linkedList = null;
        hashMap = null;
        if (bl2) {
            System.out.println("done.");
        }
        if (bl2) {
            System.out.print("Sorting and merging events... ");
        }
        this.sortAndMerge(list, bl, bl2);
        if (bl2) {
            System.out.println("Done indexing.");
        }
    }

    private LinkedList<Event> computeEventCounts(EventStream eventStream, Map<String, Integer> map, int n) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        LinkedList<Event> linkedList = new LinkedList<Event>();
        while (eventStream.hasNext()) {
            Event event = eventStream.next();
            linkedList.addLast(event);
            OnePassDataIndexer.update(event.getContext(), hashSet, hashMap, n);
        }
        this.predCounts = new int[hashSet.size()];
        int n2 = 0;
        for (String string : hashSet) {
            this.predCounts[n2] = (Integer)hashMap.get(string);
            map.put(string, n2);
            ++n2;
        }
        return linkedList;
    }

    protected List<ComparableEvent> index(LinkedList<Event> linkedList, Map<String, Integer> map) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = linkedList.size();
        int n2 = 0;
        ArrayList<ComparableEvent> arrayList = new ArrayList<ComparableEvent>(n);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            int n3;
            Event event = linkedList.removeFirst();
            String[] stringArray = event.getContext();
            String string = event.getOutcome();
            if (hashMap.containsKey(string)) {
                n3 = (Integer)hashMap.get(string);
            } else {
                n3 = n2++;
                hashMap.put(string, n3);
            }
            String[] stringArray2 = stringArray;
            int n4 = stringArray2.length;
            for (int j = 0; j < n4; ++j) {
                String string2 = stringArray2[j];
                if (!map.containsKey(string2)) continue;
                arrayList2.add(map.get(string2));
            }
            if (arrayList2.size() > 0) {
                int[] nArray = new int[arrayList2.size()];
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    nArray[n4] = (Integer)arrayList2.get(n4);
                }
                ComparableEvent comparableEvent = new ComparableEvent(n3, nArray);
                arrayList.add(comparableEvent);
            } else {
                System.err.println("Dropped event " + event.getOutcome() + ":" + Arrays.asList(event.getContext()));
            }
            arrayList2.clear();
        }
        this.outcomeLabels = OnePassDataIndexer.toIndexedStringArray(hashMap);
        this.predLabels = OnePassDataIndexer.toIndexedStringArray(map);
        return arrayList;
    }
}

