/*
 * Decompiled with CFR 0.152.
 */
package nak.data;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import nak.data.DataReader;

public class PlainTextFileDataReader
implements DataReader {
    private BufferedReader input;

    public PlainTextFileDataReader(File file) throws IOException {
        this.input = file.getName().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new BufferedInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file)))))) : new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(file))));
    }

    public PlainTextFileDataReader(InputStream inputStream) {
        this.input = new BufferedReader(new InputStreamReader(inputStream));
    }

    public PlainTextFileDataReader(BufferedReader bufferedReader) {
        this.input = bufferedReader;
    }

    @Override
    public double readDouble() throws IOException {
        return Double.parseDouble(this.input.readLine());
    }

    @Override
    public int readInt() throws IOException {
        return Integer.parseInt(this.input.readLine());
    }

    @Override
    public String readUTF() throws IOException {
        return this.input.readLine();
    }
}

