/*
 * Decompiled with CFR 0.152.
 */
package nak.data;

import java.io.File;
import java.io.IOException;
import nak.core.Event;
import nak.data.FileEventStream;
import nak.data.OnePassRealValueDataIndexer;
import nak.io.SuffixSensitiveGISModelWriter;
import nak.maxent.GIS;
import nak.maxent.GISModel;

public class RealValueFileEventStream
extends FileEventStream {
    public RealValueFileEventStream(String string) throws IOException {
        super(string);
    }

    public RealValueFileEventStream(String string, String string2) throws IOException {
        super(string, string2);
    }

    public RealValueFileEventStream(File file) throws IOException {
        super(file);
    }

    public static float[] parseContexts(String[] stringArray) {
        boolean bl = false;
        float[] fArray = new float[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].lastIndexOf("=");
            if (n > 0 && n + 1 < stringArray[i].length()) {
                boolean bl2 = true;
                try {
                    fArray[i] = Float.parseFloat(stringArray[i].substring(n + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    bl2 = false;
                    System.err.println("Unable to determine value in context:" + stringArray[i]);
                    fArray[i] = 1.0f;
                }
                if (!bl2) continue;
                if (fArray[i] < 0.0f) {
                    throw new RuntimeException("Negative values are not allowed: " + stringArray[i]);
                }
                stringArray[i] = stringArray[i].substring(0, n);
                bl = true;
                continue;
            }
            fArray[i] = 1.0f;
        }
        if (!bl) {
            fArray = null;
        }
        return fArray;
    }

    @Override
    public Event next() {
        int n = this.line.indexOf(32);
        String string = this.line.substring(0, n);
        String[] stringArray = this.line.substring(n + 1).split(" ");
        float[] fArray = RealValueFileEventStream.parseContexts(stringArray);
        return new Event(string, stringArray, fArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        GISModel gISModel;
        if (stringArray.length == 0) {
            System.err.println("Usage: RealValueFileEventStream eventfile [iterations cutoff]");
            System.exit(1);
        }
        int n = 0;
        String string = stringArray[n++];
        int n2 = 100;
        int n3 = 5;
        if (n < stringArray.length) {
            n2 = Integer.parseInt(stringArray[n++]);
            n3 = Integer.parseInt(stringArray[n++]);
        }
        RealValueFileEventStream realValueFileEventStream = new RealValueFileEventStream(string);
        try {
            gISModel = GIS.trainModel(n2, new OnePassRealValueDataIndexer(realValueFileEventStream, n3));
        }
        finally {
            realValueFileEventStream.close();
        }
        new SuffixSensitiveGISModelWriter(gISModel, new File(string + ".bin.gz")).persist();
    }
}

