/*
 * Decompiled with CFR 0.152.
 */
package nak.io;

import java.io.File;
import java.io.IOException;
import nak.core.LinearModel;
import nak.data.DataReader;
import nak.io.AbstractModelReader;
import nak.io.GISModelReader;
import nak.io.LiblinearModelReader;
import nak.io.PerceptronModelReader;
import nak.io.QNModelReader;

public class GenericModelReader
extends AbstractModelReader {
    private AbstractModelReader delegateModelReader;

    public GenericModelReader(File file) throws IOException {
        super(file);
    }

    public GenericModelReader(DataReader dataReader) {
        super(dataReader);
    }

    @Override
    public void checkModelType() throws IOException {
        String string = this.readUTF();
        if (string.equals("Perceptron")) {
            this.delegateModelReader = new PerceptronModelReader(this.dataReader);
        } else if (string.equals("GIS")) {
            this.delegateModelReader = new GISModelReader(this.dataReader);
        } else if (string.equals("QN")) {
            this.delegateModelReader = new QNModelReader(this.dataReader);
        } else if (string.equals("Liblinear")) {
            this.delegateModelReader = new LiblinearModelReader(this.dataReader);
        } else {
            throw new IOException("Unknown model format: " + string);
        }
    }

    @Override
    public LinearModel constructModel() throws IOException {
        return this.delegateModelReader.constructModel();
    }
}

