/*
 * Decompiled with CFR 0.152.
 */
package nak.io;

import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPOutputStream;
import nak.core.AbstractModel;
import nak.core.LinearModel;
import nak.io.AbstractModelWriter;
import nak.io.BinaryGISModelWriter;
import nak.io.BinaryPerceptronModelWriter;
import nak.io.BinaryQNModelWriter;
import nak.io.LiblinearModelWriter;
import nak.io.PlainTextGISModelWriter;
import nak.io.PlainTextPerceptronModelWriter;

public class GenericModelWriter
extends AbstractModelWriter {
    private AbstractModelWriter delegateWriter;

    public GenericModelWriter(LinearModel linearModel, File file) throws IOException {
        OutputStream outputStream;
        String string = file.getName();
        if (string.endsWith(".gz")) {
            outputStream = new GZIPOutputStream(new FileOutputStream(file));
            string = string.substring(0, string.length() - 3);
        } else {
            outputStream = new FileOutputStream(file);
        }
        if (string.endsWith(".bin")) {
            this.init(linearModel, new DataOutputStream(outputStream));
        } else {
            this.init(linearModel, new BufferedWriter(new OutputStreamWriter(outputStream)));
        }
    }

    public GenericModelWriter(LinearModel linearModel, DataOutputStream dataOutputStream) {
        this.init(linearModel, dataOutputStream);
    }

    private void init(LinearModel linearModel, DataOutputStream dataOutputStream) {
        if (linearModel.getModelType() == AbstractModel.ModelType.Perceptron) {
            this.delegateWriter = new BinaryPerceptronModelWriter(linearModel, dataOutputStream);
        } else if (linearModel.getModelType() == AbstractModel.ModelType.Maxent) {
            this.delegateWriter = new BinaryGISModelWriter(linearModel, dataOutputStream);
        } else if (linearModel.getModelType() == AbstractModel.ModelType.MaxentQn) {
            this.delegateWriter = new BinaryQNModelWriter(linearModel, dataOutputStream);
        } else if (linearModel.getModelType() == AbstractModel.ModelType.Liblinear) {
            this.delegateWriter = new LiblinearModelWriter(linearModel, dataOutputStream);
        }
    }

    private void init(LinearModel linearModel, BufferedWriter bufferedWriter) {
        if (linearModel.getModelType() == AbstractModel.ModelType.Perceptron) {
            this.delegateWriter = new PlainTextPerceptronModelWriter(linearModel, bufferedWriter);
        } else if (linearModel.getModelType() == AbstractModel.ModelType.Maxent) {
            this.delegateWriter = new PlainTextGISModelWriter(linearModel, bufferedWriter);
        }
    }

    @Override
    public void close() throws IOException {
        this.delegateWriter.close();
    }

    @Override
    public void persist() throws IOException {
        this.delegateWriter.persist();
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.delegateWriter.writeDouble(d);
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.delegateWriter.writeInt(n);
    }

    @Override
    public void writeUTF(String string) throws IOException {
        this.delegateWriter.writeUTF(string);
    }
}

