/*
 * Decompiled with CFR 0.152.
 */
package nak.io;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import nak.core.Context;
import nak.io.PlainTextGISModelReader;
import nak.io.SuffixSensitiveGISModelWriter;

public class OldFormatGISModelReader
extends PlainTextGISModelReader {
    DataInputStream paramsInput;

    public OldFormatGISModelReader(String string) throws IOException {
        super(new File(string + ".mei.gz"));
        this.paramsInput = new DataInputStream(new GZIPInputStream(new FileInputStream(string + ".mep.gz")));
    }

    @Override
    protected Context[] getParameters(int[][] nArray) throws IOException {
        Context[] contextArray = new Context[this.NUM_PREDS];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2;
            int[] nArray2 = new int[nArray[i].length - 1];
            for (n2 = 1; n2 < nArray[i].length; ++n2) {
                nArray2[n2 - 1] = nArray[i][n2];
            }
            for (n2 = 0; n2 < nArray[i][0]; ++n2) {
                double[] dArray = new double[nArray[i].length - 1];
                for (int j = 1; j < nArray[i].length; ++j) {
                    dArray[j - 1] = this.readDouble();
                }
                contextArray[n] = new Context(nArray2, dArray);
                ++n;
            }
        }
        return contextArray;
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 1) {
            System.out.println("Usage: java opennlp.maxent.io.OldFormatGISModelReader model_name_prefix (new_model_name)");
            System.exit(0);
        }
        int n = 0;
        String string = stringArray[n];
        String string2 = stringArray.length > n ? stringArray[n + 1] : string + ".bin.gz";
        OldFormatGISModelReader oldFormatGISModelReader = new OldFormatGISModelReader(string);
        new SuffixSensitiveGISModelWriter(oldFormatGISModelReader.getModel(), new File(string2)).persist();
    }
}

