/*
 * Decompiled with CFR 0.152.
 */
package nak.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPOutputStream;
import nak.core.LinearModel;
import nak.io.PerceptronModelWriter;

public class PlainTextPerceptronModelWriter
extends PerceptronModelWriter {
    BufferedWriter output;

    public PlainTextPerceptronModelWriter(LinearModel linearModel, File file) throws IOException, FileNotFoundException {
        super(linearModel);
        this.output = file.getName().endsWith(".gz") ? new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(file)))) : new BufferedWriter(new FileWriter(file));
    }

    public PlainTextPerceptronModelWriter(LinearModel linearModel, BufferedWriter bufferedWriter) {
        super(linearModel);
        this.output = bufferedWriter;
    }

    @Override
    public void writeUTF(String string) throws IOException {
        this.output.write(string);
        this.output.newLine();
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.output.write(Integer.toString(n));
        this.output.newLine();
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.output.write(Double.toString(d));
        this.output.newLine();
    }

    @Override
    public void close() throws IOException {
        this.output.flush();
        this.output.close();
    }
}

