/*
 * Decompiled with CFR 0.152.
 */
package nak.io;

import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPOutputStream;
import nak.core.LinearModel;
import nak.io.BinaryGISModelWriter;
import nak.io.GISModelWriter;
import nak.io.PlainTextGISModelWriter;

public class SuffixSensitiveGISModelWriter
extends GISModelWriter {
    private final GISModelWriter suffixAppropriateWriter;

    public SuffixSensitiveGISModelWriter(LinearModel linearModel, File file) throws IOException {
        super(linearModel);
        FilterOutputStream filterOutputStream;
        String string = file.getName();
        if (string.endsWith(".gz")) {
            filterOutputStream = new GZIPOutputStream(new FileOutputStream(file));
            string = string.substring(0, string.length() - 3);
        } else {
            filterOutputStream = new DataOutputStream(new FileOutputStream(file));
        }
        this.suffixAppropriateWriter = string.endsWith(".bin") ? new BinaryGISModelWriter(linearModel, new DataOutputStream(filterOutputStream)) : new PlainTextGISModelWriter(linearModel, new BufferedWriter(new OutputStreamWriter(filterOutputStream)));
    }

    @Override
    public void writeUTF(String string) throws IOException {
        this.suffixAppropriateWriter.writeUTF(string);
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.suffixAppropriateWriter.writeInt(n);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.suffixAppropriateWriter.writeDouble(d);
    }

    @Override
    public void close() throws IOException {
        this.suffixAppropriateWriter.close();
    }
}

