/*
 * Decompiled with CFR 0.152.
 */
package nak.liblinear;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Formatter;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Pattern;
import nak.liblinear.Feature;
import nak.liblinear.FeatureNode;
import nak.liblinear.Function;
import nak.liblinear.IntArrayPointer;
import nak.liblinear.L2R_L2_SvcFunction;
import nak.liblinear.L2R_L2_SvrFunction;
import nak.liblinear.L2R_LrFunction;
import nak.liblinear.Model;
import nak.liblinear.Parameter;
import nak.liblinear.Problem;
import nak.liblinear.SolverMCSVM_CS;
import nak.liblinear.SolverType;
import nak.liblinear.Tron;

public class Linear {
    static final Charset FILE_CHARSET = Charset.forName("ISO-8859-1");
    static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static Object OUTPUT_MUTEX = new Object();
    private static PrintStream DEBUG_OUTPUT = System.out;
    private static final long DEFAULT_RANDOM_SEED = 0L;
    static Random random = new Random(0L);

    public static void crossValidation(Problem problem, Parameter parameter, int n, double[] dArray) {
        int n2;
        int n3;
        int[] nArray = new int[n + 1];
        int n4 = problem.l;
        int[] nArray2 = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray2[n3] = n3;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = n3 + random.nextInt(n4 - n3);
            Linear.swap(nArray2, n3, n2);
        }
        for (n3 = 0; n3 <= n; ++n3) {
            nArray[n3] = n3 * n4 / n;
        }
        for (n3 = 0; n3 < n; ++n3) {
            int n5;
            n2 = nArray[n3];
            int n6 = nArray[n3 + 1];
            Problem problem2 = new Problem();
            problem2.bias = problem.bias;
            problem2.n = problem.n;
            problem2.l = n4 - (n6 - n2);
            problem2.x = new Feature[problem2.l][];
            problem2.y = new double[problem2.l];
            int n7 = 0;
            for (n5 = 0; n5 < n2; ++n5) {
                problem2.x[n7] = problem.x[nArray2[n5]];
                problem2.y[n7] = problem.y[nArray2[n5]];
                ++n7;
            }
            for (n5 = n6; n5 < n4; ++n5) {
                problem2.x[n7] = problem.x[nArray2[n5]];
                problem2.y[n7] = problem.y[nArray2[n5]];
                ++n7;
            }
            Model model = Linear.train(problem2, parameter);
            for (n5 = n2; n5 < n6; ++n5) {
                dArray[nArray2[n5]] = Linear.predict(model, problem.x[nArray2[n5]]);
            }
        }
    }

    private static GroupClassesReturn groupClasses(Problem problem, int[] nArray) {
        int n;
        int n2 = problem.l;
        int n3 = 16;
        int n4 = 0;
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n2];
        for (n = 0; n < n2; ++n) {
            int n5;
            int n6 = (int)problem.y[n];
            for (n5 = 0; n5 < n4; ++n5) {
                if (n6 != nArray2[n5]) continue;
                int n7 = n5;
                nArray3[n7] = nArray3[n7] + 1;
                break;
            }
            nArray4[n] = n5;
            if (n5 != n4) continue;
            if (n4 == n3) {
                nArray2 = Linear.copyOf(nArray2, n3 *= 2);
                nArray3 = Linear.copyOf(nArray3, n3);
            }
            nArray2[n4] = n6;
            nArray3[n4] = 1;
            ++n4;
        }
        int[] nArray5 = new int[n4];
        nArray5[0] = 0;
        for (n = 1; n < n4; ++n) {
            nArray5[n] = nArray5[n - 1] + nArray3[n - 1];
        }
        for (n = 0; n < n2; ++n) {
            nArray[nArray5[nArray4[n]]] = n;
            int n8 = nArray4[n];
            nArray5[n8] = nArray5[n8] + 1;
        }
        nArray5[0] = 0;
        for (n = 1; n < n4; ++n) {
            nArray5[n] = nArray5[n - 1] + nArray3[n - 1];
        }
        return new GroupClassesReturn(n4, nArray2, nArray5, nArray3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void info(String string) {
        Object object = OUTPUT_MUTEX;
        synchronized (object) {
            if (DEBUG_OUTPUT == null) {
                return;
            }
            DEBUG_OUTPUT.printf(string, new Object[0]);
            DEBUG_OUTPUT.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void info(String string, Object ... objectArray) {
        Object object = OUTPUT_MUTEX;
        synchronized (object) {
            if (DEBUG_OUTPUT == null) {
                return;
            }
            DEBUG_OUTPUT.printf(string, objectArray);
            DEBUG_OUTPUT.flush();
        }
    }

    static double atof(String string) {
        if (string == null || string.length() < 1) {
            throw new IllegalArgumentException("Can't convert empty string to integer");
        }
        double d = Double.parseDouble(string);
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new IllegalArgumentException("NaN or Infinity in input: " + string);
        }
        return d;
    }

    static int atoi(String string) throws NumberFormatException {
        if (string == null || string.length() < 1) {
            throw new IllegalArgumentException("Can't convert empty string to integer");
        }
        if (string.charAt(0) == '+') {
            string = string.substring(1);
        }
        return Integer.parseInt(string);
    }

    public static double[] copyOf(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, Math.min(dArray.length, n));
        return dArray2;
    }

    public static int[] copyOf(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, Math.min(nArray.length, n));
        return nArray2;
    }

    public static Model loadModel(Reader reader) throws IOException {
        Model model = new Model();
        model.label = null;
        Pattern pattern = Pattern.compile("\\s+");
        BufferedReader bufferedReader = null;
        bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray = pattern.split(string);
            if (stringArray[0].equals("solver_type")) {
                SolverType solverType = SolverType.valueOf(stringArray[1]);
                if (solverType == null) {
                    throw new RuntimeException("unknown solver type");
                }
                model.solverType = solverType;
                continue;
            }
            if (stringArray[0].equals("nr_class")) {
                model.nr_class = Linear.atoi(stringArray[1]);
                Integer.parseInt(stringArray[1]);
                continue;
            }
            if (stringArray[0].equals("nr_feature")) {
                model.nr_feature = Linear.atoi(stringArray[1]);
                continue;
            }
            if (stringArray[0].equals("bias")) {
                model.bias = Linear.atof(stringArray[1]);
                continue;
            }
            if (stringArray[0].equals("w")) break;
            if (stringArray[0].equals("label")) {
                model.label = new int[model.nr_class];
                for (int i = 0; i < model.nr_class; ++i) {
                    model.label[i] = Linear.atoi(stringArray[i + 1]);
                }
                continue;
            }
            throw new RuntimeException("unknown text in model file: [" + string + "]");
        }
        int n = model.nr_feature;
        if (model.bias >= 0.0) {
            ++n;
        }
        int n2 = model.nr_class;
        if (model.nr_class == 2 && model.solverType != SolverType.MCSVM_CS) {
            n2 = 1;
        }
        model.w = new double[n * n2];
        int[] nArray = new int[128];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = 0;
                while (true) {
                    int n4;
                    if ((n4 = bufferedReader.read()) == -1) {
                        throw new EOFException("unexpected EOF");
                    }
                    if (n4 == 32) break;
                    nArray[n3++] = n4;
                }
                model.w[i * n2 + j] = Linear.atof(new String(nArray, 0, n3));
            }
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model loadModel(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), FILE_CHARSET));
        try {
            Model model = Linear.loadModel(bufferedReader);
            return model;
        }
        finally {
            bufferedReader.close();
        }
    }

    static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static double predict(Model model, Feature[] featureArray) {
        double[] dArray = new double[model.nr_class];
        return Linear.predictValues(model, featureArray, dArray);
    }

    public static double predictProbability(Model model, Feature[] featureArray, double[] dArray) throws IllegalArgumentException {
        if (!model.isProbabilityModel()) {
            throw new IllegalArgumentException("probability output is only supported for logistic regression");
        }
        int n = model.nr_class;
        int n2 = n == 2 ? 1 : n;
        double d = Linear.predictValues(model, featureArray, dArray);
        for (int i = 0; i < n2; ++i) {
            dArray[i] = 1.0 / (1.0 + Math.exp(-dArray[i]));
        }
        if (n == 2) {
            dArray[1] = 1.0 - dArray[0];
        } else {
            int n3;
            double d2 = 0.0;
            for (n3 = 0; n3 < n; ++n3) {
                d2 += dArray[n3];
            }
            for (n3 = 0; n3 < n; ++n3) {
                dArray[n3] = dArray[n3] / d2;
            }
        }
        return d;
    }

    public static double predictValues(Model model, Feature[] featureArray, double[] dArray) {
        int n = model.bias >= 0.0 ? model.nr_feature + 1 : model.nr_feature;
        double[] dArray2 = model.w;
        int n2 = model.nr_class == 2 && model.solverType != SolverType.MCSVM_CS ? 1 : model.nr_class;
        for (int i = 0; i < n2; ++i) {
            dArray[i] = 0.0;
        }
        Feature[] featureArray2 = featureArray;
        int n3 = featureArray2.length;
        for (int i = 0; i < n3; ++i) {
            Feature feature = featureArray2[i];
            int n4 = feature.getIndex();
            if (n4 > n) continue;
            for (int j = 0; j < n2; ++j) {
                int n5 = j;
                dArray[n5] = dArray[n5] + dArray2[(n4 - 1) * n2 + j] * feature.getValue();
            }
        }
        if (model.nr_class == 2) {
            if (model.solverType.isSupportVectorRegression()) {
                return dArray[0];
            }
            return dArray[0] > 0.0 ? (double)model.label[0] : (double)model.label[1];
        }
        int n6 = 0;
        for (n3 = 1; n3 < model.nr_class; ++n3) {
            if (!(dArray[n3] > dArray[n6])) continue;
            n6 = n3;
        }
        return model.label[n6];
    }

    static void printf(Formatter formatter, String string, Object ... objectArray) throws IOException {
        formatter.format(string, objectArray);
        IOException iOException = formatter.ioException();
        if (iOException != null) {
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveModel(Writer writer, Model model) throws IOException {
        int n;
        int n2 = n = model.nr_feature;
        if (model.bias >= 0.0) {
            ++n2;
        }
        int n3 = model.nr_class;
        if (model.nr_class == 2 && model.solverType != SolverType.MCSVM_CS) {
            n3 = 1;
        }
        Formatter formatter = new Formatter(writer, DEFAULT_LOCALE);
        try {
            int n4;
            Linear.printf(formatter, "solver_type %s\n", model.solverType.name());
            Linear.printf(formatter, "nr_class %d\n", model.nr_class);
            if (model.label != null) {
                Linear.printf(formatter, "label", new Object[0]);
                for (n4 = 0; n4 < model.nr_class; ++n4) {
                    Linear.printf(formatter, " %d", model.label[n4]);
                }
                Linear.printf(formatter, "\n", new Object[0]);
            }
            Linear.printf(formatter, "nr_feature %d\n", n);
            Linear.printf(formatter, "bias %.16g\n", model.bias);
            Linear.printf(formatter, "w\n", new Object[0]);
            for (n4 = 0; n4 < n2; ++n4) {
                for (int i = 0; i < n3; ++i) {
                    double d = model.w[n4 * n3 + i];
                    if (d == 0.0) {
                        Linear.printf(formatter, "%d ", 0);
                        continue;
                    }
                    Linear.printf(formatter, "%.16g ", d);
                }
                Linear.printf(formatter, "\n", new Object[0]);
            }
            formatter.flush();
            IOException iOException = formatter.ioException();
            if (iOException != null) {
                throw iOException;
            }
        }
        finally {
            formatter.close();
        }
    }

    public static void saveModel(File file, Model model) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), FILE_CHARSET));
        Linear.saveModel(bufferedWriter, model);
    }

    private static int GETI(byte[] byArray, int n) {
        return byArray[n] + 1;
    }

    private static void solve_l2r_l1l2_svc(Problem problem, double[] dArray, double d, double d2, double d3, SolverType solverType) {
        int n;
        int n2 = problem.l;
        int n3 = problem.n;
        int n4 = 0;
        double[] dArray2 = new double[n2];
        int n5 = 1000;
        int[] nArray = new int[n2];
        double[] dArray3 = new double[n2];
        byte[] byArray = new byte[n2];
        int n6 = n2;
        double d4 = Double.POSITIVE_INFINITY;
        double d5 = Double.NEGATIVE_INFINITY;
        double[] dArray4 = new double[]{0.5 / d3, 0.0, 0.5 / d2};
        double[] dArray5 = new double[]{Double.POSITIVE_INFINITY, 0.0, Double.POSITIVE_INFINITY};
        if (solverType == SolverType.L2R_L1LOSS_SVC_DUAL) {
            dArray4[0] = 0.0;
            dArray4[2] = 0.0;
            dArray5[0] = d3;
            dArray5[2] = d2;
        }
        for (n = 0; n < n2; ++n) {
            byArray[n] = problem.y[n] > 0.0 ? 1 : -1;
        }
        for (n = 0; n < n2; ++n) {
            dArray3[n] = 0.0;
        }
        for (n = 0; n < n3; ++n) {
            dArray[n] = 0.0;
        }
        for (n = 0; n < n2; ++n) {
            dArray2[n] = dArray4[Linear.GETI(byArray, n)];
            for (Feature feature : problem.x[n]) {
                double d6 = feature.getValue();
                int n7 = n;
                dArray2[n7] = dArray2[n7] + d6 * d6;
                int n8 = feature.getIndex() - 1;
                dArray[n8] = dArray[n8] + (double)byArray[n] * dArray3[n] * d6;
            }
            nArray[n] = n;
        }
        while (n4 < n5) {
            double d7 = Double.NEGATIVE_INFINITY;
            double d8 = Double.POSITIVE_INFINITY;
            for (n = 0; n < n6; ++n) {
                int n9 = n + random.nextInt(n6 - n);
                Linear.swap(nArray, n, n9);
            }
            for (int i = 0; i < n6; ++i) {
                n = nArray[i];
                double d9 = 0.0;
                byte by = byArray[n];
                for (Feature feature : problem.x[n]) {
                    d9 += dArray[feature.getIndex() - 1] * feature.getValue();
                }
                d9 = d9 * (double)by - 1.0;
                double d10 = dArray5[Linear.GETI(byArray, n)];
                d9 += dArray3[n] * dArray4[Linear.GETI(byArray, n)];
                double d11 = 0.0;
                if (dArray3[n] == 0.0) {
                    if (d9 > d4) {
                        Linear.swap(nArray, i, --n6);
                        --i;
                        continue;
                    }
                    if (d9 < 0.0) {
                        d11 = d9;
                    }
                } else if (dArray3[n] == d10) {
                    if (d9 < d5) {
                        Linear.swap(nArray, i, --n6);
                        --i;
                        continue;
                    }
                    if (d9 > 0.0) {
                        d11 = d9;
                    }
                } else {
                    d11 = d9;
                }
                d7 = Math.max(d7, d11);
                d8 = Math.min(d8, d11);
                if (!(Math.abs(d11) > 1.0E-12)) continue;
                double d12 = dArray3[n];
                dArray3[n] = Math.min(Math.max(dArray3[n] - d9 / dArray2[n], 0.0), d10);
                double d13 = (dArray3[n] - d12) * (double)by;
                for (Feature feature : problem.x[n]) {
                    int n10 = feature.getIndex() - 1;
                    dArray[n10] = dArray[n10] + d13 * feature.getValue();
                }
            }
            if (++n4 % 10 == 0) {
                Linear.info(".");
            }
            if (d7 - d8 <= d) {
                if (n6 == n2) break;
                n6 = n2;
                Linear.info("*");
                d4 = Double.POSITIVE_INFINITY;
                d5 = Double.NEGATIVE_INFINITY;
                continue;
            }
            d4 = d7;
            d5 = d8;
            if (d4 <= 0.0) {
                d4 = Double.POSITIVE_INFINITY;
            }
            if (!(d5 >= 0.0)) continue;
            d5 = Double.NEGATIVE_INFINITY;
        }
        Linear.info("%noptimization finished, #iter = %d%n", n4);
        if (n4 >= n5) {
            Linear.info("%nWARNING: reaching max number of iterations%nUsing -s 2 may be faster (also see FAQ)%n%n");
        }
        double d14 = 0.0;
        int n11 = 0;
        for (n = 0; n < n3; ++n) {
            d14 += dArray[n] * dArray[n];
        }
        for (n = 0; n < n2; ++n) {
            d14 += dArray3[n] * (dArray3[n] * dArray4[Linear.GETI(byArray, n)] - 2.0);
            if (!(dArray3[n] > 0.0)) continue;
            ++n11;
        }
        Linear.info("Objective value = %g%n", d14 / 2.0);
        Linear.info("nSV = %d%n", n11);
    }

    private static int GETI_SVR(int n) {
        return 0;
    }

    private static void solve_l2r_l1l2_svr(Problem problem, double[] dArray, Parameter parameter) {
        double d;
        int n;
        int n2 = problem.l;
        double d2 = parameter.C;
        double d3 = parameter.p;
        int n3 = problem.n;
        double d4 = parameter.eps;
        int n4 = 0;
        int n5 = 1000;
        int n6 = n2;
        int[] nArray = new int[n2];
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = 0.0;
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double[] dArray4 = problem.y;
        double[] dArray5 = new double[]{0.5 / d2};
        double[] dArray6 = new double[]{Double.POSITIVE_INFINITY};
        if (parameter.solverType == SolverType.L2R_L1LOSS_SVR_DUAL) {
            dArray5[0] = 0.0;
            dArray6[0] = d2;
        }
        for (n = 0; n < n2; ++n) {
            dArray2[n] = 0.0;
        }
        for (n = 0; n < n3; ++n) {
            dArray[n] = 0.0;
        }
        for (n = 0; n < n2; ++n) {
            dArray3[n] = 0.0;
            for (Feature feature : problem.x[n]) {
                d = feature.getValue();
                int n7 = n;
                dArray3[n7] = dArray3[n7] + d * d;
                int n8 = feature.getIndex() - 1;
                dArray[n8] = dArray[n8] + dArray2[n] * d;
            }
            nArray[n] = n;
        }
        while (n4 < n5) {
            double d7 = 0.0;
            double d8 = 0.0;
            for (n = 0; n < n6; ++n) {
                int n9 = n + random.nextInt(n6 - n);
                Linear.swap(nArray, n, n9);
            }
            for (int i = 0; i < n6; ++i) {
                n = nArray[i];
                double d9 = -dArray4[n] + dArray5[Linear.GETI_SVR(n)] * dArray2[n];
                double d10 = dArray3[n] + dArray5[Linear.GETI_SVR(n)];
                for (Feature feature : problem.x[n]) {
                    int n10 = feature.getIndex() - 1;
                    double d11 = feature.getValue();
                    d9 += d11 * dArray[n10];
                }
                double d12 = d9 + d3;
                double d13 = d9 - d3;
                d = 0.0;
                if (dArray2[n] == 0.0) {
                    if (d12 < 0.0) {
                        d = -d12;
                    } else if (d13 > 0.0) {
                        d = d13;
                    } else if (d12 > d5 && d13 < -d5) {
                        Linear.swap(nArray, i, --n6);
                        --i;
                        continue;
                    }
                } else if (dArray2[n] >= dArray6[Linear.GETI_SVR(n)]) {
                    if (d12 > 0.0) {
                        d = d12;
                    } else if (d12 < -d5) {
                        Linear.swap(nArray, i, --n6);
                        --i;
                        continue;
                    }
                } else if (dArray2[n] <= -dArray6[Linear.GETI_SVR(n)]) {
                    if (d13 < 0.0) {
                        d = -d13;
                    } else if (d13 > d5) {
                        Linear.swap(nArray, i, --n6);
                        --i;
                        continue;
                    }
                } else {
                    d = dArray2[n] > 0.0 ? Math.abs(d12) : Math.abs(d13);
                }
                d7 = Math.max(d7, d);
                d8 += d;
                double d14 = d12 < d10 * dArray2[n] ? -d12 / d10 : (d13 > d10 * dArray2[n] ? -d13 / d10 : -dArray2[n]);
                if (Math.abs(d14) < 1.0E-12) continue;
                double d15 = dArray2[n];
                dArray2[n] = Math.min(Math.max(dArray2[n] + d14, -dArray6[Linear.GETI_SVR(n)]), dArray6[Linear.GETI_SVR(n)]);
                d14 = dArray2[n] - d15;
                if (d14 == 0.0) continue;
                for (Feature feature : problem.x[n]) {
                    int n11 = feature.getIndex() - 1;
                    dArray[n11] = dArray[n11] + d14 * feature.getValue();
                }
            }
            if (n4 == 0) {
                d6 = d8;
            }
            if (++n4 % 10 == 0) {
                Linear.info(".");
            }
            if (d8 <= d4 * d6) {
                if (n6 == n2) break;
                n6 = n2;
                Linear.info("*");
                d5 = Double.POSITIVE_INFINITY;
                continue;
            }
            d5 = d7;
        }
        Linear.info("%noptimization finished, #iter = %d%n", n4);
        if (n4 >= n5) {
            Linear.info("%nWARNING: reaching max number of iterations%nUsing -s 11 may be faster%n%n");
        }
        double d16 = 0.0;
        int n12 = 0;
        for (n = 0; n < n3; ++n) {
            d16 += dArray[n] * dArray[n];
        }
        d16 = 0.5 * d16;
        for (n = 0; n < n2; ++n) {
            d16 += d3 * Math.abs(dArray2[n]) - dArray4[n] * dArray2[n] + 0.5 * dArray5[Linear.GETI_SVR(n)] * dArray2[n] * dArray2[n];
            if (dArray2[n] == 0.0) continue;
            ++n12;
        }
        Linear.info("Objective value = %g%n", d16);
        Linear.info("nSV = %d%n", n12);
    }

    private static void solve_l2r_lr_dual(Problem problem, double[] dArray, double d, double d2, double d3) {
        double d4;
        int n;
        int n2 = problem.l;
        int n3 = problem.n;
        int n4 = 0;
        double[] dArray2 = new double[n2];
        int n5 = 1000;
        int[] nArray = new int[n2];
        double[] dArray3 = new double[2 * n2];
        byte[] byArray = new byte[n2];
        int n6 = 100;
        double d5 = 0.01;
        double d6 = Math.min(1.0E-8, d);
        double[] dArray4 = new double[]{d3, 0.0, d2};
        for (n = 0; n < n2; ++n) {
            byArray[n] = problem.y[n] > 0.0 ? 1 : -1;
        }
        for (n = 0; n < n2; ++n) {
            dArray3[2 * n] = Math.min(0.001 * dArray4[Linear.GETI(byArray, n)], 1.0E-8);
            dArray3[2 * n + 1] = dArray4[Linear.GETI(byArray, n)] - dArray3[2 * n];
        }
        for (n = 0; n < n3; ++n) {
            dArray[n] = 0.0;
        }
        for (n = 0; n < n2; ++n) {
            dArray2[n] = 0.0;
            for (Feature feature : problem.x[n]) {
                d4 = feature.getValue();
                int n7 = n;
                dArray2[n7] = dArray2[n7] + d4 * d4;
                int n8 = feature.getIndex() - 1;
                dArray[n8] = dArray[n8] + (double)byArray[n] * dArray3[2 * n] * d4;
            }
            nArray[n] = n;
        }
        while (n4 < n5) {
            int n9;
            for (n = 0; n < n2; ++n) {
                n9 = n + random.nextInt(n2 - n);
                Linear.swap(nArray, n, n9);
            }
            n9 = 0;
            double d7 = 0.0;
            for (int i = 0; i < n2; ++i) {
                int n10;
                double d8;
                double d9;
                n = nArray[i];
                byte by = byArray[n];
                d4 = dArray4[Linear.GETI(byArray, n)];
                double d10 = 0.0;
                double d11 = dArray2[n];
                for (Feature feature : problem.x[n]) {
                    d10 += dArray[feature.getIndex() - 1] * feature.getValue();
                }
                double d12 = d11;
                double d13 = d10 *= (double)byArray[n];
                int n11 = 2 * n;
                int n12 = 2 * n + 1;
                int n13 = 1;
                if (0.5 * d12 * (dArray3[n12] - dArray3[n11]) + d13 < 0.0) {
                    n11 = 2 * n + 1;
                    n12 = 2 * n;
                    n13 = -1;
                }
                if (d4 - (d9 = (d8 = dArray3[n11])) < 0.5 * d4) {
                    d9 = 0.1 * d9;
                }
                double d14 = d12 * (d9 - d8) + (double)n13 * d13 + Math.log(d9 / (d4 - d9));
                d7 = Math.max(d7, Math.abs(d14));
                for (n10 = 0; n10 <= n6 && !(Math.abs(d14) < d5); ++n10) {
                    double d15 = d12 + d4 / (d4 - d9) / d9;
                    double d16 = d9 - d14 / d15;
                    d9 = d16 <= 0.0 ? (d9 *= 0.1) : d16;
                    d14 = d12 * (d9 - d8) + (double)n13 * d13 + Math.log(d9 / (d4 - d9));
                    ++n9;
                }
                if (n10 <= 0) continue;
                dArray3[n11] = d9;
                dArray3[n12] = d4 - d9;
                for (Feature feature : problem.x[n]) {
                    int n14 = feature.getIndex() - 1;
                    dArray[n14] = dArray[n14] + (double)n13 * (d9 - d8) * (double)by * feature.getValue();
                }
            }
            if (++n4 % 10 == 0) {
                Linear.info(".");
            }
            if (d7 < d) break;
            if (n9 > n2 / 10) continue;
            d5 = Math.max(d6, 0.1 * d5);
        }
        Linear.info("%noptimization finished, #iter = %d%n", n4);
        if (n4 >= n5) {
            Linear.info("%nWARNING: reaching max number of iterations%nUsing -s 0 may be faster (also see FAQ)%n%n");
        }
        double d17 = 0.0;
        for (n = 0; n < n3; ++n) {
            d17 += dArray[n] * dArray[n];
        }
        d17 *= 0.5;
        for (n = 0; n < n2; ++n) {
            d17 += dArray3[2 * n] * Math.log(dArray3[2 * n]) + dArray3[2 * n + 1] * Math.log(dArray3[2 * n + 1]) - dArray4[Linear.GETI(byArray, n)] * Math.log(dArray4[Linear.GETI(byArray, n)]);
        }
        Linear.info("Objective value = %g%n", d17);
    }

    private static void solve_l1r_l2_svc(Problem problem, double[] dArray, double d, double d2, double d3) {
        double d4;
        int n;
        int n2 = problem.l;
        int n3 = problem.n;
        int n4 = 0;
        int n5 = 1000;
        int n6 = n3;
        int n7 = 20;
        double d5 = 0.01;
        double d6 = Double.POSITIVE_INFINITY;
        double d7 = 0.0;
        double d8 = 0.0;
        int[] nArray = new int[n3];
        byte[] byArray = new byte[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[]{d3, 0.0, d2};
        for (n = 0; n < n3; ++n) {
            dArray[n] = 0.0;
        }
        for (n = 0; n < n2; ++n) {
            dArray2[n] = 1.0;
            byArray[n] = problem.y[n] > 0.0 ? 1 : -1;
        }
        for (n = 0; n < n3; ++n) {
            nArray[n] = n;
            dArray3[n] = 0.0;
            for (Feature object : problem.x[n]) {
                int n8 = object.getIndex() - 1;
                object.setValue(object.getValue() * (double)byArray[n8]);
                d4 = object.getValue();
                int n9 = n8;
                dArray2[n9] = dArray2[n9] - dArray[n] * d4;
                int n10 = n;
                dArray3[n10] = dArray3[n10] + dArray4[Linear.GETI(byArray, n8)] * d4 * d4;
            }
        }
        while (n4 < n5) {
            double d9 = 0.0;
            double d10 = 0.0;
            for (n = 0; n < n6; ++n) {
                int n11 = n + random.nextInt(n6 - n);
                Linear.swap(nArray, n11, n);
            }
            for (int i = 0; i < n6; ++i) {
                int n11;
                int n12;
                n = nArray[i];
                double d11 = 0.0;
                double d12 = 0.0;
                for (Feature feature : problem.x[n]) {
                    int n13 = feature.getIndex() - 1;
                    if (!(dArray2[n13] > 0.0)) continue;
                    d4 = feature.getValue();
                    double d13 = dArray4[Linear.GETI(byArray, n13)] * d4;
                    d11 -= d13 * dArray2[n13];
                    d12 += d13 * d4;
                }
                double d14 = d11 *= 2.0;
                d12 *= 2.0;
                d12 = Math.max(d12, 1.0E-12);
                double d15 = d14 + 1.0;
                double d16 = d14 - 1.0;
                double d17 = 0.0;
                if (dArray[n] == 0.0) {
                    if (d15 < 0.0) {
                        d17 = -d15;
                    } else if (d16 > 0.0) {
                        d17 = d16;
                    } else if (d15 > d6 / (double)n2 && d16 < -d6 / (double)n2) {
                        Linear.swap(nArray, i, --n6);
                        --i;
                        continue;
                    }
                } else {
                    d17 = dArray[n] > 0.0 ? Math.abs(d15) : Math.abs(d16);
                }
                d9 = Math.max(d9, d17);
                d10 += d17;
                double d18 = d15 < d12 * dArray[n] ? -d15 / d12 : (d16 > d12 * dArray[n] ? -d16 / d12 : -dArray[n]);
                if (Math.abs(d18) < 1.0E-12) continue;
                double d19 = Math.abs(dArray[n] + d18) - Math.abs(dArray[n]) + d14 * d18;
                double d20 = 0.0;
                for (n12 = 0; n12 < n7; ++n12) {
                    double d21;
                    int n14;
                    double d22;
                    double d23 = d20 - d18;
                    double d24 = Math.abs(dArray[n] + d18) - Math.abs(dArray[n]) - d5 * d19;
                    double d25 = dArray3[n] * d18 * d18 + d11 * d18 + d24;
                    if (d25 <= 0.0) {
                        for (Feature feature : problem.x[n]) {
                            int n15 = feature.getIndex() - 1;
                            dArray2[n15] = dArray2[n15] + d23 * feature.getValue();
                        }
                        break;
                    }
                    if (n12 == 0) {
                        d8 = 0.0;
                        d22 = 0.0;
                        for (Feature feature : problem.x[n]) {
                            n14 = feature.getIndex() - 1;
                            if (dArray2[n14] > 0.0) {
                                d8 += dArray4[Linear.GETI(byArray, n14)] * dArray2[n14] * dArray2[n14];
                            }
                            dArray2[n14] = d21 = dArray2[n14] + d23 * feature.getValue();
                            if (!(d21 > 0.0)) continue;
                            d22 += dArray4[Linear.GETI(byArray, n14)] * d21 * d21;
                        }
                    } else {
                        d22 = 0.0;
                        for (Feature feature : problem.x[n]) {
                            n14 = feature.getIndex() - 1;
                            dArray2[n14] = d21 = dArray2[n14] + d23 * feature.getValue();
                            if (!(d21 > 0.0)) continue;
                            d22 += dArray4[Linear.GETI(byArray, n14)] * d21 * d21;
                        }
                    }
                    if ((d24 = d24 + d22 - d8) <= 0.0) break;
                    d20 = d18;
                    d18 *= 0.5;
                    d19 *= 0.5;
                }
                int n16 = n;
                dArray[n16] = dArray[n16] + d18;
                if (n12 < n7) continue;
                Linear.info("#");
                for (n11 = 0; n11 < n2; ++n11) {
                    dArray2[n11] = 1.0;
                }
                for (n11 = 0; n11 < n3; ++n11) {
                    if (dArray[n11] == 0.0) continue;
                    for (Feature feature : problem.x[n11]) {
                        int n17 = feature.getIndex() - 1;
                        dArray2[n17] = dArray2[n17] - dArray[n11] * feature.getValue();
                    }
                }
            }
            if (n4 == 0) {
                d7 = d10;
            }
            if (++n4 % 10 == 0) {
                Linear.info(".");
            }
            if (d9 <= d * d7) {
                if (n6 == n3) break;
                n6 = n3;
                Linear.info("*");
                d6 = Double.POSITIVE_INFINITY;
                continue;
            }
            d6 = d9;
        }
        Linear.info("%noptimization finished, #iter = %d%n", n4);
        if (n4 >= n5) {
            Linear.info("%nWARNING: reaching max number of iterations%n");
        }
        double d26 = 0.0;
        int n19 = 0;
        for (n = 0; n < n3; ++n) {
            for (Feature feature : problem.x[n]) {
                feature.setValue(feature.getValue() * problem.y[feature.getIndex() - 1]);
            }
            if (dArray[n] == 0.0) continue;
            d26 += Math.abs(dArray[n]);
            ++n19;
        }
        for (n = 0; n < n2; ++n) {
            if (!(dArray2[n] > 0.0)) continue;
            d26 += dArray4[Linear.GETI(byArray, n)] * dArray2[n] * dArray2[n];
        }
        Linear.info("Objective value = %g%n", d26);
        Linear.info("#nonzeros/#features = %d/%d%n", n19, n3);
    }

    private static void solve_l1r_lr(Problem problem, double[] dArray, double d, double d2, double d3) {
        int n;
        int n2;
        int n3 = problem.l;
        int n4 = problem.n;
        int n5 = 0;
        int n6 = 0;
        int n7 = 100;
        int n8 = 1000;
        int n9 = 20;
        double d4 = 1.0E-12;
        double d5 = 1.0;
        double d6 = 0.01;
        double d7 = 0.0;
        double d8 = Double.POSITIVE_INFINITY;
        double d9 = Double.POSITIVE_INFINITY;
        int[] nArray = new int[n4];
        byte[] byArray = new byte[n3];
        double[] dArray2 = new double[n4];
        double[] dArray3 = new double[n4];
        double[] dArray4 = new double[n4];
        double[] dArray5 = new double[n4];
        double[] dArray6 = new double[n3];
        double[] dArray7 = new double[n3];
        double[] dArray8 = new double[n3];
        double[] dArray9 = new double[n3];
        double[] dArray10 = new double[n3];
        double[] dArray11 = new double[]{d3, 0.0, d2};
        for (n2 = 0; n2 < n4; ++n2) {
            dArray[n2] = 0.0;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            byArray[n2] = problem.y[n2] > 0.0 ? 1 : -1;
            dArray7[n2] = 0.0;
        }
        double d10 = 0.0;
        for (n2 = 0; n2 < n4; ++n2) {
            d10 += Math.abs(dArray[n2]);
            dArray4[n2] = dArray[n2];
            nArray[n2] = n2;
            dArray5[n2] = 0.0;
            Feature[] featureArray = problem.x[n2];
            n = featureArray.length;
            for (int i = 0; i < n; ++i) {
                Feature feature = featureArray[i];
                int n10 = feature.getIndex() - 1;
                double d11 = feature.getValue();
                int n11 = n10;
                dArray7[n11] = dArray7[n11] + dArray[n2] * d11;
                if (byArray[n10] != -1) continue;
                int n12 = n2;
                dArray5[n12] = dArray5[n12] + dArray11[Linear.GETI(byArray, n10)] * d11;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray7[n2] = Math.exp(dArray7[n2]);
            double d12 = 1.0 / (1.0 + dArray7[n2]);
            dArray9[n2] = dArray11[Linear.GETI(byArray, n2)] * d12;
            dArray10[n2] = dArray11[Linear.GETI(byArray, n2)] * dArray7[n2] * d12 * d12;
        }
        while (n5 < n7) {
            int n13;
            int n14;
            double d13 = 0.0;
            double d14 = 0.0;
            int n15 = n4;
            for (n14 = 0; n14 < n15; ++n14) {
                n2 = nArray[n14];
                dArray2[n2] = d4;
                dArray3[n2] = 0.0;
                double d15 = 0.0;
                for (Feature feature : problem.x[n2]) {
                    int n16 = feature.getIndex() - 1;
                    int n17 = n2;
                    dArray2[n17] = dArray2[n17] + feature.getValue() * feature.getValue() * dArray10[n16];
                    d15 += feature.getValue() * dArray9[n16];
                }
                dArray3[n2] = -d15 + dArray5[n2];
                double d16 = dArray3[n2] + 1.0;
                double d17 = dArray3[n2] - 1.0;
                double d18 = 0.0;
                if (dArray[n2] == 0.0) {
                    if (d16 < 0.0) {
                        d18 = -d16;
                    } else if (d17 > 0.0) {
                        d18 = d17;
                    } else if (d16 > d8 / (double)n3 && d17 < -d8 / (double)n3) {
                        Linear.swap(nArray, n14, --n15);
                        --n14;
                        continue;
                    }
                } else {
                    d18 = dArray[n2] > 0.0 ? Math.abs(d16) : Math.abs(d17);
                }
                d13 = Math.max(d13, d18);
                d14 += d18;
            }
            if (n5 == 0) {
                d7 = d14;
            }
            if (d14 <= d * d7) break;
            n6 = 0;
            d9 = Double.POSITIVE_INFINITY;
            int n18 = n15;
            for (int i = 0; i < n3; ++i) {
                dArray6[i] = 0.0;
            }
            while (n6 < n8) {
                double d19 = 0.0;
                double d20 = 0.0;
                for (n2 = 0; n2 < n18; ++n2) {
                    int n19 = random.nextInt(n18 - n2);
                    Linear.swap(nArray, n19, n2);
                }
                for (n14 = 0; n14 < n18; ++n14) {
                    n2 = nArray[n14];
                    double d21 = dArray2[n2];
                    double d22 = dArray3[n2] + (dArray4[n2] - dArray[n2]) * d4;
                    Feature[] featureArray = problem.x[n2];
                    n = featureArray.length;
                    for (int i = 0; i < n; ++i) {
                        Feature feature = featureArray[i];
                        int n20 = feature.getIndex() - 1;
                        d22 += feature.getValue() * dArray10[n20] * dArray6[n20];
                    }
                    double d23 = d22 + 1.0;
                    double d24 = d22 - 1.0;
                    double d25 = 0.0;
                    if (dArray4[n2] == 0.0) {
                        if (d23 < 0.0) {
                            d25 = -d23;
                        } else if (d24 > 0.0) {
                            d25 = d24;
                        } else if (d23 > d9 / (double)n3 && d24 < -d9 / (double)n3) {
                            Linear.swap(nArray, n14, --n18);
                            --n14;
                            continue;
                        }
                    } else {
                        d25 = dArray4[n2] > 0.0 ? Math.abs(d23) : Math.abs(d24);
                    }
                    d19 = Math.max(d19, d25);
                    d20 += d25;
                    double d26 = d23 < d21 * dArray4[n2] ? -d23 / d21 : (d24 > d21 * dArray4[n2] ? -d24 / d21 : -dArray4[n2]);
                    if (Math.abs(d26) < 1.0E-12) continue;
                    d26 = Math.min(Math.max(d26, -10.0), 10.0);
                    int n21 = n2;
                    dArray4[n21] = dArray4[n21] + d26;
                    for (Feature feature : problem.x[n2]) {
                        int n22;
                        int n23 = n22 = feature.getIndex() - 1;
                        dArray6[n23] = dArray6[n23] + feature.getValue() * d26;
                    }
                }
                ++n6;
                if (d20 <= d5 * d7) {
                    if (n18 == n15) break;
                    n18 = n15;
                    d9 = Double.POSITIVE_INFINITY;
                    continue;
                }
                d9 = d19;
            }
            if (n6 >= n8) {
                Linear.info("WARNING: reaching max number of inner iterations%n");
            }
            double d27 = 0.0;
            double d28 = 0.0;
            for (n2 = 0; n2 < n4; ++n2) {
                d27 += dArray3[n2] * (dArray4[n2] - dArray[n2]);
                if (dArray4[n2] == 0.0) continue;
                d28 += Math.abs(dArray4[n2]);
            }
            d27 += d28 - d10;
            double d29 = 0.0;
            for (n13 = 0; n13 < n3; ++n13) {
                if (byArray[n13] != -1) continue;
                d29 += dArray11[Linear.GETI(byArray, n13)] * dArray6[n13];
            }
            for (n13 = 0; n13 < n9; ++n13) {
                double d30 = d28 - d10 + d29 - d6 * d27;
                for (n = 0; n < n3; ++n) {
                    double d31 = Math.exp(dArray6[n]);
                    dArray8[n] = dArray7[n] * d31;
                    d30 += dArray11[Linear.GETI(byArray, n)] * Math.log((1.0 + dArray8[n]) / (d31 + dArray8[n]));
                }
                if (d30 <= 0.0) {
                    d10 = d28;
                    for (n2 = 0; n2 < n4; ++n2) {
                        dArray[n2] = dArray4[n2];
                    }
                    for (n = 0; n < n3; ++n) {
                        dArray7[n] = dArray8[n];
                        double d32 = 1.0 / (1.0 + dArray7[n]);
                        dArray9[n] = dArray11[Linear.GETI(byArray, n)] * d32;
                        dArray10[n] = dArray11[Linear.GETI(byArray, n)] * dArray7[n] * d32 * d32;
                    }
                    break;
                }
                d28 = 0.0;
                for (n2 = 0; n2 < n4; ++n2) {
                    dArray4[n2] = (dArray[n2] + dArray4[n2]) * 0.5;
                    if (dArray4[n2] == 0.0) continue;
                    d28 += Math.abs(dArray4[n2]);
                }
                d27 *= 0.5;
                d29 *= 0.5;
                n = 0;
                while (n < n3) {
                    int n24 = n++;
                    dArray6[n24] = dArray6[n24] * 0.5;
                }
            }
            if (n13 >= n9) {
                for (n = 0; n < n3; ++n) {
                    dArray7[n] = 0.0;
                }
                for (n = 0; n < n4; ++n) {
                    if (dArray[n] == 0.0) continue;
                    for (Feature feature : problem.x[n]) {
                        int n25 = feature.getIndex() - 1;
                        dArray7[n25] = dArray7[n25] + dArray[n] * feature.getValue();
                    }
                }
                for (n = 0; n < n3; ++n) {
                    dArray7[n] = Math.exp(dArray7[n]);
                }
            }
            if (n6 == 1) {
                d5 *= 0.25;
            }
            d8 = d13;
            Linear.info("iter %3d  #CD cycles %d%n", ++n5, n6);
        }
        Linear.info("=========================%n");
        Linear.info("optimization finished, #iter = %d%n", n5);
        if (n5 >= n7) {
            Linear.info("WARNING: reaching max number of iterations%n");
        }
        double d33 = 0.0;
        int n26 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            if (dArray[n2] == 0.0) continue;
            d33 += Math.abs(dArray[n2]);
            ++n26;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (byArray[n2] == 1) {
                d33 += dArray11[Linear.GETI(byArray, n2)] * Math.log(1.0 + 1.0 / dArray7[n2]);
                continue;
            }
            d33 += dArray11[Linear.GETI(byArray, n2)] * Math.log(1.0 + dArray7[n2]);
        }
        Linear.info("Objective value = %g%n", d33);
        Linear.info("#nonzeros/#features = %d/%d%n", n26, n4);
    }

    static Problem transpose(Problem problem) {
        int n;
        int n2 = problem.l;
        int n3 = problem.n;
        int[] nArray = new int[n3 + 1];
        Problem problem2 = new Problem();
        problem2.l = n2;
        problem2.n = n3;
        problem2.y = new double[n2];
        problem2.x = new Feature[n3][];
        for (n = 0; n < n2; ++n) {
            problem2.y[n] = problem.y[n];
        }
        for (n = 0; n < n2; ++n) {
            for (Feature feature : problem.x[n]) {
                int n4 = feature.getIndex();
                nArray[n4] = nArray[n4] + 1;
            }
        }
        for (n = 0; n < n3; ++n) {
            problem2.x[n] = new Feature[nArray[n + 1]];
            nArray[n] = 0;
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < problem.x[n].length; ++i) {
                Feature feature = problem.x[n][i];
                int n5 = feature.getIndex() - 1;
                problem2.x[n5][nArray[n5]] = new FeatureNode(n + 1, feature.getValue());
                int n6 = n5;
                nArray[n6] = nArray[n6] + 1;
            }
        }
        return problem2;
    }

    static void swap(double[] dArray, int n, int n2) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
    }

    static void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    static void swap(IntArrayPointer intArrayPointer, int n, int n2) {
        int n3 = intArrayPointer.get(n);
        intArrayPointer.set(n, intArrayPointer.get(n2));
        intArrayPointer.set(n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    public static Model train(Problem problem, Parameter parameter) {
        Object object22;
        if (problem == null) {
            throw new IllegalArgumentException("problem must not be null");
        }
        if (parameter == null) {
            throw new IllegalArgumentException("parameter must not be null");
        }
        if (problem.n == 0) {
            throw new IllegalArgumentException("problem has zero features");
        }
        if (problem.l == 0) {
            throw new IllegalArgumentException("problem has zero instances");
        }
        for (Object object22 : problem.x) {
            int n = 0;
            for (Feature feature : object22) {
                if (feature.getIndex() <= n) {
                    throw new IllegalArgumentException("feature nodes must be sorted by index in ascending order");
                }
                n = feature.getIndex();
            }
        }
        int n = problem.l;
        int n2 = problem.n;
        int n3 = problem.n;
        object22 = new Model();
        object22.nr_feature = problem.bias >= 0.0 ? n2 - 1 : n2;
        object22.solverType = parameter.solverType;
        object22.bias = problem.bias;
        if (parameter.solverType == SolverType.L2R_L2LOSS_SVR || parameter.solverType == SolverType.L2R_L1LOSS_SVR_DUAL || parameter.solverType == SolverType.L2R_L2LOSS_SVR_DUAL) {
            object22.w = new double[n3];
            object22.nr_class = 2;
            object22.label = null;
            Linear.checkProblemSize(n2, object22.nr_class);
            Linear.train_one(problem, parameter, object22.w, 0.0, 0.0);
        } else {
            int dArray2;
            int n4;
            int n5;
            int[] nArray = new int[n];
            GroupClassesReturn groupClassesReturn = Linear.groupClasses(problem, nArray);
            int n6 = groupClassesReturn.nr_class;
            int[] nArray2 = groupClassesReturn.label;
            int[] nArray3 = groupClassesReturn.start;
            int[] nArray4 = groupClassesReturn.count;
            Linear.checkProblemSize(n2, n6);
            object22.nr_class = n6;
            object22.label = new int[n6];
            for (int i = 0; i < n6; ++i) {
                object22.label[i] = nArray2[i];
            }
            double[] dArray = new double[n6];
            for (n5 = 0; n5 < n6; ++n5) {
                dArray[n5] = parameter.C;
            }
            for (n5 = 0; n5 < parameter.getNumWeights(); ++n5) {
                for (n4 = 0; n4 < n6 && parameter.weightLabel[n5] != nArray2[n4]; ++n4) {
                }
                if (n4 == n6) {
                    throw new IllegalArgumentException("class label " + parameter.weightLabel[n5] + " specified in weight is not found");
                }
                int n7 = n4;
                dArray[n7] = dArray[n7] * parameter.weight[n5];
            }
            Feature[][] featureArrayArray = new Feature[n][];
            for (n4 = 0; n4 < n; ++n4) {
                featureArrayArray[n4] = problem.x[nArray[n4]];
            }
            Problem problem2 = new Problem();
            problem2.l = n;
            problem2.n = n2;
            problem2.x = new Feature[problem2.l][];
            problem2.y = new double[problem2.l];
            for (dArray2 = 0; dArray2 < problem2.l; ++dArray2) {
                problem2.x[dArray2] = featureArrayArray[dArray2];
            }
            if (parameter.solverType == SolverType.MCSVM_CS) {
                object22.w = new double[n2 * n6];
                for (dArray2 = 0; dArray2 < n6; ++dArray2) {
                    for (int i = nArray3[dArray2]; i < nArray3[dArray2] + nArray4[dArray2]; ++i) {
                        problem2.y[i] = dArray2;
                    }
                }
                SolverMCSVM_CS solverMCSVM_CS = new SolverMCSVM_CS(problem2, n6, dArray, parameter.eps);
                solverMCSVM_CS.solve(object22.w);
            } else if (n6 == 2) {
                void var16_29;
                void var16_28;
                object22.w = new double[n3];
                dArray2 = nArray3[0] + nArray4[0];
                boolean bl = false;
                while (var16_28 < dArray2) {
                    problem2.y[var16_28] = 1.0;
                    ++var16_28;
                }
                while (var16_29 < problem2.l) {
                    problem2.y[var16_29] = -1.0;
                    ++var16_29;
                }
                Linear.train_one(problem2, parameter, object22.w, dArray[0], dArray[1]);
            } else {
                void var16_31;
                object22.w = new double[n3 * n6];
                double[] dArray3 = new double[n3];
                boolean bl = false;
                while (var16_31 < n6) {
                    int n8;
                    int n9 = nArray3[var16_31];
                    int n10 = n9 + nArray4[var16_31];
                    for (n8 = 0; n8 < n9; ++n8) {
                        problem2.y[n8] = -1.0;
                    }
                    while (n8 < n10) {
                        problem2.y[n8] = 1.0;
                        ++n8;
                    }
                    while (n8 < problem2.l) {
                        problem2.y[n8] = -1.0;
                        ++n8;
                    }
                    Linear.train_one(problem2, parameter, dArray3, dArray[var16_31], parameter.C);
                    for (int i = 0; i < n2; ++i) {
                        object22.w[i * n6 + var16_31] = dArray3[i];
                    }
                    ++var16_31;
                }
            }
        }
        return object22;
    }

    private static void checkProblemSize(int n, int n2) {
        if (n >= Integer.MAX_VALUE / n2 || n * n2 < 0) {
            throw new IllegalArgumentException("'number of classes' * 'number of instances' is too large: " + n2 + "*" + n);
        }
    }

    private static void train_one(Problem problem, Parameter parameter, double[] dArray, double d, double d2) {
        int n;
        double d3 = parameter.eps;
        int n2 = 0;
        for (n = 0; n < problem.l; ++n) {
            if (!(problem.y[n] > 0.0)) continue;
            ++n2;
        }
        n = problem.l - n2;
        double d4 = d3 * (double)Math.max(Math.min(n2, n), 1) / (double)problem.l;
        Function function = null;
        switch (parameter.solverType) {
            case L2R_LR: {
                double[] dArray2 = new double[problem.l];
                for (int i = 0; i < problem.l; ++i) {
                    dArray2[i] = problem.y[i] > 0.0 ? d : d2;
                }
                function = new L2R_LrFunction(problem, dArray2);
                Tron tron = new Tron(function, d4);
                tron.tron(dArray);
                break;
            }
            case L2R_L2LOSS_SVC: {
                double[] dArray3 = new double[problem.l];
                for (int i = 0; i < problem.l; ++i) {
                    dArray3[i] = problem.y[i] > 0.0 ? d : d2;
                }
                function = new L2R_L2_SvcFunction(problem, dArray3);
                Tron tron = new Tron(function, d4);
                tron.tron(dArray);
                break;
            }
            case L2R_L2LOSS_SVC_DUAL: {
                Linear.solve_l2r_l1l2_svc(problem, dArray, d3, d, d2, SolverType.L2R_L2LOSS_SVC_DUAL);
                break;
            }
            case L2R_L1LOSS_SVC_DUAL: {
                Linear.solve_l2r_l1l2_svc(problem, dArray, d3, d, d2, SolverType.L2R_L1LOSS_SVC_DUAL);
                break;
            }
            case L1R_L2LOSS_SVC: {
                Problem problem2 = Linear.transpose(problem);
                Linear.solve_l1r_l2_svc(problem2, dArray, d4, d, d2);
                break;
            }
            case L1R_LR: {
                Problem problem3 = Linear.transpose(problem);
                Linear.solve_l1r_lr(problem3, dArray, d4, d, d2);
                break;
            }
            case L2R_LR_DUAL: {
                Linear.solve_l2r_lr_dual(problem, dArray, d3, d, d2);
                break;
            }
            case L2R_L2LOSS_SVR: {
                double[] dArray4 = new double[problem.l];
                for (int i = 0; i < problem.l; ++i) {
                    dArray4[i] = parameter.C;
                }
                function = new L2R_L2_SvrFunction(problem, dArray4, parameter.p);
                Tron tron = new Tron(function, parameter.eps);
                tron.tron(dArray);
                break;
            }
            case L2R_L1LOSS_SVR_DUAL: 
            case L2R_L2LOSS_SVR_DUAL: {
                Linear.solve_l2r_l1l2_svr(problem, dArray, parameter);
                break;
            }
            default: {
                throw new IllegalStateException("unknown solver type: " + (Object)((Object)parameter.solverType));
            }
        }
    }

    public static void disableDebugOutput() {
        Linear.setDebugOutput(null);
    }

    public static void enableDebugOutput() {
        Linear.setDebugOutput(System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDebugOutput(PrintStream printStream) {
        Object object = OUTPUT_MUTEX;
        synchronized (object) {
            DEBUG_OUTPUT = printStream;
        }
    }

    public static void resetRandom() {
        random = new Random(0L);
    }

    private static class GroupClassesReturn {
        final int[] count;
        final int[] label;
        final int nr_class;
        final int[] start;

        GroupClassesReturn(int n, int[] nArray, int[] nArray2, int[] nArray3) {
            this.nr_class = n;
            this.label = nArray;
            this.start = nArray2;
            this.count = nArray3;
        }
    }
}

