/*
 * Decompiled with CFR 0.152.
 */
package nak.quasinewton;

import nak.quasinewton.ArrayMath;
import nak.quasinewton.DifferentiableFunction;
import nak.quasinewton.LineSearchResult;

public class LineSearch {
    private static final double INITIAL_STEP_SIZE = 1.0;
    private static final double MIN_STEP_SIZE = 1.0E-10;
    private static final double C1 = 1.0E-4;
    private static final double C2 = 0.9;
    private static final double TT = 16.0;

    public static LineSearchResult doLineSearch(DifferentiableFunction differentiableFunction, double[] dArray, LineSearchResult lineSearchResult) {
        return LineSearch.doLineSearch(differentiableFunction, dArray, lineSearchResult, false);
    }

    public static LineSearchResult doLineSearch(DifferentiableFunction differentiableFunction, double[] dArray, LineSearchResult lineSearchResult, boolean bl) {
        long l;
        double d;
        double[] dArray2;
        double[] dArray3;
        double[] dArray4;
        double d2;
        double[] dArray5;
        double d3;
        int n;
        block5: {
            n = lineSearchResult.getFctEvalCount();
            d3 = 1.0;
            dArray5 = lineSearchResult.getNextPoint();
            d2 = lineSearchResult.getValueAtNext();
            dArray4 = lineSearchResult.getGradAtNext();
            dArray3 = null;
            dArray2 = null;
            d = 0.0;
            double d4 = 0.0;
            double d5 = Double.POSITIVE_INFINITY;
            l = System.currentTimeMillis();
            do {
                dArray3 = ArrayMath.updatePoint(dArray5, dArray, d3);
                d = differentiableFunction.valueAt(dArray3);
                ++n;
                dArray2 = differentiableFunction.gradientAt(dArray3);
                if (!LineSearch.checkArmijoCond(d2, d, dArray4, dArray, d3, true)) {
                    d5 = d3;
                } else {
                    if (LineSearch.checkCurvature(dArray2, dArray4, dArray, dArray5.length, true)) break block5;
                    d4 = d3;
                }
                if (d5 < Double.POSITIVE_INFINITY) {
                    d3 = (d4 + d5) / 16.0;
                    continue;
                }
                d3 *= 16.0;
            } while (!(d3 < 1.0E-10 + d4));
            d3 = 0.0;
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        if (bl) {
            System.out.print("\t" + d2);
            System.out.print("\t" + (d - d2));
            System.out.print("\t" + (double)l3 / 1000.0 + "\n");
        }
        LineSearchResult lineSearchResult2 = new LineSearchResult(d3, d2, d, dArray4, dArray2, dArray5, dArray3, n);
        return lineSearchResult2;
    }

    private static boolean checkArmijoCond(double d, double d2, double[] dArray, double[] dArray2, double d3, boolean bl) {
        double d4 = d + 1.0E-4 * ArrayMath.innerProduct(dArray2, dArray) * d3;
        return bl ? d2 > d4 : d2 <= d4;
    }

    private static boolean checkCurvature(double[] dArray, double[] dArray2, double[] dArray3, int n, boolean bl) {
        double d = ArrayMath.innerProduct(dArray3, dArray);
        double d2 = 0.9 * ArrayMath.innerProduct(dArray3, dArray2);
        return bl ? d < d2 : d >= d2;
    }
}

