/*
 * Decompiled with CFR 0.152.
 */
package nak.util;

public class IndexHashTable<T> {
    private final Object[] keys;
    private final int[] values;
    private final int size;

    public IndexHashTable(T[] TArray, double d) {
        if (d <= 0.0 || d > 1.0) {
            throw new IllegalArgumentException("loadfactor must be larger than 0 and equal to or smaller than 1 but is " + d + "!");
        }
        int n = (int)((double)TArray.length / d) + 1;
        this.keys = new Object[n];
        this.values = new int[n];
        this.size = TArray.length;
        int n2 = 0;
        while (n2 < TArray.length) {
            int n3 = IndexHashTable.indexForHash(TArray[n2].hashCode(), this.keys.length);
            int n4 = this.searchKey(n3, null, true);
            if (n4 == -1) {
                throw new IllegalArgumentException("Array must contain only unique keys!");
            }
            this.keys[n4] = TArray[n2];
            this.values[n4] = n2++;
        }
    }

    private static int indexForHash(int n, int n2) {
        return (n & Integer.MAX_VALUE) % n2;
    }

    private int searchKey(int n, Object object, boolean bl) {
        int n2 = n;
        while (true) {
            if (this.keys[n2] == null) {
                if (bl) {
                    return n2;
                }
                return -1;
            }
            if (this.keys[n2].equals(object)) {
                if (!bl) {
                    return n2;
                }
                return -1;
            }
            n2 = (n2 + 1) % this.keys.length;
        }
    }

    public int get(T t) {
        int n = IndexHashTable.indexForHash(t.hashCode(), this.keys.length);
        int n2 = this.searchKey(n, t, false);
        if (n2 != -1) {
            return this.values[n2];
        }
        return -1;
    }

    public int size() {
        return this.size;
    }

    public T[] toArray(T[] TArray) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            TArray[this.values[i]] = this.keys[i];
        }
        return TArray;
    }
}

