/*
 * Decompiled with CFR 0.152.
 */
package nak.liblinear;

import nak.liblinear.Feature;
import nak.liblinear.Function;
import nak.liblinear.Problem;

class L2R_L2_SvcFunction
implements Function {
    protected final Problem prob;
    protected final double[] C;
    protected final int[] I;
    protected final double[] z;
    protected int sizeI;

    public L2R_L2_SvcFunction(Problem problem, double[] dArray) {
        int n = problem.l;
        this.prob = problem;
        this.z = new double[n];
        this.I = new int[n];
        this.C = dArray;
    }

    @Override
    public double fun(double[] dArray) {
        int n;
        double d = 0.0;
        double[] dArray2 = this.prob.y;
        int n2 = this.prob.l;
        int n3 = this.get_nr_variable();
        this.Xv(dArray, this.z);
        for (n = 0; n < n3; ++n) {
            d += dArray[n] * dArray[n];
        }
        d /= 2.0;
        for (n = 0; n < n2; ++n) {
            this.z[n] = dArray2[n] * this.z[n];
            double d2 = 1.0 - this.z[n];
            if (!(d2 > 0.0)) continue;
            d += this.C[n] * d2 * d2;
        }
        return d;
    }

    @Override
    public int get_nr_variable() {
        return this.prob.n;
    }

    @Override
    public void grad(double[] dArray, double[] dArray2) {
        int n;
        double[] dArray3 = this.prob.y;
        int n2 = this.prob.l;
        int n3 = this.get_nr_variable();
        this.sizeI = 0;
        for (n = 0; n < n2; ++n) {
            if (!(this.z[n] < 1.0)) continue;
            this.z[this.sizeI] = this.C[n] * dArray3[n] * (this.z[n] - 1.0);
            this.I[this.sizeI] = n;
            ++this.sizeI;
        }
        this.subXTv(this.z, dArray2);
        for (n = 0; n < n3; ++n) {
            dArray2[n] = dArray[n] + 2.0 * dArray2[n];
        }
    }

    @Override
    public void Hv(double[] dArray, double[] dArray2) {
        int n;
        int n2 = this.get_nr_variable();
        double[] dArray3 = new double[this.sizeI];
        this.subXv(dArray, dArray3);
        for (n = 0; n < this.sizeI; ++n) {
            dArray3[n] = this.C[this.I[n]] * dArray3[n];
        }
        this.subXTv(dArray3, dArray2);
        for (n = 0; n < n2; ++n) {
            dArray2[n] = dArray[n] + 2.0 * dArray2[n];
        }
    }

    protected void subXTv(double[] dArray, double[] dArray2) {
        int n;
        int n2 = this.get_nr_variable();
        for (n = 0; n < n2; ++n) {
            dArray2[n] = 0.0;
        }
        for (n = 0; n < this.sizeI; ++n) {
            for (Feature feature : this.prob.x[this.I[n]]) {
                int n3 = feature.getIndex() - 1;
                dArray2[n3] = dArray2[n3] + dArray[n] * feature.getValue();
            }
        }
    }

    private void subXv(double[] dArray, double[] dArray2) {
        for (int i = 0; i < this.sizeI; ++i) {
            dArray2[i] = 0.0;
            for (Feature feature : this.prob.x[this.I[i]]) {
                int n = i;
                dArray2[n] = dArray2[n] + dArray[feature.getIndex() - 1] * feature.getValue();
            }
        }
    }

    protected void Xv(double[] dArray, double[] dArray2) {
        for (int i = 0; i < this.prob.l; ++i) {
            dArray2[i] = 0.0;
            for (Feature feature : this.prob.x[i]) {
                int n = i;
                dArray2[n] = dArray2[n] + dArray[feature.getIndex() - 1] * feature.getValue();
            }
        }
    }
}

