/*
 * Decompiled with CFR 0.152.
 */
package nak.liblinear;

import nak.liblinear.Linear;
import nak.liblinear.SolverType;

public final class Parameter {
    double C;
    double eps;
    SolverType solverType;
    double[] weight = null;
    int[] weightLabel = null;
    double p;

    public Parameter(SolverType solverType, double d, double d2) {
        this(solverType, d, d2, 0.1);
    }

    public Parameter(SolverType solverType, double d, double d2, double d3) {
        this.setSolverType(solverType);
        this.setC(d);
        this.setEps(d2);
        this.setP(d3);
    }

    public void setWeights(double[] dArray, int[] nArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("'weight' must not be null");
        }
        if (nArray == null || nArray.length != dArray.length) {
            throw new IllegalArgumentException("'weightLabels' must have same length as 'weight'");
        }
        this.weightLabel = Linear.copyOf(nArray, nArray.length);
        this.weight = Linear.copyOf(dArray, dArray.length);
    }

    public double[] getWeights() {
        return Linear.copyOf(this.weight, this.weight.length);
    }

    public int[] getWeightLabels() {
        return Linear.copyOf(this.weightLabel, this.weightLabel.length);
    }

    public int getNumWeights() {
        if (this.weight == null) {
            return 0;
        }
        return this.weight.length;
    }

    public void setC(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("C must not be <= 0");
        }
        this.C = d;
    }

    public double getC() {
        return this.C;
    }

    public void setEps(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("eps must not be <= 0");
        }
        this.eps = d;
    }

    public double getEps() {
        return this.eps;
    }

    public void setSolverType(SolverType solverType) {
        if (solverType == null) {
            throw new IllegalArgumentException("solver type must not be null");
        }
        this.solverType = solverType;
    }

    public SolverType getSolverType() {
        return this.solverType;
    }

    public void setP(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("p must not be less than 0");
        }
        this.p = d;
    }

    public double getP() {
        return this.p;
    }
}

