/*
 * Decompiled with CFR 0.152.
 */
package nak.liblinear;

import nak.liblinear.Function;
import nak.liblinear.Linear;

class Tron {
    private final Function fun_obj;
    private final double eps;
    private final int max_iter;

    public Tron(Function function) {
        this(function, 0.1);
    }

    public Tron(Function function, double d) {
        this(function, d, 1000);
    }

    public Tron(Function function, double d, int n) {
        this.fun_obj = function;
        this.eps = d;
        this.max_iter = n;
    }

    void tron(double[] dArray) {
        double d;
        double d2;
        double d3 = 1.0E-4;
        double d4 = 0.25;
        double d5 = 0.75;
        double d6 = 0.25;
        double d7 = 0.5;
        double d8 = 4.0;
        int n = this.fun_obj.get_nr_variable();
        double d9 = 1.0;
        boolean bl = true;
        int n2 = 1;
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = 0.0;
        }
        double d10 = this.fun_obj.fun(dArray);
        this.fun_obj.grad(dArray, dArray5);
        double d11 = d2 = (d = Tron.euclideanNorm(dArray5));
        if (d11 <= this.eps * d2) {
            bl = false;
        }
        n2 = 1;
        while (n2 <= this.max_iter && bl) {
            int n3 = this.trcg(d, dArray5, dArray2, dArray3);
            System.arraycopy(dArray, 0, dArray4, 0, n);
            Tron.daxpy(d9, dArray2, dArray4);
            double d12 = Tron.dot(dArray5, dArray2);
            double d13 = -0.5 * (d12 - Tron.dot(dArray2, dArray3));
            double d14 = this.fun_obj.fun(dArray4);
            double d15 = d10 - d14;
            double d16 = Tron.euclideanNorm(dArray2);
            if (n2 == 1) {
                d = Math.min(d, d16);
            }
            double d17 = d14 - d10 - d12 <= 0.0 ? d8 : Math.max(d6, -0.5 * (d12 / (d14 - d10 - d12)));
            d = d15 < d3 * d13 ? Math.min(Math.max(d17, d6) * d16, d7 * d) : (d15 < d4 * d13 ? Math.max(d6 * d, Math.min(d17 * d16, d7 * d)) : (d15 < d5 * d13 ? Math.max(d6 * d, Math.min(d17 * d16, d8 * d)) : Math.max(d, Math.min(d17 * d16, d8 * d))));
            Linear.info("iter %2d act %5.3e pre %5.3e delta %5.3e f %5.3e |g| %5.3e CG %3d%n", n2, d15, d13, d, d10, d11, n3);
            if (d15 > d3 * d13) {
                ++n2;
                System.arraycopy(dArray4, 0, dArray, 0, n);
                d10 = d14;
                this.fun_obj.grad(dArray, dArray5);
                d11 = Tron.euclideanNorm(dArray5);
                if (d11 <= this.eps * d2) break;
            }
            if (d10 < -1.0E32) {
                Linear.info("WARNING: f < -1.0e+32%n");
                break;
            }
            if (Math.abs(d15) <= 0.0 && d13 <= 0.0) {
                Linear.info("WARNING: actred and prered <= 0%n");
                break;
            }
            if (!(Math.abs(d15) <= 1.0E-12 * Math.abs(d10)) || !(Math.abs(d13) <= 1.0E-12 * Math.abs(d10))) continue;
            Linear.info("WARNING: actred and prered too small%n");
            break;
        }
    }

    private int trcg(double d, double[] dArray, double[] dArray2, double[] dArray3) {
        int n;
        int n2 = this.fun_obj.get_nr_variable();
        double d2 = 1.0;
        double[] dArray4 = new double[n2];
        double[] dArray5 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray2[n] = 0.0;
            dArray3[n] = -dArray[n];
            dArray4[n] = dArray3[n];
        }
        double d3 = 0.1 * Tron.euclideanNorm(dArray);
        n = 0;
        double d4 = Tron.dot(dArray3, dArray3);
        while (!(Tron.euclideanNorm(dArray3) <= d3)) {
            double d5;
            ++n;
            this.fun_obj.Hv(dArray4, dArray5);
            double d6 = d4 / Tron.dot(dArray4, dArray5);
            Tron.daxpy(d6, dArray4, dArray2);
            if (Tron.euclideanNorm(dArray2) > d) {
                Linear.info("cg reaches trust region boundary%n");
                d6 = -d6;
                Tron.daxpy(d6, dArray4, dArray2);
                d5 = Tron.dot(dArray2, dArray4);
                double d7 = Tron.dot(dArray2, dArray2);
                double d8 = Tron.dot(dArray4, dArray4);
                double d9 = d * d;
                double d10 = Math.sqrt(d5 * d5 + d8 * (d9 - d7));
                d6 = d5 >= 0.0 ? (d9 - d7) / (d5 + d10) : (d10 - d5) / d8;
                Tron.daxpy(d6, dArray4, dArray2);
                d6 = -d6;
                Tron.daxpy(d6, dArray5, dArray3);
                break;
            }
            d6 = -d6;
            Tron.daxpy(d6, dArray5, dArray3);
            double d11 = Tron.dot(dArray3, dArray3);
            d5 = d11 / d4;
            Tron.scale(d5, dArray4);
            Tron.daxpy(d2, dArray3, dArray4);
            d4 = d11;
        }
        return n;
    }

    private static void daxpy(double d, double[] dArray, double[] dArray2) {
        if (d == 0.0) {
            return;
        }
        assert (dArray.length == dArray2.length);
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            dArray2[n] = dArray2[n] + d * dArray[i];
        }
    }

    private static double dot(double[] dArray, double[] dArray2) {
        double d = 0.0;
        assert (dArray.length == dArray2.length);
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    private static double euclideanNorm(double[] dArray) {
        int n = dArray.length;
        if (n < 1) {
            return 0.0;
        }
        if (n == 1) {
            return Math.abs(dArray[0]);
        }
        double d = 0.0;
        double d2 = 1.0;
        for (int i = 0; i < n; ++i) {
            double d3;
            if (dArray[i] == 0.0) continue;
            double d4 = Math.abs(dArray[i]);
            if (d < d4) {
                d3 = d / d4;
                d2 = 1.0 + d2 * (d3 * d3);
                d = d4;
                continue;
            }
            d3 = d4 / d;
            d2 += d3 * d3;
        }
        return d * Math.sqrt(d2);
    }

    private static void scale(double d, double[] dArray) {
        if (d == 1.0) {
            return;
        }
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * d;
        }
    }
}

