/*
 * Decompiled with CFR 0.152.
 */
package org.scalawag.timber.backend;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicReference;
import org.scalawag.timber.api.BaseLogger;
import org.scalawag.timber.api.Entry;
import org.scalawag.timber.api.Message$;
import org.scalawag.timber.backend.InternalLogger$;
import org.scalawag.timber.backend.dispatcher.Dispatcher;
import org.scalawag.timber.backend.dispatcher.Dispatcher$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class DefaultDispatcher$
implements org.scalawag.timber.api.Dispatcher {
    public static final DefaultDispatcher$ MODULE$;
    private static final String org$scalawag$timber$backend$DefaultDispatcher$$SYSTEM_PROPERTY;
    private static final AtomicReference<org.scalawag.timber.api.Dispatcher> dispatcherRef;

    static {
        org.scalawag.timber.api.Dispatcher dispatcher;
        MODULE$ = new DefaultDispatcher$();
        org$scalawag$timber$backend$DefaultDispatcher$$SYSTEM_PROPERTY = "timber.dispatcher.class";
        String DEFAULT_DISPATCHER_CLASS_NAME = Dispatcher.class.getName();
        Option option = Option$.MODULE$.apply((Object)System.getProperty(MODULE$.org$scalawag$timber$backend$DefaultDispatcher$$SYSTEM_PROPERTY()));
        if (option instanceof Some) {
            Some some = (Some)option;
            String className = (String)some.value();
            dispatcher = (org.scalawag.timber.api.Dispatcher)MODULE$.loadDispatcherByName(className).getOrElse((Function0 & Serializable)() -> {
                InternalLogger$.MODULE$.warning(Message$.MODULE$.stringFnToMessage((Function0 & Serializable)() -> new StringBuilder(54).append("Falling back to the default timber dispatcher class (").append(DEFAULT_DISPATCHER_CLASS_NAME).append(")").toString()), new BaseLogger.LogCallLocation(new Entry.SourceLocation("DefaultDispatcher.scala", 69), (Option)new Some((Object)"org.scalawag.timber.backend.DefaultDispatcher"), (Option)None$.MODULE$));
                return new Dispatcher(Dispatcher$.MODULE$.$lessinit$greater$default$1(), Dispatcher$.MODULE$.$lessinit$greater$default$2());
            });
        } else if (None$.MODULE$.equals(option)) {
            InternalLogger$.MODULE$.debug(Message$.MODULE$.stringFnToMessage((Function0 & Serializable)() -> new StringBuilder(73).append("The system property '").append(MODULE$.org$scalawag$timber$backend$DefaultDispatcher$$SYSTEM_PROPERTY()).append("' is not specified, using the default dispatcher (").append(DEFAULT_DISPATCHER_CLASS_NAME).append(").").toString()), new BaseLogger.LogCallLocation(new Entry.SourceLocation("DefaultDispatcher.scala", 73), (Option)new Some((Object)"org.scalawag.timber.backend.DefaultDispatcher"), (Option)None$.MODULE$));
            dispatcher = new Dispatcher(Dispatcher$.MODULE$.$lessinit$greater$default$1(), Dispatcher$.MODULE$.$lessinit$greater$default$2());
        } else {
            throw new MatchError((Object)option);
        }
        dispatcherRef = new AtomicReference<org.scalawag.timber.api.Dispatcher>(dispatcher);
    }

    public void dispatch(Entry entry) {
        dispatcherRef.get().dispatch(entry);
    }

    public void set(org.scalawag.timber.api.Dispatcher delegate) {
        dispatcherRef.set(delegate);
    }

    public String org$scalawag$timber$backend$DefaultDispatcher$$SYSTEM_PROPERTY() {
        return org$scalawag$timber$backend$DefaultDispatcher$$SYSTEM_PROPERTY;
    }

    private Option<org.scalawag.timber.api.Dispatcher> loadDispatcherByName(String className) {
        Seq classLoaders = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()), new Some((Object)this.getClass().getClassLoader()), new Some((Object)ClassLoader.getSystemClassLoader())})).flatten(Predef$.MODULE$.$conforms());
        Seq eitherClassOrExceptions = (Seq)classLoaders.map((Function1 & Serializable)cl -> {
            Right right;
            try {
                right = package$.MODULE$.Left().apply(Class.forName(className, true, cl));
            }
            catch (ClassNotFoundException ex) {
                right = package$.MODULE$.Right().apply((Object)ex);
            }
            return right;
        });
        return (Option)eitherClassOrExceptions.collectFirst((PartialFunction)new Serializable(className){
            private static final long serialVersionUID = 0L;
            private final String className$1;

            public final <A1 extends Either<Class<Object>, ClassNotFoundException>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Left) {
                    Some some;
                    Left left = (Left)A1;
                    Class cls = (Class)left.value();
                    try {
                        some = new Some((Object)((org.scalawag.timber.api.Dispatcher)cls.newInstance()));
                    }
                    catch (ClassCastException ex) {
                        InternalLogger$.MODULE$.error(Message$.MODULE$.stringFnToMessage((Function0 & Serializable)() -> new StringBuilder(79).append("The class specified by the system property '").append(DefaultDispatcher$.MODULE$.org$scalawag$timber$backend$DefaultDispatcher$$SYSTEM_PROPERTY()).append("' (").append($this.className$1).append(") is not a timber dispatcher (").append(org.scalawag.timber.api.Dispatcher.class.getName()).append(").").toString()), new BaseLogger.LogCallLocation(new Entry.SourceLocation("DefaultDispatcher.scala", 108), (Option)new Some((Object)"org.scalawag.timber.backend.DefaultDispatcher"), (Option)new Some((Object)"loadDispatcherByName")));
                        some = None$.MODULE$;
                    }
                    catch (Exception ex) {
                        InternalLogger$.MODULE$.error(Message$.MODULE$.stringFnToMessage((Function0 & Serializable)() -> new StringBuilder(76).append("The class specified by the system property '").append(DefaultDispatcher$.MODULE$.org$scalawag$timber$backend$DefaultDispatcher$$SYSTEM_PROPERTY()).append("' (").append($this.className$1).append(") could not be instantiated: ").append(ex).toString()), new BaseLogger.LogCallLocation(new Entry.SourceLocation("DefaultDispatcher.scala", 113), (Option)new Some((Object)"org.scalawag.timber.backend.DefaultDispatcher"), (Option)new Some((Object)"loadDispatcherByName")));
                        some = None$.MODULE$;
                    }
                    object = some;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Either<Class<Object>, ClassNotFoundException> x1) {
                Either<Class<Object>, ClassNotFoundException> either = x1;
                boolean bl = either instanceof Left;
                return bl;
            }
            {
                this.className$1 = className$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.scalawag.timber.backend.DefaultDispatcher$$anonfun$loadDispatcherByName$2 ), $anonfun$applyOrElse$2(org.scalawag.timber.backend.DefaultDispatcher$$anonfun$loadDispatcherByName$2 java.lang.Exception )}, serializedLambda);
            }
        }).getOrElse((Function0 & Serializable)() -> {
            InternalLogger$.MODULE$.error(Message$.MODULE$.stringFnToMessage((Function0 & Serializable)() -> new StringBuilder(68).append("The class specified by the system property '").append(MODULE$.org$scalawag$timber$backend$DefaultDispatcher$$SYSTEM_PROPERTY()).append("' (").append(className).append(") could not be found.").toString()), new BaseLogger.LogCallLocation(new Entry.SourceLocation("DefaultDispatcher.scala", 120), (Option)new Some((Object)"org.scalawag.timber.backend.DefaultDispatcher"), (Option)new Some((Object)"loadDispatcherByName")));
            return None$.MODULE$;
        });
    }

    private DefaultDispatcher$() {
    }
}

