/*
 * Decompiled with CFR 0.152.
 */
package org.scalawag.timber.backend.dispatcher.configuration.debug;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import org.scalawag.timber.backend.dispatcher.configuration.Configuration;
import org.scalawag.timber.backend.dispatcher.configuration.ImmutableConditionVertex;
import org.scalawag.timber.backend.dispatcher.configuration.ImmutableReceiverVertex;
import org.scalawag.timber.backend.dispatcher.configuration.ImmutableVertex;
import org.scalawag.timber.backend.dispatcher.configuration.debug.DotDumper$;
import org.scalawag.timber.backend.dispatcher.configuration.debug.IndentingPrintWriter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015c\u0001B\n\u0015\t\rB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006_\u0001!\t\u0001\r\u0005\bg\u0001\u0001\r\u0011\"\u00035\u0011\u001dA\u0005\u00011A\u0005\n%Caa\u0014\u0001!B\u0013)\u0004\"\u0002)\u0001\t\u0013\t\u0006\"B0\u0001\t\u0013\u0001\u0007\"B3\u0001\t\u00131\u0007\"B6\u0001\t\u0013a\u0007\"B8\u0001\t\u0013\u0001\bb\u0002?\u0001#\u0003%I! \u0005\b\u0003#\u0001A\u0011BA\n\u0011!\tY\u0002AI\u0001\n\u0013ixaBA\u000f)!\u0005\u0011q\u0004\u0004\u0007'QA\t!!\t\t\r=zA\u0011AA\u0012\u0011\u0019yv\u0002\"\u0001\u0002&!1ql\u0004C\u0001\u0003o\u0011\u0011\u0002R8u\tVl\u0007/\u001a:\u000b\u0005U1\u0012!\u00023fEV<'BA\f\u0019\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]*\u0011\u0011DG\u0001\u000bI&\u001c\b/\u0019;dQ\u0016\u0014(BA\u000e\u001d\u0003\u001d\u0011\u0017mY6f]\u0012T!!\b\u0010\u0002\rQLWNY3s\u0015\ty\u0002%\u0001\u0005tG\u0006d\u0017m^1h\u0015\u0005\t\u0013aA8sO\u000e\u00011C\u0001\u0001%!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u0019\te.\u001f*fM\u0006\u0019q.\u001e;\u0011\u00051jS\"\u0001\u000b\n\u00059\"\"\u0001F%oI\u0016tG/\u001b8h!JLg\u000e^,sSR,'/\u0001\u0004=S:LGO\u0010\u000b\u0003cI\u0002\"\u0001\f\u0001\t\u000b)\u0012\u0001\u0019A\u0016\u0002\r\u0011,X\u000e]3e+\u0005)\u0004c\u0001\u001c<{5\tqG\u0003\u00029s\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003u\u0019\n!bY8mY\u0016\u001cG/[8o\u0013\tatGA\u0002TKR\u0004\"AP#\u000f\u0005}\u001a\u0005C\u0001!'\u001b\u0005\t%B\u0001\"#\u0003\u0019a$o\\8u}%\u0011AIJ\u0001\u0007!J,G-\u001a4\n\u0005\u0019;%AB*ue&twM\u0003\u0002EM\u0005QA-^7qK\u0012|F%Z9\u0015\u0005)k\u0005CA\u0013L\u0013\taeE\u0001\u0003V]&$\bb\u0002(\u0005\u0003\u0003\u0005\r!N\u0001\u0004q\u0012\n\u0014a\u00023v[B,G\rI\u0001\u0006O\u0016$\u0018\n\u001a\u000b\u0003%f\u0003\"a\u0015-\u000e\u0003QS!!\u0016,\u0002\t1\fgn\u001a\u0006\u0002/\u0006!!.\u0019<b\u0013\t1E\u000bC\u0003[\r\u0001\u00071,\u0001\u0004wKJ$X\r\u001f\t\u00039vk\u0011AF\u0005\u0003=Z\u0011q\"S7nkR\f'\r\\3WKJ$X\r_\u0001\u0005IVl\u0007\u000f\u0006\u0002KC\")qc\u0002a\u0001EB\u0011AlY\u0005\u0003IZ\u0011QbQ8oM&<WO]1uS>t\u0017\u0001\u00033v[B,EmZ3\u0015\u0007);\u0017\u000eC\u0003i\u0011\u0001\u0007Q(\u0001\u0004ge>l\u0017\n\u001a\u0005\u0006U\"\u0001\raW\u0001\u0003i>\fa!Z:dCB,GC\u0001*n\u0011\u0015q\u0017\u00021\u0001>\u0003\u0005\u0019\u0018A\u00033v[B4VM\u001d;fqR!!*\u001d:x\u0011\u0015Q&\u00021\u0001\\\u0011\u0015\u0019(\u00021\u0001u\u0003\u0015\u0001(o\u001c9t!\u0011qT/P\u001f\n\u0005Y<%aA'ba\"9\u0001P\u0003I\u0001\u0002\u0004I\u0018\u0001\u0002:b].\u00042!\n>>\u0013\tYhE\u0001\u0004PaRLwN\\\u0001\u0015IVl\u0007OV3si\u0016DH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003yT#!_@,\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u001bi!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0003'\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001f\t)AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0002Z;na\u0016cW-\\3oiR)!*!\u0006\u0002\u0018!)!\f\u0004a\u00017\"A\u0011\u0011\u0004\u0007\u0011\u0002\u0003\u0007\u00110\u0001\u0004qCJ,g\u000e^\u0001\u0016IVl\u0007/\u00127f[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003%!u\u000e\u001e#v[B,'\u000f\u0005\u0002-\u001fM\u0011q\u0002\n\u000b\u0003\u0003?!RASA\u0014\u0003SAQaF\tA\u0002\tDaAK\tA\u0002\u0005-\u0002\u0003BA\u0017\u0003gi!!a\f\u000b\u0007\u0005Eb+\u0001\u0002j_&!\u0011QGA\u0018\u0005-\u0001&/\u001b8u/JLG/\u001a:\u0015\u000b)\u000bI$a\u000f\t\u000b]\u0011\u0002\u0019\u00012\t\u000f\u0005u\"\u00031\u0001\u0002@\u0005!a-\u001b7f!\u0011\ti#!\u0011\n\t\u0005\r\u0013q\u0006\u0002\u0005\r&dW\r")
public class DotDumper {
    private final IndentingPrintWriter out;
    private Set<String> dumped;

    public static void dump(Configuration configuration, File file) {
        DotDumper$.MODULE$.dump(configuration, file);
    }

    public static void dump(Configuration configuration, PrintWriter printWriter) {
        DotDumper$.MODULE$.dump(configuration, printWriter);
    }

    private Set<String> dumped() {
        return this.dumped;
    }

    private void dumped_$eq(Set<String> x$1) {
        this.dumped = x$1;
    }

    private String getId(ImmutableVertex vertex) {
        return Integer.toString(System.identityHashCode(vertex));
    }

    public void org$scalawag$timber$backend$dispatcher$configuration$debug$DotDumper$$dump(Configuration configuration) {
        this.out.println("digraph Configuration {");
        this.out.indent((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.out.println("ranksep=\"1in\";");
            $this.out.println("{");
            $this.out.indent((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.out.println("rank=\"source\";");
                $this.out.println("\"root\" [label=\"root\",shape=\"invhouse\"];");
            });
            $this.out.println("}");
            configuration.roots().foreach((Function1 & Serializable)x$1 -> {
                this.dumpElement(x$1, (Option<String>)new Some((Object)"root"));
                return BoxedUnit.UNIT;
            });
        });
        this.out.println("}");
    }

    private void dumpEdge(String fromId, ImmutableVertex to) {
        String toId = this.getId(to);
        this.out.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\"%s\":s -> \"%s\":n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{fromId, toId})));
    }

    private String escape(String s) {
        return StringOps$.MODULE$.replaceAllLiterally$extension(Predef$.MODULE$.augmentString(s), "\"", "\\\"").replaceAll("\n", "\\\\n");
    }

    private void dumpVertex(ImmutableVertex vertex, Map<String, String> props, Option<String> rank) {
        block1: {
            String id = this.getId(vertex);
            if (rank.isDefined()) {
                this.out.println("{");
                this.out.changeIndent(1);
                this.out.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("rank=\"%s\";"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{rank.get()})));
            }
            this.out.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\"%s\" [%s];"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{id, this.format$1(props)})));
            if (!rank.isDefined()) break block1;
            this.out.changeIndent(-1);
            this.out.println("}");
        }
    }

    private Option<String> dumpVertex$default$3() {
        return None$.MODULE$;
    }

    private void dumpElement(ImmutableVertex vertex, Option<String> parent) {
        String id = this.getId(vertex);
        if (!this.dumped().contains((Object)id)) {
            Tuple2 tuple2;
            ImmutableVertex immutableVertex = vertex;
            if (immutableVertex instanceof ImmutableConditionVertex) {
                ImmutableConditionVertex immutableConditionVertex = (ImmutableConditionVertex)immutableVertex;
                String label = immutableConditionVertex.condition().toString();
                tuple2 = new Tuple2((Object)None$.MODULE$, Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shape"), (Object)"rect"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)label)})));
            } else if (immutableVertex instanceof ImmutableReceiverVertex) {
                ImmutableReceiverVertex immutableReceiverVertex = (ImmutableReceiverVertex)immutableVertex;
                tuple2 = new Tuple2((Object)new Some((Object)"sink"), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shape"), (Object)"house"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)immutableReceiverVertex.receiver().toString())})));
            } else {
                throw new MatchError((Object)immutableVertex);
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            Option rank = (Option)tuple22._1();
            Map props = (Map)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)rank, (Object)props);
            Tuple2 tuple24 = tuple23;
            Option rank2 = (Option)tuple24._1();
            Map props2 = (Map)tuple24._2();
            this.dumpVertex(vertex, (Map<String, String>)props2, (Option<String>)rank2);
            ImmutableVertex immutableVertex2 = vertex;
            if (immutableVertex2 instanceof ImmutableConditionVertex) {
                ImmutableConditionVertex immutableConditionVertex = (ImmutableConditionVertex)immutableVertex2;
                immutableConditionVertex.nexts().foreach((Function1 & Serializable)x$3 -> {
                    this.dumpElement(x$3, (Option<String>)new Some((Object)id));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (immutableVertex2 instanceof ImmutableReceiverVertex) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)immutableVertex2);
            }
            this.dumped_$eq((Set<String>)((Set)this.dumped().$plus((Object)id)));
        }
        parent.foreach((Function1 & Serializable)x$4 -> {
            this.dumpEdge(x$4, vertex);
            return BoxedUnit.UNIT;
        });
    }

    private Option<String> dumpElement$default$2() {
        return None$.MODULE$;
    }

    private final String format$1(Map props) {
        return ((IterableOnceOps)props.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s=\"%s\""), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{k, this.escape(v)}));
            return string;
        })).mkString(",");
    }

    public DotDumper(IndentingPrintWriter out) {
        this.out = out;
        this.dumped = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
    }
}

