/*
 * Decompiled with CFR 0.152.
 */
package org.scalawag.timber.backend.receiver;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.scalawag.timber.api.Entry;
import org.scalawag.timber.backend.receiver.ConsoleReceiver$;
import org.scalawag.timber.backend.receiver.Receiver;
import org.scalawag.timber.backend.receiver.formatter.EntryFormatter;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005A4a!\u0004\b\u0002\u0002IA\u0002\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\t\u0011)\u0002!\u0011!Q\u0001\n-BQ!\u000f\u0001\u0005\u0002iBQA\u0010\u0001\u0007\u0012}Ba\u0001\u0013\u0001!\u0002\u0013I\u0005\"\u0002)\u0001\t\u0003\n\u0006\"B/\u0001\t\u0003r\u0006\"B0\u0001\t\u0003rv\u0001\u00031\u000f\u0003\u0003E\tAE1\u0007\u00115q\u0011\u0011!E\u0001%\tDQ!\u000f\u0006\u0005\u0002\rDq\u0001\u001a\u0006\u0012\u0002\u0013\u0005QMA\bD_:\u001cx\u000e\\3SK\u000e,\u0017N^3s\u0015\ty\u0001#\u0001\u0005sK\u000e,\u0017N^3s\u0015\t\t\"#A\u0004cC\u000e\\WM\u001c3\u000b\u0005M!\u0012A\u0002;j[\n,'O\u0003\u0002\u0016-\u0005A1oY1mC^\fwMC\u0001\u0018\u0003\ry'oZ\n\u0004\u0001ey\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g\r\u0005\u0002!C5\ta\"\u0003\u0002#\u001d\tA!+Z2fSZ,'/A\u0005g_Jl\u0017\r\u001e;fe\u000e\u0001\u0001C\u0001\u0014)\u001b\u00059#BA\u0012\u000f\u0013\tIsE\u0001\bF]R\u0014\u0018PR8s[\u0006$H/\u001a:\u0002\u0017\rD\u0017M]:fi:\u000bW.\u001a\t\u000451r\u0013BA\u0017\u001c\u0005\u0019y\u0005\u000f^5p]B\u0011qF\u000e\b\u0003aQ\u0002\"!M\u000e\u000e\u0003IR!a\r\u0013\u0002\rq\u0012xn\u001c;?\u0013\t)4$\u0001\u0004Qe\u0016$WMZ\u0005\u0003oa\u0012aa\u0015;sS:<'BA\u001b\u001c\u0003\u0019a\u0014N\\5u}Q\u00191\bP\u001f\u0011\u0005\u0001\u0002\u0001\"B\u0012\u0004\u0001\u0004)\u0003b\u0002\u0016\u0004!\u0003\u0005\raK\u0001\u0007gR\u0014X-Y7\u0016\u0003\u0001\u0003\"!\u0011$\u000e\u0003\tS!a\u0011#\u0002\u0005%|'\"A#\u0002\t)\fg/Y\u0005\u0003\u000f\n\u0013AbT;uaV$8\u000b\u001e:fC6\fqa\u00195beN,G\u000f\u0005\u0002K\u001d6\t1J\u0003\u0002I\u0019*\u0011Q\nR\u0001\u0004]&|\u0017BA(L\u0005\u001d\u0019\u0005.\u0019:tKR\fqA]3dK&4X\r\u0006\u0002S+B\u0011!dU\u0005\u0003)n\u0011A!\u00168ji\")aK\u0002a\u0001/\u0006)QM\u001c;ssB\u0011\u0001lW\u0007\u00023*\u0011!LE\u0001\u0004CBL\u0017B\u0001/Z\u0005\u0015)e\u000e\u001e:z\u0003\u00151G.^:i)\u0005\u0011\u0016!B2m_N,\u0017aD\"p]N|G.\u001a*fG\u0016Lg/\u001a:\u0011\u0005\u0001R1C\u0001\u0006\u001a)\u0005\t\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'F\u0001gU\tYsmK\u0001i!\tIg.D\u0001k\u0015\tYG.A\u0005v]\u000eDWmY6fI*\u0011QnG\u0001\u000bC:tw\u000e^1uS>t\u0017BA8k\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public abstract class ConsoleReceiver
implements Receiver {
    private final EntryFormatter formatter;
    private final Charset charset;

    public static Option<String> $lessinit$greater$default$2() {
        return ConsoleReceiver$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public Receiver flushImmediately() {
        return Receiver.flushImmediately$(this);
    }

    @Override
    public Receiver flushAtLeastEvery(FiniteDuration duration) {
        return Receiver.flushAtLeastEvery$(this, duration);
    }

    @Override
    public Receiver withLocking() {
        return Receiver.withLocking$(this);
    }

    @Override
    public Receiver withQueueing() {
        return Receiver.withQueueing$(this);
    }

    public abstract OutputStream stream();

    @Override
    public void receive(Entry entry) {
        String s = this.formatter.format(entry);
        ByteBuffer bb = this.charset.encode(s);
        this.stream().write(bb.array(), bb.arrayOffset(), bb.limit());
    }

    @Override
    public void flush() {
        this.stream().flush();
    }

    @Override
    public void close() {
        this.stream().flush();
    }

    public ConsoleReceiver(EntryFormatter formatter, Option<String> charsetName) {
        Charset charset;
        this.formatter = formatter;
        Receiver.$init$(this);
        Option<String> option = charsetName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String csn = (String)some.value();
            charset = Charset.forName(csn);
        } else if (None$.MODULE$.equals(option)) {
            charset = Charset.defaultCharset();
        } else {
            throw new MatchError(option);
        }
        this.charset = charset;
    }
}

