/*
 * Decompiled with CFR 0.152.
 */
package scalaz.concurrent;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function1;
import scala.Product;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scalaz.Contravariant;
import scalaz.concurrent.Actor$;
import scalaz.concurrent.Node;
import scalaz.concurrent.Run;
import scalaz.concurrent.Run$;
import scalaz.concurrent.Strategy;

public final class Actor<A>
implements Product,
Serializable {
    private final Function1 handler;
    private final Function1 onError;
    private final Strategy strategy;
    private final AtomicReference<Node<A>> head;
    private final Run toEffect;

    public static <A> Function1<A, BoxedUnit> ToFunctionFromActor(Actor<A> actor) {
        return Actor$.MODULE$.ToFunctionFromActor((Actor)actor);
    }

    public static <A> Actor<A> actor(Function1<A, BoxedUnit> function1, Function1<Throwable, BoxedUnit> function12, Strategy strategy) {
        return Actor$.MODULE$.actor((Function1)function1, (Function1)function12, strategy);
    }

    public static Contravariant<Actor> actorContravariant() {
        return Actor$.MODULE$.actorContravariant();
    }

    public static <A> Actor<A> unapply(Actor<A> actor) {
        return Actor$.MODULE$.unapply(actor);
    }

    public static <A> Function1<Throwable, BoxedUnit> $lessinit$greater$default$2() {
        return Actor$.MODULE$.$lessinit$greater$default$2();
    }

    public static <A> Function1<Throwable, BoxedUnit> actor$default$2() {
        return Actor$.MODULE$.actor$default$2();
    }

    public Actor(Function1<A, BoxedUnit> handler, Function1<Throwable, BoxedUnit> onError, Strategy strategy) {
        this.handler = handler;
        this.onError = onError;
        this.strategy = strategy;
        this.head = new AtomicReference();
        this.toEffect = Run$.MODULE$.apply((JProcedure1 & Serializable)a -> this.$bang(a), strategy);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Actor)) return false;
        Actor actor = (Actor)object;
        Function1<A, BoxedUnit> function1 = this.handler();
        Function1<A, BoxedUnit> function12 = actor.handler();
        if (function1 == null) {
            if (function12 != null) {
                return false;
            }
        } else if (!function1.equals(function12)) return false;
        Function1<Throwable, BoxedUnit> function13 = this.onError();
        Function1<Throwable, BoxedUnit> function14 = actor.onError();
        if (function13 == null) {
            if (function14 == null) return true;
            return false;
        } else {
            if (!function13.equals(function14)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Actor;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "Actor";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        if (0 == n2) {
            object = this._1();
        } else if (1 == n2) {
            object = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "handler";
        } else if (1 == n2) {
            string = "onError";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public Function1<A, BoxedUnit> handler() {
        return this.handler;
    }

    public Function1<Throwable, BoxedUnit> onError() {
        return this.onError;
    }

    public Strategy strategy() {
        return this.strategy;
    }

    public Run<A> toEffect() {
        return this.toEffect;
    }

    public void $bang(A a) {
        Node<A> n = new Node<A>(a);
        Node<A> h = this.head.getAndSet(n);
        if (h != null) {
            h.lazySet(n);
        } else {
            this.schedule(n);
        }
    }

    public void apply(A a) {
        this.$bang(a);
    }

    public <B> Actor<B> contramap(Function1<B, A> f) {
        return new Actor<A>((JProcedure1 & Serializable)b -> this.$bang(f.apply(b)), this.onError(), this.strategy());
    }

    private void schedule(Node<A> n) {
        this.strategy().apply(() -> this.schedule$$anonfun$1(n));
    }

    private void act(Node<A> n, int i) {
        Actor actor = this;
        int n2 = i;
        Node node = n;
        while (true) {
            try {
                actor.handler().apply(node.a());
            }
            catch (Throwable ex) {
                actor.onError().apply((Object)ex);
            }
            Node n22 = (Node)node.get();
            if (n22 == null) {
                actor.scheduleLastTry(node);
                break;
            }
            if (n2 == 0) {
                actor.schedule(n22);
                break;
            }
            Actor actor2 = actor;
            Node node2 = n22;
            int n3 = n2 - 1;
            actor = actor2;
            node = node2;
            n2 = n3;
        }
    }

    private int act$default$2() {
        return 1024;
    }

    private void scheduleLastTry(Node<A> n) {
        this.strategy().apply(() -> this.scheduleLastTry$$anonfun$1(n));
    }

    private void lastTry(Node<A> n) {
        if (!this.head.compareAndSet(n, null)) {
            this.act(this.next(n), this.act$default$2());
        }
    }

    private Node<A> next(Node<A> n) {
        Node n2;
        Actor actor = this;
        while ((n2 = (Node)n.get()) == null) {
        }
        return n2;
    }

    public <A> Actor<A> copy(Function1<A, BoxedUnit> handler, Function1<Throwable, BoxedUnit> onError, Strategy strategy) {
        return new Actor<A>(handler, onError, strategy);
    }

    public <A> Function1<A, BoxedUnit> copy$default$1() {
        return this.handler();
    }

    public <A> Function1<Throwable, BoxedUnit> copy$default$2() {
        return this.onError();
    }

    public Function1<A, BoxedUnit> _1() {
        return this.handler();
    }

    public Function1<Throwable, BoxedUnit> _2() {
        return this.onError();
    }

    private final void schedule$$anonfun$1(Node n$1) {
        this.act(n$1, this.act$default$2());
    }

    private final void scheduleLastTry$$anonfun$1(Node n$2) {
        this.lastTry(n$2);
    }
}

