/*
 * Decompiled with CFR 0.152.
 */
package scalaz.concurrent;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.SyncVar;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileObjectRef;
import scala.runtime.function.JProcedure1;
import scalaz.;
import scalaz.$bslash$div$minus$;
import scalaz.$minus$bslash$div$;
import scalaz.Applicative;
import scalaz.Free;
import scalaz.Nondeterminism;
import scalaz.Reducer;
import scalaz.Trampoline$;
import scalaz.concurrent.Future$;
import scalaz.concurrent.Future$Async$;
import scalaz.concurrent.Future$BindAsync$;
import scalaz.concurrent.Future$BindSuspend$;
import scalaz.concurrent.Future$Now$;
import scalaz.concurrent.Future$Suspend$;
import scalaz.concurrent.Strategy$;
import scalaz.concurrent.Timer$;

public abstract class Future<A> {
    public static <A> Future<A> apply(Function0<A> function0, ExecutorService executorService) {
        return Future$.MODULE$.apply(function0, executorService);
    }

    public static <A> Future<A> async(Function1<Function1<A, BoxedUnit>, BoxedUnit> function1) {
        return Future$.MODULE$.async(function1);
    }

    public static <A> Future<A> delay(Function0<A> function0) {
        return Future$.MODULE$.delay(function0);
    }

    public static <A> Future<A> fork(Function0<Future<A>> function0, ExecutorService executorService) {
        return Future$.MODULE$.fork(function0, executorService);
    }

    public static Nondeterminism<Future> futureInstance() {
        return Future$.MODULE$.futureInstance();
    }

    public static Applicative<Object> futureParallelApplicativeInstance() {
        return Future$.MODULE$.futureParallelApplicativeInstance();
    }

    public static <A> Future<List<A>> gatherUnordered(Seq<Future<A>> seq) {
        return Future$.MODULE$.gatherUnordered(seq);
    }

    public static <A> Future<A> now(A a) {
        return Future$.MODULE$.now(a);
    }

    public static int ordinal(Future future) {
        return Future$.MODULE$.ordinal(future);
    }

    public static <A, M> Future<M> reduceUnordered(Seq<Future<A>> seq, Reducer<A, M> reducer) {
        return Future$.MODULE$.reduceUnordered(seq, reducer);
    }

    public static <A> Future<A> schedule(Function0<A> function0, Duration duration, ScheduledExecutorService scheduledExecutorService) {
        return Future$.MODULE$.schedule(function0, duration, scheduledExecutorService);
    }

    public static <A> Future<A> suspend(Function0<Future<A>> function0) {
        return Future$.MODULE$.suspend(function0);
    }

    public static <A> ExecutorService apply$default$2(Function0<A> function0) {
        return Future$.MODULE$.apply$default$2(function0);
    }

    public static <A> ExecutorService fork$default$2(Function0<Future<A>> function0) {
        return Future$.MODULE$.fork$default$2(function0);
    }

    public static <A> ScheduledExecutorService schedule$default$3(Function0<A> function0, Duration duration) {
        return Future$.MODULE$.schedule$default$3(function0, duration);
    }

    public <B> Future<B> flatMap(Function1<A, Future<B>> f) {
        Future future;
        Future future2 = this;
        if (future2 instanceof Now) {
            Object a;
            Now now = Future$Now$.MODULE$.unapply((Now)future2);
            Object a2 = a = now._1();
            future = Future$Suspend$.MODULE$.apply((Function0 & Serializable)() -> (Future)f.apply(a2));
        } else if (future2 instanceof Suspend) {
            Function0 function0;
            Suspend suspend = Future$Suspend$.MODULE$.unapply((Suspend)future2);
            Function0 thunk = function0 = suspend._1();
            future = Future$BindSuspend$.MODULE$.apply(thunk, f);
        } else if (future2 instanceof Async) {
            Function1 function1;
            Async async = Future$Async$.MODULE$.unapply((Async)future2);
            Function1 listen = function1 = async._1();
            future = Future$BindAsync$.MODULE$.apply(listen, f);
        } else if (future2 instanceof BindSuspend) {
            BindSuspend bindSuspend = Future$BindSuspend$.MODULE$.unapply((BindSuspend)future2);
            Function0 function0 = bindSuspend._1();
            Function1 function1 = bindSuspend._2();
            Function0 thunk = function0;
            Function1 g = function1;
            future = Future$Suspend$.MODULE$.apply((Function0 & Serializable)() -> Future$BindSuspend$.MODULE$.apply(thunk, g.andThen((Function1 & Serializable)_$1 -> _$1.flatMap(f))));
        } else if (future2 instanceof BindAsync) {
            BindAsync bindAsync = Future$BindAsync$.MODULE$.unapply((BindAsync)future2);
            Function1 function1 = bindAsync._1();
            Function1 function12 = bindAsync._2();
            Function1 listen = function1;
            Function1 g = function12;
            future = Future$Suspend$.MODULE$.apply((Function0 & Serializable)() -> Future$BindAsync$.MODULE$.apply(listen, g.andThen((Function1 & Serializable)_$2 -> _$2.flatMap(f))));
        } else {
            throw new MatchError((Object)future2);
        }
        return future;
    }

    public <B> Future<B> map(Function1<A, B> f) {
        return this.flatMap(f.andThen((Function1 & Serializable)b -> Future$.MODULE$.now(b)));
    }

    public void unsafePerformListen(Function1<A, Free<Function0, BoxedUnit>> cb) {
        Future<A> future = this.step();
        if (future instanceof Now) {
            Object a;
            Now now = Future$Now$.MODULE$.unapply((Now)future);
            Object a2 = a = now._1();
            ((Free)cb.apply(a2)).run($less$colon$less$.MODULE$.refl());
        } else if (future instanceof Async) {
            Function1 function1;
            Async async = Future$Async$.MODULE$.unapply((Async)future);
            Function1 onFinish = function1 = async._1();
            onFinish.apply(cb);
        } else if (future instanceof BindAsync) {
            BindAsync bindAsync = Future$BindAsync$.MODULE$.unapply((BindAsync)future);
            Function1 function1 = bindAsync._1();
            Function1 function12 = bindAsync._2();
            Function1 onFinish = function1;
            Function1 g = function12;
            onFinish.apply((Function1 & Serializable)x -> Trampoline$.MODULE$.delay(() -> Future.unsafePerformListen$$anonfun$2$$anonfun$1(g, x)).map((Function1)(JProcedure1 & Serializable)_$3 -> _$3.unsafePerformListen(cb)));
        } else {
            throw new MatchError(future);
        }
    }

    public void listen(Function1<A, Free<Function0, BoxedUnit>> cb) {
        this.unsafePerformListen(cb);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void unsafePerformListenInterruptibly(Function1<A, Free<Function0, BoxedUnit>> cb, AtomicBoolean cancel) {
        Future<A> future = this.stepInterruptibly(cancel);
        if (future instanceof Now) {
            Object a2;
            Now now = Future$Now$.MODULE$.unapply((Now)future);
            Object a3 = a2 = now._1();
            if (!cancel.get()) {
                ((Free)cb.apply(a3)).run($less$colon$less$.MODULE$.refl());
                return;
            }
        }
        if (future instanceof Async) {
            Function1 function1;
            Async async = Future$Async$.MODULE$.unapply((Async)future);
            Function1 onFinish = function1 = async._1();
            if (!cancel.get()) {
                onFinish.apply((Function1 & Serializable)a -> !cancel.get() ? (Free)cb.apply(a) : Trampoline$.MODULE$.done((Object)BoxedUnit.UNIT));
                return;
            }
        }
        if (future instanceof BindAsync) {
            BindAsync bindAsync = Future$BindAsync$.MODULE$.unapply((BindAsync)future);
            Function1 function1 = bindAsync._1();
            Function1 function12 = bindAsync._2();
            Function1 onFinish = function1;
            Function1 g = function12;
            if (!cancel.get()) {
                onFinish.apply((Function1 & Serializable)x -> !cancel.get() ? Trampoline$.MODULE$.delay(() -> Future.unsafePerformListenInterruptibly$$anonfun$3$$anonfun$1(g, x)).map((Function1)(JProcedure1 & Serializable)_$4 -> _$4.unsafePerformListenInterruptibly(cb, cancel)) : Trampoline$.MODULE$.done((Object)BoxedUnit.UNIT));
                return;
            }
        }
        if (!cancel.get()) throw new MatchError(future);
    }

    public void listenInterruptibly(Function1<A, Free<Function0, BoxedUnit>> cb, AtomicBoolean cancel) {
        this.unsafePerformListenInterruptibly(cb, cancel);
    }

    public final Future<A> step() {
        Future future = this;
        while (true) {
            Future future2;
            if ((future2 = future) instanceof Suspend) {
                Function0 function0;
                Suspend suspend = Future$Suspend$.MODULE$.unapply((Suspend)future2);
                Function0 thunk = function0 = suspend._1();
                future = (Future)thunk.apply();
                continue;
            }
            if (!(future2 instanceof BindSuspend)) break;
            BindSuspend bindSuspend = Future$BindSuspend$.MODULE$.unapply((BindSuspend)future2);
            Function0 function0 = bindSuspend._1();
            Function1 function1 = bindSuspend._2();
            Function0 thunk = function0;
            Function1 f = function1;
            future = ((Future)thunk.apply()).flatMap(f);
        }
        return future;
    }

    public final Future<A> stepInterruptibly(AtomicBoolean cancel) {
        Future future;
        block3: {
            Future future2 = this;
            while (!cancel.get()) {
                Future future3 = future2;
                if (future3 instanceof Suspend) {
                    Function0 function0;
                    Suspend suspend = Future$Suspend$.MODULE$.unapply((Suspend)future3);
                    Function0 thunk = function0 = suspend._1();
                    future2 = (Future)thunk.apply();
                    continue;
                }
                if (future3 instanceof BindSuspend) {
                    BindSuspend bindSuspend = Future$BindSuspend$.MODULE$.unapply((BindSuspend)future3);
                    Function0 function0 = bindSuspend._1();
                    Function1 function1 = bindSuspend._2();
                    Function0 thunk = function0;
                    Function1 f = function1;
                    future2 = ((Future)thunk.apply()).flatMap(f);
                    continue;
                }
                future = future2;
                break block3;
            }
            future = future2;
        }
        return future;
    }

    public Future<A> unsafeStart() {
        CountDownLatch latch = new CountDownLatch(1);
        VolatileObjectRef result = VolatileObjectRef.create((Object)None$.MODULE$);
        this.unsafePerformAsync((Function1<A, BoxedUnit>)(JProcedure1 & Serializable)a -> {
            Some some = Some$.MODULE$.apply(a);
            result$1.elem = some;
            latch.countDown();
        });
        return Future$.MODULE$.delay(() -> Future.unsafeStart$$anonfun$2(latch, result));
    }

    public Future<A> start() {
        return this.unsafeStart();
    }

    public void unsafePerformAsync(Function1<A, BoxedUnit> cb) {
        this.unsafePerformListen((Function1 & Serializable)a -> Trampoline$.MODULE$.done(cb.apply(a)));
    }

    public void runAsync(Function1<A, BoxedUnit> cb) {
        this.unsafePerformAsync(cb);
    }

    public void unsafePerformAsyncInterruptibly(Function1<A, BoxedUnit> cb, AtomicBoolean cancel) {
        this.unsafePerformListenInterruptibly((Function1 & Serializable)a -> Trampoline$.MODULE$.done(cb.apply(a)), cancel);
    }

    public void runAsyncInterruptibly(Function1<A, BoxedUnit> cb, AtomicBoolean cancel) {
        this.unsafePerformAsyncInterruptibly(cb, cancel);
    }

    public A unsafePerformSync() {
        Object object;
        Future future = this;
        if (future instanceof Now) {
            Object a2;
            Object a3;
            Now now = Future$Now$.MODULE$.unapply((Now)future);
            object = a3 = (a2 = now._1());
        } else {
            CountDownLatch latch = new CountDownLatch(1);
            VolatileObjectRef result = VolatileObjectRef.create((Object)None$.MODULE$);
            this.unsafePerformAsync((Function1<A, BoxedUnit>)(JProcedure1 & Serializable)a -> {
                Some some = Some$.MODULE$.apply(a);
                result$3.elem = some;
                latch.countDown();
            });
            latch.await();
            object = ((Option)result.elem).get();
        }
        return object;
    }

    public A run() {
        return this.unsafePerformSync();
    }

    public A unsafePerformSyncFor(long timeoutInMillis) {
        Object object;
        .bslash.div<Throwable, A> div2 = this.unsafePerformSyncAttemptFor(timeoutInMillis);
        if (div2 instanceof .minus.bslash.div) {
            Throwable throwable;
            .minus.bslash.div div3 = $minus$bslash$div$.MODULE$.unapply((.minus.bslash.div)div2);
            Throwable e = throwable = (Throwable)div3._1();
            throw e;
        }
        if (!(div2 instanceof .bslash.div.minus)) {
            throw new MatchError(div2);
        }
        .bslash.div.minus minus2 = $bslash$div$minus$.MODULE$.unapply((.bslash.div.minus)div2);
        Object a = object = minus2._1();
        return (A)a;
    }

    public A unsafePerformSyncFor(Duration timeout) {
        return this.unsafePerformSyncFor(timeout.toMillis());
    }

    public A runFor(long timeoutInMillis) {
        return this.unsafePerformSyncFor(timeoutInMillis);
    }

    public A runFor(Duration timeout) {
        return this.unsafePerformSyncFor(timeout);
    }

    public .bslash.div<Throwable, A> unsafePerformSyncAttemptFor(long timeoutInMillis) {
        SyncVar sync = new SyncVar();
        AtomicBoolean interrupt = new AtomicBoolean(false);
        this.unsafePerformAsyncInterruptibly((Function1<A, BoxedUnit>)(JProcedure1 & Serializable)a -> sync.put((Object)$bslash$div$minus$.MODULE$.apply(a)), interrupt);
        return (.bslash.div)sync.get(timeoutInMillis).getOrElse(() -> Future.unsafePerformSyncAttemptFor$$anonfun$2(timeoutInMillis, interrupt));
    }

    public .bslash.div<Throwable, A> unsafePerformSyncAttemptFor(Duration timeout) {
        return this.unsafePerformSyncAttemptFor(timeout.toMillis());
    }

    public .bslash.div<Throwable, A> attemptRunFor(long timeoutInMillis) {
        return this.unsafePerformSyncAttemptFor(timeoutInMillis);
    }

    public .bslash.div<Throwable, A> attemptRunFor(Duration timeout) {
        return this.unsafePerformSyncAttemptFor(timeout);
    }

    public Future<.bslash.div<Throwable, A>> timed(long timeoutInMillis, ScheduledExecutorService scheduler) {
        return Future$.MODULE$.async((JProcedure1 & Serializable)cb -> {
            AtomicBoolean cancel = new AtomicBoolean(false);
            AtomicBoolean done = new AtomicBoolean(false);
            scheduler.schedule(new Runnable(timeoutInMillis, (Function1)cb, cancel, done){
                private final long timeoutInMillis$1;
                private final Function1 cb$1;
                private final AtomicBoolean cancel$1;
                private final AtomicBoolean done$1;
                {
                    this.timeoutInMillis$1 = timeoutInMillis$4;
                    this.cb$1 = cb$17;
                    this.cancel$1 = cancel$5;
                    this.done$1 = done$3;
                }

                public void run() {
                    if (this.done$1.compareAndSet(false, true)) {
                        this.cancel$1.set(true);
                        this.cb$1.apply((Object)$minus$bslash$div$.MODULE$.apply((Object)new TimeoutException(new StringBuilder(29).append("Timed out after ").append(this.timeoutInMillis$1).append(" milliseconds").toString())));
                    }
                }
            }, timeoutInMillis, TimeUnit.MILLISECONDS);
            this.unsafePerformAsyncInterruptibly((Function1<A, BoxedUnit>)(JProcedure1 & Serializable)a -> {
                if (done.compareAndSet(false, true)) {
                    cb.apply((Object)$bslash$div$minus$.MODULE$.apply(a));
                }
            }, cancel);
        });
    }

    public Future<.bslash.div<Throwable, A>> timed(Duration timeout, ScheduledExecutorService scheduler) {
        return this.timed(timeout.toMillis(), scheduler);
    }

    public ScheduledExecutorService timed$default$2(Duration timeout) {
        return Strategy$.MODULE$.DefaultTimeoutScheduler();
    }

    public Future<.bslash.div<Throwable, A>> unsafePerformTimed(Duration timeout, ScheduledExecutorService scheduler) {
        return this.timed(timeout.toMillis(), scheduler);
    }

    public ScheduledExecutorService unsafePerformTimed$default$2(Duration timeout) {
        return Strategy$.MODULE$.DefaultTimeoutScheduler();
    }

    public Future<.bslash.div<Throwable, A>> unsafePerformTimed(long timeoutInMillis, ScheduledExecutorService scheduler) {
        return this.timed(timeoutInMillis, scheduler);
    }

    public Future<A> after(Duration t) {
        return this.after(t.toMillis());
    }

    public Future<A> after(long t) {
        return Timer$.MODULE$.default().valueWait(BoxedUnit.UNIT, t).flatMap((Function1 & Serializable)_$5 -> this);
    }

    private static final Future unsafePerformListen$$anonfun$2$$anonfun$1(Function1 g$4, Object x$1) {
        return (Future)g$4.apply(x$1);
    }

    private static final Future unsafePerformListenInterruptibly$$anonfun$3$$anonfun$1(Function1 g$6, Object x$2) {
        return (Future)g$6.apply(x$2);
    }

    private static final Object unsafeStart$$anonfun$2(CountDownLatch latch$2, VolatileObjectRef result$2) {
        latch$2.await();
        return ((Option)result$2.elem).get();
    }

    private static final .minus.bslash.div unsafePerformSyncAttemptFor$$anonfun$2(long timeoutInMillis$1, AtomicBoolean interrupt$1) {
        interrupt$1.set(true);
        return $minus$bslash$div$.MODULE$.apply((Object)new TimeoutException(new StringBuilder(29).append("Timed out after ").append(timeoutInMillis$1).append(" milliseconds").toString()));
    }

    public static class Async<A>
    extends Future<A>
    implements Product,
    Serializable {
        private final Function1 onFinish;

        public static <A> Async<A> apply(Function1<Function1<A, Free<Function0, BoxedUnit>>, BoxedUnit> function1) {
            return Future$Async$.MODULE$.apply(function1);
        }

        public static Async fromProduct(Product product) {
            return Future$Async$.MODULE$.fromProduct(product);
        }

        public static <A> Async<A> unapply(Async<A> async) {
            return Future$Async$.MODULE$.unapply(async);
        }

        public Async(Function1<Function1<A, Free<Function0, BoxedUnit>>, BoxedUnit> onFinish) {
            this.onFinish = onFinish;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Async)) return false;
            Async async = (Async)object;
            Function1<Function1<A, Free<Function0, BoxedUnit>>, BoxedUnit> function1 = this.onFinish();
            Function1<Function1<A, Free<Function0, BoxedUnit>>, BoxedUnit> function12 = async.onFinish();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!async.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Async;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Async";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "onFinish";
        }

        public Function1<Function1<A, Free<Function0, BoxedUnit>>, BoxedUnit> onFinish() {
            return this.onFinish;
        }

        public <A> Async<A> copy(Function1<Function1<A, Free<Function0, BoxedUnit>>, BoxedUnit> onFinish) {
            return new Async<A>(onFinish);
        }

        public <A> Function1<Function1<A, Free<Function0, BoxedUnit>>, BoxedUnit> copy$default$1() {
            return this.onFinish();
        }

        public Function1<Function1<A, Free<Function0, BoxedUnit>>, BoxedUnit> _1() {
            return this.onFinish();
        }
    }

    public static class BindAsync<A, B>
    extends Future<B>
    implements Product,
    Serializable {
        private final Function1 onFinish;
        private final Function1 f;

        public static <A, B> BindAsync<A, B> apply(Function1<Function1<A, Free<Function0, BoxedUnit>>, BoxedUnit> function1, Function1<A, Future<B>> function12) {
            return Future$BindAsync$.MODULE$.apply(function1, function12);
        }

        public static BindAsync fromProduct(Product product) {
            return Future$BindAsync$.MODULE$.fromProduct(product);
        }

        public static <A, B> BindAsync<A, B> unapply(BindAsync<A, B> bindAsync) {
            return Future$BindAsync$.MODULE$.unapply(bindAsync);
        }

        public BindAsync(Function1<Function1<A, Free<Function0, BoxedUnit>>, BoxedUnit> onFinish, Function1<A, Future<B>> f) {
            this.onFinish = onFinish;
            this.f = f;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BindAsync)) return false;
            BindAsync bindAsync = (BindAsync)object;
            Function1<Function1<A, Free<Function0, BoxedUnit>>, BoxedUnit> function1 = this.onFinish();
            Function1<Function1<A, Free<Function0, BoxedUnit>>, BoxedUnit> function12 = bindAsync.onFinish();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            Function1<A, Future<B>> function13 = this.f();
            Function1<A, Future<B>> function14 = bindAsync.f();
            if (function13 == null) {
                if (function14 != null) {
                    return false;
                }
            } else if (!function13.equals(function14)) return false;
            if (!bindAsync.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof BindAsync;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "BindAsync";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "onFinish";
            } else if (1 == n2) {
                string = "f";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public Function1<Function1<A, Free<Function0, BoxedUnit>>, BoxedUnit> onFinish() {
            return this.onFinish;
        }

        public Function1<A, Future<B>> f() {
            return this.f;
        }

        public <A, B> BindAsync<A, B> copy(Function1<Function1<A, Free<Function0, BoxedUnit>>, BoxedUnit> onFinish, Function1<A, Future<B>> f) {
            return new BindAsync<A, B>(onFinish, f);
        }

        public <A, B> Function1<Function1<A, Free<Function0, BoxedUnit>>, BoxedUnit> copy$default$1() {
            return this.onFinish();
        }

        public <A, B> Function1<A, Future<B>> copy$default$2() {
            return this.f();
        }

        public Function1<Function1<A, Free<Function0, BoxedUnit>>, BoxedUnit> _1() {
            return this.onFinish();
        }

        public Function1<A, Future<B>> _2() {
            return this.f();
        }
    }

    public static class BindSuspend<A, B>
    extends Future<B>
    implements Product,
    Serializable {
        private final Function0 thunk;
        private final Function1 f;

        public static <A, B> BindSuspend<A, B> apply(Function0<Future<A>> function0, Function1<A, Future<B>> function1) {
            return Future$BindSuspend$.MODULE$.apply(function0, function1);
        }

        public static BindSuspend fromProduct(Product product) {
            return Future$BindSuspend$.MODULE$.fromProduct(product);
        }

        public static <A, B> BindSuspend<A, B> unapply(BindSuspend<A, B> bindSuspend) {
            return Future$BindSuspend$.MODULE$.unapply(bindSuspend);
        }

        public BindSuspend(Function0<Future<A>> thunk, Function1<A, Future<B>> f) {
            this.thunk = thunk;
            this.f = f;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BindSuspend)) return false;
            BindSuspend bindSuspend = (BindSuspend)object;
            Function0<Future<A>> function0 = this.thunk();
            Function0<Future<A>> function02 = bindSuspend.thunk();
            if (function0 == null) {
                if (function02 != null) {
                    return false;
                }
            } else if (!function0.equals(function02)) return false;
            Function1<A, Future<B>> function1 = this.f();
            Function1<A, Future<B>> function12 = bindSuspend.f();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!bindSuspend.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof BindSuspend;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "BindSuspend";
        }

        public Object productElement(int n) {
            Function0<Future<A>> function0;
            int n2 = n;
            if (0 == n2) {
                function0 = this._1();
            } else if (1 == n2) {
                function0 = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return function0;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "thunk";
            } else if (1 == n2) {
                string = "f";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public Function0<Future<A>> thunk() {
            return this.thunk;
        }

        public Function1<A, Future<B>> f() {
            return this.f;
        }

        public <A, B> BindSuspend<A, B> copy(Function0<Future<A>> thunk, Function1<A, Future<B>> f) {
            return new BindSuspend<A, B>(thunk, f);
        }

        public <A, B> Function0<Future<A>> copy$default$1() {
            return this.thunk();
        }

        public <A, B> Function1<A, Future<B>> copy$default$2() {
            return this.f();
        }

        public Function0<Future<A>> _1() {
            return this.thunk();
        }

        public Function1<A, Future<B>> _2() {
            return this.f();
        }
    }

    public static class Now<A>
    extends Future<A>
    implements Product,
    Serializable {
        private final Object a;

        public static <A> Now<A> apply(A a) {
            return Future$Now$.MODULE$.apply(a);
        }

        public static Now fromProduct(Product product) {
            return Future$Now$.MODULE$.fromProduct(product);
        }

        public static <A> Now<A> unapply(Now<A> now) {
            return Future$Now$.MODULE$.unapply(now);
        }

        public Now(A a) {
            this.a = a;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Now)) return false;
            Now now = (Now)object;
            if (!BoxesRunTime.equals(this.a(), now.a())) return false;
            if (!now.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Now;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Now";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "a";
        }

        public A a() {
            return (A)this.a;
        }

        public <A> Now<A> copy(A a) {
            return new Now<A>(a);
        }

        public <A> A copy$default$1() {
            return this.a();
        }

        public A _1() {
            return this.a();
        }
    }

    public static class Suspend<A>
    extends Future<A>
    implements Product,
    Serializable {
        private final Function0 thunk;

        public static <A> Suspend<A> apply(Function0<Future<A>> function0) {
            return Future$Suspend$.MODULE$.apply(function0);
        }

        public static Suspend fromProduct(Product product) {
            return Future$Suspend$.MODULE$.fromProduct(product);
        }

        public static <A> Suspend<A> unapply(Suspend<A> suspend) {
            return Future$Suspend$.MODULE$.unapply(suspend);
        }

        public Suspend(Function0<Future<A>> thunk) {
            this.thunk = thunk;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Suspend)) return false;
            Suspend suspend = (Suspend)object;
            Function0<Future<A>> function0 = this.thunk();
            Function0<Future<A>> function02 = suspend.thunk();
            if (function0 == null) {
                if (function02 != null) {
                    return false;
                }
            } else if (!function0.equals(function02)) return false;
            if (!suspend.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Suspend;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Suspend";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "thunk";
        }

        public Function0<Future<A>> thunk() {
            return this.thunk;
        }

        public <A> Suspend<A> copy(Function0<Future<A>> thunk) {
            return new Suspend<A>(thunk);
        }

        public <A> Function0<Future<A>> copy$default$1() {
            return this.thunk();
        }

        public Function0<Future<A>> _1() {
            return this.thunk();
        }
    }
}

