/*
 * Decompiled with CFR 0.152.
 */
package scalaz.zio.internal;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxesRunTime;
import scalaz.zio.internal.ExecutionMetrics;
import scalaz.zio.internal.Executor;
import scalaz.zio.internal.Executor$;
import scalaz.zio.internal.Executor$Unyielding$;
import scalaz.zio.internal.Executor$Yielding$;
import scalaz.zio.internal.NamedThreadFactory;

public final class Executor$
implements Serializable {
    public static Executor$ MODULE$;

    static {
        new Executor$();
    }

    public final Executor newDefaultExecutor(Executor.Role role) {
        Executor executor;
        if (Executor$Unyielding$.MODULE$.equals(role)) {
            Function1 & java.io.Serializable & Serializable intersect = (Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Executor$.$anonfun$newDefaultExecutor$1(x$1));
            int corePoolSize = Integer.MAX_VALUE;
            int maxPoolSize = Integer.MAX_VALUE;
            long keepAliveTime = 1000L;
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            SynchronousQueue<Runnable> workQueue = new SynchronousQueue<Runnable>();
            NamedThreadFactory threadFactory = new NamedThreadFactory("zio-default-unyielding", true);
            ThreadPoolExecutor threadPool = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, timeUnit, workQueue, threadFactory);
            threadPool.allowCoreThreadTimeOut(true);
            executor = this.fromThreadPoolExecutor(role, (Function1<ExecutionMetrics, Object>)intersect, threadPool);
        } else if (Executor$Yielding$.MODULE$.equals(role)) {
            Function1 & java.io.Serializable & Serializable intersect = (Function1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Executor$.$anonfun$newDefaultExecutor$2(x$2));
            int corePoolSize = Runtime.getRuntime().availableProcessors() * 2;
            long keepAliveTime = 1000L;
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
            NamedThreadFactory threadFactory = new NamedThreadFactory("zio-default-yielding", true);
            ThreadPoolExecutor threadPool = new ThreadPoolExecutor(corePoolSize, corePoolSize, keepAliveTime, timeUnit, workQueue, threadFactory);
            threadPool.allowCoreThreadTimeOut(true);
            executor = this.fromThreadPoolExecutor(role, (Function1<ExecutionMetrics, Object>)intersect, threadPool);
        } else {
            throw new MatchError((Object)role);
        }
        return executor;
    }

    public final Executor fromExecutionContext(Executor.Role role0, Function1<ExecutionMetrics, Object> yieldOpCount0, int concurrency0, ExecutionContext ec) {
        return new Executor(role0, concurrency0, yieldOpCount0, ec){
            private final AtomicLong scalaz$zio$internal$Executor$$anon$$_enqueuedCount;
            private final AtomicLong scalaz$zio$internal$Executor$$anon$$_dequeuedCount;
            private final ExecutionMetrics metrics;
            private ExecutionContext asEC;
            private volatile boolean bitmap$0;
            private final Executor.Role role0$1;
            public final int concurrency0$1;
            private final Function1 yieldOpCount0$1;
            private final ExecutionContext ec$1;

            private ExecutionContext asEC$lzycompute() {
                synchronized (this) {
                    if (!this.bitmap$0) {
                        this.asEC = Executor.asEC$(this);
                        this.bitmap$0 = true;
                    }
                }
                return this.asEC;
            }

            public ExecutionContext asEC() {
                if (!this.bitmap$0) {
                    return this.asEC$lzycompute();
                }
                return this.asEC;
            }

            public AtomicLong scalaz$zio$internal$Executor$$anon$$_enqueuedCount() {
                return this.scalaz$zio$internal$Executor$$anon$$_enqueuedCount;
            }

            public AtomicLong scalaz$zio$internal$Executor$$anon$$_dequeuedCount() {
                return this.scalaz$zio$internal$Executor$$anon$$_dequeuedCount;
            }

            public Executor.Role role() {
                return this.role0$1;
            }

            public ExecutionMetrics metrics() {
                return this.metrics;
            }

            public int yieldOpCount() {
                return BoxesRunTime.unboxToInt((Object)this.yieldOpCount0$1.apply((Object)this.metrics()));
            }

            public boolean submit(Runnable runnable) {
                try {
                    this.ec$1.execute(new Runnable(this, runnable){
                        private final /* synthetic */ anon.2 $outer;
                        private final Runnable runnable$1;

                        public void run() {
                            try {
                                this.runnable$1.run();
                            }
                            finally {
                                this.$outer.scalaz$zio$internal$Executor$$anon$$_dequeuedCount().incrementAndGet();
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.runnable$1 = runnable$1;
                        }
                    });
                    this.scalaz$zio$internal$Executor$$anon$$_enqueuedCount().incrementAndGet();
                    return true;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    return false;
                }
            }

            public boolean here() {
                return false;
            }

            public void shutdown() {
            }
            {
                this.role0$1 = role0$1;
                this.concurrency0$1 = concurrency0$1;
                this.yieldOpCount0$1 = yieldOpCount0$1;
                this.ec$1 = ec$1;
                Executor.$init$(this);
                this.scalaz$zio$internal$Executor$$anon$$_enqueuedCount = new AtomicLong();
                this.scalaz$zio$internal$Executor$$anon$$_dequeuedCount = new AtomicLong();
                this.metrics = new ExecutionMetrics(this){
                    private final /* synthetic */ anon.2 $outer;

                    public int concurrency() {
                        return this.$outer.concurrency0$1;
                    }

                    public int capacity() {
                        return Integer.MAX_VALUE;
                    }

                    public int size() {
                        return (int)(this.enqueuedCount() - this.dequeuedCount());
                    }

                    public long enqueuedCount() {
                        return this.$outer.scalaz$zio$internal$Executor$$anon$$_enqueuedCount().get();
                    }

                    public long dequeuedCount() {
                        return this.$outer.scalaz$zio$internal$Executor$$anon$$_dequeuedCount().get();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }
        };
    }

    public final Executor fromThreadPoolExecutor(Executor.Role role0, Function1<ExecutionMetrics, Object> yieldOpCount0, ThreadPoolExecutor es) {
        return new Executor(role0, es, yieldOpCount0){
            private final ExecutionMetrics metrics;
            private ExecutionContext asEC;
            private volatile boolean bitmap$0;
            private final Executor.Role role0$2;
            public final ThreadPoolExecutor es$1;
            private final Function1 yieldOpCount0$2;

            private ExecutionContext asEC$lzycompute() {
                synchronized (this) {
                    if (!this.bitmap$0) {
                        this.asEC = Executor.asEC$(this);
                        this.bitmap$0 = true;
                    }
                }
                return this.asEC;
            }

            public ExecutionContext asEC() {
                if (!this.bitmap$0) {
                    return this.asEC$lzycompute();
                }
                return this.asEC;
            }

            public Executor.Role role() {
                return this.role0$2;
            }

            public ExecutionMetrics metrics() {
                return this.metrics;
            }

            public int yieldOpCount() {
                return BoxesRunTime.unboxToInt((Object)this.yieldOpCount0$2.apply((Object)this.metrics()));
            }

            public boolean submit(Runnable runnable) {
                try {
                    this.es$1.execute(runnable);
                    return true;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    return false;
                }
            }

            public boolean here() {
                return false;
            }

            public void shutdown() {
                this.es$1.shutdown();
            }
            {
                this.role0$2 = role0$2;
                this.es$1 = es$1;
                this.yieldOpCount0$2 = yieldOpCount0$2;
                Executor.$init$(this);
                this.metrics = new ExecutionMetrics(this){
                    private final /* synthetic */ anon.5 $outer;

                    public int concurrency() {
                        return this.$outer.es$1.getMaximumPoolSize();
                    }

                    public int capacity() {
                        BlockingQueue<Runnable> queue = this.$outer.es$1.getQueue();
                        int remaining = queue.remainingCapacity();
                        if (remaining == Integer.MAX_VALUE) {
                            return remaining;
                        }
                        return remaining + queue.size();
                    }

                    public int size() {
                        return this.$outer.es$1.getQueue().size();
                    }

                    public long enqueuedCount() {
                        return this.$outer.es$1.getTaskCount();
                    }

                    public long dequeuedCount() {
                        return this.enqueuedCount() - (long)this.size();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }
        };
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ int $anonfun$newDefaultExecutor$1(ExecutionMetrics x$1) {
        return Integer.MAX_VALUE;
    }

    public static final /* synthetic */ int $anonfun$newDefaultExecutor$2(ExecutionMetrics x$2) {
        return 1024;
    }

    private Executor$() {
        MODULE$ = this;
    }
}

