/*
 * Decompiled with CFR 0.152.
 */
package scalaz.zio.internal.impls;

import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scalaz.zio.internal.impls.padding.HeadPadding;
import scalaz.zio.internal.impls.padding.MutableQueueFieldsPadding;
import scalaz.zio.internal.impls.padding.TailPadding;

@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001\u0002\f\u0018\u0001\u0001B\u0001\"\u000f\u0001\u0003\u0006\u0004%\tA\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005w!)q\b\u0001C\u0001\u0001\"9A\t\u0001b\u0001\n\u000bQ\u0004BB#\u0001A\u000351\b\u0003\u0004G\u0001\u0001\u0006Ia\u0012\u0005\u0007\u0015\u0002\u0001\u000b\u0011B&\t\rE\u0003\u0001\u0015!\u0003S\u0011\u0019q\u0006\u0001)A\u0007?\"1\u0011\r\u0001Q\u0001\u000e\tDa\u0001\u001a\u0001!\u0002\u001b)\u0007BB4\u0001A\u00035\u0001\u000eC\u0003k\u0001\u0011\u00153\u000eC\u0003m\u0001\u0011\u0015S\u000eC\u0003o\u0001\u0011\u0015S\u000eC\u0003p\u0001\u0011\u0015\u0003\u000fC\u0003w\u0001\u0011\u0015s\u000fC\u0003{\u0001\u0011\u00153\u0010C\u0003}\u0001\u0011\u00153\u0010C\u0003~\u0001\u0011%a\u0010C\u0004\u0002\b\u0001!I!!\u0003\u0003\u0015IKgn\u001a\"vM\u001a,'O\u0003\u0002\u00193\u0005)\u0011.\u001c9mg*\u0011!dG\u0001\tS:$XM\u001d8bY*\u0011A$H\u0001\u0004u&|'\"\u0001\u0010\u0002\rM\u001c\u0017\r\\1{\u0007\u0001)\"!\t\u0016\u0014\u0007\u0001\u0011c\u0007E\u0002$M!j\u0011\u0001\n\u0006\u0003K]\tq\u0001]1eI&tw-\u0003\u0002(I\tIR*\u001e;bE2,\u0017+^3vK\u001aKW\r\u001c3t!\u0006$G-\u001b8h!\tI#\u0006\u0004\u0001\u0005\u000b-\u0002!\u0019\u0001\u0017\u0003\u0003\u0005\u000b\"!L\u001a\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\u000f9{G\u000f[5oOB\u0011a\u0006N\u0005\u0003k=\u00121!\u00118z!\tqs'\u0003\u00029_\ta1+\u001a:jC2L'0\u00192mK\u0006yA-Z:je\u0016$7)\u00199bG&$\u00180F\u0001<!\tqC(\u0003\u0002>_\t\u0019\u0011J\u001c;\u0002!\u0011,7/\u001b:fI\u000e\u000b\u0007/Y2jif\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002B\u0007B\u0019!\t\u0001\u0015\u000e\u0003]AQ!O\u0002A\u0002m\n\u0001bY1qC\u000eLG/_\u0001\nG\u0006\u0004\u0018mY5us\u0002\nq!\u001b3y\u001b\u0006\u001c8\u000e\u0005\u0002/\u0011&\u0011\u0011j\f\u0002\u0005\u0019>tw-A\u0002ck\u001a\u00042A\f'O\u0013\tiuFA\u0003BeJ\f\u0017\u0010\u0005\u0002/\u001f&\u0011\u0001k\f\u0002\u0007\u0003:L(+\u001a4\u0002\u0007M,\u0017\u000f\u0005\u0002T96\tAK\u0003\u0002V-\u00061\u0011\r^8nS\u000eT!a\u0016-\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002Z5\u0006!Q\u000f^5m\u0015\u0005Y\u0016\u0001\u00026bm\u0006L!!\u0018+\u0003\u001f\u0005#x.\\5d\u0019>tw-\u0011:sCf\f!b\u0015+B)\u0016{FjT(Q\u001f\u0005\u0001W$\u0001\u0001\u0002\u0017M#\u0016\tV#`\u000b6\u0003F+W\b\u0002Gv\tq@\u0001\u0006T)\u0006#Vi\u0018$V\u00192{\u0011AZ\u000f\u0002}\bq1\u000bV!U\u000b~\u0013ViU#S-\u0016#u\"A5\u001e\u0003\u0005\tAa]5{KR\t1(A\u0007f]F,X-^3e\u0007>,h\u000e\u001e\u000b\u0002\u000f\u0006iA-Z9vKV,GmQ8v]R\fQa\u001c4gKJ$\"!\u001d;\u0011\u00059\u0012\u0018BA:0\u0005\u001d\u0011un\u001c7fC:DQ!\u001e\tA\u0002!\n\u0011!Y\u0001\u0005a>dG\u000e\u0006\u0002)q\")\u00110\u0005a\u0001Q\u00059A-\u001a4bk2$\u0018aB5t\u000b6\u0004H/\u001f\u000b\u0002c\u00061\u0011n\u001d$vY2\f\u0001\u0002]8t)>LE\r\u001f\u000b\u0005w}\f\u0019\u0001\u0003\u0004\u0002\u0002Q\u0001\raR\u0001\u0004a>\u001c\bBBA\u0003)\u0001\u0007q)\u0001\u0003nCN\\\u0017\u0001\u00038fqR\u0004vn\u001e\u001a\u0015\u0007m\nY\u0001\u0003\u0004\u0002\u000eU\u0001\raO\u0001\u0002]\u0002")
public class RingBuffer<A>
extends MutableQueueFieldsPadding<A>
implements Serializable {
    private final int desiredCapacity;
    private final int capacity;
    private final long idxMask;
    private final Object[] buf;
    private final AtomicLongArray seq;

    public int desiredCapacity() {
        return this.desiredCapacity;
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    @Override
    public final int size() {
        return (int)(MutableQueueFieldsPadding.tailUpdater.get(this) - MutableQueueFieldsPadding.headUpdater.get(this));
    }

    @Override
    public final long enqueuedCount() {
        return MutableQueueFieldsPadding.tailUpdater.get(this);
    }

    @Override
    public final long dequeuedCount() {
        return MutableQueueFieldsPadding.headUpdater.get(this);
    }

    @Override
    public final boolean offer(A a) {
        int aCapacity = this.capacity();
        long aMask = this.idxMask;
        AtomicLongArray aSeq = this.seq;
        AtomicLongFieldUpdater<HeadPadding> aHead = MutableQueueFieldsPadding.headUpdater;
        AtomicLongFieldUpdater<TailPadding> aTail = MutableQueueFieldsPadding.tailUpdater;
        long curTail = aTail.get(this);
        int curIdx = 0;
        int state = 0;
        while (state == 0) {
            curIdx = this.posToIdx(curTail, aMask);
            long curSeq = aSeq.get(curIdx);
            if (curSeq < curTail) {
                long curHead = aHead.get(this);
                if (curTail >= curHead + (long)aCapacity) {
                    state = -2;
                    continue;
                }
                state = 0;
                continue;
            }
            if (curSeq == curTail) {
                if (aTail.compareAndSet(this, curTail, curTail + 1L)) {
                    state = 1;
                    continue;
                }
                ++curTail;
                state = 0;
                continue;
            }
            curTail = aTail.get(this);
            state = 0;
        }
        if (state == 1) {
            this.buf[curIdx] = a;
            aSeq.lazySet(curIdx, curTail + 1L);
            return true;
        }
        return false;
    }

    @Override
    public final A poll(A a) {
        int aCapacity = this.capacity();
        long aMask = this.idxMask;
        Object[] aBuf = this.buf;
        AtomicLongArray aSeq = this.seq;
        AtomicLongFieldUpdater<HeadPadding> aHead = MutableQueueFieldsPadding.headUpdater;
        long curHead = aHead.get(this);
        int curIdx = 0;
        AtomicLongFieldUpdater<TailPadding> aTail = MutableQueueFieldsPadding.tailUpdater;
        int state = 0;
        while (state == 0) {
            curIdx = this.posToIdx(curHead, aMask);
            long curSeq = aSeq.get(curIdx);
            if (curSeq <= curHead) {
                long curTail = aTail.get(this);
                if (curHead >= curTail) {
                    state = -1;
                    continue;
                }
                state = 0;
                continue;
            }
            if (curSeq == curHead + 1L) {
                if (aHead.compareAndSet(this, curHead, curHead + 1L)) {
                    state = 1;
                    continue;
                }
                ++curHead;
                state = 0;
                continue;
            }
            curHead = aHead.get(this);
            state = 0;
        }
        if (state == 1) {
            Object deqElement = aBuf[curIdx];
            aBuf[curIdx] = null;
            aSeq.lazySet(curIdx, curHead + (long)aCapacity);
            return (A)deqElement;
        }
        return a;
    }

    @Override
    public final boolean isEmpty() {
        return MutableQueueFieldsPadding.tailUpdater.get(this) == MutableQueueFieldsPadding.headUpdater.get(this);
    }

    @Override
    public final boolean isFull() {
        return MutableQueueFieldsPadding.tailUpdater.get(this) == MutableQueueFieldsPadding.headUpdater.get(this) + (long)this.capacity();
    }

    private int posToIdx(long pos, long mask) {
        return (int)(pos & mask);
    }

    private int nextPow2(int n) {
        int nextPow = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(Math.log(n) / Math.log(2.0)));
        return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper((int)Math.pow(2.0, nextPow)), 2);
    }

    public RingBuffer(int desiredCapacity) {
        this.desiredCapacity = desiredCapacity;
        this.capacity = this.nextPow2(desiredCapacity);
        this.idxMask = this.capacity() - 1;
        this.buf = new Object[this.capacity()];
        this.seq = new AtomicLongArray(this.capacity());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.capacity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> $this.seq.set(i, i));
    }
}

