/*
 * Decompiled with CFR 0.152.
 */
package scalaz.zio.internal;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxesRunTime;
import scalaz.zio.internal.ExecutionMetrics;
import scalaz.zio.internal.Executor;
import scalaz.zio.internal.Executor$;
import scalaz.zio.internal.Executor$Unyielding$;
import scalaz.zio.internal.Executor$Yielding$;
import scalaz.zio.internal.NamedThreadFactory;

public final class Executor$
implements Serializable {
    public static Executor$ MODULE$;

    static {
        new Executor$();
    }

    public final Executor newDefaultExecutor(Executor.Role role) {
        Executor executor;
        if (Executor$Unyielding$.MODULE$.equals(role)) {
            Function1 & java.io.Serializable & Serializable intersect = (Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Executor$.$anonfun$newDefaultExecutor$1(x$1));
            int corePoolSize = Integer.MAX_VALUE;
            int maxPoolSize = Integer.MAX_VALUE;
            long keepAliveTime = 1000L;
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            SynchronousQueue<Runnable> workQueue = new SynchronousQueue<Runnable>();
            NamedThreadFactory threadFactory = new NamedThreadFactory("zio-default-unyielding", true);
            ThreadPoolExecutor threadPool = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, timeUnit, workQueue, threadFactory);
            threadPool.allowCoreThreadTimeOut(true);
            executor = this.fromThreadPoolExecutor(role, (Function1<ExecutionMetrics, Object>)intersect, threadPool);
        } else if (Executor$Yielding$.MODULE$.equals(role)) {
            Function1 & java.io.Serializable & Serializable intersect = (Function1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Executor$.$anonfun$newDefaultExecutor$2(x$2));
            int corePoolSize = Runtime.getRuntime().availableProcessors() * 2;
            long keepAliveTime = 1000L;
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
            NamedThreadFactory threadFactory = new NamedThreadFactory("zio-default-yielding", true);
            ThreadPoolExecutor threadPool = new ThreadPoolExecutor(corePoolSize, corePoolSize, keepAliveTime, timeUnit, workQueue, threadFactory);
            threadPool.allowCoreThreadTimeOut(true);
            executor = this.fromThreadPoolExecutor(role, (Function1<ExecutionMetrics, Object>)intersect, threadPool);
        } else {
            throw new MatchError((Object)role);
        }
        return executor;
    }

    public final Executor fromExecutionContext(Executor.Role role0, int yieldOpCount0, ExecutionContext ec) {
        return new Executor(role0, yieldOpCount0, ec){
            private ExecutionContext asEC;
            private volatile boolean bitmap$0;
            private final Executor.Role role0$1;
            private final int yieldOpCount0$1;
            private final ExecutionContext ec$1;

            public final void submitOrThrow(Runnable runnable) {
                Executor.submitOrThrow$(this, runnable);
            }

            private ExecutionContext asEC$lzycompute() {
                synchronized (this) {
                    if (!this.bitmap$0) {
                        this.asEC = Executor.asEC$(this);
                        this.bitmap$0 = true;
                    }
                }
                return this.asEC;
            }

            public ExecutionContext asEC() {
                if (!this.bitmap$0) {
                    return this.asEC$lzycompute();
                }
                return this.asEC;
            }

            public Executor.Role role() {
                return this.role0$1;
            }

            public int yieldOpCount() {
                return this.yieldOpCount0$1;
            }

            public boolean submit(Runnable runnable) {
                try {
                    this.ec$1.execute(runnable);
                    return true;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    return false;
                }
            }

            public boolean here() {
                return false;
            }

            public void shutdown() {
            }
            {
                this.role0$1 = role0$1;
                this.yieldOpCount0$1 = yieldOpCount0$1;
                this.ec$1 = ec$1;
                Executor.$init$(this);
            }
        };
    }

    public final Executor fromThreadPoolExecutor(Executor.Role role0, Function1<ExecutionMetrics, Object> yieldOpCount0, ThreadPoolExecutor es) {
        return new Executor(role0, es, yieldOpCount0){
            private final ExecutionMetrics metrics;
            private ExecutionContext asEC;
            private volatile boolean bitmap$0;
            private final Executor.Role role0$2;
            public final ThreadPoolExecutor es$1;
            private final Function1 yieldOpCount0$2;

            public final void submitOrThrow(Runnable runnable) {
                Executor.submitOrThrow$(this, runnable);
            }

            private ExecutionContext asEC$lzycompute() {
                synchronized (this) {
                    if (!this.bitmap$0) {
                        this.asEC = Executor.asEC$(this);
                        this.bitmap$0 = true;
                    }
                }
                return this.asEC;
            }

            public ExecutionContext asEC() {
                if (!this.bitmap$0) {
                    return this.asEC$lzycompute();
                }
                return this.asEC;
            }

            public Executor.Role role() {
                return this.role0$2;
            }

            private ExecutionMetrics metrics() {
                return this.metrics;
            }

            public int yieldOpCount() {
                return BoxesRunTime.unboxToInt((Object)this.yieldOpCount0$2.apply((Object)this.metrics()));
            }

            public boolean submit(Runnable runnable) {
                try {
                    this.es$1.execute(runnable);
                    return true;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    return false;
                }
            }

            public boolean here() {
                return false;
            }

            public void shutdown() {
                this.es$1.shutdown();
            }
            {
                this.role0$2 = role0$2;
                this.es$1 = es$1;
                this.yieldOpCount0$2 = yieldOpCount0$2;
                Executor.$init$(this);
                this.metrics = new ExecutionMetrics(this){
                    private final /* synthetic */ anon.3 $outer;

                    public int concurrency() {
                        return this.$outer.es$1.getMaximumPoolSize();
                    }

                    public int capacity() {
                        BlockingQueue<Runnable> queue = this.$outer.es$1.getQueue();
                        int remaining = queue.remainingCapacity();
                        if (remaining == Integer.MAX_VALUE) {
                            return remaining;
                        }
                        return remaining + queue.size();
                    }

                    public int size() {
                        return this.$outer.es$1.getQueue().size();
                    }

                    public long enqueuedCount() {
                        return this.$outer.es$1.getTaskCount();
                    }

                    public long dequeuedCount() {
                        return this.enqueuedCount() - (long)this.size();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }
        };
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ int $anonfun$newDefaultExecutor$1(ExecutionMetrics x$1) {
        return Integer.MAX_VALUE;
    }

    public static final /* synthetic */ int $anonfun$newDefaultExecutor$2(ExecutionMetrics x$2) {
        return 1024;
    }

    private Executor$() {
        MODULE$ = this;
    }
}

