/*
 * Decompiled with CFR 0.152.
 */
package scalaz.zio.internal.impls;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scalaz.zio.Exit;
import scalaz.zio.IO;
import scalaz.zio.internal.Env;
import scalaz.zio.internal.ExecutionMetrics;
import scalaz.zio.internal.Executor;
import scalaz.zio.internal.Executor$Unyielding$;
import scalaz.zio.internal.Executor$Yielding$;
import scalaz.zio.internal.FiberContext;
import scalaz.zio.internal.NamedThreadFactory;
import scalaz.zio.internal.Scheduler;
import scalaz.zio.internal.Scheduler$;
import scalaz.zio.internal.impls.Env$;

public final class Env$ {
    public static Env$ MODULE$;

    static {
        new Env$();
    }

    public final Env newDefaultEnv(Function1<Exit.Cause<?>, IO<Nothing$, ?>> reportFailure0) {
        return new Env(reportFailure0){
            private final Executor sync;
            private final Executor async;
            private final Scheduler scheduler;
            private final Function1 reportFailure0$1;

            public Executor defaultExecutor() {
                return Env.defaultExecutor$(this);
            }

            public final <E, A> A unsafeRun(IO<E, A> io) {
                return (A)Env.unsafeRun$(this, io);
            }

            public final <E, A> Exit<E, A> unsafeRunSync(IO<E, A> io) {
                return Env.unsafeRunSync$(this, io);
            }

            public final <E, A> void unsafeRunAsync(IO<E, A> io, Function1<Exit<E, A>, BoxedUnit> k) {
                Env.unsafeRunAsync$(this, io, k);
            }

            public final <E, A> void unsafeRunAsync_(IO<E, A> io) {
                Env.unsafeRunAsync_$(this, io);
            }

            public final void shutdown() {
                Env.shutdown$(this);
            }

            public final <E, A> FiberContext<E, A> newFiberContext(Function1<Exit.Cause<Object>, IO<Nothing$, ?>> unhandled) {
                return Env.newFiberContext$(this, unhandled);
            }

            private Executor sync() {
                return this.sync;
            }

            private Executor async() {
                return this.async;
            }

            public Executor executor(Executor.Role tpe) {
                Executor executor;
                if (Executor$Unyielding$.MODULE$.equals(tpe)) {
                    executor = this.sync();
                } else if (Executor$Yielding$.MODULE$.equals(tpe)) {
                    executor = this.async();
                } else {
                    throw new MatchError((Object)tpe);
                }
                return executor;
            }

            public Scheduler scheduler() {
                return this.scheduler;
            }

            public boolean nonFatal(Throwable t) {
                return !(t instanceof VirtualMachineError);
            }

            public IO<Nothing$, ?> reportFailure(Exit.Cause<?> cause) {
                return (IO)this.reportFailure0$1.apply(cause);
            }

            public <A, B> Map<A, B> newWeakHashMap() {
                return new WeakHashMap<K, V>();
            }
            {
                this.reportFailure0$1 = reportFailure0$1;
                Env.$init$(this);
                this.sync = Env$.MODULE$.newDefaultExecutor(Executor$Unyielding$.MODULE$);
                this.async = Env$.MODULE$.newDefaultExecutor(Executor$Yielding$.MODULE$);
                this.scheduler = Scheduler$.MODULE$.fromScheduledExecutorService(Executors.newScheduledThreadPool(1, new NamedThreadFactory("zio-timer", true)));
            }
        };
    }

    public final Executor newDefaultExecutor(Executor.Role role) {
        Executor executor;
        if (Executor$Unyielding$.MODULE$.equals(role)) {
            int corePoolSize = 0;
            int maxPoolSize = Integer.MAX_VALUE;
            long keepAliveTime = 1000L;
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            SynchronousQueue<Runnable> workQueue = new SynchronousQueue<Runnable>();
            NamedThreadFactory threadFactory = new NamedThreadFactory("zio-default-unyielding", true);
            executor = this.fromThreadPoolExecutor(role, (Function1<ExecutionMetrics, Object>)(Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Env$.$anonfun$newDefaultExecutor$1(x$1)), new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, timeUnit, workQueue, threadFactory));
        } else if (Executor$Yielding$.MODULE$.equals(role)) {
            Function1 & java.io.Serializable & Serializable intersect = (Function1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Env$.$anonfun$newDefaultExecutor$2(x$2));
            int corePoolSize = Runtime.getRuntime().availableProcessors() * 2;
            long keepAliveTime = 1000L;
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
            NamedThreadFactory threadFactory = new NamedThreadFactory("zio-default-yielding", true);
            ThreadPoolExecutor threadPool = new ThreadPoolExecutor(corePoolSize, corePoolSize, keepAliveTime, timeUnit, workQueue, threadFactory);
            threadPool.allowCoreThreadTimeOut(true);
            executor = this.fromThreadPoolExecutor(role, (Function1<ExecutionMetrics, Object>)intersect, threadPool);
        } else {
            throw new MatchError((Object)role);
        }
        return executor;
    }

    public final Executor fromThreadPoolExecutor(Executor.Role role0, Function1<ExecutionMetrics, Object> yieldOpCount0, ThreadPoolExecutor es) {
        return new Executor(role0, es, yieldOpCount0){
            private ExecutionContext asEC;
            private volatile boolean bitmap$0;
            private final Executor.Role role0$1;
            public final ThreadPoolExecutor es$1;
            private final Function1 yieldOpCount0$1;

            public final void submitOrThrow(Runnable runnable) {
                Executor.submitOrThrow$(this, runnable);
            }

            private ExecutionContext asEC$lzycompute() {
                synchronized (this) {
                    if (!this.bitmap$0) {
                        this.asEC = Executor.asEC$(this);
                        this.bitmap$0 = true;
                    }
                }
                return this.asEC;
            }

            public ExecutionContext asEC() {
                if (!this.bitmap$0) {
                    return this.asEC$lzycompute();
                }
                return this.asEC;
            }

            public Executor.Role role() {
                return this.role0$1;
            }

            private ExecutionMetrics metrics0() {
                return new ExecutionMetrics(this){
                    private final /* synthetic */ anon.2 $outer;

                    public int concurrency() {
                        return this.$outer.es$1.getMaximumPoolSize();
                    }

                    public int capacity() {
                        BlockingQueue<Runnable> queue = this.$outer.es$1.getQueue();
                        int remaining = queue.remainingCapacity();
                        if (remaining == Integer.MAX_VALUE) {
                            return remaining;
                        }
                        return remaining + queue.size();
                    }

                    public int size() {
                        return this.$outer.es$1.getQueue().size();
                    }

                    public int workersCount() {
                        return this.$outer.es$1.getPoolSize();
                    }

                    public long enqueuedCount() {
                        return this.$outer.es$1.getTaskCount();
                    }

                    public long dequeuedCount() {
                        return this.enqueuedCount() - (long)this.size();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }

            public Some<ExecutionMetrics> metrics() {
                return new Some((Object)this.metrics0());
            }

            public int yieldOpCount() {
                return BoxesRunTime.unboxToInt((Object)this.yieldOpCount0$1.apply((Object)this.metrics0()));
            }

            public boolean submit(Runnable runnable) {
                try {
                    this.es$1.execute(runnable);
                    return true;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    return false;
                }
            }

            public boolean here() {
                return false;
            }

            public void shutdown() {
                this.es$1.shutdown();
            }
            {
                this.role0$1 = role0$1;
                this.es$1 = es$1;
                this.yieldOpCount0$1 = yieldOpCount0$1;
                Executor.$init$(this);
            }
        };
    }

    public static final /* synthetic */ int $anonfun$newDefaultExecutor$1(ExecutionMetrics x$1) {
        return Integer.MAX_VALUE;
    }

    public static final /* synthetic */ int $anonfun$newDefaultExecutor$2(ExecutionMetrics x$2) {
        return 1024;
    }

    private Env$() {
        MODULE$ = this;
    }
}

