/*
 * Decompiled with CFR 0.152.
 */
package scalaz.stream.nio;

import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.charset.CharsetDecoder;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.io.Codec;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scalaz.;
import scalaz.concurrent.Task;
import scalaz.concurrent.Task$;
import scalaz.stream.Cause;
import scalaz.stream.Cause$End$;
import scalaz.stream.ChannelSyntax$;
import scalaz.stream.Process;
import scalaz.stream.Process$;
import scalaz.stream.Process$Process0Syntax$;
import scalaz.stream.Process$ProcessSyntax$;
import scalaz.stream.io$;
import scalaz.stream.text$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class file$ {
    public static final file$ MODULE$;

    static {
        new file$();
    }

    public Process<Task, Function1<Object, Task<ByteVector>>> chunkR(String path) {
        return this.chunkR(Paths.get(path, new String[0]));
    }

    public Process<Task, Function1<Object, Task<ByteVector>>> chunkR(URI uri) {
        return this.chunkR(Paths.get(uri));
    }

    public Process<Task, Function1<Object, Task<ByteVector>>> chunkR(Path path) {
        return this.chunkR((Function0<AsynchronousFileChannel>)(Function0 & java.io.Serializable & Serializable)() -> AsynchronousFileChannel.open(path, StandardOpenOption.READ));
    }

    public Process<Task, Function1<Object, Task<ByteVector>>> chunkR(Function0<AsynchronousFileChannel> src) {
        return ChannelSyntax$.MODULE$.mapOut$extension(Process$.MODULE$.toChannelSyntax(this.chunkReadBuffer(src)), (Function1 & java.io.Serializable & Serializable)bytes -> ByteVector$.MODULE$.view(bytes), Task$.MODULE$.taskInstance());
    }

    public Process<Task, Function1<ByteVector, Task<BoxedUnit>>> chunkW(String path) {
        return this.chunkW(path, true);
    }

    public Process<Task, Function1<ByteVector, Task<BoxedUnit>>> chunkW(String path, boolean create) {
        return this.chunkW(Paths.get(path, new String[0]), create);
    }

    public Process<Task, Function1<ByteVector, Task<BoxedUnit>>> chunkW(URI uri) {
        return this.chunkW(uri, true);
    }

    public Process<Task, Function1<ByteVector, Task<BoxedUnit>>> chunkW(URI uri, boolean create) {
        return this.chunkW(Paths.get(uri), create);
    }

    public Process<Task, Function1<ByteVector, Task<BoxedUnit>>> chunkW(Path path) {
        return this.chunkW(path, true);
    }

    public Process<Task, Function1<ByteVector, Task<BoxedUnit>>> chunkW(Path path, boolean create) {
        return create ? this.chunkW((Function0<AsynchronousFileChannel>)(Function0 & java.io.Serializable & Serializable)() -> AsynchronousFileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE)) : this.chunkW((Function0<AsynchronousFileChannel>)(Function0 & java.io.Serializable & Serializable)() -> AsynchronousFileChannel.open(path, StandardOpenOption.WRITE));
    }

    public Process<Task, Function1<ByteVector, Task<BoxedUnit>>> chunkW(Function0<AsynchronousFileChannel> src) {
        return this.chunkWriteBuffer(src).map((Function1 & java.io.Serializable & Serializable)buffToTask -> (Function1 & java.io.Serializable & Serializable)vec -> (Task)buffToTask.apply((Object)vec.toByteBuffer()));
    }

    public Process<Task, String> linesR(String filename, Codec codec) {
        return this.linesR(Paths.get(filename, new String[0]), codec);
    }

    public Process<Task, String> linesR(Path path, Codec codec) {
        return this.linesR((Function0<AsynchronousFileChannel>)(Function0 & java.io.Serializable & Serializable)() -> AsynchronousFileChannel.open(path, new OpenOption[0]), codec);
    }

    public Process<Task, String> linesR(Function0<AsynchronousFileChannel> src, Codec codec) {
        return this.textR(src, codec).pipe(text$.MODULE$.lines(-1));
    }

    public Process<Task, String> textR(Function0<AsynchronousFileChannel> src, Codec codec) {
        return Process$.MODULE$.suspend((Function0 & java.io.Serializable & Serializable)() -> {
            Function1<ByteBuffer, CharBuffer> f = this.decodeByteBuff(codec);
            return Process$ProcessSyntax$.MODULE$.through$extension(Process$.MODULE$.ProcessSyntax(Process$Process0Syntax$.MODULE$.toSource$extension(Process$.MODULE$.Process0Syntax(Process$.MODULE$.constant(BoxesRunTime.boxToInteger((int)1024), Process$.MODULE$.constant$default$2())))), this.chunkReadBuffer(src)).flatMap((Function1 & java.io.Serializable & Serializable)buff -> {
                CharBuffer charbuff = (CharBuffer)f.apply(buff);
                String res = CharBuffer.wrap(charbuff).toString();
                return Process$.MODULE$.emit(res);
            });
        });
    }

    public Process<Task, Function1<Object, Task<ByteBuffer>>> chunkReadBuffer(Function0<AsynchronousFileChannel> src2) {
        IntRef filePos = IntRef.create((int)0);
        BooleanRef foundEOF = BooleanRef.create((boolean)false);
        return io$.MODULE$.resource(Task$.MODULE$.delay(src2), (Function1 & java.io.Serializable & Serializable)src -> Task$.MODULE$.delay((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> src.close()), (Function1 & java.io.Serializable & Serializable)src -> Task$.MODULE$.now((Function1 & java.io.Serializable & Serializable)size -> Task$.MODULE$.async((Function1 & java.io.Serializable & Serializable)cb -> {
            file$.$anonfun$chunkReadBuffer$5(src$1, filePos$1, foundEOF$1, src$4, size, cb);
            return BoxedUnit.UNIT;
        })));
    }

    public Process<Task, Function1<ByteBuffer, Task<BoxedUnit>>> chunkWriteBuffer(Function0<AsynchronousFileChannel> src2) {
        IntRef pos = IntRef.create((int)0);
        return io$.MODULE$.resource(Task$.MODULE$.delay(src2), (Function1 & java.io.Serializable & Serializable)src -> Task$.MODULE$.delay((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> src.close()), (Function1 & java.io.Serializable & Serializable)src -> Task$.MODULE$.now((Function1 & java.io.Serializable & Serializable)buff -> Task$.MODULE$.async((Function1 & java.io.Serializable & Serializable)cb -> {
            file$.scalaz$stream$nio$file$$go$1(pos, src, buff, cb);
            return BoxedUnit.UNIT;
        })));
    }

    private Function1<ByteBuffer, CharBuffer> decodeByteBuff(Codec codec) {
        ObjectRef currentBuff = ObjectRef.create(null);
        CharsetDecoder dec = codec.decoder();
        return (Function1 & java.io.Serializable & Serializable)buff -> {
            void var3_3;
            block0: {
                file$.concat$1(buff, currentBuff);
                CharBuffer str = dec.decode((ByteBuffer)currentBuff$1.elem);
                if (((ByteBuffer)currentBuff$1.elem).remaining() != 0) break block0;
                currentBuff$1.elem = null;
            }
            return var3_3;
        };
    }

    public static final CompletionHandler scalaz$stream$nio$file$$completionHandler$1(ByteBuffer buff, int expected, int bufPos, Function1 cb, Function0 src$1, IntRef filePos$1, BooleanRef foundEOF$1) {
        return new CompletionHandler<Integer, Null$>(src$1, filePos$1, foundEOF$1, buff, expected, bufPos, cb){
            private final Function0 src$1;
            private final IntRef filePos$1;
            private final BooleanRef foundEOF$1;
            private final ByteBuffer buff$1;
            private final int expected$1;
            private final int bufPos$1;
            private final Function1 cb$1;

            public void completed(Integer found, Null$ attachment) {
                if (BoxesRunTime.equalsNumObject((Number)found, (Object)BoxesRunTime.boxToInteger((int)-1)) || this.foundEOF$1.elem) {
                    if (!this.foundEOF$1.elem) {
                        this.foundEOF$1.elem = true;
                        this.buff$1.flip();
                        this.cb$1.apply((Object)new .bslash.div.minus((Object)this.buff$1));
                    } else {
                        this.cb$1.apply((Object)new .minus.bslash.div((Object)new Cause.Terminated(Cause$End$.MODULE$)));
                    }
                } else if (Predef$.MODULE$.Integer2int(found) < this.expected$1) {
                    this.filePos$1.elem += Predef$.MODULE$.Integer2int(found);
                    int missing = this.expected$1 - Predef$.MODULE$.Integer2int(found);
                    int nextBufPos = this.bufPos$1 + Predef$.MODULE$.Integer2int(found);
                    ((AsynchronousFileChannel)this.src$1.apply()).read(this.buff$1, this.filePos$1.elem, null, file$.scalaz$stream$nio$file$$completionHandler$1(this.buff$1, missing, nextBufPos, this.cb$1, this.src$1, this.filePos$1, this.foundEOF$1));
                } else {
                    this.filePos$1.elem += Predef$.MODULE$.Integer2int(found);
                    this.buff$1.flip();
                    this.cb$1.apply((Object)new .bslash.div.minus((Object)this.buff$1));
                }
            }

            public void failed(Throwable exc, Null$ attachment) {
                this.cb$1.apply((Object)new .minus.bslash.div((Object)new Cause.Terminated(new Cause.Error(exc))));
            }
            {
                this.src$1 = src$1;
                this.filePos$1 = filePos$1;
                this.foundEOF$1 = foundEOF$1;
                this.buff$1 = buff$1;
                this.expected$1 = expected$1;
                this.bufPos$1 = bufPos$1;
                this.cb$1 = cb$1;
            }
        };
    }

    public static final /* synthetic */ void $anonfun$chunkReadBuffer$5(Function0 src$1, IntRef filePos$1, BooleanRef foundEOF$1, AsynchronousFileChannel src$4, int size$1, Function1 cb) {
        ByteBuffer buff = ByteBuffer.allocate(size$1);
        src$4.read(buff, filePos$1.elem, null, file$.scalaz$stream$nio$file$$completionHandler$1(buff, size$1, 0, cb, src$1, filePos$1, foundEOF$1));
    }

    public static final void scalaz$stream$nio$file$$go$1(IntRef pos$1, AsynchronousFileChannel src$6, ByteBuffer buff$2, Function1 cb$2) {
        src$6.write(buff$2, pos$1.elem, null, new CompletionHandler<Integer, Null$>(pos$1, src$6, buff$2, cb$2){
            private final IntRef pos$1;
            private final AsynchronousFileChannel src$6;
            private final ByteBuffer buff$2;
            private final Function1 cb$2;

            public void completed(Integer result, Null$ attachment) {
                if (BoxesRunTime.equalsNumObject((Number)result, (Object)BoxesRunTime.boxToInteger((int)-1))) {
                    this.cb$2.apply((Object)new .minus.bslash.div((Object)new Cause.Terminated(Cause$End$.MODULE$)));
                } else {
                    this.pos$1.elem += Predef$.MODULE$.Integer2int(result);
                    if (this.buff$2.remaining() != 0) {
                        file$.scalaz$stream$nio$file$$go$1(this.pos$1, this.src$6, this.buff$2, this.cb$2);
                    } else {
                        this.cb$2.apply((Object)new .bslash.div.minus((Object)BoxedUnit.UNIT));
                    }
                }
            }

            public void failed(Throwable exc, Null$ attachment) {
                this.cb$2.apply((Object)new .minus.bslash.div((Object)new Cause.Terminated(new Cause.Error(exc))));
            }
            {
                this.pos$1 = pos$1;
                this.src$6 = src$6;
                this.buff$2 = buff$2;
                this.cb$2 = cb$2;
            }
        });
    }

    private static final void concat$1(ByteBuffer buff, ObjectRef currentBuff$1) {
        if ((ByteBuffer)currentBuff$1.elem == null) {
            currentBuff$1.elem = buff;
        } else {
            ByteBuffer newbuff = ByteBuffer.allocate(((ByteBuffer)currentBuff$1.elem).remaining() + buff.remaining());
            newbuff.put((ByteBuffer)currentBuff$1.elem).put(buff).flip();
            currentBuff$1.elem = newbuff;
        }
    }

    private file$() {
        MODULE$ = this;
    }
}

