/*
 * Decompiled with CFR 0.152.
 */
package scalus.builtin;

import java.math.BigInteger;
import org.bitcoin.NativeSecp256k1;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.digests.Blake2bDigest;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.bouncycastle.jcajce.provider.digest.RIPEMD160;
import org.bouncycastle.jcajce.provider.digest.SHA3;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.math.BigInt;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scalus.builtin.BLS12_381_G1_Element;
import scalus.builtin.BLS12_381_G1_Element$;
import scalus.builtin.BLS12_381_G2_Element;
import scalus.builtin.BLS12_381_G2_Element$;
import scalus.builtin.BLS12_381_MlResult;
import scalus.builtin.ByteString;
import scalus.builtin.ByteString$;
import scalus.builtin.PlatformSpecific;
import scalus.builtin.PlatformSpecific$;
import scalus.utils.Utils$;
import supranational.blst.P1;
import supranational.blst.P2;
import supranational.blst.PT;

public interface JVMPlatformSpecific
extends PlatformSpecific {
    public static ByteString sha2_256$(JVMPlatformSpecific $this, ByteString bs) {
        return $this.sha2_256(bs);
    }

    @Override
    default public ByteString sha2_256(ByteString bs) {
        return ByteString$.MODULE$.unsafeFromArray(Utils$.MODULE$.sha2_256(bs.bytes()));
    }

    public static ByteString sha3_256$(JVMPlatformSpecific $this, ByteString bs) {
        return $this.sha3_256(bs);
    }

    @Override
    default public ByteString sha3_256(ByteString bs) {
        SHA3.Digest256 digestSHA3 = new SHA3.Digest256();
        return ByteString$.MODULE$.unsafeFromArray(digestSHA3.digest(bs.bytes()));
    }

    public static ByteString blake2b_224$(JVMPlatformSpecific $this, ByteString bs) {
        return $this.blake2b_224(bs);
    }

    @Override
    default public ByteString blake2b_224(ByteString bs) {
        Blake2bDigest digest = new Blake2bDigest(224);
        digest.update(bs.bytes(), 0, bs.length());
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);
        return ByteString$.MODULE$.unsafeFromArray(hash);
    }

    public static ByteString blake2b_256$(JVMPlatformSpecific $this, ByteString bs) {
        return $this.blake2b_256(bs);
    }

    @Override
    default public ByteString blake2b_256(ByteString bs) {
        Blake2bDigest digest = new Blake2bDigest(256);
        digest.update(bs.bytes(), 0, bs.length());
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);
        return ByteString$.MODULE$.unsafeFromArray(hash);
    }

    public static boolean verifySchnorrSecp256k1Signature$(JVMPlatformSpecific $this, ByteString pk, ByteString msg, ByteString sig) {
        return $this.verifySchnorrSecp256k1Signature(pk, msg, sig);
    }

    @Override
    default public boolean verifySchnorrSecp256k1Signature(ByteString pk, ByteString msg, ByteString sig) {
        Predef$.MODULE$.require(pk.length() == 32, () -> JVMPlatformSpecific.verifySchnorrSecp256k1Signature$$anonfun$1(pk));
        Object object = Predef$.MODULE$.byteArrayOps(pk.bytes());
        Predef$.MODULE$.require(NativeSecp256k1.isValidPubKey((byte[])((byte[])ArrayOps$.MODULE$.$plus$colon$extension(object, (Object)BoxesRunTime.boxToByte((byte)2), ClassTag$.MODULE$.apply(Byte.TYPE)))), () -> JVMPlatformSpecific.verifySchnorrSecp256k1Signature$$anonfun$2(pk));
        Predef$.MODULE$.require(sig.length() == 64, () -> JVMPlatformSpecific.verifySchnorrSecp256k1Signature$$anonfun$3(sig));
        return NativeSecp256k1.schnorrVerify((byte[])sig.bytes(), (byte[])msg.bytes(), (byte[])pk.bytes());
    }

    public static boolean verifyEd25519Signature$(JVMPlatformSpecific $this, ByteString pk, ByteString msg, ByteString sig) {
        return $this.verifyEd25519Signature(pk, msg, sig);
    }

    @Override
    default public boolean verifyEd25519Signature(ByteString pk, ByteString msg, ByteString sig) {
        Ed25519PublicKeyParameters ed25519PublicKeyParameters;
        Predef$.MODULE$.require(pk.length() == 32, () -> JVMPlatformSpecific.verifyEd25519Signature$$anonfun$1(pk));
        Predef$.MODULE$.require(sig.length() == 64, () -> JVMPlatformSpecific.verifyEd25519Signature$$anonfun$2(sig));
        try {
            ed25519PublicKeyParameters = new Ed25519PublicKeyParameters(pk.bytes(), 0);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        Ed25519PublicKeyParameters pubKeyParams = ed25519PublicKeyParameters;
        Ed25519Signer verifier = new Ed25519Signer();
        verifier.init(false, (CipherParameters)pubKeyParams);
        verifier.update(msg.bytes(), 0, msg.length());
        return verifier.verifySignature(sig.bytes());
    }

    public static boolean verifyEcdsaSecp256k1Signature$(JVMPlatformSpecific $this, ByteString pk, ByteString msg, ByteString sig) {
        return $this.verifyEcdsaSecp256k1Signature(pk, msg, sig);
    }

    @Override
    default public boolean verifyEcdsaSecp256k1Signature(ByteString pk, ByteString msg, ByteString sig) {
        Predef$.MODULE$.require(pk.length() == 33, () -> JVMPlatformSpecific.verifyEcdsaSecp256k1Signature$$anonfun$1(pk));
        Predef$.MODULE$.require(NativeSecp256k1.isValidPubKey((byte[])pk.bytes()), () -> JVMPlatformSpecific.verifyEcdsaSecp256k1Signature$$anonfun$2(pk));
        Predef$.MODULE$.require(msg.length() == 32, () -> JVMPlatformSpecific.verifyEcdsaSecp256k1Signature$$anonfun$3(msg));
        Predef$.MODULE$.require(sig.length() == 64, () -> JVMPlatformSpecific.verifyEcdsaSecp256k1Signature$$anonfun$4(sig));
        BigInt r = package$.MODULE$.BigInt().apply(new BigInteger(1, sig.bytes(), 0, 32));
        BigInt s = package$.MODULE$.BigInt().apply(new BigInteger(1, sig.bytes(), 32, 32));
        int rsSize = r.toByteArray().length + s.toByteArray().length;
        int totalSize = 4 + rsSize;
        Object object = Predef$.MODULE$.byteArrayOps(new byte[]{(byte)48, (byte)totalSize, (byte)2, (byte)r.toByteArray().length});
        Object object2 = Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)r.toByteArray(), ClassTag$.MODULE$.apply(Byte.TYPE)));
        Object object3 = Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.$plus$plus$extension(object2, (Object)new byte[]{(byte)2, (byte)s.toByteArray().length}, ClassTag$.MODULE$.apply(Byte.TYPE)));
        byte[] signature = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object3, (Object)s.toByteArray(), ClassTag$.MODULE$.apply(Byte.TYPE));
        return NativeSecp256k1.verify((byte[])msg.bytes(), (byte[])signature, (byte[])pk.bytes());
    }

    public static boolean bls12_381_G1_equal$(JVMPlatformSpecific $this, BLS12_381_G1_Element p1, BLS12_381_G1_Element p2) {
        return $this.bls12_381_G1_equal(p1, p2);
    }

    @Override
    default public boolean bls12_381_G1_equal(BLS12_381_G1_Element p1, BLS12_381_G1_Element p2) {
        BLS12_381_G1_Element bLS12_381_G1_Element = p1;
        BLS12_381_G1_Element bLS12_381_G1_Element2 = p2;
        return !(bLS12_381_G1_Element != null ? !((Object)bLS12_381_G1_Element).equals(bLS12_381_G1_Element2) : bLS12_381_G1_Element2 != null);
    }

    public static BLS12_381_G1_Element bls12_381_G1_add$(JVMPlatformSpecific $this, BLS12_381_G1_Element p1, BLS12_381_G1_Element p2) {
        return $this.bls12_381_G1_add(p1, p2);
    }

    @Override
    default public BLS12_381_G1_Element bls12_381_G1_add(BLS12_381_G1_Element p1, BLS12_381_G1_Element p2) {
        return BLS12_381_G1_Element$.MODULE$.apply(p1.value().dup().add(p2.value()));
    }

    public static BLS12_381_G1_Element bls12_381_G1_scalarMul$(JVMPlatformSpecific $this, BigInt s, BLS12_381_G1_Element p) {
        return $this.bls12_381_G1_scalarMul(s, p);
    }

    @Override
    default public BLS12_381_G1_Element bls12_381_G1_scalarMul(BigInt s, BLS12_381_G1_Element p) {
        BigInteger scalar = s.bigInteger().mod(PlatformSpecific$.MODULE$.bls12_381_scalar_period().bigInteger());
        return BLS12_381_G1_Element$.MODULE$.apply(p.value().dup().mult(scalar));
    }

    public static BLS12_381_G1_Element bls12_381_G1_neg$(JVMPlatformSpecific $this, BLS12_381_G1_Element p) {
        return $this.bls12_381_G1_neg(p);
    }

    @Override
    default public BLS12_381_G1_Element bls12_381_G1_neg(BLS12_381_G1_Element p) {
        return BLS12_381_G1_Element$.MODULE$.apply(p.value().dup().neg());
    }

    public static ByteString bls12_381_G1_compress$(JVMPlatformSpecific $this, BLS12_381_G1_Element p) {
        return $this.bls12_381_G1_compress(p);
    }

    @Override
    default public ByteString bls12_381_G1_compress(BLS12_381_G1_Element p) {
        return p.toCompressedByteString();
    }

    public static BLS12_381_G1_Element bls12_381_G1_uncompress$(JVMPlatformSpecific $this, ByteString bs) {
        return $this.bls12_381_G1_uncompress(bs);
    }

    @Override
    default public BLS12_381_G1_Element bls12_381_G1_uncompress(ByteString bs) {
        Predef$.MODULE$.require(bs.length() == 48, () -> JVMPlatformSpecific.bls12_381_G1_uncompress$$anonfun$1(bs));
        Predef$.MODULE$.require((bs.bytes()[0] & 0x80) != 0, () -> JVMPlatformSpecific.bls12_381_G1_uncompress$$anonfun$2(bs));
        P1 p = new P1(bs.bytes());
        if (!p.in_group()) {
            throw new IllegalArgumentException("Invalid point");
        }
        return BLS12_381_G1_Element$.MODULE$.apply(p);
    }

    public static BLS12_381_G1_Element bls12_381_G1_hashToGroup$(JVMPlatformSpecific $this, ByteString bs, ByteString dst) {
        return $this.bls12_381_G1_hashToGroup(bs, dst);
    }

    @Override
    default public BLS12_381_G1_Element bls12_381_G1_hashToGroup(ByteString bs, ByteString dst) {
        Predef$.MODULE$.require(dst.length() <= 255, () -> JVMPlatformSpecific.bls12_381_G1_hashToGroup$$anonfun$1(dst));
        P1 p = new P1();
        p.hash_to(bs.bytes(), new String(dst.bytes(), "Latin1"));
        return BLS12_381_G1_Element$.MODULE$.apply(p);
    }

    public static boolean bls12_381_G2_equal$(JVMPlatformSpecific $this, BLS12_381_G2_Element p1, BLS12_381_G2_Element p2) {
        return $this.bls12_381_G2_equal(p1, p2);
    }

    @Override
    default public boolean bls12_381_G2_equal(BLS12_381_G2_Element p1, BLS12_381_G2_Element p2) {
        BLS12_381_G2_Element bLS12_381_G2_Element = p1;
        BLS12_381_G2_Element bLS12_381_G2_Element2 = p2;
        return !(bLS12_381_G2_Element != null ? !((Object)bLS12_381_G2_Element).equals(bLS12_381_G2_Element2) : bLS12_381_G2_Element2 != null);
    }

    public static BLS12_381_G2_Element bls12_381_G2_add$(JVMPlatformSpecific $this, BLS12_381_G2_Element p1, BLS12_381_G2_Element p2) {
        return $this.bls12_381_G2_add(p1, p2);
    }

    @Override
    default public BLS12_381_G2_Element bls12_381_G2_add(BLS12_381_G2_Element p1, BLS12_381_G2_Element p2) {
        return BLS12_381_G2_Element$.MODULE$.apply(p1.value().dup().add(p2.value()));
    }

    public static BLS12_381_G2_Element bls12_381_G2_scalarMul$(JVMPlatformSpecific $this, BigInt s, BLS12_381_G2_Element p) {
        return $this.bls12_381_G2_scalarMul(s, p);
    }

    @Override
    default public BLS12_381_G2_Element bls12_381_G2_scalarMul(BigInt s, BLS12_381_G2_Element p) {
        BigInteger scalar = s.bigInteger().mod(PlatformSpecific$.MODULE$.bls12_381_scalar_period().bigInteger());
        return BLS12_381_G2_Element$.MODULE$.apply(p.value().dup().mult(scalar));
    }

    public static BLS12_381_G2_Element bls12_381_G2_neg$(JVMPlatformSpecific $this, BLS12_381_G2_Element p) {
        return $this.bls12_381_G2_neg(p);
    }

    @Override
    default public BLS12_381_G2_Element bls12_381_G2_neg(BLS12_381_G2_Element p) {
        return BLS12_381_G2_Element$.MODULE$.apply(p.value().dup().neg());
    }

    public static ByteString bls12_381_G2_compress$(JVMPlatformSpecific $this, BLS12_381_G2_Element p) {
        return $this.bls12_381_G2_compress(p);
    }

    @Override
    default public ByteString bls12_381_G2_compress(BLS12_381_G2_Element p) {
        return p.toCompressedByteString();
    }

    public static BLS12_381_G2_Element bls12_381_G2_uncompress$(JVMPlatformSpecific $this, ByteString bs) {
        return $this.bls12_381_G2_uncompress(bs);
    }

    @Override
    default public BLS12_381_G2_Element bls12_381_G2_uncompress(ByteString bs) {
        Predef$.MODULE$.require(bs.length() == 96, () -> JVMPlatformSpecific.bls12_381_G2_uncompress$$anonfun$1(bs));
        Predef$.MODULE$.require((bs.bytes()[0] & 0x80) != 0, () -> JVMPlatformSpecific.bls12_381_G2_uncompress$$anonfun$2(bs));
        P2 p = new P2(bs.bytes());
        if (!p.in_group()) {
            throw new IllegalArgumentException("Invalid point");
        }
        return BLS12_381_G2_Element$.MODULE$.apply(p);
    }

    public static BLS12_381_G2_Element bls12_381_G2_hashToGroup$(JVMPlatformSpecific $this, ByteString bs, ByteString dst) {
        return $this.bls12_381_G2_hashToGroup(bs, dst);
    }

    @Override
    default public BLS12_381_G2_Element bls12_381_G2_hashToGroup(ByteString bs, ByteString dst) {
        Predef$.MODULE$.require(dst.length() <= 255, () -> JVMPlatformSpecific.bls12_381_G2_hashToGroup$$anonfun$1(dst));
        P2 p = new P2();
        p.hash_to(bs.bytes(), new String(dst.bytes(), "Latin1"));
        return BLS12_381_G2_Element$.MODULE$.apply(p);
    }

    public static BLS12_381_MlResult bls12_381_millerLoop$(JVMPlatformSpecific $this, BLS12_381_G1_Element p1, BLS12_381_G2_Element p2) {
        return $this.bls12_381_millerLoop(p1, p2);
    }

    @Override
    default public BLS12_381_MlResult bls12_381_millerLoop(BLS12_381_G1_Element p1, BLS12_381_G2_Element p2) {
        PT pt = new PT(p1.value(), p2.value());
        return new BLS12_381_MlResult(pt);
    }

    public static BLS12_381_MlResult bls12_381_mulMlResult$(JVMPlatformSpecific $this, BLS12_381_MlResult r1, BLS12_381_MlResult r2) {
        return $this.bls12_381_mulMlResult(r1, r2);
    }

    @Override
    default public BLS12_381_MlResult bls12_381_mulMlResult(BLS12_381_MlResult r1, BLS12_381_MlResult r2) {
        PT pt = r1.value().dup().mul(r2.value());
        return new BLS12_381_MlResult(pt);
    }

    public static boolean bls12_381_finalVerify$(JVMPlatformSpecific $this, BLS12_381_MlResult p1, BLS12_381_MlResult p2) {
        return $this.bls12_381_finalVerify(p1, p2);
    }

    @Override
    default public boolean bls12_381_finalVerify(BLS12_381_MlResult p1, BLS12_381_MlResult p2) {
        return PT.finalverify((PT)p1.value(), (PT)p2.value());
    }

    public static ByteString keccak_256$(JVMPlatformSpecific $this, ByteString bs) {
        return $this.keccak_256(bs);
    }

    @Override
    default public ByteString keccak_256(ByteString bs) {
        Keccak.Digest256 digest = new Keccak.Digest256();
        return ByteString$.MODULE$.unsafeFromArray(digest.digest(bs.bytes()));
    }

    public static ByteString ripemd_160$(JVMPlatformSpecific $this, ByteString byteString) {
        return $this.ripemd_160(byteString);
    }

    @Override
    default public ByteString ripemd_160(ByteString byteString) {
        RIPEMD160.Digest digest = new RIPEMD160.Digest();
        return ByteString$.MODULE$.unsafeFromArray(digest.digest(byteString.bytes()));
    }

    private static Object verifySchnorrSecp256k1Signature$$anonfun$1(ByteString pk$1) {
        return new StringBuilder(26).append("Invalid public key length ").append(pk$1.length()).toString();
    }

    private static Object verifySchnorrSecp256k1Signature$$anonfun$2(ByteString pk$2) {
        return new StringBuilder(19).append("Invalid public key ").append(pk$2).toString();
    }

    private static Object verifySchnorrSecp256k1Signature$$anonfun$3(ByteString sig$1) {
        return new StringBuilder(25).append("Invalid signature length ").append(sig$1.length()).toString();
    }

    private static Object verifyEd25519Signature$$anonfun$1(ByteString pk$3) {
        return new StringBuilder(26).append("Invalid public key length ").append(pk$3.length()).toString();
    }

    private static Object verifyEd25519Signature$$anonfun$2(ByteString sig$2) {
        return new StringBuilder(25).append("Invalid signature length ").append(sig$2.length()).toString();
    }

    private static Object verifyEcdsaSecp256k1Signature$$anonfun$1(ByteString pk$4) {
        return new StringBuilder(41).append("Invalid public key length ").append(pk$4.length()).append(", expected 33, ").append(pk$4.toHex()).toString();
    }

    private static Object verifyEcdsaSecp256k1Signature$$anonfun$2(ByteString pk$5) {
        return new StringBuilder(19).append("Invalid public key ").append(pk$5).toString();
    }

    private static Object verifyEcdsaSecp256k1Signature$$anonfun$3(ByteString msg$1) {
        return new StringBuilder(36).append("Invalid message length ").append(msg$1.length()).append(", expected 32").toString();
    }

    private static Object verifyEcdsaSecp256k1Signature$$anonfun$4(ByteString sig$3) {
        return new StringBuilder(38).append("Invalid signature length ").append(sig$3.length()).append(", expected 64").toString();
    }

    private static Object bls12_381_G1_uncompress$$anonfun$1(ByteString bs$1) {
        return new StringBuilder(87).append("Invalid length of bytes for compressed point of G1: expected 48, actual: ").append(bs$1.length()).append(", byteString: ").append(bs$1).toString();
    }

    private static Object bls12_381_G1_uncompress$$anonfun$2(ByteString bs$2) {
        return new StringBuilder(54).append("Compressed bit isn't set for point in G1, byteString: ").append(bs$2).toString();
    }

    private static Object bls12_381_G1_hashToGroup$$anonfun$1(ByteString dst$1) {
        return new StringBuilder(90).append("Invalid length of bytes for dst parameter of hashToGroup of G1, expected: <= 255, actual: ").append(dst$1.length()).toString();
    }

    private static Object bls12_381_G2_uncompress$$anonfun$1(ByteString bs$3) {
        return new StringBuilder(87).append("Invalid length of bytes for compressed point of G2: expected 96, actual: ").append(bs$3.length()).append(", byteString: ").append(bs$3).toString();
    }

    private static Object bls12_381_G2_uncompress$$anonfun$2(ByteString bs$4) {
        return new StringBuilder(54).append("Compressed bit isn't set for point in G2, byteString: ").append(bs$4).toString();
    }

    private static Object bls12_381_G2_hashToGroup$$anonfun$1(ByteString dst$2) {
        return new StringBuilder(90).append("Invalid length of bytes for dst parameter of hashToGroup of G2, expected: <= 255, actual: ").append(dst$2.length()).toString();
    }
}

