/*
 * Decompiled with CFR 0.152.
 */
package scalus.cardano.address;

import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.reflect.Enum;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure$;
import scala.util.Try;
import scala.util.Try$;
import scalus.builtin.ByteString;
import scalus.cardano.address.Address$;
import scalus.cardano.address.Address$Byron$;
import scalus.cardano.address.Address$Shelley$;
import scalus.cardano.address.Address$Stake$;
import scalus.cardano.address.ByronAddress;
import scalus.cardano.address.Network;
import scalus.cardano.address.ShelleyAddress;
import scalus.cardano.address.StakeAddress;

public abstract class Address
implements Product,
Enum {
    public static Address fromBech32(String string) {
        return Address$.MODULE$.fromBech32(string);
    }

    public static Address fromByteString(ByteString byteString) {
        return Address$.MODULE$.fromByteString(byteString);
    }

    public static Address fromBytes(byte[] byArray) {
        return Address$.MODULE$.fromBytes(byArray);
    }

    public static Address fromOrdinal(int n) {
        return Address$.MODULE$.fromOrdinal(n);
    }

    public static Address fromString(String string) {
        return Address$.MODULE$.fromString(string);
    }

    public static Try<StakeAddress> shelleyToStake(ShelleyAddress shelleyAddress) {
        return Address$.MODULE$.shelleyToStake(shelleyAddress);
    }

    public Option<Network> network() {
        Address address = this;
        if (address instanceof Byron) {
            Byron byron = Address$Byron$.MODULE$.unapply((Byron)address);
            ByronAddress byronAddress = byron._1();
            return None$.MODULE$;
        }
        if (address instanceof Shelley) {
            ShelleyAddress shelleyAddress;
            Shelley shelley = Address$Shelley$.MODULE$.unapply((Shelley)address);
            ShelleyAddress addr = shelleyAddress = shelley._1();
            return Some$.MODULE$.apply((Object)addr.network());
        }
        if (address instanceof Stake) {
            StakeAddress stakeAddress;
            Stake stake = Address$Stake$.MODULE$.unapply((Stake)address);
            StakeAddress addr = stakeAddress = stake._1();
            return Some$.MODULE$.apply((Object)addr.network());
        }
        throw new MatchError((Object)address);
    }

    public byte typeId() {
        Address address = this;
        if (address instanceof Byron) {
            ByronAddress byronAddress;
            Byron byron = Address$Byron$.MODULE$.unapply((Byron)address);
            ByronAddress addr = byronAddress = byron._1();
            return addr.typeId();
        }
        if (address instanceof Shelley) {
            ShelleyAddress shelleyAddress;
            Shelley shelley = Address$Shelley$.MODULE$.unapply((Shelley)address);
            ShelleyAddress addr = shelleyAddress = shelley._1();
            return addr.typeId();
        }
        if (address instanceof Stake) {
            StakeAddress stakeAddress;
            Stake stake = Address$Stake$.MODULE$.unapply((Stake)address);
            StakeAddress addr = stakeAddress = stake._1();
            return addr.typeId();
        }
        throw new MatchError((Object)address);
    }

    public Try<String> hrp() {
        Address address = this;
        if (address instanceof Byron) {
            Byron byron = Address$Byron$.MODULE$.unapply((Byron)address);
            ByronAddress byronAddress = byron._1();
            return Failure$.MODULE$.apply((Throwable)new UnsupportedOperationException("Byron addresses don't use bech32"));
        }
        if (address instanceof Shelley) {
            ShelleyAddress shelleyAddress;
            Shelley shelley = Address$Shelley$.MODULE$.unapply((Shelley)address);
            ShelleyAddress addr = shelleyAddress = shelley._1();
            return addr.hrp();
        }
        if (address instanceof Stake) {
            StakeAddress stakeAddress;
            Stake stake = Address$Stake$.MODULE$.unapply((Stake)address);
            StakeAddress addr = stakeAddress = stake._1();
            return addr.hrp();
        }
        throw new MatchError((Object)address);
    }

    public boolean hasScript() {
        Address address = this;
        if (address instanceof Byron) {
            Byron byron = Address$Byron$.MODULE$.unapply((Byron)address);
            ByronAddress byronAddress = byron._1();
            return false;
        }
        if (address instanceof Shelley) {
            ShelleyAddress shelleyAddress;
            Shelley shelley = Address$Shelley$.MODULE$.unapply((Shelley)address);
            ShelleyAddress addr = shelleyAddress = shelley._1();
            return addr.hasScript();
        }
        if (address instanceof Stake) {
            StakeAddress stakeAddress;
            Stake stake = Address$Stake$.MODULE$.unapply((Stake)address);
            StakeAddress addr = stakeAddress = stake._1();
            return addr.isScript();
        }
        throw new MatchError((Object)address);
    }

    public boolean isEnterprise() {
        Address address = this;
        if (address instanceof Shelley) {
            ShelleyAddress shelleyAddress;
            Shelley shelley = Address$Shelley$.MODULE$.unapply((Shelley)address);
            ShelleyAddress addr = shelleyAddress = shelley._1();
            return addr.isEnterprise();
        }
        return false;
    }

    public ByteString toBytes() {
        Address address = this;
        if (address instanceof Byron) {
            ByronAddress byronAddress;
            Byron byron = Address$Byron$.MODULE$.unapply((Byron)address);
            ByronAddress addr = byronAddress = byron._1();
            return addr.toBytes();
        }
        if (address instanceof Shelley) {
            ShelleyAddress shelleyAddress;
            Shelley shelley = Address$Shelley$.MODULE$.unapply((Shelley)address);
            ShelleyAddress addr = shelleyAddress = shelley._1();
            return addr.toBytes();
        }
        if (address instanceof Stake) {
            StakeAddress stakeAddress;
            Stake stake = Address$Stake$.MODULE$.unapply((Stake)address);
            StakeAddress addr = stakeAddress = stake._1();
            return addr.toBytes();
        }
        throw new MatchError((Object)address);
    }

    public String toHex() {
        Address address = this;
        if (address instanceof Byron) {
            ByronAddress byronAddress;
            Byron byron = Address$Byron$.MODULE$.unapply((Byron)address);
            ByronAddress addr = byronAddress = byron._1();
            return addr.toHex();
        }
        if (address instanceof Shelley) {
            ShelleyAddress shelleyAddress;
            Shelley shelley = Address$Shelley$.MODULE$.unapply((Shelley)address);
            ShelleyAddress addr = shelleyAddress = shelley._1();
            return addr.toHex();
        }
        if (address instanceof Stake) {
            StakeAddress stakeAddress;
            Stake stake = Address$Stake$.MODULE$.unapply((Stake)address);
            StakeAddress addr = stakeAddress = stake._1();
            return addr.toHex();
        }
        throw new MatchError((Object)address);
    }

    public Try<String> encode() {
        Address address = this;
        if (address instanceof Byron) {
            ByronAddress byronAddress;
            Byron byron = Address$Byron$.MODULE$.unapply((Byron)address);
            ByronAddress addr = byronAddress = byron._1();
            return Try$.MODULE$.apply(() -> Address.encode$$anonfun$1(addr));
        }
        if (address instanceof Shelley) {
            ShelleyAddress shelleyAddress;
            Shelley shelley = Address$Shelley$.MODULE$.unapply((Shelley)address);
            ShelleyAddress addr = shelleyAddress = shelley._1();
            return addr.toBech32();
        }
        if (address instanceof Stake) {
            StakeAddress stakeAddress;
            Stake stake = Address$Stake$.MODULE$.unapply((Stake)address);
            StakeAddress addr = stakeAddress = stake._1();
            return addr.toBech32();
        }
        throw new MatchError((Object)address);
    }

    private static final String encode$$anonfun$1(ByronAddress addr$1) {
        return addr$1.toBase58();
    }

    public static final class Byron
    extends Address {
        private final ByronAddress address;

        public static Byron apply(ByronAddress byronAddress) {
            return Address$Byron$.MODULE$.apply(byronAddress);
        }

        public static Byron fromProduct(Product product) {
            return Address$Byron$.MODULE$.fromProduct(product);
        }

        public static Byron unapply(Byron byron) {
            return Address$Byron$.MODULE$.unapply(byron);
        }

        public Byron() {
            this.address = address;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Byron)) return false;
            Byron byron = (Byron)object;
            ByronAddress byronAddress = this.address();
            ByronAddress byronAddress2 = byron.address();
            if (byronAddress != null) {
                if (!((Object)byronAddress).equals(byronAddress2)) return false;
                return true;
            }
            if (byronAddress2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Byron;
        }

        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Byron";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "address";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ByronAddress address() {
            return this.address;
        }

        public Byron copy(ByronAddress address) {
            return new Byron();
        }

        public ByronAddress copy$default$1() {
            return this.address();
        }

        public int ordinal() {
            return 0;
        }

        public ByronAddress _1() {
            return this.address();
        }
    }

    public static final class Shelley
    extends Address {
        private final ShelleyAddress address;

        public static Shelley apply(ShelleyAddress shelleyAddress) {
            return Address$Shelley$.MODULE$.apply(shelleyAddress);
        }

        public static Shelley fromProduct(Product product) {
            return Address$Shelley$.MODULE$.fromProduct(product);
        }

        public static Shelley unapply(Shelley shelley) {
            return Address$Shelley$.MODULE$.unapply(shelley);
        }

        public Shelley() {
            this.address = address;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Shelley)) return false;
            Shelley shelley = (Shelley)object;
            ShelleyAddress shelleyAddress = this.address();
            ShelleyAddress shelleyAddress2 = shelley.address();
            if (shelleyAddress != null) {
                if (!((Object)shelleyAddress).equals(shelleyAddress2)) return false;
                return true;
            }
            if (shelleyAddress2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Shelley;
        }

        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Shelley";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "address";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ShelleyAddress address() {
            return this.address;
        }

        public Shelley copy(ShelleyAddress address) {
            return new Shelley();
        }

        public ShelleyAddress copy$default$1() {
            return this.address();
        }

        public int ordinal() {
            return 1;
        }

        public ShelleyAddress _1() {
            return this.address();
        }
    }

    public static final class Stake
    extends Address {
        private final StakeAddress address;

        public static Stake apply(StakeAddress stakeAddress) {
            return Address$Stake$.MODULE$.apply(stakeAddress);
        }

        public static Stake fromProduct(Product product) {
            return Address$Stake$.MODULE$.fromProduct(product);
        }

        public static Stake unapply(Stake stake) {
            return Address$Stake$.MODULE$.unapply(stake);
        }

        public Stake() {
            this.address = address;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Stake)) return false;
            Stake stake = (Stake)object;
            StakeAddress stakeAddress = this.address();
            StakeAddress stakeAddress2 = stake.address();
            if (stakeAddress != null) {
                if (!((Object)stakeAddress).equals(stakeAddress2)) return false;
                return true;
            }
            if (stakeAddress2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Stake;
        }

        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Stake";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "address";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public StakeAddress address() {
            return this.address;
        }

        public Stake copy(StakeAddress address) {
            return new Stake();
        }

        public StakeAddress copy$default$1() {
            return this.address();
        }

        public int ordinal() {
            return 2;
        }

        public StakeAddress _1() {
            return this.address();
        }
    }
}

