/*
 * Decompiled with CFR 0.152.
 */
package scalus.cardano.ledger;

import io.bullet.borer.Codec;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scalus.builtin.ByteString;
import scalus.cardano.ledger.AuxiliaryData;
import scalus.cardano.ledger.Block$;
import scalus.cardano.ledger.BlockHeader;
import scalus.cardano.ledger.Transaction;
import scalus.cardano.ledger.Transaction$;
import scalus.cardano.ledger.TransactionBody;
import scalus.cardano.ledger.TransactionWitnessSet;

public class Block
implements Product,
Serializable {
    private final BlockHeader header;
    private final Seq transactionBodies;
    private final Seq transactionWitnessSets;
    private final Map auxiliaryDataSet;
    private final Seq invalidTransactions;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Block$.class.getDeclaredField("derived$Codec$lzy1"));

    public static Block apply(BlockHeader blockHeader, Seq<TransactionBody> seq, Seq<TransactionWitnessSet> seq2, Map<Object, AuxiliaryData> map, Seq<Object> seq3) {
        return Block$.MODULE$.apply(blockHeader, seq, seq2, map, seq3);
    }

    public static Codec<Block> derived$Codec() {
        return Block$.MODULE$.derived$Codec();
    }

    public static Block fromProduct(Product product) {
        return Block$.MODULE$.fromProduct(product);
    }

    public static Block unapply(Block block) {
        return Block$.MODULE$.unapply(block);
    }

    public Block(BlockHeader header, Seq<TransactionBody> transactionBodies, Seq<TransactionWitnessSet> transactionWitnessSets, Map<Object, AuxiliaryData> auxiliaryDataSet, Seq<Object> invalidTransactions) {
        this.header = header;
        this.transactionBodies = transactionBodies;
        this.transactionWitnessSets = transactionWitnessSets;
        this.auxiliaryDataSet = auxiliaryDataSet;
        this.invalidTransactions = invalidTransactions;
        Predef$.MODULE$.require(transactionBodies.size() == transactionWitnessSets.size(), () -> Block.$init$$$anonfun$1(transactionBodies, transactionWitnessSets));
        Predef$.MODULE$.require(auxiliaryDataSet.keys().forall((Function1)(JFunction1.mcZI.sp & Serializable)idx -> idx >= 0 && idx < transactionBodies.size()), Block::$init$$$anonfun$3);
        Predef$.MODULE$.require(invalidTransactions.forall((Function1)(JFunction1.mcZI.sp & Serializable)idx -> idx >= 0 && idx < transactionBodies.size()), Block::$init$$$anonfun$5);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Block)) return false;
        Block block = (Block)object;
        BlockHeader blockHeader = this.header();
        BlockHeader blockHeader2 = block.header();
        if (blockHeader == null) {
            if (blockHeader2 != null) {
                return false;
            }
        } else if (!((Object)blockHeader).equals(blockHeader2)) return false;
        Seq<TransactionBody> seq = this.transactionBodies();
        Seq<TransactionBody> seq2 = block.transactionBodies();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Seq<TransactionWitnessSet> seq3 = this.transactionWitnessSets();
        Seq<TransactionWitnessSet> seq4 = block.transactionWitnessSets();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        Map<Object, AuxiliaryData> map = this.auxiliaryDataSet();
        Map<Object, AuxiliaryData> map2 = block.auxiliaryDataSet();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Seq<Object> seq5 = this.invalidTransactions();
        Seq<Object> seq6 = block.invalidTransactions();
        if (seq5 == null) {
            if (seq6 != null) {
                return false;
            }
        } else if (!seq5.equals(seq6)) return false;
        if (!block.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Block;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "Block";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "header";
            }
            case 1: {
                return "transactionBodies";
            }
            case 2: {
                return "transactionWitnessSets";
            }
            case 3: {
                return "auxiliaryDataSet";
            }
            case 4: {
                return "invalidTransactions";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public BlockHeader header() {
        return this.header;
    }

    public Seq<TransactionBody> transactionBodies() {
        return this.transactionBodies;
    }

    public Seq<TransactionWitnessSet> transactionWitnessSets() {
        return this.transactionWitnessSets;
    }

    public Map<Object, AuxiliaryData> auxiliaryDataSet() {
        return this.auxiliaryDataSet;
    }

    public Seq<Object> invalidTransactions() {
        return this.invalidTransactions;
    }

    public long blockNumber() {
        return this.header().blockNumber();
    }

    public long slot() {
        return this.header().slot();
    }

    public ByteString hash() {
        return this.header().headerBody().blockBodyHash();
    }

    public int txCount() {
        return this.transactionBodies().size();
    }

    public int invalidTxCount() {
        return this.invalidTransactions().size();
    }

    public int validTxCount() {
        return this.txCount() - this.invalidTxCount();
    }

    public boolean isEmpty() {
        return this.transactionBodies().isEmpty();
    }

    public Seq<Transaction> transactions() {
        return (Seq)((IterableOps)this.transactionBodies().zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                TransactionBody body = (TransactionBody)tuple2._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                TransactionWitnessSet witnessSet = (TransactionWitnessSet)this.transactionWitnessSets().apply(idx);
                Option auxData = this.auxiliaryDataSet().get((Object)BoxesRunTime.boxToInteger((int)idx));
                boolean isValid = !this.invalidTransactions().contains((Object)BoxesRunTime.boxToInteger((int)idx));
                return Transaction$.MODULE$.apply(body, witnessSet, isValid, (Option<AuxiliaryData>)auxData);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Block copy(BlockHeader header, Seq<TransactionBody> transactionBodies, Seq<TransactionWitnessSet> transactionWitnessSets, Map<Object, AuxiliaryData> auxiliaryDataSet, Seq<Object> invalidTransactions) {
        return new Block(header, transactionBodies, transactionWitnessSets, auxiliaryDataSet, invalidTransactions);
    }

    public BlockHeader copy$default$1() {
        return this.header();
    }

    public Seq<TransactionBody> copy$default$2() {
        return this.transactionBodies();
    }

    public Seq<TransactionWitnessSet> copy$default$3() {
        return this.transactionWitnessSets();
    }

    public Map<Object, AuxiliaryData> copy$default$4() {
        return this.auxiliaryDataSet();
    }

    public Seq<Object> copy$default$5() {
        return this.invalidTransactions();
    }

    public BlockHeader _1() {
        return this.header();
    }

    public Seq<TransactionBody> _2() {
        return this.transactionBodies();
    }

    public Seq<TransactionWitnessSet> _3() {
        return this.transactionWitnessSets();
    }

    public Map<Object, AuxiliaryData> _4() {
        return this.auxiliaryDataSet();
    }

    public Seq<Object> _5() {
        return this.invalidTransactions();
    }

    private static final Object $init$$$anonfun$1(Seq transactionBodies$1, Seq transactionWitnessSets$1) {
        return new StringBuilder(68).append("Number of transaction bodies (").append(transactionBodies$1.size()).append(") must match number of witness sets (").append(transactionWitnessSets$1.size()).append(")").toString();
    }

    private static final Object $init$$$anonfun$3() {
        return "Transaction index in auxiliary data set must be valid";
    }

    private static final Object $init$$$anonfun$5() {
        return "Invalid transaction index must be valid";
    }
}

