/*
 * Decompiled with CFR 0.152.
 */
package scalus.uplc.eval;

import scala.;
import scala.$less$colon$less$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scalus.builtin.PlatformSpecific;
import scalus.ledger.api.BuiltinSemanticsVariant;
import scalus.ledger.api.PlutusLedgerLanguage;
import scalus.ledger.api.PlutusLedgerLanguage$;
import scalus.uplc.BuiltinsMeaning;
import scalus.uplc.Constant;
import scalus.uplc.Constant$Unit$;
import scalus.uplc.DeBruijn$;
import scalus.uplc.DeBruijnedProgram;
import scalus.uplc.Term;
import scalus.uplc.Term$Const$;
import scalus.uplc.eval.BudgetSpender;
import scalus.uplc.eval.CekMachine;
import scalus.uplc.eval.CountingBudgetSpender;
import scalus.uplc.eval.ExBudget;
import scalus.uplc.eval.ExBudgetCategory;
import scalus.uplc.eval.InvalidReturnValue;
import scalus.uplc.eval.Logger;
import scalus.uplc.eval.MachineParams;
import scalus.uplc.eval.NoBudgetSpender$;
import scalus.uplc.eval.NoLogger$;
import scalus.uplc.eval.PlutusVM$;
import scalus.uplc.eval.Result;
import scalus.uplc.eval.Result$Failure$;
import scalus.uplc.eval.Result$Success$;
import scalus.uplc.eval.TallyingBudgetSpenderLogger;

public class PlutusVM {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(PlutusVM.class.getDeclaredField("builtins$lzy1"));
    private final PlutusLedgerLanguage language;
    private final MachineParams machineParams;
    private final BuiltinSemanticsVariant semanticVariant;
    private PlatformSpecific platformSpecific;
    private volatile Object builtins$lzy1;

    public static PlutusVM makePlutusV1VM(MachineParams machineParams, PlatformSpecific platformSpecific) {
        return PlutusVM$.MODULE$.makePlutusV1VM(machineParams, platformSpecific);
    }

    public static PlutusVM makePlutusV2VM(MachineParams machineParams, PlatformSpecific platformSpecific) {
        return PlutusVM$.MODULE$.makePlutusV2VM(machineParams, platformSpecific);
    }

    public static PlutusVM makePlutusV3VM(MachineParams machineParams, PlatformSpecific platformSpecific) {
        return PlutusVM$.MODULE$.makePlutusV3VM(machineParams, platformSpecific);
    }

    public static MachineParams makePlutusV1VM$default$1() {
        return PlutusVM$.MODULE$.makePlutusV1VM$default$1();
    }

    public static MachineParams makePlutusV2VM$default$1() {
        return PlutusVM$.MODULE$.makePlutusV2VM$default$1();
    }

    public static MachineParams makePlutusV3VM$default$1() {
        return PlutusVM$.MODULE$.makePlutusV3VM$default$1();
    }

    public PlutusVM(PlutusLedgerLanguage language, MachineParams machineParams, BuiltinSemanticsVariant semanticVariant, PlatformSpecific platformSpecific) {
        this.language = language;
        this.machineParams = machineParams;
        this.semanticVariant = semanticVariant;
        this.platformSpecific = platformSpecific;
    }

    public PlutusLedgerLanguage language() {
        return this.language;
    }

    public MachineParams machineParams() {
        return this.machineParams;
    }

    public BuiltinSemanticsVariant semanticVariant() {
        return this.semanticVariant;
    }

    private BuiltinsMeaning builtins() {
        Object object = this.builtins$lzy1;
        if (object instanceof BuiltinsMeaning) {
            return (BuiltinsMeaning)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (BuiltinsMeaning)this.builtins$lzyINIT1();
    }

    private Object builtins$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.builtins$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    BuiltinsMeaning builtinsMeaning = null;
                    try {
                        builtinsMeaning = new BuiltinsMeaning(this.machineParams().builtinCostModel(), this.platformSpecific, this.semanticVariant());
                        object2 = builtinsMeaning == null ? LazyVals.NullValue$.MODULE$ : builtinsMeaning;
                        this.platformSpecific = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.builtins$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return builtinsMeaning;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Term evaluateScript(DeBruijnedProgram program, BudgetSpender budgetSpender, Logger logger) {
        Term result = this.evaluateDeBruijnedTerm(program.term(), budgetSpender, logger);
        if (this.isResultValid(result)) {
            return result;
        }
        throw new InvalidReturnValue(result);
    }

    public Result evaluateScriptDebug(DeBruijnedProgram program) {
        Result result;
        TallyingBudgetSpenderLogger spenderLogger = new TallyingBudgetSpenderLogger(new CountingBudgetSpender());
        try {
            Term result2 = this.evaluateScript(program, spenderLogger, spenderLogger);
            result = Result$Success$.MODULE$.apply(result2, spenderLogger.getSpentBudget(), (Map<ExBudgetCategory, Seq<ExBudget>>)spenderLogger.costs().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), spenderLogger.getLogsWithBudget());
        }
        catch (Exception e) {
            result = Result$Failure$.MODULE$.apply(e, spenderLogger.getSpentBudget(), (Map<ExBudgetCategory, Seq<ExBudget>>)spenderLogger.costs().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), spenderLogger.getLogsWithBudget());
        }
        return result;
    }

    public Term evaluateDeBruijnedTerm(Term debruijnedTerm, BudgetSpender budgetSpender, Logger logger) {
        CekMachine cek = new CekMachine(this.machineParams(), budgetSpender, logger, this.builtins());
        return DeBruijn$.MODULE$.fromDeBruijnTerm(cek.evaluateTerm(debruijnedTerm));
    }

    public BudgetSpender evaluateDeBruijnedTerm$default$2() {
        return NoBudgetSpender$.MODULE$;
    }

    public Logger evaluateDeBruijnedTerm$default$3() {
        return NoLogger$.MODULE$;
    }

    private boolean isResultValid(Term res) {
        block5: {
            Term term;
            PlutusLedgerLanguage plutusLedgerLanguage;
            block10: {
                block7: {
                    PlutusLedgerLanguage plutusLedgerLanguage2;
                    PlutusLedgerLanguage plutusLedgerLanguage3;
                    block9: {
                        block8: {
                            PlutusLedgerLanguage plutusLedgerLanguage4;
                            PlutusLedgerLanguage plutusLedgerLanguage5;
                            block6: {
                                Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)this.language(), (Object)res);
                                if (tuple2 == null) break block5;
                                plutusLedgerLanguage = (PlutusLedgerLanguage)((Object)tuple2._1());
                                term = (Term)tuple2._2();
                                plutusLedgerLanguage5 = PlutusLedgerLanguage$.PlutusV1;
                                plutusLedgerLanguage4 = plutusLedgerLanguage;
                                if (plutusLedgerLanguage5 != null) break block6;
                                if (plutusLedgerLanguage4 == null) break block7;
                                break block8;
                            }
                            if (((Object)((Object)plutusLedgerLanguage5)).equals((Object)plutusLedgerLanguage4)) break block7;
                        }
                        plutusLedgerLanguage3 = PlutusLedgerLanguage$.PlutusV2;
                        plutusLedgerLanguage2 = plutusLedgerLanguage;
                        if (plutusLedgerLanguage3 != null) break block9;
                        if (plutusLedgerLanguage2 == null) break block7;
                        break block10;
                    }
                    if (!((Object)((Object)plutusLedgerLanguage3)).equals((Object)plutusLedgerLanguage2)) break block10;
                }
                return true;
            }
            PlutusLedgerLanguage plutusLedgerLanguage6 = PlutusLedgerLanguage$.PlutusV3;
            PlutusLedgerLanguage plutusLedgerLanguage7 = plutusLedgerLanguage;
            if (!(plutusLedgerLanguage6 != null ? !((Object)((Object)plutusLedgerLanguage6)).equals((Object)plutusLedgerLanguage7) : plutusLedgerLanguage7 != null)) {
                Term.Const const_;
                Constant constant;
                if (term instanceof Term.Const && Constant$Unit$.MODULE$.equals(constant = (const_ = Term$Const$.MODULE$.unapply((Term.Const)term))._1())) {
                    return true;
                }
            }
        }
        return false;
    }
}

