/*
 * Decompiled with CFR 0.152.
 */
package scalus.utils;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scalus.ledger.api.PlutusLedgerLanguage;
import scalus.ledger.api.PlutusLedgerLanguage$;
import scalus.uplc.DeBruijnedProgram;
import scalus.uplc.Program;
import scalus.uplc.Program$;
import scalus.utils.Hex$;
import scalus.utils.PlutusTextEnvelope;
import scalus.utils.PlutusTextEnvelope$;
import ujson.Readable;
import ujson.Readable$;
import upickle.default$;

public final class Utils$
implements Serializable {
    public static final Utils$ MODULE$ = new Utils$();

    private Utils$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Utils$.class);
    }

    public final String bytesToHex(byte[] bytes) {
        return Hex$.MODULE$.bytesToHex(bytes);
    }

    public final byte[] hexToBytes(String hex) {
        return Hex$.MODULE$.hexToBytes(hex);
    }

    public String lowerFirst(String s) {
        if (s == null || s.length() == 0 || !RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(s.charAt(0)))) {
            return s;
        }
        return StringOps$.MODULE$.updated$extension(Predef$.MODULE$.augmentString(s), 0, RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(s.charAt(0))));
    }

    public byte[] sha2_256(byte[] bytes) {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        digest.update(bytes);
        return digest.digest();
    }

    public void writePlutusFile(String path, Program program, PlutusLedgerLanguage plutusVersion) {
        this.writePlutusFile(path, program.deBruijnedProgram(), plutusVersion);
    }

    public void writePlutusFile(String path, DeBruijnedProgram program, PlutusLedgerLanguage plutusVersion) {
        String content = this.programToPlutusFileContent(program, plutusVersion);
        Files.write(Paths.get(path, new String[0]), content.getBytes("UTF-8"), new OpenOption[0]);
    }

    public String programToPlutusFileContent(Program program, PlutusLedgerLanguage plutusVersion) {
        return this.programToPlutusFileContent(program.deBruijnedProgram(), plutusVersion);
    }

    public String programToPlutusFileContent(DeBruijnedProgram program, PlutusLedgerLanguage plutusVersion) {
        String string;
        PlutusLedgerLanguage plutusLedgerLanguage = plutusVersion;
        PlutusLedgerLanguage plutusLedgerLanguage2 = PlutusLedgerLanguage$.PlutusV1;
        PlutusLedgerLanguage plutusLedgerLanguage3 = plutusLedgerLanguage;
        if (!(plutusLedgerLanguage2 != null ? !((Object)((Object)plutusLedgerLanguage2)).equals((Object)plutusLedgerLanguage3) : plutusLedgerLanguage3 != null)) {
            string = "PlutusScriptV1";
        } else {
            PlutusLedgerLanguage plutusLedgerLanguage4 = PlutusLedgerLanguage$.PlutusV2;
            PlutusLedgerLanguage plutusLedgerLanguage5 = plutusLedgerLanguage;
            if (!(plutusLedgerLanguage4 != null ? !((Object)((Object)plutusLedgerLanguage4)).equals((Object)plutusLedgerLanguage5) : plutusLedgerLanguage5 != null)) {
                string = "PlutusScriptV2";
            } else {
                PlutusLedgerLanguage plutusLedgerLanguage6 = PlutusLedgerLanguage$.PlutusV3;
                PlutusLedgerLanguage plutusLedgerLanguage7 = plutusLedgerLanguage;
                if (!(plutusLedgerLanguage6 != null ? !((Object)((Object)plutusLedgerLanguage6)).equals((Object)plutusLedgerLanguage7) : plutusLedgerLanguage7 != null)) {
                    string = "PlutusScriptV3";
                } else {
                    throw new MatchError((Object)plutusLedgerLanguage);
                }
            }
        }
        String type = string;
        return default$.MODULE$.write((Object)PlutusTextEnvelope$.MODULE$.apply(type, "", program.doubleCborHex()), default$.MODULE$.write$default$2(), default$.MODULE$.write$default$3(), default$.MODULE$.write$default$4(), PlutusTextEnvelope$.MODULE$.derived$ReadWriter());
    }

    public Program readPlutusFileContent(String content) {
        PlutusTextEnvelope envelope = (PlutusTextEnvelope)default$.MODULE$.read((Readable)Readable$.MODULE$.fromString(content), default$.MODULE$.read$default$2(), PlutusTextEnvelope$.MODULE$.derived$ReadWriter());
        String doubleCborHex = envelope.cborHex();
        return Program$.MODULE$.fromDoubleCborHex(doubleCborHex);
    }

    public Program readPlutusFile(String path) {
        String content = new String(Files.readAllBytes(Paths.get(path, new String[0])), "UTF-8");
        return this.readPlutusFileContent(content);
    }
}

