/*
 * Decompiled with CFR 0.152.
 */
package scalus.cardano.ledger;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scalus.cardano.ledger.Bech32;
import scalus.cardano.ledger.Bech32$Bech32Decoded$;

public final class Bech32$
implements Serializable {
    public static final Bech32$Bech32Decoded$ Bech32Decoded;
    private static final Map<Object, Object> CHARSET_MAP;
    private static final Map<Object, Object> CHARSET_REVERSE_MAP;
    private static final int[] GENERATOR;
    public static final Bech32$ MODULE$;

    private Bech32$() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        MODULE$ = new Bech32$();
        String CHARSET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
        Map m = Predef$.MODULE$.Map().empty();
        for (int i = 0; i < "qpzry9x8gf2tvdw0s3jn54khce6mua7l".length(); ++i) {
            Character c = (Character)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)"qpzry9x8gf2tvdw0s3jn54khce6mua7l".charAt(i)));
            m = (Map)m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)c, (Object)BoxesRunTime.boxToByte((byte)((byte)i))));
        }
        CHARSET_MAP = var1_1;
        Map m2 = Predef$.MODULE$.Map().empty();
        for (Tuple2 tuple2 : CHARSET_MAP) {
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            char c = BoxesRunTime.unboxToChar((Object)tuple2._1());
            byte b = BoxesRunTime.unboxToByte((Object)tuple2._2());
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)c), (Object)BoxesRunTime.boxToByte((byte)b));
            char c2 = BoxesRunTime.unboxToChar((Object)tuple22._1());
            byte b2 = BoxesRunTime.unboxToByte((Object)tuple22._2());
            Byte by = (Byte)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToByte((byte)b2));
            m2 = (Map)m2.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)by, (Object)BoxesRunTime.boxToCharacter((char)c2)));
        }
        CHARSET_REVERSE_MAP = m2;
        GENERATOR = new int[]{996825010, 642813549, 513874426, 1027748829, 705979059};
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Bech32$.class);
    }

    public final char SEP() {
        return '1';
    }

    public final int polymod(byte[] values) {
        int chk = 1;
        for (int idx = 0; idx < values.length; ++idx) {
            byte v = values[idx];
            int b = chk >>> 25;
            chk = (chk & 0x1FFFFFF) << 5 ^ v;
            for (int i = 0; i < 5; ++i) {
                if ((b >>> i & 1) == 0) continue;
                chk ^= GENERATOR[i];
            }
        }
        return chk;
    }

    public final byte[] hrpExpand(String s) {
        int i;
        byte[] result = new byte[s.length() * 2 + 1];
        for (i = 0; i < s.length(); ++i) {
            result[i] = (byte)(s.charAt(i) >>> 5);
        }
        result[i] = (byte)0;
        ++i;
        for (int j = 0; j < s.length(); ++j) {
            result[i + j] = (byte)(s.charAt(j) & 0x1F);
        }
        return result;
    }

    public final boolean verifyCheckSum(String hrp, byte[] data) {
        byte[] expanded = this.hrpExpand(hrp);
        byte[] combined = new byte[expanded.length + data.length];
        System.arraycopy(expanded, 0, combined, 0, expanded.length);
        System.arraycopy(data, 0, combined, expanded.length, data.length);
        return this.polymod(combined) == 1;
    }

    public final byte[] createChecksum(String hrp, byte[] data) {
        int i;
        byte[] expanded = this.hrpExpand(hrp);
        byte[] values = new byte[expanded.length + data.length + 6];
        System.arraycopy(expanded, 0, values, 0, expanded.length);
        System.arraycopy(data, 0, values, expanded.length, data.length);
        for (i = 0; i < 6; ++i) {
            values[expanded.length + data.length + i] = (byte)0;
        }
        int poly = this.polymod(values) ^ 1;
        byte[] result = new byte[6];
        for (i = 0; i < 6; ++i) {
            result[i] = (byte)(poly >>> 5 * (5 - i) & 0x1F);
        }
        return result;
    }

    public final Bech32.Bech32Decoded decode(String bech32) {
        Tuple2<String, byte[]> tuple2 = this.decodeTo5Bit(bech32);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String hrp = (String)tuple2._1();
        byte[] data5 = (byte[])tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)hrp, (Object)data5);
        String hrp2 = (String)tuple22._1();
        byte[] data52 = (byte[])tuple22._2();
        return Bech32$Bech32Decoded$.MODULE$.apply(hrp2, this.from5Bit(data52));
    }

    public final Tuple2<String, byte[]> decodeTo5Bit(String bech32) {
        int sepPosition = bech32.lastIndexOf(49);
        Predef$.MODULE$.require(sepPosition != -1, Bech32$::decodeTo5Bit$$anonfun$1);
        String dataPart = bech32.substring(sepPosition + 1);
        Predef$.MODULE$.require(StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(dataPart), (Function1 & Serializable)c -> Bech32$.decodeTo5Bit$$anonfun$2(BoxesRunTime.unboxToChar((Object)c))) || StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(dataPart), (Function1 & Serializable)c -> Bech32$.decodeTo5Bit$$anonfun$3(BoxesRunTime.unboxToChar((Object)c))), Bech32$::decodeTo5Bit$$anonfun$4);
        String input = bech32.toLowerCase();
        String hrp = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(input), sepPosition);
        byte[] data = new byte[input.length() - sepPosition - 1];
        for (int i = 0; i < data.length; ++i) {
            char c2 = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(input), sepPosition + 1 + i);
            data[i] = BoxesRunTime.unboxToByte((Object)CHARSET_MAP.getOrElse((Object)BoxesRunTime.boxToCharacter((char)c2), () -> Bech32$.decodeTo5Bit$$anonfun$5(c2)));
        }
        Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(hrp)), Bech32$::decodeTo5Bit$$anonfun$6);
        Predef$.MODULE$.require(data.length >= 6, Bech32$::decodeTo5Bit$$anonfun$7);
        Predef$.MODULE$.require(this.verifyCheckSum(hrp, data), Bech32$::decodeTo5Bit$$anonfun$8);
        byte[] dataWithoutChecksum = new byte[data.length - 6];
        System.arraycopy(data, 0, dataWithoutChecksum, 0, data.length - 6);
        return Tuple2$.MODULE$.apply((Object)hrp, (Object)dataWithoutChecksum);
    }

    public final String encode(String hrp, byte[] data) {
        return this.encodeFrom5Bit(hrp, this.to5Bit(data));
    }

    public final String encodeFrom5Bit(String hrp, byte[] data) {
        Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(hrp)), Bech32$::encodeFrom5Bit$$anonfun$1);
        byte[] checksum = this.createChecksum(hrp, data);
        byte[] combined = new byte[data.length + checksum.length];
        System.arraycopy(data, 0, combined, 0, data.length);
        System.arraycopy(checksum, 0, combined, data.length, checksum.length);
        StringBuilder sb = new StringBuilder(hrp.length() + 1 + combined.length);
        sb.append(hrp).append('1');
        for (int i = 0; i < combined.length; ++i) {
            char c = BoxesRunTime.unboxToChar((Object)CHARSET_REVERSE_MAP.getOrElse((Object)BoxesRunTime.boxToByte((byte)combined[i]), Bech32$::$anonfun$1));
            sb.append(c);
        }
        return sb.toString();
    }

    public final byte[] to5Bit(byte[] input) {
        int outputSize = (input.length * 8 + 4) / 5;
        byte[] result = new byte[outputSize];
        long buffer = 0L;
        int count = 0;
        int outputIndex = 0;
        for (int i = 0; i < input.length; ++i) {
            buffer = buffer << 8 | (long)(input[i] & 0xFF);
            count += 8;
            while (count >= 5) {
                result[outputIndex] = (byte)(buffer >> count - 5 & 0x1FL);
                count -= 5;
                ++outputIndex;
            }
        }
        if (count > 0) {
            result[outputIndex] = (byte)(buffer << 5 - count & 0x1FL);
        }
        return result;
    }

    public final byte[] from5Bit(byte[] input) {
        int outputSize = input.length * 5 / 8;
        byte[] result = new byte[outputSize];
        long buffer = 0L;
        int count = 0;
        int outputIndex = 0;
        for (int i = 0; i < input.length; ++i) {
            buffer = buffer << 5 | (long)(input[i] & 0x1F);
            count += 5;
            while (count >= 8) {
                result[outputIndex] = (byte)(buffer >> count - 8 & 0xFFL);
                count -= 8;
                ++outputIndex;
            }
        }
        Predef$.MODULE$.require(count <= 4, Bech32$::from5Bit$$anonfun$1);
        Predef$.MODULE$.require((buffer & (long)((1 << count) - 1)) == 0L, Bech32$::from5Bit$$anonfun$2);
        return result;
    }

    private static final Object decodeTo5Bit$$anonfun$1() {
        return new java.lang.StringBuilder(48).append("Invalid Bech32: missing separator '").append('1').append("'.").toString();
    }

    private static final /* synthetic */ boolean decodeTo5Bit$$anonfun$2(char c) {
        return RichChar$.MODULE$.isLower$extension(Predef$.MODULE$.charWrapper(c)) || RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(c));
    }

    private static final /* synthetic */ boolean decodeTo5Bit$$anonfun$3(char c) {
        return RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(c)) || RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(c));
    }

    private static final Object decodeTo5Bit$$anonfun$4() {
        return "Invalid Bech32: mixed case in data part.";
    }

    private static final byte decodeTo5Bit$$anonfun$5(char c$1) {
        throw new IllegalArgumentException(new java.lang.StringBuilder(29).append("Invalid character '").append(c$1).append("'. Valid: ").append(StringOps$.MODULE$.mkString$extension(Predef$.MODULE$.augmentString("qpzry9x8gf2tvdw0s3jn54khce6mua7l"), "[", ",", "]")).toString());
    }

    private static final Object decodeTo5Bit$$anonfun$6() {
        return "HRP must not be empty.";
    }

    private static final Object decodeTo5Bit$$anonfun$7() {
        return "Data too short for checksum.";
    }

    private static final Object decodeTo5Bit$$anonfun$8() {
        return "Invalid checksum.";
    }

    private static final Object encodeFrom5Bit$$anonfun$1() {
        return "HRP must not be empty.";
    }

    private static final char $anonfun$1() {
        throw new IllegalArgumentException("Invalid UInt5 value in data.");
    }

    private static final Object from5Bit$$anonfun$1() {
        return "Invalid padding in 5-bit encoding.";
    }

    private static final Object from5Bit$$anonfun$2() {
        return "Non-zero padding bits in 5-bit encoding.";
    }
}

