/*
 * Decompiled with CFR 0.152.
 */
package scalus.cardano.ledger;

import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Set;
import scala.reflect.Enum;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scalus.builtin.ByteString;
import scalus.cardano.ledger.Anchor;
import scalus.cardano.ledger.Certificate$;
import scalus.cardano.ledger.Certificate$AuthCommitteeHotCert$;
import scalus.cardano.ledger.Certificate$PoolRegistration$;
import scalus.cardano.ledger.Certificate$PoolRetirement$;
import scalus.cardano.ledger.Certificate$RegCert$;
import scalus.cardano.ledger.Certificate$RegDRepCert$;
import scalus.cardano.ledger.Certificate$ResignCommitteeColdCert$;
import scalus.cardano.ledger.Certificate$StakeDelegation$;
import scalus.cardano.ledger.Certificate$StakeRegDelegCert$;
import scalus.cardano.ledger.Certificate$StakeVoteDelegCert$;
import scalus.cardano.ledger.Certificate$StakeVoteRegDelegCert$;
import scalus.cardano.ledger.Certificate$UnregCert$;
import scalus.cardano.ledger.Certificate$UnregDRepCert$;
import scalus.cardano.ledger.Certificate$UpdateDRepCert$;
import scalus.cardano.ledger.Certificate$VoteDelegCert$;
import scalus.cardano.ledger.Certificate$VoteRegDelegCert$;
import scalus.cardano.ledger.Coin;
import scalus.cardano.ledger.Credential;
import scalus.cardano.ledger.DRep;
import scalus.cardano.ledger.PoolMetadata;
import scalus.cardano.ledger.Relay;
import scalus.cardano.ledger.RewardAccount;
import scalus.cardano.ledger.UnitInterval;
import scalus.ledger.babbage.ProtocolParams;

public abstract class Certificate
implements Product,
Enum {
    public static Coin conwayDRepRefundsTxCerts(Function1<Credential, Option<Coin>> function1, Iterable<Certificate> iterable) {
        return Certificate$.MODULE$.conwayDRepRefundsTxCerts(function1, iterable);
    }

    public static Certificate fromOrdinal(int n) {
        return Certificate$.MODULE$.fromOrdinal(n);
    }

    public static Coin shelleyTotalRefundsTxCerts(Function1<Credential, Option<Coin>> function1, ProtocolParams protocolParams, Iterable<Certificate> iterable) {
        return Certificate$.MODULE$.shelleyTotalRefundsTxCerts(function1, protocolParams, iterable);
    }

    public Option<Credential> lookupRegStakeTxCert() {
        Certificate certificate = this;
        if (certificate instanceof RegCert) {
            RegCert regCert = Certificate$RegCert$.MODULE$.unapply((RegCert)certificate);
            Credential credential = regCert._1();
            Option<Coin> option = regCert._2();
            Credential c = credential;
            return Some$.MODULE$.apply((Object)c);
        }
        if (certificate instanceof StakeRegDelegCert) {
            StakeRegDelegCert stakeRegDelegCert = Certificate$StakeRegDelegCert$.MODULE$.unapply((StakeRegDelegCert)certificate);
            Credential credential = stakeRegDelegCert._1();
            ByteString byteString = stakeRegDelegCert._2();
            Coin coin = stakeRegDelegCert._3();
            Credential c = credential;
            return Some$.MODULE$.apply((Object)c);
        }
        if (certificate instanceof VoteRegDelegCert) {
            VoteRegDelegCert voteRegDelegCert = Certificate$VoteRegDelegCert$.MODULE$.unapply((VoteRegDelegCert)certificate);
            Credential credential = voteRegDelegCert._1();
            DRep dRep = voteRegDelegCert._2();
            Coin coin = voteRegDelegCert._3();
            Credential c = credential;
            return Some$.MODULE$.apply((Object)c);
        }
        if (certificate instanceof StakeVoteRegDelegCert) {
            StakeVoteRegDelegCert stakeVoteRegDelegCert = Certificate$StakeVoteRegDelegCert$.MODULE$.unapply((StakeVoteRegDelegCert)certificate);
            Credential credential = stakeVoteRegDelegCert._1();
            ByteString byteString = stakeVoteRegDelegCert._2();
            DRep dRep = stakeVoteRegDelegCert._3();
            Coin coin = stakeVoteRegDelegCert._4();
            Credential c = credential;
            return Some$.MODULE$.apply((Object)c);
        }
        return None$.MODULE$;
    }

    public Option<Credential> lookupUnRegStakeTxCert() {
        Certificate certificate = this;
        if (certificate instanceof UnregCert) {
            UnregCert unregCert = Certificate$UnregCert$.MODULE$.unapply((UnregCert)certificate);
            Credential credential = unregCert._1();
            Option<Coin> option = unregCert._2();
            Credential c = credential;
            return Some$.MODULE$.apply((Object)c);
        }
        return None$.MODULE$;
    }

    public static final class AuthCommitteeHotCert
    extends Certificate {
        private final Credential committeeColdCredential;
        private final Credential committeeHotCredential;

        public static AuthCommitteeHotCert apply(Credential credential, Credential credential2) {
            return Certificate$AuthCommitteeHotCert$.MODULE$.apply(credential, credential2);
        }

        public static AuthCommitteeHotCert fromProduct(Product product) {
            return Certificate$AuthCommitteeHotCert$.MODULE$.fromProduct(product);
        }

        public static AuthCommitteeHotCert unapply(AuthCommitteeHotCert authCommitteeHotCert) {
            return Certificate$AuthCommitteeHotCert$.MODULE$.unapply(authCommitteeHotCert);
        }

        public AuthCommitteeHotCert() {
            this.committeeColdCredential = committeeColdCredential;
            this.committeeHotCredential = committeeHotCredential;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AuthCommitteeHotCert)) return false;
            AuthCommitteeHotCert authCommitteeHotCert = (AuthCommitteeHotCert)object;
            Credential credential = this.committeeColdCredential();
            Credential credential2 = authCommitteeHotCert.committeeColdCredential();
            if (credential == null) {
                if (credential2 != null) {
                    return false;
                }
            } else if (!credential.equals(credential2)) return false;
            Credential credential3 = this.committeeHotCredential();
            Credential credential4 = authCommitteeHotCert.committeeHotCredential();
            if (credential3 == null) {
                if (credential4 == null) return true;
                return false;
            } else {
                if (!credential3.equals(credential4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AuthCommitteeHotCert;
        }

        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "AuthCommitteeHotCert";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "committeeColdCredential";
            }
            if (1 == n2) {
                return "committeeHotCredential";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Credential committeeColdCredential() {
            return this.committeeColdCredential;
        }

        public Credential committeeHotCredential() {
            return this.committeeHotCredential;
        }

        public AuthCommitteeHotCert copy(Credential committeeColdCredential, Credential committeeHotCredential) {
            return new AuthCommitteeHotCert();
        }

        public Credential copy$default$1() {
            return this.committeeColdCredential();
        }

        public Credential copy$default$2() {
            return this.committeeHotCredential();
        }

        public int ordinal() {
            return 10;
        }

        public Credential _1() {
            return this.committeeColdCredential();
        }

        public Credential _2() {
            return this.committeeHotCredential();
        }
    }

    public static final class PoolRegistration
    extends Certificate {
        private final ByteString operator;
        private final ByteString vrfKeyHash;
        private final Coin pledge;
        private final Coin cost;
        private final UnitInterval margin;
        private final RewardAccount rewardAccount;
        private final Set poolOwners;
        private final IndexedSeq relays;
        private final Option poolMetadata;

        public static PoolRegistration apply(ByteString byteString, ByteString byteString2, Coin coin, Coin coin2, UnitInterval unitInterval, RewardAccount rewardAccount, Set<ByteString> set, IndexedSeq<Relay> indexedSeq, Option<PoolMetadata> option) {
            return Certificate$PoolRegistration$.MODULE$.apply(byteString, byteString2, coin, coin2, unitInterval, rewardAccount, set, indexedSeq, option);
        }

        public static PoolRegistration fromProduct(Product product) {
            return Certificate$PoolRegistration$.MODULE$.fromProduct(product);
        }

        public static PoolRegistration unapply(PoolRegistration poolRegistration) {
            return Certificate$PoolRegistration$.MODULE$.unapply(poolRegistration);
        }

        public PoolRegistration(ByteString pledge, ByteString cost, Coin margin, Coin rewardAccount, UnitInterval poolOwners, RewardAccount relays, Set<ByteString> poolMetadata, IndexedSeq<Relay> indexedSeq, Option<PoolMetadata> option) {
            this.operator = operator;
            this.vrfKeyHash = (ByteString)vrfKeyHash;
            this.pledge = pledge;
            this.cost = cost;
            this.margin = margin;
            this.rewardAccount = rewardAccount;
            this.poolOwners = poolOwners;
            this.relays = relays;
            this.poolMetadata = poolMetadata;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PoolRegistration)) return false;
            PoolRegistration poolRegistration = (PoolRegistration)object;
            ByteString byteString = this.operator();
            ByteString byteString2 = poolRegistration.operator();
            if (byteString == null) {
                if (byteString2 != null) {
                    return false;
                }
            } else if (!((Object)byteString).equals(byteString2)) return false;
            ByteString byteString3 = this.vrfKeyHash();
            ByteString byteString4 = poolRegistration.vrfKeyHash();
            if (byteString3 == null) {
                if (byteString4 != null) {
                    return false;
                }
            } else if (!((Object)byteString3).equals(byteString4)) return false;
            Coin coin = this.pledge();
            Coin coin2 = poolRegistration.pledge();
            if (coin == null) {
                if (coin2 != null) {
                    return false;
                }
            } else if (!((Object)coin).equals(coin2)) return false;
            Coin coin3 = this.cost();
            Coin coin4 = poolRegistration.cost();
            if (coin3 == null) {
                if (coin4 != null) {
                    return false;
                }
            } else if (!((Object)coin3).equals(coin4)) return false;
            UnitInterval unitInterval = this.margin();
            UnitInterval unitInterval2 = poolRegistration.margin();
            if (unitInterval == null) {
                if (unitInterval2 != null) {
                    return false;
                }
            } else if (!((Object)unitInterval).equals(unitInterval2)) return false;
            RewardAccount rewardAccount = this.rewardAccount();
            RewardAccount rewardAccount2 = poolRegistration.rewardAccount();
            if (rewardAccount == null) {
                if (rewardAccount2 != null) {
                    return false;
                }
            } else if (!((Object)rewardAccount).equals(rewardAccount2)) return false;
            Set<ByteString> set = this.poolOwners();
            Set<ByteString> set2 = poolRegistration.poolOwners();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            IndexedSeq<Relay> indexedSeq = this.relays();
            IndexedSeq<Relay> indexedSeq2 = poolRegistration.relays();
            if (indexedSeq == null) {
                if (indexedSeq2 != null) {
                    return false;
                }
            } else if (!indexedSeq.equals(indexedSeq2)) return false;
            Option<PoolMetadata> option = this.poolMetadata();
            Option<PoolMetadata> option2 = poolRegistration.poolMetadata();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PoolRegistration;
        }

        public int productArity() {
            return 9;
        }

        @Override
        public String productPrefix() {
            return "PoolRegistration";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
                case 8: {
                    return this._9();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "operator";
                }
                case 1: {
                    return "vrfKeyHash";
                }
                case 2: {
                    return "pledge";
                }
                case 3: {
                    return "cost";
                }
                case 4: {
                    return "margin";
                }
                case 5: {
                    return "rewardAccount";
                }
                case 6: {
                    return "poolOwners";
                }
                case 7: {
                    return "relays";
                }
                case 8: {
                    return "poolMetadata";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ByteString operator() {
            return this.operator;
        }

        public ByteString vrfKeyHash() {
            return this.vrfKeyHash;
        }

        public Coin pledge() {
            return this.pledge;
        }

        public Coin cost() {
            return this.cost;
        }

        public UnitInterval margin() {
            return this.margin;
        }

        public RewardAccount rewardAccount() {
            return this.rewardAccount;
        }

        public Set<ByteString> poolOwners() {
            return this.poolOwners;
        }

        public IndexedSeq<Relay> relays() {
            return this.relays;
        }

        public Option<PoolMetadata> poolMetadata() {
            return this.poolMetadata;
        }

        public PoolRegistration copy(ByteString operator, ByteString vrfKeyHash, Coin pledge, Coin cost, UnitInterval margin, RewardAccount rewardAccount, Set<ByteString> poolOwners, IndexedSeq<Relay> relays, Option<PoolMetadata> poolMetadata) {
            return new PoolRegistration(operator, vrfKeyHash, pledge, cost, margin, rewardAccount, poolOwners, relays, poolMetadata);
        }

        public ByteString copy$default$1() {
            return this.operator();
        }

        public ByteString copy$default$2() {
            return this.vrfKeyHash();
        }

        public Coin copy$default$3() {
            return this.pledge();
        }

        public Coin copy$default$4() {
            return this.cost();
        }

        public UnitInterval copy$default$5() {
            return this.margin();
        }

        public RewardAccount copy$default$6() {
            return this.rewardAccount();
        }

        public Set<ByteString> copy$default$7() {
            return this.poolOwners();
        }

        public IndexedSeq<Relay> copy$default$8() {
            return this.relays();
        }

        public Option<PoolMetadata> copy$default$9() {
            return this.poolMetadata();
        }

        public int ordinal() {
            return 1;
        }

        public ByteString _1() {
            return this.operator();
        }

        public ByteString _2() {
            return this.vrfKeyHash();
        }

        public Coin _3() {
            return this.pledge();
        }

        public Coin _4() {
            return this.cost();
        }

        public UnitInterval _5() {
            return this.margin();
        }

        public RewardAccount _6() {
            return this.rewardAccount();
        }

        public Set<ByteString> _7() {
            return this.poolOwners();
        }

        public IndexedSeq<Relay> _8() {
            return this.relays();
        }

        public Option<PoolMetadata> _9() {
            return this.poolMetadata();
        }
    }

    public static final class PoolRetirement
    extends Certificate {
        private final ByteString poolKeyHash;
        private final long epochNo;

        public static PoolRetirement apply(ByteString byteString, long l) {
            return Certificate$PoolRetirement$.MODULE$.apply(byteString, l);
        }

        public static PoolRetirement fromProduct(Product product) {
            return Certificate$PoolRetirement$.MODULE$.fromProduct(product);
        }

        public static PoolRetirement unapply(PoolRetirement poolRetirement) {
            return Certificate$PoolRetirement$.MODULE$.unapply(poolRetirement);
        }

        public PoolRetirement() {
            this.poolKeyHash = poolKeyHash;
            this.epochNo = epochNo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.poolKeyHash()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.epochNo()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PoolRetirement)) return false;
            PoolRetirement poolRetirement = (PoolRetirement)object;
            if (this.epochNo() != poolRetirement.epochNo()) return false;
            ByteString byteString = this.poolKeyHash();
            ByteString byteString2 = poolRetirement.poolKeyHash();
            if (byteString != null) {
                if (!((Object)byteString).equals(byteString2)) return false;
                return true;
            }
            if (byteString2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PoolRetirement;
        }

        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "PoolRetirement";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToLong((long)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "poolKeyHash";
            }
            if (1 == n2) {
                return "epochNo";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ByteString poolKeyHash() {
            return this.poolKeyHash;
        }

        public long epochNo() {
            return this.epochNo;
        }

        public PoolRetirement copy(ByteString poolKeyHash, long epochNo) {
            return new PoolRetirement();
        }

        public ByteString copy$default$1() {
            return this.poolKeyHash();
        }

        public long copy$default$2() {
            return this.epochNo();
        }

        public int ordinal() {
            return 2;
        }

        public ByteString _1() {
            return this.poolKeyHash();
        }

        public long _2() {
            return this.epochNo();
        }
    }

    public static final class RegCert
    extends Certificate {
        private final Credential credential;
        private final Option coin;

        public static RegCert apply(Credential credential, Option<Coin> option) {
            return Certificate$RegCert$.MODULE$.apply(credential, option);
        }

        public static RegCert fromProduct(Product product) {
            return Certificate$RegCert$.MODULE$.fromProduct(product);
        }

        public static RegCert unapply(RegCert regCert) {
            return Certificate$RegCert$.MODULE$.unapply(regCert);
        }

        public RegCert(Credential credential2, Option<Coin> option) {
            this.credential = credential;
            this.coin = (Option)coin;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RegCert)) return false;
            RegCert regCert = (RegCert)object;
            Credential credential = this.credential();
            Credential credential2 = regCert.credential();
            if (credential == null) {
                if (credential2 != null) {
                    return false;
                }
            } else if (!credential.equals(credential2)) return false;
            Option<Coin> option = this.coin();
            Option<Coin> option2 = regCert.coin();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RegCert;
        }

        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "RegCert";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "credential";
            }
            if (1 == n2) {
                return "coin";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Credential credential() {
            return this.credential;
        }

        public Option<Coin> coin() {
            return this.coin;
        }

        public RegCert copy(Credential credential, Option<Coin> coin) {
            return new RegCert(credential, coin);
        }

        public Credential copy$default$1() {
            return this.credential();
        }

        public Option<Coin> copy$default$2() {
            return this.coin();
        }

        public int ordinal() {
            return 3;
        }

        public Credential _1() {
            return this.credential();
        }

        public Option<Coin> _2() {
            return this.coin();
        }
    }

    public static final class RegDRepCert
    extends Certificate {
        private final Credential drepCredential;
        private final Coin coin;
        private final Option anchor;

        public static RegDRepCert apply(Credential credential, Coin coin, Option<Anchor> option) {
            return Certificate$RegDRepCert$.MODULE$.apply(credential, coin, option);
        }

        public static RegDRepCert fromProduct(Product product) {
            return Certificate$RegDRepCert$.MODULE$.fromProduct(product);
        }

        public static RegDRepCert unapply(RegDRepCert regDRepCert) {
            return Certificate$RegDRepCert$.MODULE$.unapply(regDRepCert);
        }

        public RegDRepCert(Credential anchor, Coin coin2, Option<Anchor> option) {
            this.drepCredential = drepCredential;
            this.coin = (Coin)coin;
            this.anchor = anchor;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RegDRepCert)) return false;
            RegDRepCert regDRepCert = (RegDRepCert)object;
            Credential credential = this.drepCredential();
            Credential credential2 = regDRepCert.drepCredential();
            if (credential == null) {
                if (credential2 != null) {
                    return false;
                }
            } else if (!credential.equals(credential2)) return false;
            Coin coin = this.coin();
            Coin coin2 = regDRepCert.coin();
            if (coin == null) {
                if (coin2 != null) {
                    return false;
                }
            } else if (!((Object)coin).equals(coin2)) return false;
            Option<Anchor> option = this.anchor();
            Option<Anchor> option2 = regDRepCert.anchor();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RegDRepCert;
        }

        public int productArity() {
            return 3;
        }

        @Override
        public String productPrefix() {
            return "RegDRepCert";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "drepCredential";
                }
                case 1: {
                    return "coin";
                }
                case 2: {
                    return "anchor";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Credential drepCredential() {
            return this.drepCredential;
        }

        public Coin coin() {
            return this.coin;
        }

        public Option<Anchor> anchor() {
            return this.anchor;
        }

        public RegDRepCert copy(Credential drepCredential, Coin coin, Option<Anchor> anchor) {
            return new RegDRepCert(drepCredential, coin, anchor);
        }

        public Credential copy$default$1() {
            return this.drepCredential();
        }

        public Coin copy$default$2() {
            return this.coin();
        }

        public Option<Anchor> copy$default$3() {
            return this.anchor();
        }

        public int ordinal() {
            return 12;
        }

        public Credential _1() {
            return this.drepCredential();
        }

        public Coin _2() {
            return this.coin();
        }

        public Option<Anchor> _3() {
            return this.anchor();
        }
    }

    public static final class ResignCommitteeColdCert
    extends Certificate {
        private final Credential committeeColdCredential;
        private final Option anchor;

        public static ResignCommitteeColdCert apply(Credential credential, Option<Anchor> option) {
            return Certificate$ResignCommitteeColdCert$.MODULE$.apply(credential, option);
        }

        public static ResignCommitteeColdCert fromProduct(Product product) {
            return Certificate$ResignCommitteeColdCert$.MODULE$.fromProduct(product);
        }

        public static ResignCommitteeColdCert unapply(ResignCommitteeColdCert resignCommitteeColdCert) {
            return Certificate$ResignCommitteeColdCert$.MODULE$.unapply(resignCommitteeColdCert);
        }

        public ResignCommitteeColdCert(Credential credential, Option<Anchor> option) {
            this.committeeColdCredential = committeeColdCredential;
            this.anchor = (Option)anchor;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ResignCommitteeColdCert)) return false;
            ResignCommitteeColdCert resignCommitteeColdCert = (ResignCommitteeColdCert)object;
            Credential credential = this.committeeColdCredential();
            Credential credential2 = resignCommitteeColdCert.committeeColdCredential();
            if (credential == null) {
                if (credential2 != null) {
                    return false;
                }
            } else if (!credential.equals(credential2)) return false;
            Option<Anchor> option = this.anchor();
            Option<Anchor> option2 = resignCommitteeColdCert.anchor();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ResignCommitteeColdCert;
        }

        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "ResignCommitteeColdCert";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "committeeColdCredential";
            }
            if (1 == n2) {
                return "anchor";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Credential committeeColdCredential() {
            return this.committeeColdCredential;
        }

        public Option<Anchor> anchor() {
            return this.anchor;
        }

        public ResignCommitteeColdCert copy(Credential committeeColdCredential, Option<Anchor> anchor) {
            return new ResignCommitteeColdCert(committeeColdCredential, anchor);
        }

        public Credential copy$default$1() {
            return this.committeeColdCredential();
        }

        public Option<Anchor> copy$default$2() {
            return this.anchor();
        }

        public int ordinal() {
            return 11;
        }

        public Credential _1() {
            return this.committeeColdCredential();
        }

        public Option<Anchor> _2() {
            return this.anchor();
        }
    }

    public static final class StakeDelegation
    extends Certificate {
        private final Credential credential;
        private final ByteString poolKeyHash;

        public static StakeDelegation apply(Credential credential, ByteString byteString) {
            return Certificate$StakeDelegation$.MODULE$.apply(credential, byteString);
        }

        public static StakeDelegation fromProduct(Product product) {
            return Certificate$StakeDelegation$.MODULE$.fromProduct(product);
        }

        public static StakeDelegation unapply(StakeDelegation stakeDelegation) {
            return Certificate$StakeDelegation$.MODULE$.unapply(stakeDelegation);
        }

        public StakeDelegation() {
            this.credential = credential;
            this.poolKeyHash = poolKeyHash;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StakeDelegation)) return false;
            StakeDelegation stakeDelegation = (StakeDelegation)object;
            Credential credential = this.credential();
            Credential credential2 = stakeDelegation.credential();
            if (credential == null) {
                if (credential2 != null) {
                    return false;
                }
            } else if (!credential.equals(credential2)) return false;
            ByteString byteString = this.poolKeyHash();
            ByteString byteString2 = stakeDelegation.poolKeyHash();
            if (byteString == null) {
                if (byteString2 == null) return true;
                return false;
            } else {
                if (!((Object)byteString).equals(byteString2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StakeDelegation;
        }

        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "StakeDelegation";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "credential";
            }
            if (1 == n2) {
                return "poolKeyHash";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Credential credential() {
            return this.credential;
        }

        public ByteString poolKeyHash() {
            return this.poolKeyHash;
        }

        public StakeDelegation copy(Credential credential, ByteString poolKeyHash) {
            return new StakeDelegation();
        }

        public Credential copy$default$1() {
            return this.credential();
        }

        public ByteString copy$default$2() {
            return this.poolKeyHash();
        }

        public int ordinal() {
            return 0;
        }

        public Credential _1() {
            return this.credential();
        }

        public ByteString _2() {
            return this.poolKeyHash();
        }
    }

    public static final class StakeRegDelegCert
    extends Certificate {
        private final Credential credential;
        private final ByteString poolKeyHash;
        private final Coin coin;

        public static StakeRegDelegCert apply(Credential credential, ByteString byteString, Coin coin) {
            return Certificate$StakeRegDelegCert$.MODULE$.apply(credential, byteString, coin);
        }

        public static StakeRegDelegCert fromProduct(Product product) {
            return Certificate$StakeRegDelegCert$.MODULE$.fromProduct(product);
        }

        public static StakeRegDelegCert unapply(StakeRegDelegCert stakeRegDelegCert) {
            return Certificate$StakeRegDelegCert$.MODULE$.unapply(stakeRegDelegCert);
        }

        public StakeRegDelegCert(Coin coin) {
            this.credential = credential;
            this.poolKeyHash = poolKeyHash;
            this.coin = coin;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StakeRegDelegCert)) return false;
            StakeRegDelegCert stakeRegDelegCert = (StakeRegDelegCert)object;
            Credential credential = this.credential();
            Credential credential2 = stakeRegDelegCert.credential();
            if (credential == null) {
                if (credential2 != null) {
                    return false;
                }
            } else if (!credential.equals(credential2)) return false;
            ByteString byteString = this.poolKeyHash();
            ByteString byteString2 = stakeRegDelegCert.poolKeyHash();
            if (byteString == null) {
                if (byteString2 != null) {
                    return false;
                }
            } else if (!((Object)byteString).equals(byteString2)) return false;
            Coin coin = this.coin();
            Coin coin2 = stakeRegDelegCert.coin();
            if (coin == null) {
                if (coin2 == null) return true;
                return false;
            } else {
                if (!((Object)coin).equals(coin2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StakeRegDelegCert;
        }

        public int productArity() {
            return 3;
        }

        @Override
        public String productPrefix() {
            return "StakeRegDelegCert";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "credential";
                }
                case 1: {
                    return "poolKeyHash";
                }
                case 2: {
                    return "coin";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Credential credential() {
            return this.credential;
        }

        public ByteString poolKeyHash() {
            return this.poolKeyHash;
        }

        public Coin coin() {
            return this.coin;
        }

        public StakeRegDelegCert copy(Credential credential, ByteString poolKeyHash, Coin coin) {
            return new StakeRegDelegCert(coin);
        }

        public Credential copy$default$1() {
            return this.credential();
        }

        public ByteString copy$default$2() {
            return this.poolKeyHash();
        }

        public Coin copy$default$3() {
            return this.coin();
        }

        public int ordinal() {
            return 7;
        }

        public Credential _1() {
            return this.credential();
        }

        public ByteString _2() {
            return this.poolKeyHash();
        }

        public Coin _3() {
            return this.coin();
        }
    }

    public static final class StakeVoteDelegCert
    extends Certificate {
        private final Credential credential;
        private final ByteString poolKeyHash;
        private final DRep drep;

        public static StakeVoteDelegCert apply(Credential credential, ByteString byteString, DRep dRep) {
            return Certificate$StakeVoteDelegCert$.MODULE$.apply(credential, byteString, dRep);
        }

        public static StakeVoteDelegCert fromProduct(Product product) {
            return Certificate$StakeVoteDelegCert$.MODULE$.fromProduct(product);
        }

        public static StakeVoteDelegCert unapply(StakeVoteDelegCert stakeVoteDelegCert) {
            return Certificate$StakeVoteDelegCert$.MODULE$.unapply(stakeVoteDelegCert);
        }

        public StakeVoteDelegCert(DRep drep) {
            this.credential = credential;
            this.poolKeyHash = poolKeyHash;
            this.drep = drep;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StakeVoteDelegCert)) return false;
            StakeVoteDelegCert stakeVoteDelegCert = (StakeVoteDelegCert)object;
            Credential credential = this.credential();
            Credential credential2 = stakeVoteDelegCert.credential();
            if (credential == null) {
                if (credential2 != null) {
                    return false;
                }
            } else if (!credential.equals(credential2)) return false;
            ByteString byteString = this.poolKeyHash();
            ByteString byteString2 = stakeVoteDelegCert.poolKeyHash();
            if (byteString == null) {
                if (byteString2 != null) {
                    return false;
                }
            } else if (!((Object)byteString).equals(byteString2)) return false;
            DRep dRep = this.drep();
            DRep dRep2 = stakeVoteDelegCert.drep();
            if (dRep == null) {
                if (dRep2 == null) return true;
                return false;
            } else {
                if (!dRep.equals(dRep2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StakeVoteDelegCert;
        }

        public int productArity() {
            return 3;
        }

        @Override
        public String productPrefix() {
            return "StakeVoteDelegCert";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "credential";
                }
                case 1: {
                    return "poolKeyHash";
                }
                case 2: {
                    return "drep";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Credential credential() {
            return this.credential;
        }

        public ByteString poolKeyHash() {
            return this.poolKeyHash;
        }

        public DRep drep() {
            return this.drep;
        }

        public StakeVoteDelegCert copy(Credential credential, ByteString poolKeyHash, DRep drep) {
            return new StakeVoteDelegCert(drep);
        }

        public Credential copy$default$1() {
            return this.credential();
        }

        public ByteString copy$default$2() {
            return this.poolKeyHash();
        }

        public DRep copy$default$3() {
            return this.drep();
        }

        public int ordinal() {
            return 6;
        }

        public Credential _1() {
            return this.credential();
        }

        public ByteString _2() {
            return this.poolKeyHash();
        }

        public DRep _3() {
            return this.drep();
        }
    }

    public static final class StakeVoteRegDelegCert
    extends Certificate {
        private final Credential credential;
        private final ByteString poolKeyHash;
        private final DRep drep;
        private final Coin coin;

        public static StakeVoteRegDelegCert apply(Credential credential, ByteString byteString, DRep dRep, Coin coin) {
            return Certificate$StakeVoteRegDelegCert$.MODULE$.apply(credential, byteString, dRep, coin);
        }

        public static StakeVoteRegDelegCert fromProduct(Product product) {
            return Certificate$StakeVoteRegDelegCert$.MODULE$.fromProduct(product);
        }

        public static StakeVoteRegDelegCert unapply(StakeVoteRegDelegCert stakeVoteRegDelegCert) {
            return Certificate$StakeVoteRegDelegCert$.MODULE$.unapply(stakeVoteRegDelegCert);
        }

        public StakeVoteRegDelegCert(DRep drep, Coin coin) {
            this.credential = credential;
            this.poolKeyHash = poolKeyHash;
            this.drep = drep;
            this.coin = coin;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StakeVoteRegDelegCert)) return false;
            StakeVoteRegDelegCert stakeVoteRegDelegCert = (StakeVoteRegDelegCert)object;
            Credential credential = this.credential();
            Credential credential2 = stakeVoteRegDelegCert.credential();
            if (credential == null) {
                if (credential2 != null) {
                    return false;
                }
            } else if (!credential.equals(credential2)) return false;
            ByteString byteString = this.poolKeyHash();
            ByteString byteString2 = stakeVoteRegDelegCert.poolKeyHash();
            if (byteString == null) {
                if (byteString2 != null) {
                    return false;
                }
            } else if (!((Object)byteString).equals(byteString2)) return false;
            DRep dRep = this.drep();
            DRep dRep2 = stakeVoteRegDelegCert.drep();
            if (dRep == null) {
                if (dRep2 != null) {
                    return false;
                }
            } else if (!dRep.equals(dRep2)) return false;
            Coin coin = this.coin();
            Coin coin2 = stakeVoteRegDelegCert.coin();
            if (coin == null) {
                if (coin2 == null) return true;
                return false;
            } else {
                if (!((Object)coin).equals(coin2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StakeVoteRegDelegCert;
        }

        public int productArity() {
            return 4;
        }

        @Override
        public String productPrefix() {
            return "StakeVoteRegDelegCert";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "credential";
                }
                case 1: {
                    return "poolKeyHash";
                }
                case 2: {
                    return "drep";
                }
                case 3: {
                    return "coin";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Credential credential() {
            return this.credential;
        }

        public ByteString poolKeyHash() {
            return this.poolKeyHash;
        }

        public DRep drep() {
            return this.drep;
        }

        public Coin coin() {
            return this.coin;
        }

        public StakeVoteRegDelegCert copy(Credential credential, ByteString poolKeyHash, DRep drep, Coin coin) {
            return new StakeVoteRegDelegCert(drep, coin);
        }

        public Credential copy$default$1() {
            return this.credential();
        }

        public ByteString copy$default$2() {
            return this.poolKeyHash();
        }

        public DRep copy$default$3() {
            return this.drep();
        }

        public Coin copy$default$4() {
            return this.coin();
        }

        public int ordinal() {
            return 9;
        }

        public Credential _1() {
            return this.credential();
        }

        public ByteString _2() {
            return this.poolKeyHash();
        }

        public DRep _3() {
            return this.drep();
        }

        public Coin _4() {
            return this.coin();
        }
    }

    public static final class UnregCert
    extends Certificate {
        private final Credential credential;
        private final Option coin;

        public static UnregCert apply(Credential credential, Option<Coin> option) {
            return Certificate$UnregCert$.MODULE$.apply(credential, option);
        }

        public static UnregCert fromProduct(Product product) {
            return Certificate$UnregCert$.MODULE$.fromProduct(product);
        }

        public static UnregCert unapply(UnregCert unregCert) {
            return Certificate$UnregCert$.MODULE$.unapply(unregCert);
        }

        public UnregCert(Credential credential2, Option<Coin> option) {
            this.credential = credential;
            this.coin = (Option)coin;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UnregCert)) return false;
            UnregCert unregCert = (UnregCert)object;
            Credential credential = this.credential();
            Credential credential2 = unregCert.credential();
            if (credential == null) {
                if (credential2 != null) {
                    return false;
                }
            } else if (!credential.equals(credential2)) return false;
            Option<Coin> option = this.coin();
            Option<Coin> option2 = unregCert.coin();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof UnregCert;
        }

        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "UnregCert";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "credential";
            }
            if (1 == n2) {
                return "coin";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Credential credential() {
            return this.credential;
        }

        public Option<Coin> coin() {
            return this.coin;
        }

        public UnregCert copy(Credential credential, Option<Coin> coin) {
            return new UnregCert(credential, coin);
        }

        public Credential copy$default$1() {
            return this.credential();
        }

        public Option<Coin> copy$default$2() {
            return this.coin();
        }

        public int ordinal() {
            return 4;
        }

        public Credential _1() {
            return this.credential();
        }

        public Option<Coin> _2() {
            return this.coin();
        }
    }

    public static final class UnregDRepCert
    extends Certificate {
        private final Credential drepCredential;
        private final Coin coin;

        public static UnregDRepCert apply(Credential credential, Coin coin) {
            return Certificate$UnregDRepCert$.MODULE$.apply(credential, coin);
        }

        public static UnregDRepCert fromProduct(Product product) {
            return Certificate$UnregDRepCert$.MODULE$.fromProduct(product);
        }

        public static UnregDRepCert unapply(UnregDRepCert unregDRepCert) {
            return Certificate$UnregDRepCert$.MODULE$.unapply(unregDRepCert);
        }

        public UnregDRepCert() {
            this.drepCredential = drepCredential;
            this.coin = coin;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UnregDRepCert)) return false;
            UnregDRepCert unregDRepCert = (UnregDRepCert)object;
            Credential credential = this.drepCredential();
            Credential credential2 = unregDRepCert.drepCredential();
            if (credential == null) {
                if (credential2 != null) {
                    return false;
                }
            } else if (!credential.equals(credential2)) return false;
            Coin coin = this.coin();
            Coin coin2 = unregDRepCert.coin();
            if (coin == null) {
                if (coin2 == null) return true;
                return false;
            } else {
                if (!((Object)coin).equals(coin2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof UnregDRepCert;
        }

        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "UnregDRepCert";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "drepCredential";
            }
            if (1 == n2) {
                return "coin";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Credential drepCredential() {
            return this.drepCredential;
        }

        public Coin coin() {
            return this.coin;
        }

        public UnregDRepCert copy(Credential drepCredential, Coin coin) {
            return new UnregDRepCert();
        }

        public Credential copy$default$1() {
            return this.drepCredential();
        }

        public Coin copy$default$2() {
            return this.coin();
        }

        public int ordinal() {
            return 13;
        }

        public Credential _1() {
            return this.drepCredential();
        }

        public Coin _2() {
            return this.coin();
        }
    }

    public static final class UpdateDRepCert
    extends Certificate {
        private final Credential drepCredential;
        private final Option anchor;

        public static UpdateDRepCert apply(Credential credential, Option<Anchor> option) {
            return Certificate$UpdateDRepCert$.MODULE$.apply(credential, option);
        }

        public static UpdateDRepCert fromProduct(Product product) {
            return Certificate$UpdateDRepCert$.MODULE$.fromProduct(product);
        }

        public static UpdateDRepCert unapply(UpdateDRepCert updateDRepCert) {
            return Certificate$UpdateDRepCert$.MODULE$.unapply(updateDRepCert);
        }

        public UpdateDRepCert(Credential credential, Option<Anchor> option) {
            this.drepCredential = drepCredential;
            this.anchor = (Option)anchor;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UpdateDRepCert)) return false;
            UpdateDRepCert updateDRepCert = (UpdateDRepCert)object;
            Credential credential = this.drepCredential();
            Credential credential2 = updateDRepCert.drepCredential();
            if (credential == null) {
                if (credential2 != null) {
                    return false;
                }
            } else if (!credential.equals(credential2)) return false;
            Option<Anchor> option = this.anchor();
            Option<Anchor> option2 = updateDRepCert.anchor();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof UpdateDRepCert;
        }

        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "UpdateDRepCert";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "drepCredential";
            }
            if (1 == n2) {
                return "anchor";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Credential drepCredential() {
            return this.drepCredential;
        }

        public Option<Anchor> anchor() {
            return this.anchor;
        }

        public UpdateDRepCert copy(Credential drepCredential, Option<Anchor> anchor) {
            return new UpdateDRepCert(drepCredential, anchor);
        }

        public Credential copy$default$1() {
            return this.drepCredential();
        }

        public Option<Anchor> copy$default$2() {
            return this.anchor();
        }

        public int ordinal() {
            return 14;
        }

        public Credential _1() {
            return this.drepCredential();
        }

        public Option<Anchor> _2() {
            return this.anchor();
        }
    }

    public static final class VoteDelegCert
    extends Certificate {
        private final Credential credential;
        private final DRep drep;

        public static VoteDelegCert apply(Credential credential, DRep dRep) {
            return Certificate$VoteDelegCert$.MODULE$.apply(credential, dRep);
        }

        public static VoteDelegCert fromProduct(Product product) {
            return Certificate$VoteDelegCert$.MODULE$.fromProduct(product);
        }

        public static VoteDelegCert unapply(VoteDelegCert voteDelegCert) {
            return Certificate$VoteDelegCert$.MODULE$.unapply(voteDelegCert);
        }

        public VoteDelegCert() {
            this.credential = credential;
            this.drep = drep;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof VoteDelegCert)) return false;
            VoteDelegCert voteDelegCert = (VoteDelegCert)object;
            Credential credential = this.credential();
            Credential credential2 = voteDelegCert.credential();
            if (credential == null) {
                if (credential2 != null) {
                    return false;
                }
            } else if (!credential.equals(credential2)) return false;
            DRep dRep = this.drep();
            DRep dRep2 = voteDelegCert.drep();
            if (dRep == null) {
                if (dRep2 == null) return true;
                return false;
            } else {
                if (!dRep.equals(dRep2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof VoteDelegCert;
        }

        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "VoteDelegCert";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "credential";
            }
            if (1 == n2) {
                return "drep";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Credential credential() {
            return this.credential;
        }

        public DRep drep() {
            return this.drep;
        }

        public VoteDelegCert copy(Credential credential, DRep drep) {
            return new VoteDelegCert();
        }

        public Credential copy$default$1() {
            return this.credential();
        }

        public DRep copy$default$2() {
            return this.drep();
        }

        public int ordinal() {
            return 5;
        }

        public Credential _1() {
            return this.credential();
        }

        public DRep _2() {
            return this.drep();
        }
    }

    public static final class VoteRegDelegCert
    extends Certificate {
        private final Credential credential;
        private final DRep drep;
        private final Coin coin;

        public static VoteRegDelegCert apply(Credential credential, DRep dRep, Coin coin) {
            return Certificate$VoteRegDelegCert$.MODULE$.apply(credential, dRep, coin);
        }

        public static VoteRegDelegCert fromProduct(Product product) {
            return Certificate$VoteRegDelegCert$.MODULE$.fromProduct(product);
        }

        public static VoteRegDelegCert unapply(VoteRegDelegCert voteRegDelegCert) {
            return Certificate$VoteRegDelegCert$.MODULE$.unapply(voteRegDelegCert);
        }

        public VoteRegDelegCert(Coin coin) {
            this.credential = credential;
            this.drep = drep;
            this.coin = coin;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof VoteRegDelegCert)) return false;
            VoteRegDelegCert voteRegDelegCert = (VoteRegDelegCert)object;
            Credential credential = this.credential();
            Credential credential2 = voteRegDelegCert.credential();
            if (credential == null) {
                if (credential2 != null) {
                    return false;
                }
            } else if (!credential.equals(credential2)) return false;
            DRep dRep = this.drep();
            DRep dRep2 = voteRegDelegCert.drep();
            if (dRep == null) {
                if (dRep2 != null) {
                    return false;
                }
            } else if (!dRep.equals(dRep2)) return false;
            Coin coin = this.coin();
            Coin coin2 = voteRegDelegCert.coin();
            if (coin == null) {
                if (coin2 == null) return true;
                return false;
            } else {
                if (!((Object)coin).equals(coin2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof VoteRegDelegCert;
        }

        public int productArity() {
            return 3;
        }

        @Override
        public String productPrefix() {
            return "VoteRegDelegCert";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "credential";
                }
                case 1: {
                    return "drep";
                }
                case 2: {
                    return "coin";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Credential credential() {
            return this.credential;
        }

        public DRep drep() {
            return this.drep;
        }

        public Coin coin() {
            return this.coin;
        }

        public VoteRegDelegCert copy(Credential credential, DRep drep, Coin coin) {
            return new VoteRegDelegCert(coin);
        }

        public Credential copy$default$1() {
            return this.credential();
        }

        public DRep copy$default$2() {
            return this.drep();
        }

        public Coin copy$default$3() {
            return this.coin();
        }

        public int ordinal() {
            return 8;
        }

        public Credential _1() {
            return this.credential();
        }

        public DRep _2() {
            return this.drep();
        }

        public Coin _3() {
            return this.coin();
        }
    }
}

