/*
 * Decompiled with CFR 0.152.
 */
package scalus.cardano.ledger;

import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.EvidenceIterableFactory;
import scala.collection.EvidenceIterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.MapFactory;
import scala.collection.MapFactory$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.TreeSet;
import scala.collection.immutable.TreeSet$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scalus.builtin.ByteString;
import scalus.builtin.ByteString$;
import scalus.builtin.Data;
import scalus.builtin.JVMPlatformSpecific$package$;
import scalus.cardano.ledger.CostModels;
import scalus.cardano.ledger.CostModels$;
import scalus.cardano.ledger.Era;
import scalus.cardano.ledger.Era$;
import scalus.cardano.ledger.HashSize$;
import scalus.cardano.ledger.Hashes$package$Hash$;
import scalus.cardano.ledger.KeepRaw;
import scalus.cardano.ledger.Language;
import scalus.cardano.ledger.Language$;
import scalus.cardano.ledger.PlutusScript;
import scalus.cardano.ledger.Redeemers;
import scalus.cardano.ledger.Script;
import scalus.cardano.ledger.TaggedSet$package$;
import scalus.cardano.ledger.TransactionWitnessSet;
import scalus.ledger.babbage.ProtocolParams;

public final class ScriptDataHashGenerator$
implements Serializable {
    public static final ScriptDataHashGenerator$ MODULE$ = new ScriptDataHashGenerator$();

    private ScriptDataHashGenerator$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ScriptDataHashGenerator$.class);
    }

    public CostModels getUsedCostModels(ProtocolParams pparams, TransactionWitnessSet w, Set<Script> refScripts) {
        TreeSet refLangs = (TreeSet)((IterableOnceOps)refScripts.view().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Script x) {
                Script script = x;
                if (script instanceof PlutusScript) {
                    PlutusScript script2 = (PlutusScript)script;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Script x, Function1 function1) {
                Script script = x;
                if (script instanceof PlutusScript) {
                    PlutusScript script2 = (PlutusScript)script;
                    return script2.language();
                }
                return function1.apply((Object)x);
            }
        })).to(EvidenceIterableFactory$.MODULE$.toFactory((EvidenceIterableFactory)TreeSet$.MODULE$, Language$.MODULE$.given_Ordering_Language()));
        return this.getUsedCostModels(pparams, w, (TreeSet<Language>)refLangs);
    }

    public CostModels getUsedCostModels(ProtocolParams pparams, TransactionWitnessSet w, TreeSet<Language> refLangs) {
        TreeSet v1 = w.plutusV1Scripts().nonEmpty() ? (TreeSet)TreeSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Language[]{Language$.PlutusV1}), Language$.MODULE$.given_Ordering_Language()) : TreeSet$.MODULE$.empty(Language$.MODULE$.given_Ordering_Language());
        TreeSet v2 = w.plutusV2Scripts().nonEmpty() ? (TreeSet)TreeSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Language[]{Language$.PlutusV2}), Language$.MODULE$.given_Ordering_Language()) : TreeSet$.MODULE$.empty(Language$.MODULE$.given_Ordering_Language());
        TreeSet v3 = w.plutusV3Scripts().nonEmpty() ? (TreeSet)TreeSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Language[]{Language$.PlutusV3}), Language$.MODULE$.given_Ordering_Language()) : TreeSet$.MODULE$.empty(Language$.MODULE$.given_Ordering_Language());
        ListMap models = (ListMap)((IterableOnceOps)refLangs.$plus$plus((IterableOnce)v1).$plus$plus((IterableOnce)v2).$plus$plus((IterableOnce)v3).view().map((Function1 & Serializable)l -> {
            Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)l.ordinal()));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, pparams.costModels().apply((Object)l.toString()));
        })).to(MapFactory$.MODULE$.toFactory((MapFactory)ListMap$.MODULE$));
        return CostModels$.MODULE$.apply((Map<Object, IndexedSeq<Object>>)models);
    }

    public ByteString computeScriptDataHash(Era era, Option<KeepRaw<Redeemers>> redeemers, KeepRaw<IndexedSeq<KeepRaw<Data>>> datums, CostModels costModels) {
        byte[] byArray;
        Predef$.MODULE$.require(era.value() >= Era$.Conway.value(), () -> ScriptDataHashGenerator$.computeScriptDataHash$$anonfun$1(era));
        Option<KeepRaw<Redeemers>> option = redeemers;
        if (option instanceof Some) {
            KeepRaw value = (KeepRaw)((Some)option).value();
            byArray = value.raw();
        } else if (None$.MODULE$.equals(option)) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = (byte)160;
        } else {
            throw new MatchError(option);
        }
        byte[] redeemerBytes = byArray;
        TaggedSet$package$ taggedSet$package$ = TaggedSet$package$.MODULE$;
        IndexedSeq<KeepRaw<Data>> s$proxy1 = datums.value();
        byte[] plutusDataBytes = s$proxy1.isEmpty() ? (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Byte.TYPE)) : datums.raw();
        byte[] costModelsBytes = costModels.getLanguageViewEncoding();
        Object object = Predef$.MODULE$.byteArrayOps(redeemerBytes);
        Object object2 = Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)plutusDataBytes, ClassTag$.MODULE$.apply(Byte.TYPE)));
        byte[] encodedBytes = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object2, (Object)costModelsBytes, ClassTag$.MODULE$.apply(Byte.TYPE));
        return Hashes$package$Hash$.MODULE$.apply(JVMPlatformSpecific$package$.MODULE$.given_PlatformSpecific().blake2b_256(ByteString$.MODULE$.unsafeFromArray(encodedBytes)), HashSize$.MODULE$.given_HashSize_Blake2b_256());
    }

    private static final Object computeScriptDataHash$$anonfun$1(Era era$1) {
        return new StringBuilder(78).append("Script data hash generation is not supported for eras before Conway, got era: ").append((Object)era$1).toString();
    }
}

