/*
 * Decompiled with CFR 0.152.
 */
package scalus.utils;

import java.io.Serializable;
import java.util.IdentityHashMap;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.mutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scalus.utils.HashConsed$;
import scalus.utils.HashConsed$ConstRef$;
import scalus.utils.HashConsed$ForwardRef$;
import scalus.utils.HashConsed$MutRef$;
import scalus.utils.HashConsed$State$;
import scalus.utils.HashConsed$package$;
import scalus.utils.HashConsedRef;

public final class HashConsed {
    public static void finishCallbacks(State state, boolean bl) {
        HashConsed$.MODULE$.finishCallbacks(state, bl);
    }

    public static Option<Either<ForwardRefAcceptor, HashConsedRef<?>>> lookup(State state, int n, int n2) {
        return HashConsed$.MODULE$.lookup(state, n, n2);
    }

    public static Option<HashConsedRef<?>> lookupValue(State state, int n, int n2) {
        return HashConsed$.MODULE$.lookupValue(state, n, n2);
    }

    public static <A> void putForwadValueAcceptor(State state, int n, int n2, Function1<A, BoxedUnit> function1) {
        HashConsed$.MODULE$.putForwadValueAcceptor(state, n, n2, function1);
    }

    public static void putForwardRefAcceptor(State state, ForwardRefAcceptor forwardRefAcceptor) {
        HashConsed$.MODULE$.putForwardRefAcceptor(state, forwardRefAcceptor);
    }

    public static <A> void setRef(State state, int n, int n2, HashConsedRef<A> hashConsedRef) {
        HashConsed$.MODULE$.setRef(state, n, n2, hashConsedRef);
    }

    public static int tag(int n) {
        return HashConsed$.MODULE$.tag(n);
    }

    public static boolean finishCallbacks$default$2() {
        return HashConsed$.MODULE$.finishCallbacks$default$2();
    }

    public static class CachedTaggedRef<A>
    implements HashConsedRef<A> {
        private final int tag;
        private final HashConsedRef ref;
        private Object data;

        public CachedTaggedRef(int tag, HashConsedRef<A> ref) {
            this.tag = tag;
            this.ref = ref;
            this.data = null;
        }

        public int tag() {
            return this.tag;
        }

        public HashConsedRef<A> ref() {
            return this.ref;
        }

        public Object cache() {
            return this.data;
        }

        @Override
        public A finValue(State hashConsed, int level, IdentityHashMap<HashConsedRef<?>, HashConsedRef<?>> parents) {
            if (this.data == null) {
                this.data = this.ref().finValue(hashConsed, level + 1, parents);
            }
            return (A)this.data;
        }
    }

    public static class ConstRef<A>
    implements HashConsedRef<A>,
    Product,
    Serializable {
        private final Object value;

        public static <A> ConstRef<A> apply(A a) {
            return HashConsed$ConstRef$.MODULE$.apply(a);
        }

        public static <A> ConstRef<A> fromData(A a) {
            return HashConsed$ConstRef$.MODULE$.fromData(a);
        }

        public static ConstRef<?> fromProduct(Product product) {
            return HashConsed$ConstRef$.MODULE$.fromProduct(product);
        }

        public static <A> ConstRef<A> unapply(ConstRef<A> constRef) {
            return HashConsed$ConstRef$.MODULE$.unapply(constRef);
        }

        public ConstRef(A value) {
            this.value = value;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ConstRef)) return false;
            ConstRef constRef = (ConstRef)object;
            if (!BoxesRunTime.equals(this.value(), constRef.value())) return false;
            if (!constRef.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ConstRef;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ConstRef";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public A value() {
            return (A)this.value;
        }

        @Override
        public A finValue(State hashConsed, int level, IdentityHashMap<HashConsedRef<?>, HashConsedRef<?>> parents) {
            return this.value();
        }

        public <A> ConstRef<A> copy(A value) {
            return new ConstRef<A>(value);
        }

        public <A> A copy$default$1() {
            return this.value();
        }

        public A _1() {
            return this.value();
        }
    }

    public static class ForwardRef<A>
    implements HashConsedRef<A> {
        private final int ihc;
        private final int tag;
        private HashConsedRef ref;

        public static <A> HashConsedRef<A> create(State state, int n, int n2) {
            return HashConsed$ForwardRef$.MODULE$.create(state, n, n2);
        }

        public ForwardRef(int ihc, int tag) {
            this.ihc = ihc;
            this.tag = tag;
            this.ref = null;
        }

        public int ihc() {
            return this.ihc;
        }

        public int tag() {
            return this.tag;
        }

        private HashConsedRef ref() {
            return this.ref;
        }

        public void scalus$utils$HashConsed$ForwardRef$$ref_$eq(HashConsedRef x$0) {
            this.ref = x$0;
        }

        @Override
        public boolean isForward() {
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public A finValue(State hashConsed, int level, IdentityHashMap<HashConsedRef<?>, HashConsedRef<?>> parents) {
            if (this.ref() == null) {
                Option<Either<ForwardRefAcceptor, HashConsedRef<?>>> option = HashConsed$package$.MODULE$.lookup(hashConsed, this.ihc(), this.tag());
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringBuilder(33).append("Forward reference not creaded: ").append(this.ihc()).append(", ").append(this.tag()).toString());
                }
                if (!(option instanceof Some)) throw new MatchError(option);
                Either either = (Either)((Some)option).value();
                if (either instanceof Left) {
                    ForwardRefAcceptor fw = (ForwardRefAcceptor)((Left)either).value();
                    throw new IllegalStateException(new StringBuilder(34).append("Forward reference not resolved: ").append(this.ihc()).append(", ").append(this.tag()).toString());
                }
                if (!(either instanceof Right)) throw new MatchError(option);
                HashConsedRef a = (HashConsedRef)((Right)either).value();
                if (parents.get(a) != null) {
                    throw new IllegalStateException(new StringBuilder(27).append("Cycled forward referenc: ").append(this.ihc()).append(", ").append(this.tag()).toString());
                }
                if (a == this) {
                    throw new IllegalStateException(new StringBuilder(42).append("Forward reference not non-rec resolved: ").append(this.ihc()).append(", ").append(this.tag()).toString());
                }
                this.scalus$utils$HashConsed$ForwardRef$$ref_$eq(a);
            }
            parents.put(this, this);
            Object retval = this.ref().finValue(hashConsed, level + 1, parents);
            parents.remove(this);
            return retval;
        }
    }

    public static class ForwardRefAcceptor {
        private final int ihc;
        private final int tag;
        private List setRefActions;

        public ForwardRefAcceptor(int ihc, int tag, List<Function1<HashConsedRef<?>, BoxedUnit>> setRefActions) {
            this.ihc = ihc;
            this.tag = tag;
            this.setRefActions = setRefActions;
        }

        public int ihc() {
            return this.ihc;
        }

        public int tag() {
            return this.tag;
        }

        public List<Function1<HashConsedRef<?>, BoxedUnit>> setRefActions() {
            return this.setRefActions;
        }

        public void setRefActions_$eq(List<Function1<HashConsedRef<?>, BoxedUnit>> x$1) {
            this.setRefActions = x$1;
        }

        public void addAction(State state, Function1<HashConsedRef<?>, BoxedUnit> action) {
            Option option = state.refs().get((Object)new Tuple2.mcII.sp(this.ihc(), this.tag()));
            if (None$.MODULE$.equals(option)) {
                this.setRefActions_$eq(this.setRefActions().$colon$colon(action));
                return;
            }
            if (option instanceof Some) {
                CachedTaggedRef v = (CachedTaggedRef)((Some)option).value();
                action.apply((Object)v);
                return;
            }
            throw new MatchError((Object)option);
        }
    }

    public static class ForwardValueAcceptor {
        private List setValueActions;

        public ForwardValueAcceptor(List<Function1<Object, BoxedUnit>> setValueActions) {
            this.setValueActions = setValueActions;
        }

        public List<Function1<Object, BoxedUnit>> setValueActions() {
            return this.setValueActions;
        }

        public void setValueActions_$eq(List<Function1<Object, BoxedUnit>> x$1) {
            this.setValueActions = x$1;
        }
    }

    public static class MutRef<A>
    implements HashConsedRef<A> {
        private Object value;

        public static <A> MutRef<A> fromData(A a) {
            return HashConsed$MutRef$.MODULE$.fromData(a);
        }

        public MutRef(Object value) {
            this.value = value;
        }

        public Object value() {
            return this.value;
        }

        public void value_$eq(Object x$1) {
            this.value = x$1;
        }

        @Override
        public A finValue(State hashConsed, int level, IdentityHashMap<HashConsedRef<?>, HashConsedRef<?>> parents) {
            if (this.value() == null) {
                throw new IllegalStateException("Null reference during reading");
            }
            return (A)this.value();
        }

        public void setValue(A a) {
            this.value_$eq(a);
        }
    }

    public static class State
    implements Product,
    Serializable {
        private final Map forwardRefAcceptors;
        private final Map refs;
        private final Map forwardValueAcceptors;

        public static State apply(Map<Tuple2<Object, Object>, ForwardRefAcceptor> map, Map<Tuple2<Object, Object>, CachedTaggedRef<?>> map2, Map<Tuple2<Object, Object>, ForwardValueAcceptor> map3) {
            return HashConsed$State$.MODULE$.apply(map, map2, map3);
        }

        public static State empty() {
            return HashConsed$State$.MODULE$.empty();
        }

        public static State fromProduct(Product product) {
            return HashConsed$State$.MODULE$.fromProduct(product);
        }

        public static State unapply(State state) {
            return HashConsed$State$.MODULE$.unapply(state);
        }

        public State(Map<Tuple2<Object, Object>, ForwardRefAcceptor> forwardRefAcceptors, Map<Tuple2<Object, Object>, CachedTaggedRef<?>> refs, Map<Tuple2<Object, Object>, ForwardValueAcceptor> forwardValueAcceptors) {
            this.forwardRefAcceptors = forwardRefAcceptors;
            this.refs = refs;
            this.forwardValueAcceptors = forwardValueAcceptors;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            Map<Tuple2<Object, Object>, ForwardRefAcceptor> map = this.forwardRefAcceptors();
            Map<Tuple2<Object, Object>, ForwardRefAcceptor> map2 = state.forwardRefAcceptors();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Map<Tuple2<Object, Object>, CachedTaggedRef<?>> map3 = this.refs();
            Map<Tuple2<Object, Object>, CachedTaggedRef<?>> map4 = state.refs();
            if (map3 == null) {
                if (map4 != null) {
                    return false;
                }
            } else if (!map3.equals(map4)) return false;
            Map<Tuple2<Object, Object>, ForwardValueAcceptor> map5 = this.forwardValueAcceptors();
            Map<Tuple2<Object, Object>, ForwardValueAcceptor> map6 = state.forwardValueAcceptors();
            if (map5 == null) {
                if (map6 != null) {
                    return false;
                }
            } else if (!map5.equals(map6)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "forwardRefAcceptors";
                }
                case 1: {
                    return "refs";
                }
                case 2: {
                    return "forwardValueAcceptors";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Map<Tuple2<Object, Object>, ForwardRefAcceptor> forwardRefAcceptors() {
            return this.forwardRefAcceptors;
        }

        public Map<Tuple2<Object, Object>, CachedTaggedRef<?>> refs() {
            return this.refs;
        }

        public Map<Tuple2<Object, Object>, ForwardValueAcceptor> forwardValueAcceptors() {
            return this.forwardValueAcceptors;
        }

        public State copy(Map<Tuple2<Object, Object>, ForwardRefAcceptor> forwardRefAcceptors, Map<Tuple2<Object, Object>, CachedTaggedRef<?>> refs, Map<Tuple2<Object, Object>, ForwardValueAcceptor> forwardValueAcceptors) {
            return new State(forwardRefAcceptors, refs, forwardValueAcceptors);
        }

        public Map<Tuple2<Object, Object>, ForwardRefAcceptor> copy$default$1() {
            return this.forwardRefAcceptors();
        }

        public Map<Tuple2<Object, Object>, CachedTaggedRef<?>> copy$default$2() {
            return this.refs();
        }

        public Map<Tuple2<Object, Object>, ForwardValueAcceptor> copy$default$3() {
            return this.forwardValueAcceptors();
        }

        public Map<Tuple2<Object, Object>, ForwardRefAcceptor> _1() {
            return this.forwardRefAcceptors();
        }

        public Map<Tuple2<Object, Object>, CachedTaggedRef<?>> _2() {
            return this.refs();
        }

        public Map<Tuple2<Object, Object>, ForwardValueAcceptor> _3() {
            return this.forwardValueAcceptors();
        }
    }
}

