/*
 * Decompiled with CFR 0.152.
 */
package scalus.builtin;

import io.bullet.borer.Cbor$;
import io.bullet.borer.Encoder;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scalus.builtin.BLS12_381_G1_Element;
import scalus.builtin.BLS12_381_G2_Element;
import scalus.builtin.BLS12_381_MlResult;
import scalus.builtin.BitwiseLogicalOperations$;
import scalus.builtin.BuiltinList;
import scalus.builtin.BuiltinList$;
import scalus.builtin.BuiltinPair;
import scalus.builtin.BuiltinPair$;
import scalus.builtin.ByteString;
import scalus.builtin.ByteString$;
import scalus.builtin.ByteStringToInteger$;
import scalus.builtin.Data;
import scalus.builtin.Data$;
import scalus.builtin.Data$B$;
import scalus.builtin.Data$Constr$;
import scalus.builtin.Data$I$;
import scalus.builtin.Data$List$;
import scalus.builtin.Data$Map$;
import scalus.builtin.IntegerToByteString$;
import scalus.builtin.PlatformSpecific;
import scalus.builtin.PlatformSpecific$;
import scalus.builtin.UTF8Decoder$;
import scalus.uplc.eval.BuiltinException;

public abstract class AbstractBuiltins {
    private final PlatformSpecific ps;

    public AbstractBuiltins(PlatformSpecific ps) {
        this.ps = ps;
    }

    public BigInt addInteger(BigInt i1, BigInt i2) {
        return i1.$plus(i2);
    }

    public BigInt subtractInteger(BigInt i1, BigInt i2) {
        return i1.$minus(i2);
    }

    public BigInt multiplyInteger(BigInt i1, BigInt i2) {
        return i1.$times(i2);
    }

    public BigInt divideInteger(BigInt i1, BigInt i2) {
        BigInteger r = new BigDecimal(i1.bigInteger()).divide(new BigDecimal(i2.bigInteger()), RoundingMode.FLOOR).toBigInteger();
        return package$.MODULE$.BigInt().apply(r);
    }

    public BigInt quotientInteger(BigInt i1, BigInt i2) {
        return i1.$div(i2);
    }

    public BigInt remainderInteger(BigInt i1, BigInt i2) {
        return i1.$percent(i2);
    }

    public BigInt modInteger(BigInt i1, BigInt i2) {
        BigInt r = i1.$percent(i2);
        if (r.signum() == -i2.signum()) {
            return r.$plus(i2);
        }
        return r;
    }

    public boolean equalsInteger(BigInt i1, BigInt i2) {
        return BoxesRunTime.equals((Object)i1, (Object)i2);
    }

    public boolean lessThanInteger(BigInt i1, BigInt i2) {
        return i1.$less((Object)i2);
    }

    public boolean lessThanEqualsInteger(BigInt i1, BigInt i2) {
        return i1.$less$eq((Object)i2);
    }

    public ByteString appendByteString(ByteString a, ByteString b) {
        Object object = Predef$.MODULE$.byteArrayOps(a.bytes());
        return ByteString$.MODULE$.unsafeFromArray((byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)b.bytes(), ClassTag$.MODULE$.apply(Byte.TYPE)));
    }

    public ByteString consByteString(BigInt bigInt, ByteString byteString) {
        if (bigInt.$less((Object)BigInt$.MODULE$.int2bigInt(0)) || bigInt.$greater((Object)BigInt$.MODULE$.int2bigInt(255))) {
            throw new BuiltinException(new StringBuilder(36).append("consByteString: invalid byte value: ").append(bigInt).toString());
        }
        byte by = bigInt.toByte();
        Object object = Predef$.MODULE$.byteArrayOps(byteString.bytes());
        return ByteString$.MODULE$.unsafeFromArray((byte[])ArrayOps$.MODULE$.$plus$colon$extension(object, (Object)BoxesRunTime.boxToByte((byte)by), ClassTag$.MODULE$.apply(Byte.TYPE)));
    }

    public ByteString sliceByteString(BigInt from, BigInt len, ByteString bs) {
        Object object = Predef$.MODULE$.byteArrayOps(bs.bytes());
        Object object2 = Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.drop$extension(object, from.toInt()));
        return ByteString$.MODULE$.unsafeFromArray((byte[])ArrayOps$.MODULE$.take$extension(object2, len.toInt()));
    }

    public BigInt lengthOfByteString(ByteString bs) {
        return BigInt$.MODULE$.int2bigInt(bs.size());
    }

    public BigInt indexByteString(ByteString bs, BigInt i) {
        if (i.$less((Object)BigInt$.MODULE$.int2bigInt(0)) || i.$greater$eq((Object)BigInt$.MODULE$.int2bigInt(bs.size()))) {
            throw new BuiltinException(new StringBuilder(46).append("index ").append(i).append(" out of bounds for bytestring of length ").append(bs.size()).toString());
        }
        return package$.MODULE$.BigInt().apply(bs.bytes()[i.toInt()] & 0xFF);
    }

    public boolean equalsByteString(ByteString a, ByteString b) {
        ByteString byteString = a;
        ByteString byteString2 = b;
        return !(byteString != null ? !((Object)byteString).equals(byteString2) : byteString2 != null);
    }

    public boolean lessThanByteString(ByteString a, ByteString b) {
        int minLen = scala.math.package$.MODULE$.min(a.size(), b.size());
        for (int i = 0; i < minLen; ++i) {
            int bi;
            int ai = a.bytes()[i] & 0xFF;
            if (ai < (bi = b.bytes()[i] & 0xFF)) {
                return true;
            }
            if (ai <= bi) continue;
            return false;
        }
        return a.size() < b.size();
    }

    public boolean lessThanEqualsByteString(ByteString a, ByteString b) {
        int minLen = scala.math.package$.MODULE$.min(a.size(), b.size());
        for (int i = 0; i < minLen; ++i) {
            int bi;
            int ai = a.bytes()[i] & 0xFF;
            if (ai < (bi = b.bytes()[i] & 0xFF)) {
                return true;
            }
            if (ai <= bi) continue;
            return false;
        }
        return a.size() <= b.size();
    }

    public ByteString sha2_256(ByteString bs) {
        return this.ps.sha2_256(bs);
    }

    public ByteString sha3_256(ByteString bs) {
        return this.ps.sha3_256(bs);
    }

    public ByteString blake2b_256(ByteString bs) {
        return this.ps.blake2b_256(bs);
    }

    public ByteString blake2b_224(ByteString bs) {
        return this.ps.blake2b_224(bs);
    }

    public boolean verifyEd25519Signature(ByteString pk, ByteString msg, ByteString sig) {
        return this.ps.verifyEd25519Signature(pk, msg, sig);
    }

    public boolean verifyEcdsaSecp256k1Signature(ByteString pk, ByteString msg, ByteString sig) {
        return this.ps.verifyEcdsaSecp256k1Signature(pk, msg, sig);
    }

    public boolean verifySchnorrSecp256k1Signature(ByteString pk, ByteString msg, ByteString sig) {
        return this.ps.verifySchnorrSecp256k1Signature(pk, msg, sig);
    }

    public String appendString(String s1, String s2) {
        return new StringBuilder(0).append(s1).append(s2).toString();
    }

    public boolean equalsString(String s1, String s2) {
        String string = s1;
        String string2 = s2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public ByteString encodeUtf8(String s) {
        return ByteString$.MODULE$.fromArray(s.getBytes("UTF-8"));
    }

    public String decodeUtf8(ByteString bs) {
        return UTF8Decoder$.MODULE$.decode(bs.bytes());
    }

    public <A> A ifThenElse(boolean cond, A a, A b) {
        if (cond) {
            return a;
        }
        return b;
    }

    public <A> A chooseUnit(A a) {
        return a;
    }

    public <A> A trace(String s, A a) {
        Predef$.MODULE$.println((Object)s);
        return a;
    }

    public <A, B> A fstPair(BuiltinPair<A, B> p) {
        return p.fst();
    }

    public <A, B> B sndPair(BuiltinPair<A, B> p) {
        return p.snd();
    }

    public <A, B> B chooseList(BuiltinList<A> l, B e, B ne) {
        if (l.isEmpty()) {
            return e;
        }
        return ne;
    }

    public <A> BuiltinList<A> mkCons(A a, BuiltinList<A> l) {
        return l.$colon$colon(a);
    }

    public <A> A headList(BuiltinList<A> l) {
        return l.head();
    }

    public <A> BuiltinList<A> tailList(BuiltinList<A> l) {
        return l.tail();
    }

    public <A> boolean nullList(BuiltinList<A> l) {
        return l.isEmpty();
    }

    public <A> A chooseData(Data d, A constrCase, A mapCase, A listCase, A iCase, A bCase) {
        Data data = d;
        if (data instanceof Data.Constr) {
            Data.Constr constr = Data$Constr$.MODULE$.unapply((Data.Constr)data);
            long l = constr._1();
            List<Data> list2 = constr._2();
            return constrCase;
        }
        if (data instanceof Data.Map) {
            Data.Map map = Data$Map$.MODULE$.unapply((Data.Map)data);
            List<Tuple2<Data, Data>> list3 = map._1();
            return mapCase;
        }
        if (data instanceof Data.List) {
            Data.List list4 = Data$List$.MODULE$.unapply((Data.List)data);
            List<Data> list5 = list4._1();
            return listCase;
        }
        if (data instanceof Data.I) {
            Data.I i = Data$I$.MODULE$.unapply((Data.I)data);
            BigInt bigInt = i._1();
            return iCase;
        }
        if (data instanceof Data.B) {
            Data.B b = Data$B$.MODULE$.unapply((Data.B)data);
            ByteString byteString = b._1();
            return bCase;
        }
        throw new MatchError((Object)data);
    }

    public Data constrData(BigInt ctor, BuiltinList<Data> args) {
        return Data$Constr$.MODULE$.apply(ctor.toLong(), args.toList());
    }

    public Data mapData(BuiltinList<BuiltinPair<Data, Data>> values) {
        return Data$Map$.MODULE$.apply((List<Tuple2<Data, Data>>)values.toList().map((Function1 & Serializable)p -> Tuple2$.MODULE$.apply(p.fst(), p.snd())));
    }

    public Data listData(BuiltinList<Data> values) {
        return Data$List$.MODULE$.apply(values.toList());
    }

    public Data iData(BigInt value) {
        return Data$I$.MODULE$.apply(value);
    }

    public Data bData(ByteString value) {
        return Data$B$.MODULE$.apply(value);
    }

    public BuiltinPair<BigInt, BuiltinList<Data>> unConstrData(Data d) {
        Data data = d;
        if (data instanceof Data.Constr) {
            Data.Constr constr = Data$Constr$.MODULE$.unapply((Data.Constr)data);
            long l = constr._1();
            List<Data> list2 = constr._2();
            long constr2 = l;
            List<Data> args = list2;
            return BuiltinPair$.MODULE$.apply(BigInt$.MODULE$.long2bigInt(constr2), BuiltinList$.MODULE$.apply(args));
        }
        throw new Exception(new StringBuilder(22).append("not a constructor but ").append(d).toString());
    }

    public BuiltinList<Data> unListData(Data d) {
        Data data = d;
        if (data instanceof Data.List) {
            List<Data> list2;
            Data.List list3 = Data$List$.MODULE$.unapply((Data.List)data);
            List<Data> values = list2 = list3._1();
            return BuiltinList$.MODULE$.apply(values);
        }
        throw new Exception(new StringBuilder(15).append("not a list but ").append(d).toString());
    }

    public BuiltinList<BuiltinPair<Data, Data>> unMapData(Data d) {
        Data data = d;
        if (data instanceof Data.Map) {
            List<Tuple2<Data, Data>> list2;
            Data.Map map = Data$Map$.MODULE$.unapply((Data.Map)data);
            List<Tuple2<Data, Data>> values = list2 = map._1();
            return BuiltinList$.MODULE$.apply(values.map((Function1 & Serializable)x$1 -> {
                Data data = (Data)x$1._1();
                Data data2 = (Data)x$1._2();
                return BuiltinPair$.MODULE$.apply(data, data2);
            }));
        }
        throw new Exception(new StringBuilder(15).append("not a list but ").append(d).toString());
    }

    public BigInt unIData(Data d) {
        Data data = d;
        if (data instanceof Data.I) {
            BigInt bigInt;
            Data.I i = Data$I$.MODULE$.unapply((Data.I)data);
            BigInt value = bigInt = i._1();
            return value;
        }
        throw new Exception(new StringBuilder(19).append("not an integer but ").append(d).toString());
    }

    public ByteString unBData(Data d) {
        Data data = d;
        if (data instanceof Data.B) {
            ByteString byteString;
            Data.B b = Data$B$.MODULE$.unapply((Data.B)data);
            ByteString value = byteString = b._1();
            return value;
        }
        throw new Exception(new StringBuilder(21).append("not a bytestring but ").append(d).toString());
    }

    public boolean equalsData(Data d1, Data d2) {
        Data data = d1;
        Data data2 = d2;
        return !(data != null ? !data.equals(data2) : data2 != null);
    }

    public ByteString serialiseData(Data d) {
        return ByteString$.MODULE$.fromArray(Cbor$.MODULE$.encode((Object)d, (Encoder)Data$.MODULE$.dataCborEncoder()).toByteArray());
    }

    public BuiltinPair<Data, Data> mkPairData(Data fst, Data snd) {
        return BuiltinPair$.MODULE$.apply(fst, snd);
    }

    public BuiltinList<Data> mkNilData() {
        return BuiltinList$.MODULE$.empty();
    }

    public BuiltinList<BuiltinPair<Data, Data>> mkNilPairData() {
        return BuiltinList$.MODULE$.empty();
    }

    public ByteString integerToByteString(boolean endianness, BigInt length, BigInt input) {
        return IntegerToByteString$.MODULE$.integerToByteString(endianness, length, input);
    }

    public BigInt byteStringToInteger(boolean endianness, ByteString input) {
        return ByteStringToInteger$.MODULE$.byteStringToInteger(endianness, input);
    }

    public ByteString andByteString(boolean shouldPad, ByteString lhs, ByteString rhs) {
        return BitwiseLogicalOperations$.MODULE$.andByteString(shouldPad, lhs, rhs);
    }

    public ByteString orByteString(boolean shouldPad, ByteString lhs, ByteString rhs) {
        return BitwiseLogicalOperations$.MODULE$.orByteString(shouldPad, lhs, rhs);
    }

    public ByteString xorByteString(boolean shouldPad, ByteString lhs, ByteString rhs) {
        return BitwiseLogicalOperations$.MODULE$.xorByteString(shouldPad, lhs, rhs);
    }

    public ByteString complementByteString(ByteString byteString) {
        return BitwiseLogicalOperations$.MODULE$.complementByteString(byteString);
    }

    public boolean readBit(ByteString byteString, BigInt index) {
        return BitwiseLogicalOperations$.MODULE$.readBit(byteString, index);
    }

    public ByteString writeBits(ByteString byteString, List<BigInt> indexes, boolean bit) {
        return BitwiseLogicalOperations$.MODULE$.writeBits(byteString, (Seq<BigInt>)indexes, bit);
    }

    public ByteString replicateByte(BigInt length, BigInt bigInt) {
        return BitwiseLogicalOperations$.MODULE$.replicateByte(length, bigInt);
    }

    public ByteString shiftByteString(ByteString byteString, BigInt shift) {
        return BitwiseLogicalOperations$.MODULE$.shiftByteString(byteString, shift);
    }

    public ByteString rotateByteString(ByteString byteString, BigInt rotation) {
        return BitwiseLogicalOperations$.MODULE$.rotateByteString(byteString, rotation);
    }

    public BigInt countSetBits(ByteString byteString) {
        return BigInt$.MODULE$.int2bigInt(BitwiseLogicalOperations$.MODULE$.countSetBits(byteString));
    }

    public BigInt findFirstSetBit(ByteString byteString) {
        return BigInt$.MODULE$.int2bigInt(BitwiseLogicalOperations$.MODULE$.findFirstSetBit(byteString));
    }

    public boolean bls12_381_G1_equal(BLS12_381_G1_Element p1, BLS12_381_G1_Element p2) {
        return this.ps.bls12_381_G1_equal(p1, p2);
    }

    public BLS12_381_G1_Element bls12_381_G1_add(BLS12_381_G1_Element p1, BLS12_381_G1_Element p2) {
        return this.ps.bls12_381_G1_add(p1, p2);
    }

    public BLS12_381_G1_Element bls12_381_G1_scalarMul(BigInt s, BLS12_381_G1_Element p) {
        return this.ps.bls12_381_G1_scalarMul(s, p);
    }

    public BLS12_381_G1_Element bls12_381_G1_neg(BLS12_381_G1_Element p) {
        return this.ps.bls12_381_G1_neg(p);
    }

    public ByteString bls12_381_G1_compress(BLS12_381_G1_Element p) {
        return this.ps.bls12_381_G1_compress(p);
    }

    public BLS12_381_G1_Element bls12_381_G1_uncompress(ByteString bs) {
        return this.ps.bls12_381_G1_uncompress(bs);
    }

    public BLS12_381_G1_Element bls12_381_G1_hashToGroup(ByteString bs, ByteString dst) {
        return this.ps.bls12_381_G1_hashToGroup(bs, dst);
    }

    public boolean bls12_381_G2_equal(BLS12_381_G2_Element p1, BLS12_381_G2_Element p2) {
        return this.ps.bls12_381_G2_equal(p1, p2);
    }

    public BLS12_381_G2_Element bls12_381_G2_add(BLS12_381_G2_Element p1, BLS12_381_G2_Element p2) {
        return this.ps.bls12_381_G2_add(p1, p2);
    }

    public BLS12_381_G2_Element bls12_381_G2_scalarMul(BigInt s, BLS12_381_G2_Element p) {
        return this.ps.bls12_381_G2_scalarMul(s, p);
    }

    public BLS12_381_G2_Element bls12_381_G2_neg(BLS12_381_G2_Element p) {
        return this.ps.bls12_381_G2_neg(p);
    }

    public ByteString bls12_381_G2_compress(BLS12_381_G2_Element p) {
        return this.ps.bls12_381_G2_compress(p);
    }

    public BLS12_381_G2_Element bls12_381_G2_uncompress(ByteString bs) {
        return this.ps.bls12_381_G2_uncompress(bs);
    }

    public BLS12_381_G2_Element bls12_381_G2_hashToGroup(ByteString bs, ByteString dst) {
        return this.ps.bls12_381_G2_hashToGroup(bs, dst);
    }

    public ByteString bls12_381_G2_compressed_zero() {
        return PlatformSpecific$.MODULE$.bls12_381_G2_compressed_zero();
    }

    public ByteString bls12_381_G2_compressed_generator() {
        return PlatformSpecific$.MODULE$.bls12_381_G2_compressed_generator();
    }

    public BLS12_381_MlResult bls12_381_millerLoop(BLS12_381_G1_Element p1, BLS12_381_G2_Element p2) {
        return this.ps.bls12_381_millerLoop(p1, p2);
    }

    public BLS12_381_MlResult bls12_381_mulMlResult(BLS12_381_MlResult r1, BLS12_381_MlResult r2) {
        return this.ps.bls12_381_mulMlResult(r1, r2);
    }

    public boolean bls12_381_finalVerify(BLS12_381_MlResult p1, BLS12_381_MlResult p2) {
        return this.ps.bls12_381_finalVerify(p1, p2);
    }

    public ByteString keccak_256(ByteString bs) {
        return this.ps.keccak_256(bs);
    }

    public ByteString ripemd_160(ByteString byteString) {
        return this.ps.ripemd_160(byteString);
    }
}

