/*
 * Decompiled with CFR 0.152.
 */
package scalus.builtin;

import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scalus.builtin.ByteString;
import scalus.builtin.ByteString$;
import scalus.builtin.IntegerToByteString$;
import scalus.uplc.eval.BuiltinException;

public final class BitwiseLogicalOperations$
implements Serializable {
    public static final BitwiseLogicalOperations$ MODULE$ = new BitwiseLogicalOperations$();

    private BitwiseLogicalOperations$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BitwiseLogicalOperations$.class);
    }

    public ByteString andByteString(boolean shouldPad, ByteString lhs, ByteString rhs) {
        Tuple2 tuple2 = lhs.size() < rhs.size() ? Tuple2$.MODULE$.apply((Object)lhs.bytes(), (Object)rhs.bytes()) : Tuple2$.MODULE$.apply((Object)rhs.bytes(), (Object)lhs.bytes());
        byte[] shortArray = (byte[])tuple2._1();
        byte[] longArray = (byte[])tuple2._2();
        byte[] resultArray = new byte[shouldPad ? longArray.length : shortArray.length];
        int shortArrayLength = shortArray.length;
        for (int index = 0; index < shortArrayLength; ++index) {
            byte by = shortArray[index];
            byte by2 = longArray[index];
            resultArray[index] = (byte)(by & by2);
        }
        if (shouldPad && shortArray.length != longArray.length) {
            System.arraycopy(longArray, shortArray.length, resultArray, shortArray.length, longArray.length - shortArray.length);
        }
        return ByteString$.MODULE$.unsafeFromArray(resultArray);
    }

    public ByteString orByteString(boolean shouldPad, ByteString lhs, ByteString rhs) {
        Tuple2 tuple2 = lhs.size() < rhs.size() ? Tuple2$.MODULE$.apply((Object)lhs.bytes(), (Object)rhs.bytes()) : Tuple2$.MODULE$.apply((Object)rhs.bytes(), (Object)lhs.bytes());
        byte[] shortArray = (byte[])tuple2._1();
        byte[] longArray = (byte[])tuple2._2();
        byte[] resultArray = new byte[shouldPad ? longArray.length : shortArray.length];
        int shortArrayLength = shortArray.length;
        for (int index = 0; index < shortArrayLength; ++index) {
            byte by = shortArray[index];
            byte by2 = longArray[index];
            resultArray[index] = (byte)(by | by2);
        }
        if (shouldPad && shortArray.length != longArray.length) {
            System.arraycopy(longArray, shortArray.length, resultArray, shortArray.length, longArray.length - shortArray.length);
        }
        return ByteString$.MODULE$.unsafeFromArray(resultArray);
    }

    public ByteString xorByteString(boolean shouldPad, ByteString lhs, ByteString rhs) {
        Tuple2 tuple2 = lhs.size() < rhs.size() ? Tuple2$.MODULE$.apply((Object)lhs.bytes(), (Object)rhs.bytes()) : Tuple2$.MODULE$.apply((Object)rhs.bytes(), (Object)lhs.bytes());
        byte[] shortArray = (byte[])tuple2._1();
        byte[] longArray = (byte[])tuple2._2();
        byte[] resultArray = new byte[shouldPad ? longArray.length : shortArray.length];
        int shortArrayLength = shortArray.length;
        for (int index = 0; index < shortArrayLength; ++index) {
            byte by = shortArray[index];
            byte by2 = longArray[index];
            resultArray[index] = (byte)(by ^ by2);
        }
        if (shouldPad && shortArray.length != longArray.length) {
            System.arraycopy(longArray, shortArray.length, resultArray, shortArray.length, longArray.length - shortArray.length);
        }
        return ByteString$.MODULE$.unsafeFromArray(resultArray);
    }

    public ByteString complementByteString(ByteString byteString) {
        byte[] inputArray = byteString.bytes();
        int inputArrayLength = inputArray.length;
        byte[] resultArray = new byte[inputArrayLength];
        for (int index = 0; index < inputArrayLength; ++index) {
            byte by = inputArray[index];
            resultArray[index] = (byte)(by ^ 0xFF);
        }
        return ByteString$.MODULE$.unsafeFromArray(resultArray);
    }

    public boolean readBit(ByteString byteString, BigInt index) {
        int bitIndex;
        if (byteString.isEmpty()) {
            throw new BuiltinException(new StringBuilder(68).append("readBit: Index out of bounds, because byte string is empty, actual: ").append(index).toString());
        }
        byte[] bytes = byteString.bytes();
        int bitLength = bytes.length * 8;
        if (index.$less((Object)BigInt$.MODULE$.int2bigInt(0)) || index.$greater$eq((Object)BigInt$.MODULE$.int2bigInt(bitLength))) {
            throw new BuiltinException(new StringBuilder(57).append("readBit: Index out of bounds, expected: [0 .. ").append(bitLength).append("), actual: ").append(index).toString());
        }
        int currentIndex = index.toInt();
        int byteIndex = (bitLength - 1 - currentIndex) / 8;
        return (bytes[byteIndex] >> (bitIndex = currentIndex % 8) & 1) == 1;
    }

    public ByteString writeBits(ByteString byteString, Seq<BigInt> indexes, boolean bit) {
        if (indexes.isEmpty()) {
            return byteString;
        }
        if (byteString.isEmpty()) {
            throw new BuiltinException(new StringBuilder(72).append("writeBits: Indexes out of bounds, because byte string is empty, actual: ").append(indexes).toString());
        }
        byte[] resultArray = (byte[])byteString.bytes().clone();
        int bitLength = resultArray.length * 8;
        int bitValue = bit ? 1 : 0;
        indexes.foreach((Function1)(JProcedure1 & Serializable)index -> {
            if (index.$less((Object)BigInt$.MODULE$.int2bigInt(0)) || index.$greater$eq((Object)BigInt$.MODULE$.int2bigInt(bitLength))) {
                throw new BuiltinException(new StringBuilder(59).append("writeBits: Index out of bounds, expected: [0 .. ").append(bitLength).append("), actual: ").append(index).toString());
            }
            int currentIndex = index.toInt();
            int byteIndex = (bitLength - 1 - currentIndex) / 8;
            int bitIndex = currentIndex % 8;
            if (bitValue == 1) {
                resultArray$1[byteIndex] = (byte)(resultArray[byteIndex] | 1 << bitIndex);
                return;
            }
            resultArray$1[byteIndex] = (byte)(resultArray[byteIndex] & ~(1 << bitIndex));
        });
        return ByteString$.MODULE$.unsafeFromArray(resultArray);
    }

    public ByteString replicateByte(BigInt length, BigInt bigInt) {
        if (length.$less((Object)BigInt$.MODULE$.int2bigInt(0)) || length.$greater((Object)BigInt$.MODULE$.int2bigInt(IntegerToByteString$.MODULE$.maximumOutputLength()))) {
            throw new BuiltinException(new StringBuilder(74).append("replicateByte: requested length out of bounds, expected: [0 .. ").append(IntegerToByteString$.MODULE$.maximumOutputLength()).append("], actual: ").append(length).toString());
        }
        if (bigInt.$less((Object)BigInt$.MODULE$.int2bigInt(0)) || bigInt.$greater((Object)BigInt$.MODULE$.int2bigInt(255))) {
            throw new BuiltinException(new StringBuilder(71).append("replicateByte: byte value out of bounds, expected: [0 .. 255], actual: ").append(bigInt).toString());
        }
        int lengthValue = length.toInt();
        byte byteValue = bigInt.toByte();
        if (lengthValue == 0) {
            return ByteString$.MODULE$.empty();
        }
        return ByteString$.MODULE$.fill(lengthValue, byteValue);
    }

    public ByteString shiftByteString(ByteString byteString, BigInt shift) {
        if (byteString.isEmpty() || BoxesRunTime.equals((Object)shift, (Object)BoxesRunTime.boxToInteger((int)0))) {
            return byteString;
        }
        byte[] bytes = byteString.bytes();
        int bytesLength = bytes.length;
        if (BigInt$.MODULE$.int2bigInt(bytesLength * 8).$less((Object)shift.abs())) {
            return ByteString$.MODULE$.unsafeFromArray(new byte[bytesLength]);
        }
        if (shift.$less((Object)BigInt$.MODULE$.int2bigInt(Integer.MIN_VALUE)) || shift.$greater((Object)BigInt$.MODULE$.int2bigInt(Integer.MAX_VALUE))) {
            throw new BuiltinException(new StringBuilder(105).append("shiftByteString: shift out of bounds, expected: [").append(Integer.MIN_VALUE).append(" .. ").append(Integer.MAX_VALUE).append("], actual: ").append(shift).toString());
        }
        int shiftValue = shift.toInt();
        byte[] resultArray = shiftValue > 0 ? this.shiftLeft(bytes, shiftValue) : this.shiftRight(bytes, RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(shiftValue)));
        return ByteString$.MODULE$.unsafeFromArray(resultArray);
    }

    public ByteString rotateByteString(ByteString byteString, BigInt rotation) {
        if (byteString.isEmpty()) {
            return byteString;
        }
        byte[] bytes = byteString.bytes();
        int bytesLength = bytes.length;
        int bitLength = bytesLength * 8;
        BigInt rotationRemainder = rotation.$percent(BigInt$.MODULE$.int2bigInt(bitLength));
        if (BoxesRunTime.equals((Object)rotationRemainder, (Object)BoxesRunTime.boxToInteger((int)0))) {
            return byteString;
        }
        if (rotationRemainder.$less((Object)BigInt$.MODULE$.int2bigInt(Integer.MIN_VALUE)) || rotationRemainder.$greater((Object)BigInt$.MODULE$.int2bigInt(Integer.MAX_VALUE))) {
            throw new BuiltinException(new StringBuilder(112).append("rotateByteString: rotation remainder to big, expected: [").append(Integer.MIN_VALUE).append(" .. ").append(Integer.MAX_VALUE).append("], actual: ").append(rotationRemainder).toString());
        }
        int rotationValue = rotationRemainder.toInt();
        byte[] resultArray = rotationValue > 0 ? this.rotateLeft(bytes, rotationValue) : this.rotateRight(bytes, RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(rotationValue)));
        return ByteString$.MODULE$.unsafeFromArray(resultArray);
    }

    public int countSetBits(ByteString byteString) {
        if (byteString.isEmpty()) {
            return 0;
        }
        byte[] bytes = byteString.bytes();
        int bytesLength = bytes.length;
        int count = 0;
        for (int index = 0; index < bytesLength; ++index) {
            for (int value = bytes[index] & 0xFF; value != 0; value >>>= 1) {
                count += value & 1;
            }
        }
        return count;
    }

    public int findFirstSetBit(ByteString byteString) {
        if (byteString.isEmpty()) {
            return -1;
        }
        byte[] bytes = byteString.bytes();
        int bytesLength = bytes.length;
        int totalBitIndex = 0;
        for (int index = bytesLength - 1; index >= 0; --index) {
            int localBitIndex = 0;
            for (int value = bytes[index] & 0xFF; value != 0; value >>>= 1) {
                if ((value & 1) == 1) {
                    return totalBitIndex + localBitIndex;
                }
                ++localBitIndex;
            }
            totalBitIndex += 8;
        }
        return -1;
    }

    private byte[] shiftLeft(byte[] inputBytes, int shift) {
        int shiftMod = shift % 8;
        byte carryMask = (byte)((1 << shiftMod) - 1);
        int offsetBytes = shift / 8;
        int bytesLength = inputBytes.length;
        byte[] resultBytes = new byte[bytesLength];
        for (int index = 0; index < bytesLength; ++index) {
            int sourceIndex = index + offsetBytes;
            if (sourceIndex >= bytesLength) {
                resultBytes[index] = 0;
                continue;
            }
            byte src = inputBytes[sourceIndex];
            byte dst = (byte)(src << shiftMod);
            if (sourceIndex + 1 < bytesLength) {
                dst = (byte)(dst | inputBytes[sourceIndex + 1] >>> 8 - shiftMod & carryMask);
            }
            resultBytes[index] = dst;
        }
        return resultBytes;
    }

    private byte[] shiftRight(byte[] inputBytes, int shift) {
        int shiftMod = shift % 8;
        byte carryMask = (byte)(255 << 8 - shiftMod);
        int offsetBytes = shift / 8;
        int bytesLength = inputBytes.length;
        byte[] resultBytes = new byte[bytesLength];
        for (int index = bytesLength - 1; index >= 0; --index) {
            int sourceIndex = index - offsetBytes;
            if (sourceIndex < 0) {
                resultBytes[index] = 0;
                continue;
            }
            byte src = inputBytes[sourceIndex];
            byte dst = (byte)((src & 0xFF) >>> shiftMod);
            if (sourceIndex - 1 >= 0) {
                dst = (byte)(dst | inputBytes[sourceIndex - 1] << 8 - shiftMod & carryMask);
            }
            resultBytes[index] = dst;
        }
        return resultBytes;
    }

    private byte[] rotateLeft(byte[] inputBytes, int rotation) {
        int shiftMod = rotation % 8;
        byte carryMask = (byte)((1 << shiftMod) - 1);
        int offsetBytes = rotation / 8;
        int bytesLength = inputBytes.length;
        byte[] resultBytes = new byte[bytesLength];
        for (int index = 0; index < bytesLength; ++index) {
            int sourceIndex = (index + offsetBytes) % bytesLength;
            byte src = inputBytes[sourceIndex];
            byte dst = (byte)(src << shiftMod);
            resultBytes[index] = dst = (byte)(dst | inputBytes[sourceIndex + 1 < bytesLength ? sourceIndex + 1 : 0] >>> 8 - shiftMod & carryMask);
        }
        return resultBytes;
    }

    private byte[] rotateRight(byte[] inputBytes, int rotation) {
        int shiftMod = rotation % 8;
        byte carryMask = (byte)(255 << 8 - shiftMod);
        int offsetBytes = rotation / 8;
        int bytesLength = inputBytes.length;
        int lastByteIndex = bytesLength - 1;
        byte[] resultBytes = new byte[bytesLength];
        for (int index = bytesLength - 1; index >= 0; --index) {
            int diff = index - offsetBytes;
            int sourceIndex = diff >= 0 ? diff : bytesLength + diff;
            byte src = inputBytes[sourceIndex];
            byte dst = (byte)((src & 0xFF) >>> shiftMod);
            resultBytes[index] = dst = (byte)(dst | inputBytes[sourceIndex > 0 ? sourceIndex - 1 : lastByteIndex] << 8 - shiftMod & carryMask);
        }
        return resultBytes;
    }
}

