/*
 * Decompiled with CFR 0.152.
 */
package scalus.cardano.address;

import java.io.Serializable;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;
import scala.util.Try$;
import scalus.builtin.ByteString;
import scalus.builtin.ByteString$;
import scalus.cardano.address.Address;
import scalus.cardano.address.Address$given_Decoder_Address$;
import scalus.cardano.address.Address$given_Encoder_Address$;
import scalus.cardano.address.ByronAddress;
import scalus.cardano.address.ByronAddress$;
import scalus.cardano.address.Network;
import scalus.cardano.address.Network$;
import scalus.cardano.address.Pointer;
import scalus.cardano.address.Pointer$;
import scalus.cardano.address.ShelleyAddress;
import scalus.cardano.address.ShelleyAddress$;
import scalus.cardano.address.ShelleyDelegationPart;
import scalus.cardano.address.ShelleyDelegationPart$;
import scalus.cardano.address.ShelleyDelegationPart$Key$;
import scalus.cardano.address.ShelleyDelegationPart$Pointer$;
import scalus.cardano.address.ShelleyDelegationPart$Script$;
import scalus.cardano.address.ShelleyPaymentPart;
import scalus.cardano.address.ShelleyPaymentPart$Key$;
import scalus.cardano.address.ShelleyPaymentPart$Script$;
import scalus.cardano.address.StakeAddress;
import scalus.cardano.address.StakeAddress$;
import scalus.cardano.address.StakePayload;
import scalus.cardano.address.StakePayload$Script$;
import scalus.cardano.address.StakePayload$Stake$;
import scalus.cardano.ledger.Bech32$;
import scalus.cardano.ledger.Credential;
import scalus.cardano.ledger.Credential$KeyHash$;
import scalus.cardano.ledger.Credential$ScriptHash$;
import scalus.cardano.ledger.Hashes$package$AddrKeyHash$;
import scalus.cardano.ledger.Hashes$package$Hash$;

public final class Address$
implements Mirror.Sum,
Serializable {
    public static final Address$given_Encoder_Address$ given_Encoder_Address;
    public static final Address$given_Decoder_Address$ given_Decoder_Address;
    public static final Address$ MODULE$;

    private Address$() {
    }

    static {
        MODULE$ = new Address$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Address$.class);
    }

    public Address apply(Network network, Credential payment, Credential delegation) {
        ShelleyDelegationPart shelleyDelegationPart;
        ShelleyPaymentPart shelleyPaymentPart;
        Credential credential = payment;
        if (credential instanceof Credential.KeyHash) {
            ByteString byteString;
            Credential.KeyHash keyHash = Credential$KeyHash$.MODULE$.unapply((Credential.KeyHash)credential);
            ByteString hash = byteString = keyHash._1();
            shelleyPaymentPart = ShelleyPaymentPart$Key$.MODULE$.apply(hash);
        } else if (credential instanceof Credential.ScriptHash) {
            ByteString byteString;
            Credential.ScriptHash scriptHash = Credential$ScriptHash$.MODULE$.unapply((Credential.ScriptHash)credential);
            ByteString hash = byteString = scriptHash._1();
            shelleyPaymentPart = ShelleyPaymentPart$Script$.MODULE$.apply(hash);
        } else {
            throw new MatchError((Object)credential);
        }
        ShelleyPaymentPart.Key paymentPart = shelleyPaymentPart;
        Credential credential2 = delegation;
        if (credential2 instanceof Credential.KeyHash) {
            ByteString byteString;
            Credential.KeyHash keyHash = Credential$KeyHash$.MODULE$.unapply((Credential.KeyHash)credential2);
            ByteString hash = byteString = keyHash._1();
            shelleyDelegationPart = ShelleyDelegationPart$Key$.MODULE$.apply(hash);
        } else if (credential2 instanceof Credential.ScriptHash) {
            ByteString byteString;
            Credential.ScriptHash scriptHash = Credential$ScriptHash$.MODULE$.unapply((Credential.ScriptHash)credential2);
            ByteString hash = byteString = scriptHash._1();
            shelleyDelegationPart = ShelleyDelegationPart$Script$.MODULE$.apply(hash);
        } else {
            throw new MatchError((Object)credential2);
        }
        ShelleyDelegationPart.Key delegationPart = shelleyDelegationPart;
        return ShelleyAddress$.MODULE$.apply(network, paymentPart, delegationPart);
    }

    public Address apply(Network network, Credential payment) {
        ShelleyPaymentPart shelleyPaymentPart;
        Credential credential = payment;
        if (credential instanceof Credential.KeyHash) {
            ByteString byteString;
            Credential.KeyHash keyHash = Credential$KeyHash$.MODULE$.unapply((Credential.KeyHash)credential);
            ByteString hash = byteString = keyHash._1();
            shelleyPaymentPart = ShelleyPaymentPart$Key$.MODULE$.apply(hash);
        } else if (credential instanceof Credential.ScriptHash) {
            ByteString byteString;
            Credential.ScriptHash scriptHash = Credential$ScriptHash$.MODULE$.unapply((Credential.ScriptHash)credential);
            ByteString hash = byteString = scriptHash._1();
            shelleyPaymentPart = ShelleyPaymentPart$Script$.MODULE$.apply(hash);
        } else {
            throw new MatchError((Object)credential);
        }
        ShelleyPaymentPart.Key paymentPart = shelleyPaymentPart;
        return ShelleyAddress$.MODULE$.apply(network, paymentPart, ShelleyDelegationPart$.Null);
    }

    public Address fromByteString(ByteString bs) {
        return this.fromBytes(bs.bytes());
    }

    public Address fromBytes(byte[] bytes) {
        int addressType;
        Object object = Predef$.MODULE$.byteArrayOps(bytes);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(object), Address$::fromBytes$$anonfun$3);
        Object object2 = Predef$.MODULE$.byteArrayOps(bytes);
        byte header = BoxesRunTime.unboxToByte((Object)ArrayOps$.MODULE$.head$extension(object2));
        Object object3 = Predef$.MODULE$.byteArrayOps(bytes);
        byte[] payload = (byte[])ArrayOps$.MODULE$.tail$extension(object3);
        int n = addressType = (header & 0xF0) >> 4;
        switch (n) {
            case 0: {
                return this.parseType0(header, payload);
            }
            case 1: {
                return this.parseType1(header, payload);
            }
            case 2: {
                return this.parseType2(header, payload);
            }
            case 3: {
                return this.parseType3(header, payload);
            }
            case 4: {
                return this.parseType4(header, payload);
            }
            case 5: {
                return this.parseType5(header, payload);
            }
            case 6: {
                return this.parseType6(header, payload);
            }
            case 7: {
                return this.parseType7(header, payload);
            }
            case 8: {
                return this.parseType8(header, payload);
            }
            case 14: {
                return this.parseType14(header, payload);
            }
            case 15: {
                return this.parseType15(header, payload);
            }
        }
        throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("Unsupported address type: 0x%02x", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)addressType)})));
    }

    public Address fromBech32(String bech32) {
        return this.fromBytes(Bech32$.MODULE$.decode(bech32).data());
    }

    public Address fromString(String str) {
        return (Address)Try$.MODULE$.apply(() -> Address$.fromString$$anonfun$1(str)).orElse(() -> Address$.fromString$$anonfun$2(str)).get();
    }

    private Address parseType0(byte header, byte[] payload) {
        Predef$.MODULE$.require(payload.length == 56, () -> Address$.parseType0$$anonfun$1(payload));
        Network network = Network$.MODULE$.fromByte((byte)(header & 0xF));
        Object object = Predef$.MODULE$.byteArrayOps(payload);
        ByteString paymentHash = Hashes$package$AddrKeyHash$.MODULE$.apply(ByteString$.MODULE$.fromArray((byte[])ArrayOps$.MODULE$.slice$extension(object, 0, 28)));
        Object object2 = Predef$.MODULE$.byteArrayOps(payload);
        ByteString stakeHash = Hashes$package$Hash$.MODULE$.stakeKeyHash(ByteString$.MODULE$.fromArray((byte[])ArrayOps$.MODULE$.slice$extension(object2, 28, 56)));
        ShelleyPaymentPart.Key payment = ShelleyPaymentPart$Key$.MODULE$.apply(paymentHash);
        ShelleyDelegationPart.Key delegation = ShelleyDelegationPart$Key$.MODULE$.apply(stakeHash);
        return ShelleyAddress$.MODULE$.apply(network, payment, delegation);
    }

    private Address parseType1(byte header, byte[] payload) {
        Predef$.MODULE$.require(payload.length == 56, () -> Address$.parseType1$$anonfun$1(payload));
        Network network = Network$.MODULE$.fromByte((byte)(header & 0xF));
        Object object = Predef$.MODULE$.byteArrayOps(payload);
        ByteString scriptHash = Hashes$package$Hash$.MODULE$.scriptHash(ByteString$.MODULE$.fromArray((byte[])ArrayOps$.MODULE$.slice$extension(object, 0, 28)));
        Object object2 = Predef$.MODULE$.byteArrayOps(payload);
        ByteString stakeHash = Hashes$package$Hash$.MODULE$.stakeKeyHash(ByteString$.MODULE$.fromArray((byte[])ArrayOps$.MODULE$.slice$extension(object2, 28, 56)));
        ShelleyPaymentPart.Script payment = ShelleyPaymentPart$Script$.MODULE$.apply(scriptHash);
        ShelleyDelegationPart.Key delegation = ShelleyDelegationPart$Key$.MODULE$.apply(stakeHash);
        return ShelleyAddress$.MODULE$.apply(network, payment, delegation);
    }

    private Address parseType2(byte header, byte[] payload) {
        Predef$.MODULE$.require(payload.length == 56, () -> Address$.parseType2$$anonfun$1(payload));
        Network network = Network$.MODULE$.fromByte((byte)(header & 0xF));
        Object object = Predef$.MODULE$.byteArrayOps(payload);
        ByteString paymentHash = Hashes$package$AddrKeyHash$.MODULE$.apply(ByteString$.MODULE$.fromArray((byte[])ArrayOps$.MODULE$.slice$extension(object, 0, 28)));
        Object object2 = Predef$.MODULE$.byteArrayOps(payload);
        ByteString scriptHash = Hashes$package$Hash$.MODULE$.scriptHash(ByteString$.MODULE$.fromArray((byte[])ArrayOps$.MODULE$.slice$extension(object2, 28, 56)));
        ShelleyPaymentPart.Key payment = ShelleyPaymentPart$Key$.MODULE$.apply(paymentHash);
        ShelleyDelegationPart.Script delegation = ShelleyDelegationPart$Script$.MODULE$.apply(scriptHash);
        return ShelleyAddress$.MODULE$.apply(network, payment, delegation);
    }

    private Address parseType3(byte header, byte[] payload) {
        Predef$.MODULE$.require(payload.length == 56, () -> Address$.parseType3$$anonfun$1(payload));
        Network network = Network$.MODULE$.fromByte((byte)(header & 0xF));
        Object object = Predef$.MODULE$.byteArrayOps(payload);
        ByteString scriptHash1 = Hashes$package$Hash$.MODULE$.scriptHash(ByteString$.MODULE$.fromArray((byte[])ArrayOps$.MODULE$.slice$extension(object, 0, 28)));
        Object object2 = Predef$.MODULE$.byteArrayOps(payload);
        ByteString scriptHash2 = Hashes$package$Hash$.MODULE$.scriptHash(ByteString$.MODULE$.fromArray((byte[])ArrayOps$.MODULE$.slice$extension(object2, 28, 56)));
        ShelleyPaymentPart.Script payment = ShelleyPaymentPart$Script$.MODULE$.apply(scriptHash1);
        ShelleyDelegationPart.Script delegation = ShelleyDelegationPart$Script$.MODULE$.apply(scriptHash2);
        return ShelleyAddress$.MODULE$.apply(network, payment, delegation);
    }

    private Address parseType4(byte header, byte[] payload) {
        Predef$.MODULE$.require(payload.length > 28, () -> Address$.parseType4$$anonfun$1(payload));
        Network network = Network$.MODULE$.fromByte((byte)(header & 0xF));
        Object object = Predef$.MODULE$.byteArrayOps(payload);
        ByteString paymentHash = Hashes$package$AddrKeyHash$.MODULE$.apply(ByteString$.MODULE$.fromArray((byte[])ArrayOps$.MODULE$.slice$extension(object, 0, 28)));
        Object object2 = Predef$.MODULE$.byteArrayOps(payload);
        byte[] pointerBytes = (byte[])ArrayOps$.MODULE$.slice$extension(object2, 28, payload.length);
        Pointer pointer = (Pointer)Pointer$.MODULE$.fromBytes(pointerBytes).getOrElse(Address$::$anonfun$1);
        ShelleyPaymentPart.Key payment = ShelleyPaymentPart$Key$.MODULE$.apply(paymentHash);
        ShelleyDelegationPart.Pointer delegation = ShelleyDelegationPart$Pointer$.MODULE$.apply(pointer);
        return ShelleyAddress$.MODULE$.apply(network, payment, delegation);
    }

    private Address parseType5(byte header, byte[] payload) {
        Predef$.MODULE$.require(payload.length > 28, () -> Address$.parseType5$$anonfun$1(payload));
        Network network = Network$.MODULE$.fromByte((byte)(header & 0xF));
        Object object = Predef$.MODULE$.byteArrayOps(payload);
        ByteString scriptHash = Hashes$package$Hash$.MODULE$.scriptHash(ByteString$.MODULE$.fromArray((byte[])ArrayOps$.MODULE$.slice$extension(object, 0, 28)));
        Object object2 = Predef$.MODULE$.byteArrayOps(payload);
        byte[] pointerBytes = (byte[])ArrayOps$.MODULE$.slice$extension(object2, 28, payload.length);
        Pointer pointer = (Pointer)Pointer$.MODULE$.fromBytes(pointerBytes).getOrElse(Address$::$anonfun$2);
        ShelleyPaymentPart.Script payment = ShelleyPaymentPart$Script$.MODULE$.apply(scriptHash);
        ShelleyDelegationPart.Pointer delegation = ShelleyDelegationPart$Pointer$.MODULE$.apply(pointer);
        return ShelleyAddress$.MODULE$.apply(network, payment, delegation);
    }

    private Address parseType6(byte header, byte[] payload) {
        Predef$.MODULE$.require(payload.length == 28, () -> Address$.parseType6$$anonfun$1(payload));
        Network network = Network$.MODULE$.fromByte((byte)(header & 0xF));
        ByteString paymentHash = Hashes$package$AddrKeyHash$.MODULE$.apply(ByteString$.MODULE$.fromArray(payload));
        ShelleyPaymentPart.Key payment = ShelleyPaymentPart$Key$.MODULE$.apply(paymentHash);
        ShelleyDelegationPart delegation = ShelleyDelegationPart$.Null;
        return ShelleyAddress$.MODULE$.apply(network, payment, delegation);
    }

    private Address parseType7(byte header, byte[] payload) {
        Predef$.MODULE$.require(payload.length == 28, () -> Address$.parseType7$$anonfun$1(payload));
        Network network = Network$.MODULE$.fromByte((byte)(header & 0xF));
        ByteString scriptHash = Hashes$package$Hash$.MODULE$.scriptHash(ByteString$.MODULE$.fromArray(payload));
        ShelleyPaymentPart.Script payment = ShelleyPaymentPart$Script$.MODULE$.apply(scriptHash);
        ShelleyDelegationPart delegation = ShelleyDelegationPart$.Null;
        return ShelleyAddress$.MODULE$.apply(network, payment, delegation);
    }

    private Address parseType8(byte header, byte[] payload) {
        Object object = Predef$.MODULE$.byteArrayOps(payload);
        byte[] fullBytes = (byte[])ArrayOps$.MODULE$.$plus$colon$extension(object, (Object)BoxesRunTime.boxToByte((byte)header), ClassTag$.MODULE$.apply(Byte.TYPE));
        return ByronAddress$.MODULE$.apply(ByteString$.MODULE$.fromArray(fullBytes));
    }

    private Address parseType14(byte header, byte[] payload) {
        Predef$.MODULE$.require(payload.length == 28, () -> Address$.parseType14$$anonfun$1(payload));
        Network network = Network$.MODULE$.fromByte((byte)(header & 0xF));
        ByteString stakeHash = Hashes$package$Hash$.MODULE$.stakeKeyHash(ByteString$.MODULE$.fromArray(payload));
        StakePayload.Stake stakePayload = StakePayload$Stake$.MODULE$.apply(stakeHash);
        return StakeAddress$.MODULE$.apply(network, stakePayload);
    }

    private Address parseType15(byte header, byte[] payload) {
        Predef$.MODULE$.require(payload.length == 28, () -> Address$.parseType15$$anonfun$1(payload));
        Network network = Network$.MODULE$.fromByte((byte)(header & 0xF));
        ByteString scriptHash = Hashes$package$Hash$.MODULE$.scriptHash(ByteString$.MODULE$.fromArray(payload));
        StakePayload.Script stakePayload = StakePayload$Script$.MODULE$.apply(scriptHash);
        return StakeAddress$.MODULE$.apply(network, stakePayload);
    }

    public int ordinal(Address x$0) {
        Address address = x$0;
        if (address instanceof ShelleyAddress) {
            return 0;
        }
        if (address instanceof StakeAddress) {
            return 1;
        }
        if (address instanceof ByronAddress) {
            return 2;
        }
        throw new MatchError((Object)address);
    }

    private static final Object fromBytes$$anonfun$3() {
        return "Address bytes cannot be empty";
    }

    private static final Address fromString$$anonfun$1(String str$1) {
        return MODULE$.fromBech32(str$1);
    }

    private static final ByronAddress fromString$$anonfun$2$$anonfun$1(String str$3) {
        return ByronAddress$.MODULE$.apply(ByteString$.MODULE$.fromString(str$3));
    }

    private static final Try fromString$$anonfun$2(String str$2) {
        return Try$.MODULE$.apply(() -> Address$.fromString$$anonfun$2$$anonfun$1(str$2));
    }

    private static final Object parseType0$$anonfun$1(byte[] payload$1) {
        return new StringBuilder(44).append("Invalid Type-0 address length: ").append(payload$1.length).append(", expected 56").toString();
    }

    private static final Object parseType1$$anonfun$1(byte[] payload$2) {
        return new StringBuilder(44).append("Invalid Type-1 address length: ").append(payload$2.length).append(", expected 56").toString();
    }

    private static final Object parseType2$$anonfun$1(byte[] payload$3) {
        return new StringBuilder(44).append("Invalid Type-2 address length: ").append(payload$3.length).append(", expected 56").toString();
    }

    private static final Object parseType3$$anonfun$1(byte[] payload$4) {
        return new StringBuilder(44).append("Invalid Type-3 address length: ").append(payload$4.length).append(", expected 56").toString();
    }

    private static final Object parseType4$$anonfun$1(byte[] payload$5) {
        return new StringBuilder(46).append("Invalid Type-4 address length: ").append(payload$5.length).append(", expected > 28").toString();
    }

    private static final Pointer $anonfun$1() {
        throw new IllegalArgumentException("Invalid pointer data");
    }

    private static final Object parseType5$$anonfun$1(byte[] payload$6) {
        return new StringBuilder(46).append("Invalid Type-5 address length: ").append(payload$6.length).append(", expected > 28").toString();
    }

    private static final Pointer $anonfun$2() {
        throw new IllegalArgumentException("Invalid pointer data");
    }

    private static final Object parseType6$$anonfun$1(byte[] payload$7) {
        return new StringBuilder(44).append("Invalid Type-6 address length: ").append(payload$7.length).append(", expected 28").toString();
    }

    private static final Object parseType7$$anonfun$1(byte[] payload$8) {
        return new StringBuilder(44).append("Invalid Type-7 address length: ").append(payload$8.length).append(", expected 28").toString();
    }

    private static final Object parseType14$$anonfun$1(byte[] payload$9) {
        return new StringBuilder(45).append("Invalid Type-14 address length: ").append(payload$9.length).append(", expected 28").toString();
    }

    private static final Object parseType15$$anonfun$1(byte[] payload$10) {
        return new StringBuilder(45).append("Invalid Type-15 address length: ").append(payload$10.length).append(", expected 28").toString();
    }
}

