/*
 * Decompiled with CFR 0.152.
 */
package scalus.cardano.address;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;
import scala.util.Try$;
import scalus.builtin.Builtins$;
import scalus.builtin.ByteString;
import scalus.builtin.ByteString$;
import scalus.cardano.address.Address;
import scalus.cardano.address.Network;
import scalus.cardano.address.Network$Mainnet$;
import scalus.cardano.address.Network$Other$;
import scalus.cardano.address.Network$Testnet$;
import scalus.cardano.address.StakeAddress$;
import scalus.cardano.address.StakePayload;
import scalus.cardano.address.StakePayload$Script$;
import scalus.cardano.address.StakePayload$Stake$;
import scalus.cardano.ledger.Bech32$;

public class StakeAddress
implements Address,
Product,
Serializable {
    private final Network network;
    private final StakePayload payload;

    public static StakeAddress apply(Network network, StakePayload stakePayload) {
        return StakeAddress$.MODULE$.apply(network, stakePayload);
    }

    public static StakeAddress fromProduct(Product product) {
        return StakeAddress$.MODULE$.fromProduct(product);
    }

    public static StakeAddress unapply(StakeAddress stakeAddress) {
        return StakeAddress$.MODULE$.unapply(stakeAddress);
    }

    public StakeAddress(Network network, StakePayload payload) {
        this.network = network;
        this.payload = payload;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof StakeAddress)) return false;
        StakeAddress stakeAddress = (StakeAddress)object;
        Network network = this.network();
        Network network2 = stakeAddress.network();
        if (network == null) {
            if (network2 != null) {
                return false;
            }
        } else if (!network.equals(network2)) return false;
        StakePayload stakePayload = this.payload();
        StakePayload stakePayload2 = stakeAddress.payload();
        if (stakePayload == null) {
            if (stakePayload2 != null) {
                return false;
            }
        } else if (!stakePayload.equals(stakePayload2)) return false;
        if (!stakeAddress.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof StakeAddress;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "StakeAddress";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "network";
        }
        if (1 == n2) {
            return "payload";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Network network() {
        return this.network;
    }

    public StakePayload payload() {
        return this.payload;
    }

    @Override
    public byte typeId() {
        StakePayload stakePayload = this.payload();
        if (stakePayload instanceof StakePayload.Stake) {
            StakePayload.Stake stake = StakePayload$Stake$.MODULE$.unapply((StakePayload.Stake)stakePayload);
            ByteString byteString = stake._1();
            return 14;
        }
        if (stakePayload instanceof StakePayload.Script) {
            StakePayload.Script script = StakePayload$Script$.MODULE$.unapply((StakePayload.Script)stakePayload);
            ByteString byteString = script._1();
            return 15;
        }
        throw new MatchError((Object)stakePayload);
    }

    public byte toHeader() {
        return (byte)(this.typeId() << 4 | this.network().value() & 0xF);
    }

    @Override
    public Try<String> hrp() {
        Network network = this.network();
        if (Network$Testnet$.MODULE$.equals(network)) {
            return Success$.MODULE$.apply((Object)"stake_test");
        }
        if (Network$Mainnet$.MODULE$.equals(network)) {
            return Success$.MODULE$.apply((Object)"stake");
        }
        if (network instanceof Network.Other) {
            byte by;
            Network.Other other = Network$Other$.MODULE$.unapply((Network.Other)network);
            byte x = by = other._1();
            return Failure$.MODULE$.apply((Throwable)new IllegalArgumentException(new StringBuilder(17).append("Unknown network: ").append(x).toString()));
        }
        throw new MatchError((Object)network);
    }

    @Override
    public ByteString toBytes() {
        ByteString self$proxy2 = ByteString$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapByteArray(new byte[]{this.toHeader()}));
        ByteString that$proxy1 = this.payload().toBytes();
        return Builtins$.MODULE$.appendByteString(self$proxy2, that$proxy1);
    }

    @Override
    public String toHex() {
        return this.toBytes().toString();
    }

    public Try<String> toBech32() {
        return this.hrp().map((Function1 & Serializable)prefix -> {
            byte[] bytes = this.toBytes().bytes();
            return Tuple2$.MODULE$.apply(prefix, (Object)bytes);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String prefix = (String)tuple2._1();
                byte[] bytes = (byte[])tuple2._2();
                return Try$.MODULE$.apply(() -> StakeAddress.toBech32$$anonfun$4$$anonfun$1(prefix, bytes)).map((Function1 & Serializable)encoded -> encoded);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    @Override
    public boolean hasScript() {
        return this.payload().isScript();
    }

    @Override
    public boolean isEnterprise() {
        return false;
    }

    @Override
    public Try<String> encode() {
        return this.toBech32();
    }

    @Override
    public Option<ByteString> keyHashOption() {
        StakePayload stakePayload = this.payload();
        if (stakePayload instanceof StakePayload.Stake) {
            ByteString byteString;
            StakePayload.Stake stake = StakePayload$Stake$.MODULE$.unapply((StakePayload.Stake)stakePayload);
            ByteString hash = byteString = stake._1();
            return Some$.MODULE$.apply((Object)hash);
        }
        if (stakePayload instanceof StakePayload.Script) {
            StakePayload.Script script = StakePayload$Script$.MODULE$.unapply((StakePayload.Script)stakePayload);
            ByteString byteString = script._1();
            return None$.MODULE$;
        }
        throw new MatchError((Object)stakePayload);
    }

    @Override
    public Option<ByteString> scriptHashOption() {
        StakePayload stakePayload = this.payload();
        if (stakePayload instanceof StakePayload.Script) {
            ByteString byteString;
            StakePayload.Script script = StakePayload$Script$.MODULE$.unapply((StakePayload.Script)stakePayload);
            ByteString hash = byteString = script._1();
            return Some$.MODULE$.apply((Object)hash);
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Network> getNetwork() {
        return Some$.MODULE$.apply((Object)this.network());
    }

    public StakeAddress copy(Network network, StakePayload payload) {
        return new StakeAddress(network, payload);
    }

    public Network copy$default$1() {
        return this.network();
    }

    public StakePayload copy$default$2() {
        return this.payload();
    }

    public Network _1() {
        return this.network();
    }

    public StakePayload _2() {
        return this.payload();
    }

    private static final String toBech32$$anonfun$4$$anonfun$1(String prefix$2, byte[] bytes$5) {
        return Bech32$.MODULE$.encodeFrom5Bit(prefix$2, Bech32$.MODULE$.to5Bit(bytes$5));
    }
}

