/*
 * Decompiled with CFR 0.152.
 */
package scalus.cardano.ledger;

import io.bullet.borer.Decoder;
import io.bullet.borer.Encoder;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IndexedSeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scalus.builtin.ByteString;
import scalus.cardano.ledger.AuxiliaryData;
import scalus.cardano.ledger.Block$;
import scalus.cardano.ledger.BlockHeader;
import scalus.cardano.ledger.KeepRaw;
import scalus.cardano.ledger.Transaction;
import scalus.cardano.ledger.Transaction$;
import scalus.cardano.ledger.TransactionBody;
import scalus.cardano.ledger.TransactionWitnessSet;

public class Block
implements Product,
Serializable {
    private final BlockHeader header;
    private final IndexedSeq transactionBodies;
    private final IndexedSeq transactionWitnessSets;
    private final Map auxiliaryDataSet;
    private final IndexedSeq invalidTransactions;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Block$.class.getDeclaredField("given_Encoder_Block$lzy1"));

    public static Block apply(BlockHeader blockHeader, IndexedSeq<KeepRaw<TransactionBody>> indexedSeq, IndexedSeq<TransactionWitnessSet> indexedSeq2, Map<Object, KeepRaw<AuxiliaryData>> map, IndexedSeq<Object> indexedSeq3) {
        return Block$.MODULE$.apply(blockHeader, indexedSeq, indexedSeq2, map, indexedSeq3);
    }

    public static Decoder<Block> decoder(byte[] byArray) {
        return Block$.MODULE$.decoder(byArray);
    }

    public static Block fromProduct(Product product) {
        return Block$.MODULE$.fromProduct(product);
    }

    public static Encoder<Block> given_Encoder_Block() {
        return Block$.MODULE$.given_Encoder_Block();
    }

    public static Block unapply(Block block) {
        return Block$.MODULE$.unapply(block);
    }

    public Block(BlockHeader header, IndexedSeq<KeepRaw<TransactionBody>> transactionBodies, IndexedSeq<TransactionWitnessSet> transactionWitnessSets, Map<Object, KeepRaw<AuxiliaryData>> auxiliaryDataSet, IndexedSeq<Object> invalidTransactions) {
        this.header = header;
        this.transactionBodies = transactionBodies;
        this.transactionWitnessSets = transactionWitnessSets;
        this.auxiliaryDataSet = auxiliaryDataSet;
        this.invalidTransactions = invalidTransactions;
        Predef$.MODULE$.require(transactionBodies.size() == transactionWitnessSets.size(), () -> Block.$init$$$anonfun$1(transactionBodies, transactionWitnessSets));
        Predef$.MODULE$.require(auxiliaryDataSet.keys().forall((Function1)(JFunction1.mcZI.sp & Serializable)idx -> idx >= 0 && idx < transactionBodies.size()), Block::$init$$$anonfun$3);
        Predef$.MODULE$.require(invalidTransactions.forall((Function1)(JFunction1.mcZI.sp & Serializable)idx -> idx >= 0 && idx < transactionBodies.size()), Block::$init$$$anonfun$5);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Block)) return false;
        Block block = (Block)object;
        BlockHeader blockHeader = this.header();
        BlockHeader blockHeader2 = block.header();
        if (blockHeader == null) {
            if (blockHeader2 != null) {
                return false;
            }
        } else if (!((Object)blockHeader).equals(blockHeader2)) return false;
        IndexedSeq<KeepRaw<TransactionBody>> indexedSeq = this.transactionBodies();
        IndexedSeq<KeepRaw<TransactionBody>> indexedSeq2 = block.transactionBodies();
        if (indexedSeq == null) {
            if (indexedSeq2 != null) {
                return false;
            }
        } else if (!indexedSeq.equals(indexedSeq2)) return false;
        IndexedSeq<TransactionWitnessSet> indexedSeq3 = this.transactionWitnessSets();
        IndexedSeq<TransactionWitnessSet> indexedSeq4 = block.transactionWitnessSets();
        if (indexedSeq3 == null) {
            if (indexedSeq4 != null) {
                return false;
            }
        } else if (!indexedSeq3.equals(indexedSeq4)) return false;
        Map<Object, KeepRaw<AuxiliaryData>> map = this.auxiliaryDataSet();
        Map<Object, KeepRaw<AuxiliaryData>> map2 = block.auxiliaryDataSet();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        IndexedSeq<Object> indexedSeq5 = this.invalidTransactions();
        IndexedSeq<Object> indexedSeq6 = block.invalidTransactions();
        if (indexedSeq5 == null) {
            if (indexedSeq6 != null) {
                return false;
            }
        } else if (!indexedSeq5.equals(indexedSeq6)) return false;
        if (!block.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Block;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "Block";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "header";
            }
            case 1: {
                return "transactionBodies";
            }
            case 2: {
                return "transactionWitnessSets";
            }
            case 3: {
                return "auxiliaryDataSet";
            }
            case 4: {
                return "invalidTransactions";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public BlockHeader header() {
        return this.header;
    }

    public IndexedSeq<KeepRaw<TransactionBody>> transactionBodies() {
        return this.transactionBodies;
    }

    public IndexedSeq<TransactionWitnessSet> transactionWitnessSets() {
        return this.transactionWitnessSets;
    }

    public Map<Object, KeepRaw<AuxiliaryData>> auxiliaryDataSet() {
        return this.auxiliaryDataSet;
    }

    public IndexedSeq<Object> invalidTransactions() {
        return this.invalidTransactions;
    }

    public long blockNumber() {
        return this.header().blockNumber();
    }

    public long slot() {
        return this.header().slot();
    }

    public ByteString hash() {
        return this.header().headerBody().blockBodyHash();
    }

    public int txCount() {
        return this.transactionBodies().size();
    }

    public int invalidTxCount() {
        return this.invalidTransactions().size();
    }

    public int validTxCount() {
        return this.txCount() - this.invalidTxCount();
    }

    public boolean isEmpty() {
        return this.transactionBodies().isEmpty();
    }

    public Seq<Transaction> transactions(byte[] x$12) {
        return (Seq)((IndexedSeqOps)this.transactionBodies().zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                KeepRaw body = (KeepRaw)tuple2._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                TransactionWitnessSet witnessSet = (TransactionWitnessSet)this.transactionWitnessSets().apply(idx);
                Option auxData = this.auxiliaryDataSet().get((Object)BoxesRunTime.boxToInteger((int)idx));
                boolean isValid = !this.invalidTransactions().contains((Object)BoxesRunTime.boxToInteger((int)idx));
                return Transaction$.MODULE$.apply(body, witnessSet, isValid, (Option<KeepRaw<AuxiliaryData>>)auxData);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Block copy(BlockHeader header, IndexedSeq<KeepRaw<TransactionBody>> transactionBodies, IndexedSeq<TransactionWitnessSet> transactionWitnessSets, Map<Object, KeepRaw<AuxiliaryData>> auxiliaryDataSet, IndexedSeq<Object> invalidTransactions) {
        return new Block(header, transactionBodies, transactionWitnessSets, auxiliaryDataSet, invalidTransactions);
    }

    public BlockHeader copy$default$1() {
        return this.header();
    }

    public IndexedSeq<KeepRaw<TransactionBody>> copy$default$2() {
        return this.transactionBodies();
    }

    public IndexedSeq<TransactionWitnessSet> copy$default$3() {
        return this.transactionWitnessSets();
    }

    public Map<Object, KeepRaw<AuxiliaryData>> copy$default$4() {
        return this.auxiliaryDataSet();
    }

    public IndexedSeq<Object> copy$default$5() {
        return this.invalidTransactions();
    }

    public BlockHeader _1() {
        return this.header();
    }

    public IndexedSeq<KeepRaw<TransactionBody>> _2() {
        return this.transactionBodies();
    }

    public IndexedSeq<TransactionWitnessSet> _3() {
        return this.transactionWitnessSets();
    }

    public Map<Object, KeepRaw<AuxiliaryData>> _4() {
        return this.auxiliaryDataSet();
    }

    public IndexedSeq<Object> _5() {
        return this.invalidTransactions();
    }

    private static final Object $init$$$anonfun$1(IndexedSeq transactionBodies$1, IndexedSeq transactionWitnessSets$1) {
        return new StringBuilder(68).append("Number of transaction bodies (").append(transactionBodies$1.size()).append(") must match number of witness sets (").append(transactionWitnessSets$1.size()).append(")").toString();
    }

    private static final Object $init$$$anonfun$3() {
        return "Transaction index in auxiliary data set must be valid";
    }

    private static final Object $init$$$anonfun$5() {
        return "Invalid transaction index must be valid";
    }
}

