/*
 * Decompiled with CFR 0.152.
 */
package scalus.cardano.ledger;

import io.bullet.borer.Decoder;
import io.bullet.borer.Encoder;
import java.io.Serializable;
import scala.Option;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scalus.builtin.ByteString;
import scalus.builtin.ByteString$;
import scalus.builtin.JVMPlatformSpecific$package$;
import scalus.cardano.ledger.AuxiliaryData;
import scalus.cardano.ledger.HashSize$;
import scalus.cardano.ledger.Hashes$package$Hash$;
import scalus.cardano.ledger.KeepRaw;
import scalus.cardano.ledger.Transaction$;
import scalus.cardano.ledger.TransactionBody;
import scalus.cardano.ledger.TransactionWitnessSet;
import scalus.cardano.ledger.ValidityInterval;
import scalus.cardano.ledger.ValidityInterval$;
import scalus.serialization.cbor.Cbor$;

public class Transaction
implements Product,
Serializable {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Transaction.class.getDeclaredField("validityInterval$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Transaction.class.getDeclaredField("id$lzy1"));
    private final KeepRaw body;
    private final TransactionWitnessSet witnessSet;
    private final boolean isValid;
    private final Option auxiliaryData;
    private volatile transient Object id$lzy1;
    private volatile transient Object validityInterval$lzy1;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Transaction$.class.getDeclaredField("given_Encoder_Transaction$lzy1"));

    public static Transaction apply(KeepRaw<TransactionBody> keepRaw, TransactionWitnessSet transactionWitnessSet, boolean bl, Option<KeepRaw<AuxiliaryData>> option) {
        return Transaction$.MODULE$.apply(keepRaw, transactionWitnessSet, bl, option);
    }

    public static Transaction apply(TransactionBody transactionBody, TransactionWitnessSet transactionWitnessSet) {
        return Transaction$.MODULE$.apply(transactionBody, transactionWitnessSet);
    }

    public static Transaction apply(TransactionBody transactionBody, TransactionWitnessSet transactionWitnessSet, AuxiliaryData auxiliaryData) {
        return Transaction$.MODULE$.apply(transactionBody, transactionWitnessSet, auxiliaryData);
    }

    public static Decoder<Transaction> decoder(byte[] byArray) {
        return Transaction$.MODULE$.decoder(byArray);
    }

    public static Transaction empty() {
        return Transaction$.MODULE$.empty();
    }

    public static Transaction fromCbor(byte[] byArray) {
        return Transaction$.MODULE$.fromCbor(byArray);
    }

    public static Transaction fromProduct(Product product) {
        return Transaction$.MODULE$.fromProduct(product);
    }

    public static Encoder<Transaction> given_Encoder_Transaction() {
        return Transaction$.MODULE$.given_Encoder_Transaction();
    }

    public static Transaction unapply(Transaction transaction) {
        return Transaction$.MODULE$.unapply(transaction);
    }

    public static boolean $lessinit$greater$default$3() {
        return Transaction$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<KeepRaw<AuxiliaryData>> $lessinit$greater$default$4() {
        return Transaction$.MODULE$.$lessinit$greater$default$4();
    }

    public Transaction(KeepRaw<TransactionBody> body, TransactionWitnessSet witnessSet, boolean isValid, Option<KeepRaw<AuxiliaryData>> auxiliaryData) {
        this.body = body;
        this.witnessSet = witnessSet;
        this.isValid = isValid;
        this.auxiliaryData = auxiliaryData;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.body()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.witnessSet()));
        n = Statics.mix((int)n, (int)(this.isValid() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.auxiliaryData()));
        return Statics.finalizeHash((int)n, (int)4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Transaction)) return false;
        Transaction transaction = (Transaction)object;
        if (this.isValid() != transaction.isValid()) return false;
        KeepRaw<TransactionBody> keepRaw = this.body();
        KeepRaw<TransactionBody> keepRaw2 = transaction.body();
        if (keepRaw == null) {
            if (keepRaw2 != null) {
                return false;
            }
        } else if (!((Object)keepRaw).equals(keepRaw2)) return false;
        TransactionWitnessSet transactionWitnessSet = this.witnessSet();
        TransactionWitnessSet transactionWitnessSet2 = transaction.witnessSet();
        if (transactionWitnessSet == null) {
            if (transactionWitnessSet2 != null) {
                return false;
            }
        } else if (!((Object)transactionWitnessSet).equals(transactionWitnessSet2)) return false;
        Option<KeepRaw<AuxiliaryData>> option = this.auxiliaryData();
        Option<KeepRaw<AuxiliaryData>> option2 = transaction.auxiliaryData();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!transaction.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Transaction;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "Transaction";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this._3());
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "body";
            }
            case 1: {
                return "witnessSet";
            }
            case 2: {
                return "isValid";
            }
            case 3: {
                return "auxiliaryData";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public KeepRaw<TransactionBody> body() {
        return this.body;
    }

    public TransactionWitnessSet witnessSet() {
        return this.witnessSet;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public Option<KeepRaw<AuxiliaryData>> auxiliaryData() {
        return this.auxiliaryData;
    }

    public ByteString id() {
        Object object = this.id$lzy1;
        if (object instanceof ByteString) {
            return (ByteString)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ByteString)this.id$lzyINIT1();
    }

    private Object id$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.id$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ByteString byteString = null;
                    try {
                        byteString = Hashes$package$Hash$.MODULE$.apply(JVMPlatformSpecific$package$.MODULE$.given_PlatformSpecific().blake2b_256(ByteString$.MODULE$.unsafeFromArray(this.body().raw())), HashSize$.MODULE$.given_HashSize_Blake2b_256());
                        object2 = byteString == null ? LazyVals.NullValue$.MODULE$ : byteString;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.id$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return byteString;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ValidityInterval validityInterval() {
        Object object = this.validityInterval$lzy1;
        if (object instanceof ValidityInterval) {
            return (ValidityInterval)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ValidityInterval)this.validityInterval$lzyINIT1();
    }

    private Object validityInterval$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.validityInterval$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ValidityInterval validityInterval = null;
                    try {
                        validityInterval = ValidityInterval$.MODULE$.apply(this.body().value().validityStartSlot(), this.body().value().ttl());
                        object2 = validityInterval == null ? LazyVals.NullValue$.MODULE$ : validityInterval;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.validityInterval$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return validityInterval;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public byte[] toCbor() {
        return Cbor$.MODULE$.encode(this, Transaction$.MODULE$.given_Encoder_Transaction());
    }

    public Transaction copy(KeepRaw<TransactionBody> body, TransactionWitnessSet witnessSet, boolean isValid, Option<KeepRaw<AuxiliaryData>> auxiliaryData) {
        return new Transaction(body, witnessSet, isValid, auxiliaryData);
    }

    public KeepRaw<TransactionBody> copy$default$1() {
        return this.body();
    }

    public TransactionWitnessSet copy$default$2() {
        return this.witnessSet();
    }

    public boolean copy$default$3() {
        return this.isValid();
    }

    public Option<KeepRaw<AuxiliaryData>> copy$default$4() {
        return this.auxiliaryData();
    }

    public KeepRaw<TransactionBody> _1() {
        return this.body();
    }

    public TransactionWitnessSet _2() {
        return this.witnessSet();
    }

    public boolean _3() {
        return this.isValid();
    }

    public Option<KeepRaw<AuxiliaryData>> _4() {
        return this.auxiliaryData();
    }
}

