/*
 * Decompiled with CFR 0.152.
 */
package scalus.cardano.ledger;

import java.io.Serializable;
import scala.Function2;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;
import scalus.builtin.ByteString;
import scalus.cardano.ledger.AssetName;
import scalus.cardano.ledger.Coin;
import scalus.cardano.ledger.Coin$;
import scalus.cardano.ledger.MultiAsset;
import scalus.cardano.ledger.MultiAsset$;
import scalus.cardano.ledger.Value$;

public class Value
implements Product,
Serializable {
    private final Coin coin;
    private final MultiAsset assets;

    public static Value ada(long l) {
        return Value$.MODULE$.ada(l);
    }

    public static Value apply(Coin coin, MultiAsset multiAsset) {
        return Value$.MODULE$.apply(coin, multiAsset);
    }

    public static Value asset(ByteString byteString, AssetName assetName, long l, Coin coin) {
        return Value$.MODULE$.asset(byteString, assetName, l, coin);
    }

    public static Value combine(IterableOnce<Value> iterableOnce) {
        return Value$.MODULE$.combine(iterableOnce);
    }

    public static Value combine(Seq<Value> seq) {
        return Value$.MODULE$.combine(seq);
    }

    public static Value fromPolicy(ByteString byteString, Map<AssetName, Object> map, Coin coin) {
        return Value$.MODULE$.fromPolicy(byteString, map, coin);
    }

    public static Value fromProduct(Product product) {
        return Value$.MODULE$.fromProduct(product);
    }

    public static Value lovelace(long l) {
        return Value$.MODULE$.lovelace(l);
    }

    public static Value unapply(Value value) {
        return Value$.MODULE$.unapply(value);
    }

    public static Value zero() {
        return Value$.MODULE$.zero();
    }

    public static MultiAsset $lessinit$greater$default$2() {
        return Value$.MODULE$.$lessinit$greater$default$2();
    }

    public static Coin assets$default$2() {
        return Value$.MODULE$.assets$default$2();
    }

    public static Coin fromPolicy$default$3() {
        return Value$.MODULE$.fromPolicy$default$3();
    }

    public static Coin asset$default$4() {
        return Value$.MODULE$.asset$default$4();
    }

    public Value(Coin coin, MultiAsset assets) {
        this.coin = coin;
        this.assets = assets;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Value)) return false;
        Value value = (Value)object;
        Coin coin = this.coin();
        Coin coin2 = value.coin();
        if (coin == null) {
            if (coin2 != null) {
                return false;
            }
        } else if (!((Object)coin).equals(coin2)) return false;
        MultiAsset multiAsset = this.assets();
        MultiAsset multiAsset2 = value.assets();
        if (multiAsset == null) {
            if (multiAsset2 != null) {
                return false;
            }
        } else if (!((Object)multiAsset).equals(multiAsset2)) return false;
        if (!value.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Value;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "Value";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "coin";
        }
        if (1 == n2) {
            return "assets";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Coin coin() {
        return this.coin;
    }

    public MultiAsset assets() {
        return this.assets;
    }

    public Value plus(Value rhs) {
        return this.binOp((Function2<Object, Object, Object>)(JFunction2.mcJJJ.sp & Serializable)(_$1, _$2) -> _$1 + _$2, rhs);
    }

    public Value minus(Value rhs) {
        return this.binOp((Function2<Object, Object, Object>)(JFunction2.mcJJJ.sp & Serializable)(_$3, _$4) -> _$3 - _$4, rhs);
    }

    public Value negate() {
        return Value$.MODULE$.apply(this.coin().negate(), this.assets().negate());
    }

    public boolean isPositive() {
        return this.coin().value() > 0L && this.assets().isPositive();
    }

    public boolean isNegative() {
        return this.coin().value() < 0L && this.assets().isNegative();
    }

    public boolean isZero() {
        return this.coin().value() == 0L && this.assets().isEmpty();
    }

    private Value binOp(Function2<Object, Object, Object> op, Value rhs) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)this, (Object)rhs);
        if (tuple2 != null) {
            Value value = (Value)tuple2._1();
            Value value2 = (Value)tuple2._2();
            if (value != null) {
                Value value3 = Value$.MODULE$.unapply(value);
                Coin coin = value3._1();
                MultiAsset multiAsset = value3._2();
                Coin coin1 = coin;
                MultiAsset assets1 = multiAsset;
                if (value2 != null) {
                    Value value4 = Value$.MODULE$.unapply(value2);
                    Coin coin2 = value4._1();
                    MultiAsset multiAsset2 = value4._2();
                    Coin coin22 = coin2;
                    MultiAsset assets2 = multiAsset2;
                    return Value$.MODULE$.apply(Coin$.MODULE$.apply(op.apply$mcJJJ$sp(coin1.value(), coin22.value())), MultiAsset$.MODULE$.binOp(op, assets1, assets2));
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public Value copy(Coin coin, MultiAsset assets) {
        return new Value(coin, assets);
    }

    public Coin copy$default$1() {
        return this.coin();
    }

    public MultiAsset copy$default$2() {
        return this.assets();
    }

    public Coin _1() {
        return this.coin();
    }

    public MultiAsset _2() {
        return this.assets();
    }
}

