/*
 * Decompiled with CFR 0.152.
 */
package scalus.cardano.ledger;

import java.io.Serializable;
import java.math.BigInteger;
import scala.Product;
import scala.deriving.Mirror;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scalus.cardano.ledger.Word64;
import scalus.cardano.ledger.Word64$given_Decoder_Word64$;
import scalus.cardano.ledger.Word64$given_Encoder_Word64$;

public final class Word64$
implements Mirror.Product,
Serializable {
    private static final Word64 Zero;
    private static final Word64 MaxValue;
    private static final Word64 One;
    public static final Word64$given_Encoder_Word64$ given_Encoder_Word64;
    public static final Word64$given_Decoder_Word64$ given_Decoder_Word64;
    public static final Word64$ MODULE$;

    private Word64$() {
    }

    static {
        MODULE$ = new Word64$();
        Zero = MODULE$.apply(0L);
        MaxValue = MODULE$.apply(-1L);
        One = MODULE$.apply(1L);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Word64$.class);
    }

    public Word64 apply(long value) {
        return new Word64(value);
    }

    public Word64 unapply(Word64 x$1) {
        return x$1;
    }

    public Word64 fromUnsignedString(String s) {
        return this.apply(Long.parseUnsignedLong(s));
    }

    public Word64 fromBigInteger(BigInteger bi) {
        if (bi.signum() < 0) {
            throw new IllegalArgumentException(new StringBuilder(18).append("Value ").append(bi).append(" is negative").toString());
        }
        if (bi.bitLength() > 64) {
            throw new IllegalArgumentException(new StringBuilder(27).append("Value ").append(bi).append(" exceeds 64-bit range").toString());
        }
        return this.apply(bi.longValue());
    }

    public Word64 fromUnsignedInt(int value) {
        return this.apply(Integer.toUnsignedLong(value));
    }

    public Word64 Zero() {
        return Zero;
    }

    public Word64 MaxValue() {
        return MaxValue;
    }

    public Word64 One() {
        return One;
    }

    public Word64 fromProduct(Product x$0) {
        return new Word64(BoxesRunTime.unboxToLong((Object)x$0.productElement(0)));
    }
}

