/*
 * Decompiled with CFR 0.152.
 */
package scalus.prelude;

import scala.MatchError;
import scala.math.BigInt;
import scalus.builtin.ByteString;
import scalus.builtin.Data;
import scalus.cardano.onchain.OnchainError;
import scalus.ledger.api.v1.Credential;
import scalus.ledger.api.v3.ProposalProcedure;
import scalus.ledger.api.v3.ScriptContext;
import scalus.ledger.api.v3.ScriptContext$;
import scalus.ledger.api.v3.ScriptInfo;
import scalus.ledger.api.v3.ScriptInfo$CertifyingScript$;
import scalus.ledger.api.v3.ScriptInfo$MintingScript$;
import scalus.ledger.api.v3.ScriptInfo$ProposingScript$;
import scalus.ledger.api.v3.ScriptInfo$RewardingScript$;
import scalus.ledger.api.v3.ScriptInfo$SpendingScript$;
import scalus.ledger.api.v3.ScriptInfo$VotingScript$;
import scalus.ledger.api.v3.TxCert;
import scalus.ledger.api.v3.TxInfo;
import scalus.ledger.api.v3.TxOutRef;
import scalus.ledger.api.v3.Voter;
import scalus.prelude.Option;

public interface ParameterizedValidator<A> {
    public static void validate$(ParameterizedValidator $this, Object param, Data scData) {
        $this.validate(param, scData);
    }

    default public void validate(A param, Data scData) {
        ScriptContext sc = ScriptContext$.MODULE$.given_FromData_ScriptContext().apply(scData);
        ScriptInfo scriptInfo = sc.scriptInfo();
        if (scriptInfo instanceof ScriptInfo.MintingScript) {
            ByteString byteString;
            ScriptInfo.MintingScript mintingScript = ScriptInfo$MintingScript$.MODULE$.unapply((ScriptInfo.MintingScript)scriptInfo);
            ByteString policyId = byteString = mintingScript._1();
            this.mint(param, sc.redeemer(), policyId, sc.txInfo());
            return;
        }
        if (scriptInfo instanceof ScriptInfo.SpendingScript) {
            ScriptInfo.SpendingScript spendingScript = ScriptInfo$SpendingScript$.MODULE$.unapply((ScriptInfo.SpendingScript)scriptInfo);
            TxOutRef txOutRef = spendingScript._1();
            Option<Data> option = spendingScript._2();
            TxOutRef txOutRef2 = txOutRef;
            Option<Data> datum = option;
            this.spend(param, datum, sc.redeemer(), sc.txInfo(), txOutRef2);
            return;
        }
        if (scriptInfo instanceof ScriptInfo.RewardingScript) {
            Credential credential;
            ScriptInfo.RewardingScript rewardingScript = ScriptInfo$RewardingScript$.MODULE$.unapply((ScriptInfo.RewardingScript)scriptInfo);
            Credential credential2 = credential = rewardingScript._1();
            this.reward(param, sc.redeemer(), credential2, sc.txInfo());
            return;
        }
        if (scriptInfo instanceof ScriptInfo.CertifyingScript) {
            ScriptInfo.CertifyingScript certifyingScript = ScriptInfo$CertifyingScript$.MODULE$.unapply((ScriptInfo.CertifyingScript)scriptInfo);
            BigInt bigInt = certifyingScript._1();
            TxCert txCert = certifyingScript._2();
            BigInt index = bigInt;
            TxCert cert = txCert;
            this.certify(param, sc.redeemer(), cert, sc.txInfo());
            return;
        }
        if (scriptInfo instanceof ScriptInfo.VotingScript) {
            Voter voter;
            ScriptInfo.VotingScript votingScript = ScriptInfo$VotingScript$.MODULE$.unapply((ScriptInfo.VotingScript)scriptInfo);
            Voter voter2 = voter = votingScript._1();
            this.vote(param, sc.redeemer(), voter2, sc.txInfo());
            return;
        }
        if (scriptInfo instanceof ScriptInfo.ProposingScript) {
            ScriptInfo.ProposingScript proposingScript = ScriptInfo$ProposingScript$.MODULE$.unapply((ScriptInfo.ProposingScript)scriptInfo);
            BigInt bigInt = proposingScript._1();
            ProposalProcedure proposalProcedure = proposingScript._2();
            BigInt index = bigInt;
            ProposalProcedure procedure = proposalProcedure;
            this.propose(param, procedure, sc.txInfo());
            return;
        }
        throw new MatchError((Object)scriptInfo);
    }

    public static void spend$(ParameterizedValidator $this, Object param, Option datum, Data redeemer, TxInfo tx, TxOutRef ownRef) {
        $this.spend(param, datum, redeemer, tx, ownRef);
    }

    default public void spend(A param, Option<Data> datum, Data redeemer, TxInfo tx, TxOutRef ownRef) {
        throw new OnchainError("Empty Validator.spend");
    }

    public static void mint$(ParameterizedValidator $this, Object param, Data redeemer, ByteString policyId, TxInfo tx) {
        $this.mint(param, redeemer, policyId, tx);
    }

    default public void mint(A param, Data redeemer, ByteString policyId, TxInfo tx) {
        throw new OnchainError("Empty Validator.mint");
    }

    public static void reward$(ParameterizedValidator $this, Object param, Data redeemer, Credential stakingKey, TxInfo tx) {
        $this.reward(param, redeemer, stakingKey, tx);
    }

    default public void reward(A param, Data redeemer, Credential stakingKey, TxInfo tx) {
        throw new OnchainError("Empty Validator.reward");
    }

    public static void certify$(ParameterizedValidator $this, Object param, Data redeemer, TxCert cert, TxInfo tx) {
        $this.certify(param, redeemer, cert, tx);
    }

    default public void certify(A param, Data redeemer, TxCert cert, TxInfo tx) {
        throw new OnchainError("Empty Validator.certify");
    }

    public static void vote$(ParameterizedValidator $this, Object param, Data redeemer, Voter voter, TxInfo tx) {
        $this.vote(param, redeemer, voter, tx);
    }

    default public void vote(A param, Data redeemer, Voter voter, TxInfo tx) {
        throw new OnchainError("Empty Validator.vote");
    }

    public static void propose$(ParameterizedValidator $this, Object param, ProposalProcedure proposalProcedure, TxInfo tx) {
        $this.propose(param, proposalProcedure, tx);
    }

    default public void propose(A param, ProposalProcedure proposalProcedure, TxInfo tx) {
        throw new OnchainError("Empty Validator.propose");
    }
}

