/*
 * Decompiled with CFR 0.152.
 */
package scalus.prelude.crypto.bls12_381;

import java.io.Serializable;
import scala.Product;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scalus.builtin.Builtins$;
import scalus.builtin.ByteString;
import scalus.cardano.onchain.RequirementError;
import scalus.prelude.Option;
import scalus.prelude.Option$;
import scalus.prelude.Option$Some$;
import scalus.prelude.crypto.bls12_381.Scalar;
import scalus.sir.Module;
import scalus.sir.ModuleToExpr$;
import scalus.sir.SIRModuleWithDeps;
import scalus.sir.SIRModuleWithDeps$;

public final class Scalar$
implements Mirror.Product,
Serializable {
    private static final BigInt fieldPrime;
    private volatile Object sirModule$lzy1;
    private volatile Object sirDeps$lzy1;
    public static final Scalar$ MODULE$;

    private Scalar$() {
    }

    static {
        MODULE$ = new Scalar$();
        fieldPrime = package$.MODULE$.BigInt().apply("52435875175126190479447740508185965837690552500527637822603658699938581184513");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Scalar$.class);
    }

    public Scalar unapply(Scalar x$1) {
        return x$1;
    }

    public BigInt fieldPrime() {
        return fieldPrime;
    }

    public Scalar zero() {
        return new Scalar(BigInt$.MODULE$.int2bigInt(0));
    }

    public Scalar one() {
        return new Scalar(BigInt$.MODULE$.int2bigInt(1));
    }

    public Option<Scalar> apply(BigInt n) {
        if (n.$greater$eq((Object)BigInt$.MODULE$.int2bigInt(0)) && n.$less((Object)this.fieldPrime())) {
            return Option$Some$.MODULE$.apply(new Scalar(n));
        }
        return Option$.None;
    }

    public Scalar applyUnsafe(BigInt n) {
        if (!BigInt$.MODULE$.int2bigInt(0).$less$eq((Object)n) || !n.$less((Object)this.fieldPrime())) {
            throw new RequirementError("value not in the field");
        }
        return new Scalar(n);
    }

    public Option<Scalar> fromByteStringBigEndian(ByteString bytes) {
        return this.apply(Builtins$.MODULE$.byteStringToInteger(true, bytes));
    }

    public Scalar fromByteStringBigEndianUnsafe(ByteString bytes) {
        return this.applyUnsafe(Builtins$.MODULE$.byteStringToInteger(true, bytes));
    }

    public Option<Scalar> fromByteStringLittleEndian(ByteString bytes) {
        return this.apply(Builtins$.MODULE$.byteStringToInteger(false, bytes));
    }

    public Scalar fromByteStringLittleEndianUnsafe(ByteString bytes) {
        return this.applyUnsafe(Builtins$.MODULE$.byteStringToInteger(false, bytes));
    }

    public Scalar $plus(Scalar self, Scalar addend) {
        return new Scalar(self.scalus$prelude$crypto$bls12_381$Scalar$$unScalar().$plus(addend.scalus$prelude$crypto$bls12_381$Scalar$$unScalar()).$percent(this.fieldPrime()));
    }

    public Scalar $times(Scalar self, Scalar multiplier) {
        return new Scalar(self.scalus$prelude$crypto$bls12_381$Scalar$$unScalar().$times(multiplier.scalus$prelude$crypto$bls12_381$Scalar$$unScalar()).$percent(this.fieldPrime()));
    }

    public Option<Scalar> $div(Scalar self, Scalar divisor) {
        BigInt bigInt = divisor.scalus$prelude$crypto$bls12_381$Scalar$$unScalar();
        BigInt bigInt2 = this.zero().scalus$prelude$crypto$bls12_381$Scalar$$unScalar();
        if (!(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null)) {
            return Option$.None;
        }
        return Option$Some$.MODULE$.apply(this.$times(self, this.scale(divisor, this.fieldPrime().$minus(BigInt$.MODULE$.int2bigInt(2)))));
    }

    public Scalar $minus(Scalar self, Scalar subtrahend) {
        BigInt difference = self.scalus$prelude$crypto$bls12_381$Scalar$$unScalar().$minus(subtrahend.scalus$prelude$crypto$bls12_381$Scalar$$unScalar());
        return new Scalar(difference.$greater$eq((Object)BigInt$.MODULE$.int2bigInt(0)) ? difference : this.fieldPrime().$plus(difference));
    }

    public Scalar scale(Scalar self, BigInt e) {
        while (true) {
            if (e.$less((Object)BigInt$.MODULE$.int2bigInt(0))) {
                return this.zero();
            }
            if (BoxesRunTime.equals((Object)e, (Object)package$.MODULE$.BigInt().apply(0))) {
                return this.one();
            }
            BigInt bigInt = e.$percent(BigInt$.MODULE$.int2bigInt(2));
            BigInt bigInt2 = package$.MODULE$.BigInt().apply(0);
            if (bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null) break;
            Scalar scalar = this.$times(self, self);
            BigInt bigInt3 = e.$div(BigInt$.MODULE$.int2bigInt(2));
            self = scalar;
            e = bigInt3;
        }
        return this.$times(self, this.scale(this.$times(self, self), e.$minus(BigInt$.MODULE$.int2bigInt(1)).$div(BigInt$.MODULE$.int2bigInt(2))));
    }

    public Scalar scale2(Scalar self, BigInt k) {
        if (k.$less((Object)BigInt$.MODULE$.int2bigInt(0))) {
            return this.zero();
        }
        return this.go$1(self, k);
    }

    public Scalar unary_$minus(Scalar self) {
        BigInt bigInt = self.scalus$prelude$crypto$bls12_381$Scalar$$unScalar();
        BigInt bigInt2 = package$.MODULE$.BigInt().apply(0);
        if (!(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null)) {
            return self;
        }
        return new Scalar(this.fieldPrime().$minus(self.scalus$prelude$crypto$bls12_381$Scalar$$unScalar()));
    }

    public Option<Scalar> recip(Scalar self) {
        return this.$div(this.one(), self);
    }

    public BigInt toInt(Scalar self) {
        return self.scalus$prelude$crypto$bls12_381$Scalar$$unScalar();
    }

    public ByteString toByteStringBigEndian(Scalar self, BigInt size) {
        return Builtins$.MODULE$.integerToByteString(true, size, self.scalus$prelude$crypto$bls12_381$Scalar$$unScalar());
    }

    public ByteString toByteStringLittleEndian(Scalar self, BigInt size) {
        return Builtins$.MODULE$.integerToByteString(false, size, self.scalus$prelude$crypto$bls12_381$Scalar$$unScalar());
    }

    public Scalar fromProduct(Product x$0) {
        return new Scalar((BigInt)x$0.productElement(0));
    }

    public Module sirModule() {
        Object object = this.sirModule$lzy1;
        if (object instanceof Module) {
            return (Module)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Module)this.sirModule$lzyINIT1();
    }

    private Object sirModule$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.sirModule$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Scalar.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Module module = null;
                    try {
                        module = ModuleToExpr$.MODULE$.decodeStringLatin1(new StringBuilder(46366).append("\u0006\u0000\u0001'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u00812scalus.prelude.crypto.bls12_381.Scalar$.fieldPrime\u0000\t \u0082\u0080\u0080\u0080\u00e0\u00ff\u00ff\u00ff\u00ff\u00fb\u00df\u00e5\u00ff\u00bf\u0081\u00a4\u00fb\u00ce\u00aa\u0080\u00bb\u00e8\u0084\u0088\u00b0\u00e7\u0099\u0083\u00a9\u00df\u00ce\u00a9\u00a6\u009d\u00ed\u00be\u000e\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000.:2\n!,scalus.prelude.crypto.bls12_381.Scalar$.zero\u0000A\f\u0098\u00d3\u00b8\u00d8\u0014\u0098\u001c\u008b&scalus.prelude.crypto.bls12_381.Scalar\u0000\u0081\bunScalar\u0000\b\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000$\u0016$\u0016\u0001\u0001\u0001_\u0000!n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u00008\b8H\u0011&scalus.prelude.crypto.bls12_381.Scalar\u0000\u00cc\u00f2\u00bf\u00fb\u0001&scalus.prelude.crypto.bls12_381.Scalar\u0000\u00ce\u00dcp\u00ca\u0001&scalus.prelude.crypto.bls12_381.Scalar\u0000\u0081\bunScalar\u0000\b\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u00008.8H\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000$\u0016$\u0016$\u0080\u0000!n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u00008D8F\u0006Li\u00dcl\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u00008.8H\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u00008\b8H!+scalus.prelude.crypto.bls12_381.Scalar$.one\u0000A\f\u0098\u00d3\u00b8\u00d8!\u0001_\u0000!n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000>\b>F\u0011&scalus.prelude.crypto.bls12_381.Scalar\u0000\u00cc\u00f2\u00bf\u00fb\u0092\u0000 \u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000>B>D\u0006Li\u00dcl\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000>,>F\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000>\b>F!-scalus.prelude.crypto.bls12_381.Scalar$.apply\u0000@O\u00c8\u00daus\u00e13\u00f8\u00bf\u0015scalus.prelude.Option\u0000\u00b0\u001e*R\u0001\u001bscalus.prelude.Option$.Some\u0000\u0081\u0005value\u0000I\u0001A\u0000\u00ec\u0090\n!\u0001A\u0000\u00ec\u0090\n)\u0001\u0001A\u0000\u00ba\u0007\u0001]/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/Option.scala\u0000 \u0012 \u0012>\u00d5\u009a\u0087A\u001bscalus.prelude.Option$.None\u0000.\u0001]/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/Option.scala\u0000\"\u0012\"\u0012\u0011\u0001A\u0000\u00fcH\u0001]/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/Option.scala\u0000\u001c\n\u001c\n&Li\u00dcl\t\u0001n\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000P\u001cP.\n\u00b1\u008c\u00c2A`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000l\fl6\t\u0000\u0000An/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000R R\"\u0010\u0011\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000R R\"\u0001\u0001n\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000R\u0016R\u0018\u0007n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000R\u0016R\"\u00063\b\u0001`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000b\fb6\u0001\u0001n\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000R*R,\u0010\u0011\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000R*R,\u0015'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u00012scalus.prelude.crypto.bls12_381.Scalar$.fieldPrime\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000R2RF\u0007n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000R*RF\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000R\u0016RF \u0081\u001bscalus.prelude.Option$.Some\u0000\u00db\u007f\u00a8=\u0001\u0015scalus.prelude.Option\u0000\u00b4j\u00c4\u00ac\u0081\u001bscalus.prelude.Option$.Some\u0000\u0081\u0005value\u0000I\u0001A\u0000\u00ec\u0090\n!\u0001A\u0000\u00fe\u0085\n)\u0001\u0001A\u0000\u00ba\u0007\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000RRRx$\u00b3(\u00ea\u0001\u001bscalus.prelude.Option$.None\u0000.\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000RRRx\u0011\u0001A\u0000\u0000\u0001]/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/Option.scala\u0000\u001c\n\u001c\n(\u0001&scalus.prelude.crypto.bls12_381.Scalar\u0000\u00cc\u00f2\u00bf\u00fb\u0081\u0001n\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000RrRt\u0006Li\u00dcl\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000R\\Rv\u0006\u00b7\u00cc\u00dan`<T\u00a4\u00991\u00a7q\u00b1U\u0001A\u0000\u00fcH\u000e\u009e|A\u009d\u00e13\u00f8\u00bfI\u0001A\u0000\u00fcH\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000RRRx\u000f\u00c8\u00dausn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000RRRx\u0011\u001bscalus.prelude.Option$.None\u0000\u00db\u007f\u00a8=\u001fYp\u0081\u0003\u00c2g\u00f1~\u00e1n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000T\u001aT\"\u000f\u00c8\u00dausn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000R\u0010T\"\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000P\u001cP.!3scalus.prelude.crypto.bls12_381.Scalar$.applyUnsafe\u0000@L\u0098\u00d3\u00b8\u00d8!\u0001n\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000l(l:\u0003\u0001\u0010__Scalar_line_55\u0000!V1\u0098I`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000l\fl6\t\u0000\u0000An/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000n n\"\u0010\u0011\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000n n\"\u0001\u0001n\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000n*n,\u0007n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000n n,\u00063\b\u0001`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000b\fb6\u0001\u0001n\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000n4n6\u0010\u0011\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000n4n6\u0015'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u00012scalus.prelude.crypto.bls12_381.Scalar$.fieldPrime\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000n<nP\u0007n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000n4nP\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000n nP\t1\u0001^/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/Prelude.scala\u0000\u008e\u00020\u008e\u00024\u000eI\u0001\u0016value not in the field\u0000\u0011n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000nTn\u0084\u0001\u0001^/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/Prelude.scala\u0000\u008e\u0002L\u008e\u0002\u0086\u0001\t^/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/Prelude.scala\u0000\u008e\u0002\b\u008e\u0002\u0086\u0001\b\u0001&scalus.prelude.crypto.bls12_381.Scalar\u0000\u00cc\u00f2\u00bf\u00fb\u0081\u0001n\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000p&p(\u0006Li\u00dcl\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000p\u0010p*\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000p\u0010p*\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000l(l:!?scalus.prelude.crypto.bls12_381.Scalar$.fromByteStringBigEndian\u0000@\u000f\u00c8\u00daur!\u0005bytes\u0000\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0094\u0001@\u0094\u0001b\u0006\u00a1'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u0001-scalus.prelude.crypto.bls12_381.Scalar$.apply\u0000@O\u00c8\u00dausn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0096\u0001\u0010\u0096\u0001\u001c\u00063J\u0001`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000\u00e4\u0006\f\u00e4\u00066\tDan/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0096\u0001F\u0096\u0001N\u0010\u0000\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0096\u0001\u001e\u0096\u0001^\u0001\u0005bytes\u0000\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0096\u0001R\u0096\u0001\\\u0003n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0096\u0001\u001e\u0096\u0001^\u000f\u00c8\u00dausn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0096\u0001\u0010\u0096\u0001`\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0094\u0001@\u0094\u0001b!Escalus.prelude.crypto.bls12_381.Scalar$.fromByteStringBigEndianUnsafe\u0000@\f\u0098\u00d3\u00b8\u00d8!\u0005bytes\u0000\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00ac\u0001L\u00ac\u0001n\u0006\u00a1'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u00013scalus.prelude.crypto.bls12_381.Scalar$.applyUnsafe\u0000@L\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00ae\u0001\u0010\u00ae\u00014\u00063J\u0001`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000\u00e4\u0006\f\u00e4\u00066\tDan/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00ae\u0001^\u00ae\u0001f\u0010\u0000\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00ae\u00016\u00ae\u0001v\u0001\u0005bytes\u0000\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00ae\u0001j\u00ae\u0001t\u0003n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00ae\u00016\u00ae\u0001v\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00ae\u0001\u0010\u00ae\u0001x\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00ac\u0001L\u00ac\u0001n!Bscalus.prelude.crypto.bls12_381.Scalar$.fromByteStringLittleEndian\u0000@\u000f\u00c8\u00daur!\u0005bytes\u0000\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00c0\u0001F\u00c0\u0001h\u0006\u00a1'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u0001-scalus.prelude.crypto.bls12_381.Scalar$.apply\u0000@O\u00c8\u00dausn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00c2\u0001\u0010\u00c2\u0001\u001c\u00063J\u0001`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000\u00e4\u0006\f\u00e4\u00066\t@an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00c2\u0001F\u00c2\u0001P\u0010\u0000\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00c2\u0001\u001e\u00c2\u0001`\u0001\u0005bytes\u0000\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00c2\u0001T\u00c2\u0001^\u0003n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00c2\u0001\u001e\u00c2\u0001`\u000f\u00c8\u00dausn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00c2\u0001\u0010\u00c2\u0001b\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00c0\u0001F\u00c0\u0001h!Hscalus.prelude.crypto.bls12_381.Scalar$.fromByteStringLittleEndianUnsafe\u0000@\f\u0098\u00d3\u00b8\u00d8!\u0005bytes\u0000\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d8\u0001R\u00d8\u0001t\u0006\u00a1'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u00013scalus.prelude.crypto.bls12_381.Scalar$.applyUnsafe\u0000@L\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00da\u0001\u0010\u00da\u00014\u00063J\u0001`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000\u00e4\u0006\f\u00e4\u00066\t@an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00da\u0001^\u00da\u0001h\u0010\u0000\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00da\u00016\u00da\u0001x\u0001\u0005bytes\u0000\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00da\u0001l\u00da\u0001v\u0003n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00da\u00016\u00da\u0001x\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00da\u0001\u0010\u00da\u0001z\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d8\u0001R\u00d8\u0001t!)scalus.prelude.crypto.bls12_381.Scalar$.+\u0000A\u0093\u001aw\u001b\u0010d\u00c6\u009d\u00c6\u00c3&4\u00ee6\t\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00de\u0001\u001e\u00de\u00016\u0005\u0006addend\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00ee\u0001(\u00ee\u0001D\u0011&scalus.prelude.crypto.bls12_381.Scalar\u0000\u00cc\u00f2\u00bf\u00fb\u008cf\u000b`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000D\fD6\u00063\u0000\u0001`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000\u0012\f\u00126\u001e\u0001\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f0\u00010\u00f0\u00018\u0001\bunScalar\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f0\u00010\u00f0\u0001J\u0010\u0010\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f0\u00010\u00f0\u0001J\u001e\u0001\u0006addend\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f0\u0001P\u00f0\u0001\\\u0001\bunScalar\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f0\u0001P\u00f0\u0001n\u0003n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f0\u00010\u00f0\u0001n\u0010\u0010\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f0\u00010\u00f0\u0001n\u0015'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u00012scalus.prelude.crypto.bls12_381.Scalar$.fieldPrime\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f0\u0001v\u00f0\u0001\u008a\u0001\u0003n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f0\u00010\u00f0\u0001\u008a\u0001\u0006Li\u00dcl\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f0\u0001\u0018\u00f0\u0001\u008c\u0001\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00ee\u0001(\u00ee\u0001D\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00de\u0001\u001e\u00de\u00016!)scalus.prelude.crypto.bls12_381.Scalar$.*\u0000A\u0093\u001aw\u001b\u0010d\u00c6\u009d\u00c6\u00c3&4\u00ee6\t\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00de\u0001\u001e\u00de\u00016\u0005\nmultiplier\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0082\u0002(\u0082\u0002L\u0011&scalus.prelude.crypto.bls12_381.Scalar\u0000\u00cc\u00f2\u00bf\u00fb\u008cf\u000b`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000D\fD6\u00063\u0002\u0001`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000&\f&6\u001e\u0001\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0084\u0002.\u0084\u00026\u0001\bunScalar\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0084\u0002.\u0084\u0002H\u0010\u0010\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0084\u0002.\u0084\u0002H\u001e\u0001\nmultiplier\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0084\u0002N\u0084\u0002b\u0001\bunScalar\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0084\u0002N\u0084\u0002t\u0003n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0084\u0002.\u0084\u0002t\u0010\u0010\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0084\u0002.\u0084\u0002t\u0015'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u00012scalus.prelude.crypto.bls12_381.Scalar$.fieldPrime\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0084\u0002z\u0084\u0002\u008e\u0001\u0003n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0084\u0002.\u0084\u0002\u008e\u0001\u0006Li\u00dcl\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0084\u0002\u0018\u0084\u0002\u0090\u0001\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0082\u0002(\u0082\u0002L\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00de\u0001\u001e\u00de\u00016!)scalus.prelude.crypto.bls12_381.Scalar$./\u0000A\u0093\u001aw\u001b\u0010d\u00c6\u009d\u00c6\u00c3\u00f26\u009d\\\u0089\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00de\u0001\u001e\u00de\u00016\u0005\u0007divisor\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0096\u0002(\u0096\u0002F\n1\u00989`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000X\fX6\u001e\u0001\u0007divisor\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0098\u0002\u001e\u0098\u0002,\u0001\bunScalar\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0098\u0002\u001e\u0098\u0002>\u0010\u0011\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0098\u0002\u001e\u0098\u0002>\u001e5\u0001'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u0001,scalus.prelude.crypto.bls12_381.Scalar$.zero\u0000A\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0098\u0002F\u0098\u0002N\t1\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0098\u0002F\u0098\u0002N\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0098\u0002F\u0098\u0002N\u0001\bunScalar\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0098\u0002F\u0098\u0002`\u0007n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0098\u0002\u001e\u0098\u0002`\u0011\u001bscalus.prelude.Option$.None\u0000\u00db\u007f\u00a8=\u001fYp\u0081\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0098\u0002l\u0098\u0002t \u0081\u001bscalus.prelude.Option$.Some\u0000\u00db\u007f\u00a8=\u008cj\u0001'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u0001)scalus.prelude.crypto.bls12_381.Scalar$.*\u0000A\u0093\u001aw\u001b\u0010d\u00c6\u009d\u00c6\u00c3&4\u00ee6\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u009a\u00026\u009a\u00028\u0001\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u009a\u0002,\u009a\u00024\u0010d\u00c6\u009d\u00c6\u00c3&4\u00ee6\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u009a\u0002,\u009a\u00028\u00065\u0001'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u0001-scalus.prelude.crypto.bls12_381.Scalar$.scale\u0000A\u0093\u001aw\u001b\u0010\u0013&4\u00ee6\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u009a\u0002J\u009a\u0002T\u0001\u0007divisor\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u009a\u0002:\u009a\u0002H\u0010\u0013&4\u00ee6\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u009a\u0002:\u009a\u0002T\u00063\u0001\u0001`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000\u001c\f\u001c6\u0015'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u00012scalus.prelude.crypto.bls12_381.Scalar$.fieldPrime\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u009a\u0002V\u009a\u0002j\u0010\u0010\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u009a\u0002V\u009a\u0002j\t\u0000 An/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u009a\u0002p\u009a\u0002r\u0003n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u009a\u0002V\u009a\u0002r\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u009a\u0002:\u009a\u0002t\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u009a\u0002,\u009a\u0002t\u0006\u00b7\u00cc\u00dan\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u009a\u0002\"\u009a\u0002v\u000f\u00c8\u00dausn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u009a\u0002\"\u009a\u0002v\u000f\u00c8\u00dausn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0098\u0002\u0018\u009a\u0002v\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u0096\u0002(\u0096\u0002F\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00de\u0001\u001e\u00de\u00016!)scalus.prelude.crypto.bls12_381.Scalar$.-\u0000A\u0093\u001aw\u001b\u0010d\u00c6\u009d\u00c6\u00c3&4\u00ee6\t\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00de\u0001\u001e\u00de\u00016\u0005\nsubtrahend\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00ae\u0002(\u00ae\u0002L\u0003\u0001\ndifference\u0000\b\u00c6`!`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000\u001c\f\u001c6\u001e\u0001\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00b0\u0002:\u00b0\u0002B\u0001\bunScalar\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00b0\u0002:\u00b0\u0002T\u0010\u0010\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00b0\u0002:\u00b0\u0002T\u001e\u0001\nsubtrahend\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00b0\u0002Z\u00b0\u0002n\u0001\bunScalar\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00b0\u0002Z\u00b0\u0002\u0080\u0001\u0003n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00b0\u0002:\u00b0\u0002\u0080\u0001\b\u0001&scalus.prelude.crypto.bls12_381.Scalar\u0000\u00cc\u00f2\u00bf\u00fb\u0094c0\u0091`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000l\fl6\t\u0000\u0000An/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00b4\u0002>\u00b4\u0002@\u0010\u0011\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00b4\u0002>\u00b4\u0002@\u0001\ndifference\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00b4\u0002\"\u00b4\u00026\u0007n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00b4\u0002\"\u00b4\u0002@\u0001\ndifference\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00b4\u0002L\u00b4\u0002`\u00063\u0000\u0001`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000\u0012\f\u00126\u0015'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u00012scalus.prelude.crypto.bls12_381.Scalar$.fieldPrime\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00b6\u0002&\u00b6\u0002:\u0010\u0010\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00b6\u0002&\u00b6\u0002:\u0001\ndifference\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00b6\u0002@\u00b6\u0002T\u0003n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00b6\u0002&\u00b6\u0002T\u0003n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00b4\u0002\u001c\u00b6\u0002T\u0006Li\u00dcl\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00b2\u0002\u0018\u00b8\u0002\u001a\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00b2\u0002\u0018\u00b8\u0002\u001a\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00ae\u0002(\u00ae\u0002L\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00de\u0001\u001e\u00de\u00016!-scalus.prelude.crypto.bls12_381.Scalar$.scale\u0000A\u0093\u001aw\u001b\u0010\u0013&4\u00ee6\t\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00de\u0001\u001e\u00de\u00016\u0005\u0001e\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00ce\u0002$\u00ce\u00026\n1\u0098A`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000b\fb6\u0001\u0001e\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d0\u0002\u001e\u00d0\u0002 \u0010\u0011\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d0\u0002\u001e\u00d0\u0002 \t\u0000\u0000An/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d0\u0002&\u00d0\u0002(\u0007n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d0\u0002\u001e\u00d0\u0002(\u0006\u00a1'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u0001,scalus.prelude.crypto.bls12_381.Scalar$.zero\u0000A\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d0\u00024\u00d0\u0002<\t1\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d0\u00024\u00d0\u0002<\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d0\u00024\u00d0\u0002<\n1\u00989`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000X\fX6\u0001\u0001e\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d2\u0002(\u00d2\u0002*\u0010\u0011\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d2\u0002(\u00d2\u0002*\t\u0000\u0000An/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d2\u00022\u00d2\u0002D\u0007n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d2\u0002(\u00d2\u0002D\u0006\u00a1'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u0001+scalus.prelude.crypto.bls12_381.Scalar$.one\u0000A\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d2\u0002P\u00d2\u0002V\t1\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d2\u0002P\u00d2\u0002V\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d2\u0002P\u00d2\u0002V\n1\u00989`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000X\fX6\u00063\u0005\u0001`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000D\fD6\u0001\u0001e\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d4\u0002(\u00d4\u0002*\u0010\u0010\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d4\u0002(\u00d4\u0002*\t\u0000 An/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d4\u00020\u00d4\u00022\u0003n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d4\u0002(\u00d4\u00022\u0010\u0011\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d4\u0002(\u00d4\u00022\t\u0000\u0000An/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d4\u0002:\u00d4\u0002L\u0007n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d4\u0002(\u00d4\u0002L\u00065\u0001'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u0001-scalus.prelude.crypto.bls12_381.Scalar$.scale\u0000A\u0093\u001aw\u001b\u0010\u0013&4\u00ee6\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d4\u0002t\u00d4\u0002~\u00065\u0001'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u0001)scalus.prelude.crypto.bls12_381.Scalar$.*\u0000A\u0093\u001aw\u001b\u0010d\u00c6\u009d\u00c6\u00c3&4\u00ee6\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d4\u0002d\u00d4\u0002f\u0001\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d4\u0002Z\u00d4\u0002b\u0010d\u00c6\u009d\u00c6\u00c3&4\u00ee6\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d4\u0002Z\u00d4\u0002f\u0001\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d4\u0002h\u00d4\u0002p\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d4\u0002Z\u00d4\u0002p\u0010\u0013&4\u00ee6\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d4\u0002X\u00d4\u0002~\u00063\u0003\u0001`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u00000\f06\u0001\u0001e\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d4\u0002\u0080\u0001\u00d4\u0002\u0082\u0001\u0010\u0010\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d4\u0002\u0080\u0001\u00d4\u0002\u0082\u0001\t\u0000 An/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d4\u0002\u0088\u0001\u00d4\u0002\u008a\u0001\u0003n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d4\u0002\u0080\u0001\u00d4\u0002\u008a\u0001\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d4\u0002X\u00d4\u0002\u008c\u0001\u00065\u0001'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u0001)scalus.prelude.crypto.bls12_381.Scalar$.*\u0000A\u0093\u001aw\u001b\u0010d\u00c6\u009d\u00c6\u00c3&4\u00ee6\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d6\u0002,\u00d6\u0002.\u0001\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d6\u0002\"\u00d6\u0002*\u0010d\u00c6\u009d\u00c6\u00c3&4\u00ee6\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d6\u0002\"\u00d6\u0002.\u00065\u0001'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u0001-scalus.prelude.crypto.bls12_381.Scalar$.scale\u0000A\u0093\u001aw\u001b\u0010\u0013&4\u00ee6\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d6\u0002L\u00d6\u0002V\u00065\u0001'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u0001)scalus.prelude.crypto.bls12_381.Scalar$.*\u0000A\u0093\u001aw\u001b\u0010d\u00c6\u009d\u00c6\u00c3&4\u00ee6\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d6\u0002<\u00d6\u0002>\u0001\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d6\u00022\u00d6\u0002:\u0010d\u00c6\u009d\u00c6\u00c3&4\u00ee6\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d6\u00022\u00d6\u0002>\u0001\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d6\u0002@\u00d6\u0002H\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d6\u00022\u00d6\u0002H\u0010\u0013&4\u00ee6\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d6\u00020\u00d6\u0002V\u00063\u0003\u0001`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u00000\f06\u00063\u0001\u0001`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000\u001c\f\u001c6\u0001\u0001e\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d6\u0002Z\u00d6\u0002\\\u0010\u0010\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d6\u0002Z\u00d6\u0002\\\t\u0000\u0010An/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d6\u0002b\u00d6\u0002d\u0003n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d6\u0002Z\u00d6\u0002d\u0010\u0010\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d6\u0002Z\u00d6\u0002d\t\u0000 An/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d6\u0002l\u00d6\u0002n\u0003n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d6\u0002Z\u00d6\u0002n\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d6\u00020\u00d6\u0002p\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d6\u0002\"\u00d6\u0002p\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d4\u0002\"\u00d6\u0002p\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d2\u0002\"\u00d6\u0002p\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d0\u0002\u0018\u00d6\u0002p\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00ce\u0002$\u00ce\u00026\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00de\u0001\u001e\u00de\u00016!.scalus.prelude.crypto.bls12_381.Scalar$.scale2\u0000A\u0093\u001aw\u001b\u0010\u0013&4\u00ee6\t\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00de\u0001\u001e\u00de\u00016\u0005\u0001k\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00ec\u0002&\u00ec\u00028\u0003\u0001\u0002go\u0000A\u0093\u001aw\u001b\u0010\u0013&4\u00ee6\t\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f0\u0002&\u00f0\u0002>\u0005\u0001k\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f0\u0002B\u00f0\u0002T\n1\u00989`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000X\fX6\u0001\u0001k\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f2\u0002&\u00f2\u0002(\u0010\u0011\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f2\u0002&\u00f2\u0002(\t\u0000\u0000An/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f2\u00020\u00f2\u0002B\u0007n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f2\u0002&\u00f2\u0002B\u0001\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f2\u0002N\u00f2\u0002V\u00060\u0001\u0002go\u0000A\u0093\u001aw\u001b\u0010\u0013&4\u00ee6\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f4\u0002*\u00f4\u0002.\u00065\u0001'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u0001)scalus.prelude.crypto.bls12_381.Scalar$.*\u0000A\u0093\u001aw\u001b\u0010d\u00c6\u009d\u00c6\u00c3&4\u00ee6\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f4\u0002:\u00f4\u0002<\u0001\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f4\u00020\u00f4\u00028\u0010d\u00c6\u009d\u00c6\u00c3&4\u00ee6\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f4\u00020\u00f4\u0002<\u0001\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f4\u0002>\u00f4\u0002F\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f4\u00020\u00f4\u0002F\u0010\u0013&4\u00ee6\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f4\u0002*\u00f4\u0002V\u00063\u0001\u0001`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000\u001c\f\u001c6\u0001\u0001k\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f4\u0002J\u00f4\u0002L\u0010\u0010\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f4\u0002J\u00f4\u0002L\t\u0000\u0010An/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f4\u0002R\u00f4\u0002T\u0003n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f4\u0002J\u00f4\u0002T\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f4\u0002*\u00f4\u0002V\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f2\u0002 \u00f4\u0002V\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f0\u0002B\u00f0\u0002T\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f0\u0002&\u00f0\u0002>\u0005\u0018\u00cc!`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000b\fb6\u0001\u0001k\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f8\u0002\u001e\u00f8\u0002 \u0010\u0011\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f8\u0002\u001e\u00f8\u0002 \t\u0000\u0000An/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f8\u0002&\u00f8\u0002(\u0007n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f8\u0002\u001e\u00f8\u0002(\u0006\u00a1'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u0001,scalus.prelude.crypto.bls12_381.Scalar$.zero\u0000A\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f8\u00024\u00f8\u0002<\t1\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f8\u00024\u00f8\u0002<\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f8\u00024\u00f8\u0002<\u00060\u0001\u0002go\u0000A\u0093\u001aw\u001b\u0010\u0013&4\u00ee6\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00fa\u0002\"\u00fa\u0002&\u0001\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00fa\u0002(\u00fa\u00020\u0010\u0013&4\u00ee6\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00fa\u0002\"\u00fa\u00028\u0001\u0001k\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00fa\u00024\u00fa\u00026\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00fa\u0002\"\u00fa\u00028\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f8\u0002\u0018\u00fa\u00028\u0011n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00f8\u0002\u0018\u00fa\u00028\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00ec\u0002&\u00ec\u00028\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00de\u0001\u001e\u00de\u00016!/scalus.prelude.crypto.bls12_381.Scalar$.unary_-\u0000A\u0093\u001aw\u001b\f\u0098\u00d3\u00b8\u00d8!\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00de\u0001\u001e\u00de\u00016\n1\u00989`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000X\fX6\u001e\u0001\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u008a\u0003\u001e\u008a\u0003&\u0001\bunScalar\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u008a\u0003\u001e\u008a\u00038\u0010\u0011\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u008a\u0003\u001e\u008a\u00038\t\u0000\u0000An/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u008a\u0003@\u008a\u0003R\u0007n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u008a\u0003\u001e\u008a\u0003R\u0001\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u008a\u0003^\u008a\u0003f\u0011&scalus.prelude.crypto.bls12_381.Scalar\u0000\u00cc\u00f2\u00bf\u00fb\u008cf\u0003`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000\u001c\f\u001c6\u0015'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u00012scalus.prelude.crypto.bls12_381.Scalar$.fieldPrime\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u008c\u00038\u008c\u0003L\u0010\u0010\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u008c\u00038\u008c\u0003L\u001e\u0001\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u008c\u0003R\u008c\u0003Z\u0001\bunScalar\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u008c\u0003R\u008c\u0003l\u0003n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u008c\u00038\u008c\u0003l\u0006Li\u00dcl\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u008c\u0003\"\u008c\u0003n\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u008a\u0003\u0018\u008c\u0003n\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00de\u0001\u001e\u00de\u00016!-scalus.prelude.crypto.bls12_381.Scalar$.recip\u0000A\u0093\u001aw\u001b\u000f\u00c8\u00daur!\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00de\u0001\u001e\u00de\u00016\u00065\u0001'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u0001)scalus.prelude.crypto.bls12_381.Scalar$./\u0000A\u0093\u001aw\u001b\u0010d\u00c6\u009d\u00c6\u00c3\u00f26\u009d\\\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u009a\u0003P\u009a\u0003R\u0006\u00a1'scalus.prelude.crypto.bls12_381.Scalar$\u0000\u0001+scalus.prelude.crypto.bls12_381.Scalar$.one\u0000A\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u009a\u0003H\u009a\u0003N\t1\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u009a\u0003H\u009a\u0003N\f\u0098\u00d3\u00b8\u00d9n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u009a\u0003H\u009a\u0003N\u0010d\u00c6\u009d\u00c6\u00c3\u00f26\u009d\\\u0081n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u009a\u0003H\u009a\u0003R\u0001\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u009a\u0003T\u009a\u0003\\\u000f\u00c8\u00dausn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u009a\u0003H\u009a\u0003\\\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00de\u0001\u001e\u00de\u00016!-scalus.prelude.crypto.bls12_381.Scalar$.toInt\u0000A\u0093\u001aw\u001b\u0002!\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00de\u0001\u001e\u00de\u00016\u001e\u0001\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00a8\u00038\u00a8\u0003@\u0001\bunScalar\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00a8\u00038\u00a8\u0003R\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00de\u0001\u001e\u00de\u00016!=scalus.prelude.crypto.bls12_381.Scalar$.toByteStringBigEndian\u0000A\u0093\u001aw\u001b\u0010\u0010\t\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00de\u0001\u001e\u00de\u00016\u0005\u0004size\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00ba\u0003D\u00ba\u0003\\\u00061\u009aI`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000\u00d8\u0006\f\u00d8\u00066\tDan/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00bc\u0003@\u00bc\u0003H\u0010\u0014\u0004\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00bc\u0003\u0018\u00bc\u0003t\u0001\u0004size\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00bc\u0003L\u00bc\u0003T\u0010\u0010\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00bc\u0003\u0018\u00bc\u0003t\u001e\u0001\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00bc\u0003X\u00bc\u0003`\u0001\bunScalar\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00bc\u0003X\u00bc\u0003r\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00bc\u0003\u0018\u00bc\u0003t\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00ba\u0003D\u00ba\u0003\\\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00de\u0001\u001e\u00de\u00016!@scalus.prelude.crypto.bls12_381.Scalar$.toByteStringLittleEndian\u0000A\u0093\u001aw\u001b\u0010\u0010\t\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_").append("381/Scalar.scala\u0000\u00de\u0001\u001e\u00de\u00016\u0005\u0004size\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00ce\u0003J\u00ce\u0003b\u00061\u009aI`/home/runner/work/scalus/scalus/scalus-plugin/src/main/shared/scala/scalus/sir/SIRBuiltins.scala\u0000\u00d8\u0006\f\u00d8\u00066\t@an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d0\u0003@\u00d0\u0003J\u0010\u0014\u0004\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d0\u0003\u0018\u00d0\u0003v\u0001\u0004size\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d0\u0003N\u00d0\u0003V\u0010\u0010\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d0\u0003\u0018\u00d0\u0003v\u001e\u0001\u0004self\u00002cN\u00e3an/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d0\u0003Z\u00d0\u0003b\u0001\bunScalar\u0000\tn/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d0\u0003Z\u00d0\u0003t\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00d0\u0003\u0018\u00d0\u0003v\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00ce\u0003J\u00ce\u0003b\u0001n/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/prelude/crypto/bls12_381/Scalar.scala\u0000\u00de\u0001\u001e\u00de\u00016\u0001").toString());
                        object2 = module == null ? LazyVals.NullValue$.MODULE$ : module;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, Scalar.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.sirModule$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, Scalar.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return module;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, Scalar.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<SIRModuleWithDeps> sirDeps() {
        Object object = this.sirDeps$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (List)this.sirDeps$lzyINIT1();
    }

    private Object sirDeps$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.sirDeps$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Scalar.OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    List<SIRModuleWithDeps> list2 = null;
                    List<SIRModuleWithDeps> list3 = null;
                    try {
                        list3 = SIRModuleWithDeps$.MODULE$.list((Seq<SIRModuleWithDeps>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SIRModuleWithDeps[0]));
                        list2 = list3 == null ? LazyVals.NullValue$.MODULE$ : list3;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, Scalar.OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, list2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.sirDeps$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, Scalar.OFFSET$_m_1, (Object)waiting, list2);
                            waiting.countDown();
                        }
                    }
                    return list3;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, Scalar.OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private final Scalar go$1(Scalar self, BigInt k) {
        while (!BoxesRunTime.equals((Object)k, (Object)package$.MODULE$.BigInt().apply(0))) {
            Scalar scalar = this.$times(self, self);
            BigInt bigInt = k.$minus(BigInt$.MODULE$.int2bigInt(1));
            self = scalar;
            k = bigInt;
        }
        return self;
    }
}

