/*
 * Decompiled with CFR 0.152.
 */
package scalus.sir.linking;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.package$;
import scala.reflect.Enum;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scalus.sir.AnnotatedSIR;
import scalus.sir.AnnotationsDecl;
import scalus.sir.AnnotationsDecl$;
import scalus.sir.Binding;
import scalus.sir.Binding$;
import scalus.sir.DataDecl;
import scalus.sir.Module;
import scalus.sir.SIR;
import scalus.sir.SIR$And$;
import scalus.sir.SIR$Apply$;
import scalus.sir.SIR$Case$;
import scalus.sir.SIR$Cast$;
import scalus.sir.SIR$Constr$;
import scalus.sir.SIR$Decl$;
import scalus.sir.SIR$Error$;
import scalus.sir.SIR$ExternalVar$;
import scalus.sir.SIR$IfThenElse$;
import scalus.sir.SIR$LamAbs$;
import scalus.sir.SIR$Let$;
import scalus.sir.SIR$LetFlags$;
import scalus.sir.SIR$Match$;
import scalus.sir.SIR$Not$;
import scalus.sir.SIR$Or$;
import scalus.sir.SIR$Select$;
import scalus.sir.SIR$package$;
import scalus.sir.SIRCompiled;
import scalus.sir.SIRPosition;
import scalus.sir.SIRPosition$;
import scalus.sir.SIRType;
import scalus.sir.SIRType$Data$;
import scalus.sir.SIRType$Fun$;
import scalus.sir.linking.SIRLinker;
import scalus.sir.linking.SIRLinker$;
import scalus.sir.linking.SIRLinker$LinkingDefState$;
import scalus.sir.linking.SIRLinker$LinkingDefState$Linked$;
import scalus.sir.linking.SIRLinkerOptions;

public class SIRLinker {
    private final SIRLinkerOptions options;
    private final scala.collection.immutable.Map<String, Module> moduleDefs;
    private final LinkedHashMap<String, LinkingDefState> globalDefs;
    private final LinkedHashMap<String, DataDecl> globalDataDecls;
    private final scala.collection.mutable.Map<String, LinkedHashMap<String, SIR>> moduleDefsCache;
    private List<Tuple2<String, SIRPosition>> errorLog;

    public static scala.collection.immutable.Map<String, Module> readModules(List<SIRCompiled> list2) {
        return SIRLinker$.MODULE$.readModules(list2);
    }

    public SIRLinker(SIRLinkerOptions options, scala.collection.immutable.Map<String, Module> moduleDefs) {
        this.options = options;
        this.moduleDefs = moduleDefs;
        this.globalDefs = LinkedHashMap$.MODULE$.empty();
        this.globalDataDecls = LinkedHashMap$.MODULE$.empty();
        this.moduleDefsCache = LinkedHashMap$.MODULE$.empty().withDefaultValue((Object)LinkedHashMap$.MODULE$.empty());
        this.errorLog = package$.MODULE$.List().empty();
    }

    public List<Tuple2<String, SIRPosition>> retrieveErrors() {
        return this.errorLog;
    }

    private <A> A error(String message, SIRPosition pos, A defaultValue) {
        if (this.options.printErrors()) {
            Predef$.MODULE$.println((Object)new StringBuilder(11).append("Error: ").append(message).append(" at ").append(pos.show()).toString());
        } else {
            this.errorLog = (List)this.errorLog.$colon$plus((Object)Tuple2$.MODULE$.apply((Object)message, (Object)pos));
        }
        return defaultValue;
    }

    public SIR link(SIR sir, SIRPosition pos) {
        if (this.options.debugLevel() > 1) {
            Predef$.MODULE$.println((Object)new StringBuilder(25).append("Linking SIR at ").append(pos.show()).append(", options=").append(this.options).toString());
        }
        SIR processed = this.traverseAndLink(sir, pos);
        SIR full = (SIR)this.globalDefs.values().foldRight((Object)processed, (Function2 & Serializable)(x$1, x$2) -> {
            Serializable serializable;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            LinkingDefState state = (LinkingDefState)tuple2._1();
            SIR acc = (SIR)tuple2._2();
            LinkingDefState linkingDefState = state;
            if (linkingDefState instanceof LinkingDefState.Linked) {
                AnnotatedSIR annotatedSIR;
                SIRLinkedBinding sIRLinkedBinding;
                LinkingDefState.Linked linked = SIRLinker$LinkingDefState$Linked$.MODULE$.unapply((LinkingDefState.Linked)linkingDefState);
                SIRLinkedBinding b = sIRLinkedBinding = linked._1();
                List list2 = (List)new .colon.colon((Object)Binding$.MODULE$.apply(b.name(), b.body().tp(), b.body()), (List)Nil$.MODULE$);
                SIR sIR = acc;
                if (sIR instanceof AnnotatedSIR) {
                    AnnotatedSIR annssir;
                    annotatedSIR = annssir = (AnnotatedSIR)sIR;
                } else {
                    String msg = new StringBuilder(46).append("Unexpected Decl. In binding ").append(b.name()).append(" in SIRLinker.link").toString();
                    AnnotationsDecl annotationsDecl = AnnotationsDecl$.MODULE$.apply(SIRPosition$.MODULE$.apply("/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/sir/linking/SIRLinker.scala", 66, 47, 66, 68), (Option<String>)None$.MODULE$, (scala.collection.immutable.Map<String, SIR>)Predef$.MODULE$.Map().empty());
                    annotatedSIR = this.error(msg, pos, SIR$Error$.MODULE$.apply(msg, annotationsDecl.copy(pos, annotationsDecl.copy$default$2(), annotationsDecl.copy$default$3())));
                }
                AnnotationsDecl annotationsDecl = AnnotationsDecl$.MODULE$.apply(SIRPosition$.MODULE$.apply("/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/sir/linking/SIRLinker.scala", 70, 22, 70, 43), (Option<String>)None$.MODULE$, (scala.collection.immutable.Map<String, SIR>)Predef$.MODULE$.Map().empty());
                serializable = SIR$Let$.MODULE$.apply((List<Binding>)list2, annotatedSIR, b.flags(), annotationsDecl.copy(pos, annotationsDecl.copy$default$2(), annotationsDecl.copy$default$3()));
                return (SIR)((Object)serializable);
            } else {
                LinkingDefState linkingDefState2 = SIRLinker$LinkingDefState$.Linking;
                LinkingDefState linkingDefState3 = linkingDefState;
                if (linkingDefState2 != null ? !linkingDefState2.equals(linkingDefState3) : linkingDefState3 != null) throw new MatchError((Object)linkingDefState);
                String message = new StringBuilder(24).append("Linking in progress for ").append(state).toString();
                AnnotationsDecl annotationsDecl = AnnotationsDecl$.MODULE$.apply(SIRPosition$.MODULE$.apply("/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/sir/linking/SIRLinker.scala", 79, 24, 79, 45), (Option<String>)None$.MODULE$, (scala.collection.immutable.Map<String, SIR>)Predef$.MODULE$.Map().empty());
                serializable = this.error(message, pos, SIR$Error$.MODULE$.apply(message, annotationsDecl.copy(pos, annotationsDecl.copy$default$2(), annotationsDecl.copy$default$3())));
            }
            return (SIR)((Object)serializable);
        });
        SIR dataDecls = (SIR)this.globalDataDecls.foldRight((Object)full, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                DataDecl decl = (DataDecl)tuple2._2();
                SIR acc = (SIR)tuple22._2();
                return SIR$Decl$.MODULE$.apply(decl, acc);
            }
            throw new MatchError((Object)tuple22);
        });
        return dataDecls;
    }

    private SIR traverseAndLink(SIR sir, SIRPosition pos) {
        SIR sIR = sir;
        if (sIR instanceof SIR.Decl) {
            SIR.Decl decl = SIR$Decl$.MODULE$.unapply((SIR.Decl)sIR);
            DataDecl dataDecl = decl._1();
            SIR sIR2 = decl._2();
            DataDecl data = dataDecl;
            SIR term = sIR2;
            return SIR$Decl$.MODULE$.apply(data, this.traverseAndLink(term, pos));
        }
        if (sIR instanceof AnnotatedSIR) {
            AnnotatedSIR ans = (AnnotatedSIR)sIR;
            return this.traverseAndLinkExpr(ans, pos);
        }
        throw new MatchError((Object)sIR);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AnnotatedSIR traverseAndLinkExpr(AnnotatedSIR sir, SIRPosition pos) {
        AnnotatedSIR annotatedSIR = sir;
        if (annotatedSIR instanceof SIR.ExternalVar) {
            SIR.ExternalVar externalVar = (SIR.ExternalVar)annotatedSIR;
            SIR.ExternalVar externalVar2 = SIR$ExternalVar$.MODULE$.unapply(externalVar);
            String string = externalVar2._1();
            String string2 = externalVar2._2();
            SIRType sIRType = externalVar2._3();
            AnnotationsDecl annotationsDecl = externalVar2._4();
            String moduleName = string;
            String name = string2;
            SIRType tp = sIRType;
            AnnotationsDecl ann = annotationsDecl;
            SIR.ExternalVar v = externalVar;
            if (!this.globalDefs.contains((Object)name)) {
                String string3 = moduleName;
                String string4 = "scalus.builtin.internal.UniversalDataConversion$";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    String string5 = name;
                    String string6 = "scalus.builtin.internal.UniversalDataConversion$.fromData";
                    if (string5 == null) {
                        if (string6 == null) return v;
                    } else if (string5.equals(string6)) return v;
                    String string7 = name;
                    String string8 = "scalus.builtin.internal.UniversalDataConversion$.toData";
                    if (string7 == null) {
                        if (string8 == null) return v;
                    } else if (string7.equals(string8)) return v;
                    String msg = new StringBuilder(63).append("Unknown external variable in universal data conversion module: ").append(name).toString();
                    this.error(msg, ann.pos(), v);
                    return v;
                } else {
                    this.linkDefinition(moduleName, name, pos, tp, ann);
                }
                return v;
            }
        }
        if (annotatedSIR instanceof SIR.Let) {
            SIR.Let let = (SIR.Let)annotatedSIR;
            SIR.Let let2 = SIR$Let$.MODULE$.unapply(let);
            List<Binding> list2 = let2._1();
            SIR sIR = let2._2();
            int n = let2._3();
            AnnotationsDecl annotationsDecl = let2._4();
            List<Binding> bindings = list2;
            SIR body = sIR;
            int flags = n;
            AnnotationsDecl anns = annotationsDecl;
            SIR.Let v = let;
            List nBingings = bindings.map((Function1 & Serializable)b -> Binding$.MODULE$.apply(b.name(), b.tp(), this.traverseAndLink(b.value(), pos)));
            SIR nBody = this.traverseAndLink(body, pos);
            return SIR$Let$.MODULE$.apply((List<Binding>)nBingings, nBody, flags, anns);
        }
        if (annotatedSIR instanceof SIR.LamAbs) {
            SIR.LamAbs lamAbs = SIR$LamAbs$.MODULE$.unapply((SIR.LamAbs)annotatedSIR);
            SIR.Var var = lamAbs._1();
            SIR sIR = lamAbs._2();
            List<SIRType.TypeVar> list3 = lamAbs._3();
            AnnotationsDecl annotationsDecl = lamAbs._4();
            SIR.Var param = var;
            SIR term = sIR;
            List<SIRType.TypeVar> typeParams = list3;
            AnnotationsDecl anns = annotationsDecl;
            return SIR$LamAbs$.MODULE$.apply(param, this.traverseAndLink(term, pos), typeParams, anns);
        }
        if (annotatedSIR instanceof SIR.Apply) {
            AnnotatedSIR annotatedSIR2;
            SIR.Apply apply = SIR$Apply$.MODULE$.unapply((SIR.Apply)annotatedSIR);
            AnnotatedSIR annotatedSIR3 = apply._1();
            AnnotatedSIR annotatedSIR4 = apply._2();
            SIRType sIRType = apply._3();
            AnnotationsDecl annotationsDecl = apply._4();
            AnnotatedSIR f = annotatedSIR3;
            AnnotatedSIR arg = annotatedSIR4;
            SIRType tp = sIRType;
            AnnotationsDecl anns = annotationsDecl;
            if (this.options.useUniversalDataConversion()) {
                Option option = anns.data().get((Object)"fromData");
                if (option instanceof Some) {
                    SIR v = (SIR)((Some)option).value();
                    AnnotationsDecl annotationsDecl2 = AnnotationsDecl$.MODULE$.apply(SIRPosition$.MODULE$.apply("/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/sir/linking/SIRLinker.scala", 123, 30, 123, 51), (Option<String>)None$.MODULE$, (scala.collection.immutable.Map<String, SIR>)Predef$.MODULE$.Map().empty());
                    annotatedSIR2 = SIR$ExternalVar$.MODULE$.apply("scalus.builtin.internal.UniversalDataConversion$", "scalus.builtin.internal.UniversalDataConversion$.fromData", SIRType$Fun$.MODULE$.apply(SIRType$Data$.MODULE$, tp), annotationsDecl2.copy(f.anns().pos(), annotationsDecl2.copy$default$2(), annotationsDecl2.copy$default$3()));
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    Option option2 = anns.data().get((Object)"toData");
                    if (option2 instanceof Some) {
                        SIR v = (SIR)((Some)option2).value();
                        AnnotationsDecl annotationsDecl3 = AnnotationsDecl$.MODULE$.apply(SIRPosition$.MODULE$.apply("/home/runner/work/scalus/scalus/scalus-core/shared/src/main/scala/scalus/sir/linking/SIRLinker.scala", 132, 38, 132, 59), (Option<String>)None$.MODULE$, (scala.collection.immutable.Map<String, SIR>)Predef$.MODULE$.Map().empty());
                        annotatedSIR2 = SIR$ExternalVar$.MODULE$.apply("scalus.builtin.internal.UniversalDataConversion$", "scalus.builtin.internal.UniversalDataConversion$.toData", SIRType$Fun$.MODULE$.apply(arg.tp(), SIRType$Data$.MODULE$), annotationsDecl3.copy(f.anns().pos(), annotationsDecl3.copy$default$2(), annotationsDecl3.copy$default$3()));
                    } else {
                        if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                        annotatedSIR2 = f;
                    }
                }
            } else {
                annotatedSIR2 = f;
            }
            AnnotatedSIR fReplaced = annotatedSIR2;
            AnnotatedSIR nF = this.traverseAndLinkExpr(fReplaced, pos);
            AnnotatedSIR nArg = this.traverseAndLinkExpr(arg, pos);
            return SIR$Apply$.MODULE$.apply(nF, nArg, tp, anns);
        }
        if (annotatedSIR instanceof SIR.And) {
            SIR.And and = SIR$And$.MODULE$.unapply((SIR.And)annotatedSIR);
            AnnotatedSIR annotatedSIR5 = and._1();
            AnnotatedSIR annotatedSIR6 = and._2();
            AnnotationsDecl annotationsDecl = and._3();
            AnnotatedSIR lhs = annotatedSIR5;
            AnnotatedSIR rhs = annotatedSIR6;
            AnnotationsDecl anns = annotationsDecl;
            AnnotatedSIR nLhs = this.traverseAndLinkExpr(lhs, pos);
            AnnotatedSIR nRhs = this.traverseAndLinkExpr(rhs, pos);
            return SIR$And$.MODULE$.apply(nLhs, nRhs, anns);
        }
        if (annotatedSIR instanceof SIR.Or) {
            SIR.Or or = SIR$Or$.MODULE$.unapply((SIR.Or)annotatedSIR);
            AnnotatedSIR annotatedSIR7 = or._1();
            AnnotatedSIR annotatedSIR8 = or._2();
            AnnotationsDecl annotationsDecl = or._3();
            AnnotatedSIR lhs = annotatedSIR7;
            AnnotatedSIR rhs = annotatedSIR8;
            AnnotationsDecl anns = annotationsDecl;
            AnnotatedSIR nLhs = this.traverseAndLinkExpr(lhs, pos);
            AnnotatedSIR nRhs = this.traverseAndLinkExpr(rhs, pos);
            return SIR$Or$.MODULE$.apply(nLhs, nRhs, anns);
        }
        if (annotatedSIR instanceof SIR.Not) {
            SIR.Not not = SIR$Not$.MODULE$.unapply((SIR.Not)annotatedSIR);
            AnnotatedSIR annotatedSIR9 = not._1();
            AnnotationsDecl annotationsDecl = not._2();
            AnnotatedSIR term = annotatedSIR9;
            AnnotationsDecl anns = annotationsDecl;
            return SIR$Not$.MODULE$.apply(this.traverseAndLinkExpr(term, pos), anns);
        }
        if (annotatedSIR instanceof SIR.IfThenElse) {
            SIR.IfThenElse ifThenElse = SIR$IfThenElse$.MODULE$.unapply((SIR.IfThenElse)annotatedSIR);
            AnnotatedSIR annotatedSIR10 = ifThenElse._1();
            AnnotatedSIR annotatedSIR11 = ifThenElse._2();
            AnnotatedSIR annotatedSIR12 = ifThenElse._3();
            SIRType sIRType = ifThenElse._4();
            AnnotationsDecl annotationsDecl = ifThenElse._5();
            AnnotatedSIR cond = annotatedSIR10;
            AnnotatedSIR t = annotatedSIR11;
            AnnotatedSIR f = annotatedSIR12;
            SIRType tp = sIRType;
            AnnotationsDecl anns = annotationsDecl;
            AnnotatedSIR nCond = this.traverseAndLinkExpr(cond, pos);
            AnnotatedSIR nT = this.traverseAndLinkExpr(t, pos);
            AnnotatedSIR nR = this.traverseAndLinkExpr(f, pos);
            return SIR$IfThenElse$.MODULE$.apply(nCond, nT, nR, tp, anns);
        }
        if (annotatedSIR instanceof SIR.Constr) {
            SIR.Constr constr = SIR$Constr$.MODULE$.unapply((SIR.Constr)annotatedSIR);
            String string = constr._1();
            DataDecl dataDecl = constr._2();
            List<SIR> list4 = constr._3();
            SIRType sIRType = constr._4();
            AnnotationsDecl annotationsDecl = constr._5();
            String name = string;
            DataDecl data = dataDecl;
            List<SIR> args = list4;
            SIRType tp = sIRType;
            AnnotationsDecl anns = annotationsDecl;
            this.globalDataDecls.put((Object)data.name(), (Object)data);
            List nArgs = args.map((Function1 & Serializable)a -> this.traverseAndLink((SIR)a, pos));
            return SIR$Constr$.MODULE$.apply(name, data, (List<SIR>)nArgs, tp, anns);
        }
        if (annotatedSIR instanceof SIR.Match) {
            SIR.Match match = SIR$Match$.MODULE$.unapply((SIR.Match)annotatedSIR);
            AnnotatedSIR annotatedSIR13 = match._1();
            List<SIR.Case> list5 = match._2();
            SIRType sIRType = match._3();
            AnnotationsDecl annotationsDecl = match._4();
            AnnotatedSIR scrutinee = annotatedSIR13;
            List<SIR.Case> cases = list5;
            SIRType rhsType = sIRType;
            AnnotationsDecl anns = annotationsDecl;
            AnnotatedSIR nScrutinee = this.traverseAndLinkExpr(scrutinee, pos);
            List nCases = cases.map((Function1 & Serializable)c -> SIR$Case$.MODULE$.apply(c.pattern(), this.traverseAndLink(c.body(), pos), c.anns()));
            return SIR$Match$.MODULE$.apply(nScrutinee, (List<SIR.Case>)nCases, rhsType, anns);
        }
        if (annotatedSIR instanceof SIR.Select) {
            SIR.Select select = SIR$Select$.MODULE$.unapply((SIR.Select)annotatedSIR);
            SIR sIR = select._1();
            String string = select._2();
            SIRType sIRType = select._3();
            AnnotationsDecl annotationsDecl = select._4();
            SIR scrutinee = sIR;
            String field = string;
            SIRType tp = sIRType;
            AnnotationsDecl anns = annotationsDecl;
            SIR nScrutinee = this.traverseAndLink(scrutinee, pos);
            return SIR$Select$.MODULE$.apply(nScrutinee, field, tp, anns);
        }
        if (!(annotatedSIR instanceof SIR.Cast)) return annotatedSIR;
        SIR.Cast cast = SIR$Cast$.MODULE$.unapply((SIR.Cast)annotatedSIR);
        AnnotatedSIR annotatedSIR14 = cast._1();
        SIRType sIRType = cast._2();
        AnnotationsDecl annotationsDecl = cast._3();
        AnnotatedSIR term = annotatedSIR14;
        SIRType tp = sIRType;
        AnnotationsDecl anns = annotationsDecl;
        return SIR$Cast$.MODULE$.apply(this.traverseAndLinkExpr(term, pos), tp, anns);
    }

    private boolean findAndLinkDefinition(Map<String, SIR> defs, String fullName, SIRType tp, SIRPosition srcPos) {
        Option found = defs.get((Object)fullName);
        found.foreach((Function1)(JProcedure1 & Serializable)sir -> {
            this.globalDefs.update((Object)fullName, (Object)SIRLinker$LinkingDefState$.Linking);
            SIR nSir = this.traverseAndLink((SIR)sir, srcPos);
            this.globalDefs.remove((Object)fullName);
            this.globalDefs.update((Object)fullName, (Object)SIRLinker$LinkingDefState$Linked$.MODULE$.apply(new SIRLinkedBinding(fullName, SIR$LetFlags$.MODULE$.Recursivity(), nSir)));
        });
        return found.isDefined();
    }

    private void linkDefinition(String moduleName, String fullName, SIRPosition pos, SIRType tp, AnnotationsDecl anns) {
        Either<String, LinkedHashMap<String, SIR>> either = this.retrieveModule(moduleName, pos);
        if (either instanceof Left) {
            String filename = (String)((Left)either).value();
            this.error(new StringBuilder(83).append("Module not found during linking: ").append(moduleName).append(" , missing filename: ").append(filename).append(" referenced for name ").append(fullName).append(" from ").append(anns.pos().file()).append(": ").append(anns.pos().startLine() + 1).toString(), pos, BoxedUnit.UNIT);
            return;
        }
        if (either instanceof Right) {
            LinkedHashMap defs = (LinkedHashMap)((Right)either).value();
            if (!this.findAndLinkDefinition((Map<String, SIR>)defs, fullName, tp, pos)) {
                this.error(new StringBuilder(48).append("Symbol not found during linking: ").append(fullName).append(" in module ").append(moduleName).append(" at ").append(pos.show()).toString(), anns.pos(), BoxedUnit.UNIT);
                return;
            }
            return;
        }
        throw new MatchError(either);
    }

    private Either<String, LinkedHashMap<String, SIR>> retrieveModule(String moduleName, SIRPosition srcPos) {
        Option option = this.moduleDefsCache.get((Object)moduleName);
        if (option instanceof Some) {
            LinkedHashMap defs = (LinkedHashMap)((Some)option).value();
            return package$.MODULE$.Right().apply((Object)defs);
        }
        if (None$.MODULE$.equals(option)) {
            Option option2 = this.moduleDefs.get((Object)moduleName);
            if (option2 instanceof Some) {
                Module module = (Module)((Some)option2).value();
                this.validateSIRVersion(module, moduleName, srcPos);
                LinkedHashMap defsMap = LinkedHashMap$.MODULE$.from((IterableOnce)module.defs().map((Function1 & Serializable)d -> {
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)d.name());
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)d.value());
                }));
                this.moduleDefsCache.put((Object)moduleName, (Object)defsMap);
                return package$.MODULE$.Right().apply((Object)defsMap);
            }
            if (None$.MODULE$.equals(option2)) {
                return package$.MODULE$.Left().apply((Object)new StringBuilder(33).append("Can't find module ").append(moduleName).append(" in dependenies").toString());
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    private void validateSIRVersion(Module module, String moduleName, SIRPosition srcPos) {
        if (module.version()._1$mcI$sp() != SIR$package$.MODULE$.SIRVersion()._1$mcI$sp() || module.version()._1$mcI$sp() == SIR$package$.MODULE$.SIRVersion()._1$mcI$sp() && SIR$package$.MODULE$.SIRVersion()._2$mcI$sp() < module.version()._2$mcI$sp()) {
            this.error(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(322).append("During linking I've found that a module '").append(moduleName).append("' has an incompatible SIR version: ").append(module.version()).append(" (expected: ").append(SIR$package$.MODULE$.SIRVersion()).append(").\n                   |This can happen if you try to link a module compiled with a different version of Scalus.\n                   |Please, recompile the module with the version of Scalus that has the SIR version ").append(SIR$package$.MODULE$.SIRVersion()).append("\n                   |").toString())), srcPos, BoxedUnit.UNIT);
            return;
        }
    }

    public static abstract class LinkingDefState
    implements Product,
    Enum {
        public static LinkingDefState fromOrdinal(int n) {
            return SIRLinker$LinkingDefState$.MODULE$.fromOrdinal(n);
        }
    }

    public static class SIRLinkedBinding {
        private final String name;
        private final int flags;
        private final SIR body;

        public SIRLinkedBinding(String name, int flags, SIR body) {
            this.name = name;
            this.flags = flags;
            this.body = body;
        }

        public String name() {
            return this.name;
        }

        public int flags() {
            return this.flags;
        }

        public SIR body() {
            return this.body;
        }
    }
}

