/*
 * Decompiled with CFR 0.152.
 */
package scalus.uplc.eval;

import scala.;
import scala.$less$colon$less$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scalus.builtin.PlatformSpecific;
import scalus.cardano.ledger.Language;
import scalus.cardano.ledger.Language$;
import scalus.uplc.BuiltinSemanticsVariant;
import scalus.uplc.BuiltinsMeaning;
import scalus.uplc.Constant;
import scalus.uplc.Constant$Unit$;
import scalus.uplc.DeBruijn$;
import scalus.uplc.DeBruijnedProgram;
import scalus.uplc.Term;
import scalus.uplc.Term$Const$;
import scalus.uplc.eval.BudgetSpender;
import scalus.uplc.eval.CekMachine;
import scalus.uplc.eval.CountingBudgetSpender;
import scalus.uplc.eval.ExBudget;
import scalus.uplc.eval.ExBudgetCategory;
import scalus.uplc.eval.InvalidReturnValue;
import scalus.uplc.eval.Logger;
import scalus.uplc.eval.MachineParams;
import scalus.uplc.eval.NoBudgetSpender$;
import scalus.uplc.eval.NoLogger$;
import scalus.uplc.eval.PlutusVM$;
import scalus.uplc.eval.Result;
import scalus.uplc.eval.Result$Failure$;
import scalus.uplc.eval.Result$Success$;
import scalus.uplc.eval.TallyingBudgetSpenderLogger;

public class PlutusVM {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(PlutusVM.class.getDeclaredField("builtins$lzy1"));
    private final Language language;
    private final MachineParams machineParams;
    private final BuiltinSemanticsVariant semanticVariant;
    private PlatformSpecific platformSpecific;
    private volatile Object builtins$lzy1;

    public static PlutusVM makePlutusV1VM() {
        return PlutusVM$.MODULE$.makePlutusV1VM();
    }

    public static PlutusVM makePlutusV1VM(MachineParams machineParams) {
        return PlutusVM$.MODULE$.makePlutusV1VM(machineParams);
    }

    public static PlutusVM makePlutusV2VM() {
        return PlutusVM$.MODULE$.makePlutusV2VM();
    }

    public static PlutusVM makePlutusV2VM(MachineParams machineParams) {
        return PlutusVM$.MODULE$.makePlutusV2VM(machineParams);
    }

    public static PlutusVM makePlutusV3VM() {
        return PlutusVM$.MODULE$.makePlutusV3VM();
    }

    public static PlutusVM makePlutusV3VM(MachineParams machineParams) {
        return PlutusVM$.MODULE$.makePlutusV3VM(machineParams);
    }

    public PlutusVM(Language language, MachineParams machineParams, BuiltinSemanticsVariant semanticVariant, PlatformSpecific platformSpecific) {
        this.language = language;
        this.machineParams = machineParams;
        this.semanticVariant = semanticVariant;
        this.platformSpecific = platformSpecific;
    }

    public Language language() {
        return this.language;
    }

    public MachineParams machineParams() {
        return this.machineParams;
    }

    public BuiltinSemanticsVariant semanticVariant() {
        return this.semanticVariant;
    }

    private BuiltinsMeaning builtins() {
        Object object = this.builtins$lzy1;
        if (object instanceof BuiltinsMeaning) {
            return (BuiltinsMeaning)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (BuiltinsMeaning)this.builtins$lzyINIT1();
    }

    private Object builtins$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.builtins$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    BuiltinsMeaning builtinsMeaning = null;
                    try {
                        builtinsMeaning = new BuiltinsMeaning(this.machineParams().builtinCostModel(), this.platformSpecific, this.semanticVariant());
                        object2 = builtinsMeaning == null ? LazyVals.NullValue$.MODULE$ : builtinsMeaning;
                        this.platformSpecific = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.builtins$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return builtinsMeaning;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Term evaluateScript(DeBruijnedProgram program, BudgetSpender budgetSpender, Logger logger) {
        Term result = this.evaluateDeBruijnedTerm(program.term(), budgetSpender, logger);
        if (this.isResultValid(result)) {
            return result;
        }
        throw new InvalidReturnValue(result);
    }

    public Result evaluateScriptDebug(DeBruijnedProgram program) {
        Result result;
        TallyingBudgetSpenderLogger spenderLogger = new TallyingBudgetSpenderLogger(new CountingBudgetSpender());
        try {
            Term result2 = this.evaluateScript(program, spenderLogger, spenderLogger);
            result = Result$Success$.MODULE$.apply(result2, spenderLogger.getSpentBudget(), (Map<ExBudgetCategory, Seq<ExBudget>>)spenderLogger.costs().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), spenderLogger.getLogsWithBudget());
        }
        catch (Exception e) {
            result = Result$Failure$.MODULE$.apply(e, spenderLogger.getSpentBudget(), (Map<ExBudgetCategory, Seq<ExBudget>>)spenderLogger.costs().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), spenderLogger.getLogsWithBudget());
        }
        return result;
    }

    public Term evaluateDeBruijnedTerm(Term debruijnedTerm, BudgetSpender budgetSpender, Logger logger) {
        CekMachine cek = new CekMachine(this.machineParams(), budgetSpender, logger, this.builtins());
        return DeBruijn$.MODULE$.fromDeBruijnTerm(cek.evaluateTerm(debruijnedTerm));
    }

    public BudgetSpender evaluateDeBruijnedTerm$default$2() {
        return NoBudgetSpender$.MODULE$;
    }

    public Logger evaluateDeBruijnedTerm$default$3() {
        return NoLogger$.MODULE$;
    }

    private boolean isResultValid(Term res) {
        block5: {
            Term term;
            Language language;
            block10: {
                block7: {
                    Language language2;
                    Language language3;
                    block9: {
                        block8: {
                            Language language4;
                            Language language5;
                            block6: {
                                Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)this.language(), (Object)res);
                                if (tuple2 == null) break block5;
                                language = (Language)((Object)tuple2._1());
                                term = (Term)tuple2._2();
                                language5 = Language$.PlutusV1;
                                language4 = language;
                                if (language5 != null) break block6;
                                if (language4 == null) break block7;
                                break block8;
                            }
                            if (((Object)((Object)language5)).equals((Object)language4)) break block7;
                        }
                        language3 = Language$.PlutusV2;
                        language2 = language;
                        if (language3 != null) break block9;
                        if (language2 == null) break block7;
                        break block10;
                    }
                    if (!((Object)((Object)language3)).equals((Object)language2)) break block10;
                }
                return true;
            }
            Language language6 = Language$.PlutusV3;
            Language language7 = language;
            if (!(language6 != null ? !((Object)((Object)language6)).equals((Object)language7) : language7 != null)) {
                Term.Const const_;
                Constant constant;
                if (term instanceof Term.Const && Constant$Unit$.MODULE$.equals(constant = (const_ = Term$Const$.MODULE$.unapply((Term.Const)term))._1())) {
                    return true;
                }
            }
        }
        return false;
    }
}

