/*
 * Decompiled with CFR 0.152.
 */
package scalus.builtin;

import org.bitcoins.crypto.ECDigitalSignature;
import org.bitcoins.crypto.ECDigitalSignature$;
import org.bitcoins.crypto.ECPublicKey$;
import org.bitcoins.crypto.PublicKey;
import org.bitcoins.crypto.SchnorrDigitalSignature;
import org.bitcoins.crypto.SchnorrDigitalSignature$;
import org.bitcoins.crypto.SchnorrPublicKey;
import org.bitcoins.crypto.SchnorrPublicKey$;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.digests.Blake2bDigest;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.jcajce.provider.digest.SHA3;
import scalus.builtin.ByteString;
import scalus.builtin.ByteString$;
import scalus.builtin.PlatformSpecific;
import scalus.utils.Utils$;
import scodec.bits.ByteVector$;

public class JVMPlatformSpecific
implements PlatformSpecific {
    @Override
    public ByteString sha2_256(ByteString bs) {
        return ByteString$.MODULE$.unsafeFromArray(Utils$.MODULE$.sha2_256(bs.bytes()));
    }

    @Override
    public ByteString sha3_256(ByteString bs) {
        SHA3.Digest256 digestSHA3 = new SHA3.Digest256();
        return ByteString$.MODULE$.unsafeFromArray(digestSHA3.digest(bs.bytes()));
    }

    @Override
    public ByteString blake2b_224(ByteString bs) {
        Blake2bDigest digest = new Blake2bDigest(224);
        digest.update(bs.bytes(), 0, bs.bytes().length);
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);
        return ByteString$.MODULE$.unsafeFromArray(hash);
    }

    @Override
    public ByteString blake2b_256(ByteString bs) {
        Blake2bDigest digest = new Blake2bDigest(256);
        digest.update(bs.bytes(), 0, bs.bytes().length);
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);
        return ByteString$.MODULE$.unsafeFromArray(hash);
    }

    @Override
    public boolean verifySchnorrSecp256k1Signature(ByteString pk, ByteString msg, ByteString sig) {
        if (pk.bytes().length != 32) {
            throw new IllegalArgumentException(new StringBuilder(26).append("Invalid public key length ").append(pk.bytes().length).toString());
        }
        if (msg.bytes().length != 32) {
            throw new IllegalArgumentException(new StringBuilder(23).append("Invalid message length ").append(msg.bytes().length).toString());
        }
        if (sig.bytes().length != 64) {
            throw new IllegalArgumentException(new StringBuilder(25).append("Invalid signature length ").append(sig.bytes().length).toString());
        }
        SchnorrDigitalSignature signature = (SchnorrDigitalSignature)SchnorrDigitalSignature$.MODULE$.apply(ByteVector$.MODULE$.apply(sig.bytes()));
        return ((SchnorrPublicKey)SchnorrPublicKey$.MODULE$.apply(ByteVector$.MODULE$.apply(pk.bytes()))).verify(ByteVector$.MODULE$.apply(msg.bytes()), signature);
    }

    @Override
    public boolean verifyEd25519Signature(ByteString pk, ByteString msg, ByteString sig) {
        Ed25519Signer verifier = new Ed25519Signer();
        verifier.init(false, (CipherParameters)new Ed25519PublicKeyParameters(pk.bytes(), 0));
        verifier.update(msg.bytes(), 0, msg.bytes().length);
        return verifier.verifySignature(sig.bytes());
    }

    @Override
    public boolean verifyEcdsaSecp256k1Signature(ByteString pk, ByteString msg, ByteString sig) {
        if (pk.bytes().length != 33) {
            throw new IllegalArgumentException(new StringBuilder(26).append("Invalid public key length ").append(pk.bytes().length).toString());
        }
        if (msg.bytes().length != 32) {
            throw new IllegalArgumentException(new StringBuilder(23).append("Invalid message length ").append(msg.bytes().length).toString());
        }
        if (sig.bytes().length != 64) {
            throw new IllegalArgumentException(new StringBuilder(25).append("Invalid signature length ").append(sig.bytes().length).toString());
        }
        ECDigitalSignature signature = ECDigitalSignature$.MODULE$.fromRS(ByteVector$.MODULE$.apply(sig.bytes()));
        return ((PublicKey)ECPublicKey$.MODULE$.apply(ByteVector$.MODULE$.apply(pk.bytes()))).verify(ByteVector$.MODULE$.apply(msg.bytes()), signature);
    }
}

